// globals
// window arguments defined here, but may not be used.
// mainly to test & explain valid arguments.

inviteArgsObj = window.arguments[0];

invitedScreenNames        = inviteArgsObj.invitedScreenNames;
inviteToExistingWindow    = inviteArgsObj.inviteToExistingWindow;
inviteMode                = inviteArgsObj.inviteMode;
inviteMsg                 = inviteArgsObj.invitationmsg;
inviteProposalObj         = inviteArgsObj.inviteProposalObj;
inviteProposalScreenName  = inviteArgsObj.inviteProposalScreenName;
inviteToExistingRoom      = inviteArgsObj.inviteToExistingRoom;

// for incoming chat invitation
var incomingChatScreenName = inviteProposalScreenName;
var incomingChatWarningLevel;
var incomingChatRoomName;
var incomingChatRoomDate;
var incomingChatRoomInviteMsg;
var incomingChatRoom;

var ChatManagerCallBack = new Object();
var RoomCreationTimeStamp = null;

ChatManagerCallBack.OnRequestRoomComplete =  function(roomName,chatRoomObj)
{
  incomingChatRoom=chatRoomObj;
  incomingChatRoomName = chatRoomObj.GetName();
  document.getElementById("chatRendezvousRoomName001").setAttribute("value",incomingChatRoomName);   
}

ChatManagerCallBack.OnRequestRoomError =  function(roomName,errMsg)
{
  window.close();
}

myExecutionCallback = new Object();
myExecutionCallback.ExecuteIfReady = function()
{
  // get chatroom and callbacks
  inviteProposalObj.Accept();
  aimChatManager().RequestProposedRoom(ChatManagerCallBack, inviteProposalObj);
}

function setButtons(okLabel, cancelLabel, okTooltip, cancelTooltip)
{
  var buttons = document.getElementsByTagName("button");
  for (i=0;i<buttons.length;i++) {
    if (okLabel && buttons[i].getAttribute('id') == "ok") {
      buttons[i].label = okLabel;
    }
    else if (cancelLabel && buttons[i].getAttribute('id') == "cancel") {
      buttons[i].label = cancelLabel;
    }
  }
}

function chatInviteBuddyOnWinLoad(){
  doSetOKCancel(chatInviteBuddyCmdInvite, onCancel);

  /* VISHY - this is a performance optimization. 
     Since chat needs time to get ready, this tells it to 
     get ready, well before we actually use it */
  aimChatManager().ExecuteIfReady(null);

  if(inviteMode && inviteMode=="incomingchat") {
    setButtons(aimString('chat.YesButton'), aimString('chat.NoButton'), aimString('accept.tooltip'), aimString('decline.tooltip'));
    doSetOKCancel(chatInviteBuddyCmdAcceptRendezvous, chatInviteBuddyCmdDeclineRendezvous);
    document.getElementById("cibdeck001").setAttribute("selectedIndex",2);
    incomingChatWarningLevel =  " " + aimString("chat.WarningLevel").replace(/%Level%/, inviteProposalObj.GetProposer().GetWarningPercent());
    incomingChatRoomName = " ";
    incomingChatRoomDate= new Date();

    // use international date format
    try {
      var IDateTime = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].createInstance();
      var dateFormatter = IDateTime.QueryInterface(Components.interfaces.nsIScriptableDateFormat);
      var curYear = incomingChatRoomDate.getYear() + 1900;
      var curMonth = incomingChatRoomDate.getMonth() + 1;
      var curDay = incomingChatRoomDate.getDate();
      var curHours = incomingChatRoomDate.getHours();
      var curMinutes = incomingChatRoomDate.getMinutes();
      var curSeconds = incomingChatRoomDate.getSeconds();

      dateTimeStr = dateFormatter.FormatDateTime("",
                                    Components.interfaces.nsIScriptableDateFormat.dateFormatLong,
                                    Components.interfaces.nsIScriptableDateFormat.timeFormatSeconds,
                                    curYear,curMonth,curDay,curHours,curMinutes,curSeconds);
      incomingChatRoomDate = dateTimeStr;
    }
    catch(e) {
      dump("Error using FormatDateTime: " + e + "\n");
    }

    incomingChatRoomInviteMsg = inviteProposalObj.GetInvitation();
    document.getElementById("chatRendezvousScreenName001").setAttribute("value",incomingChatScreenName);
    document.getElementById("chatRendezvousScreenName002").setAttribute("label",incomingChatScreenName);
    document.getElementById("chatRendezvousScreenName003").setAttribute("value",incomingChatScreenName);
    document.getElementById("chatRendezvousWarningLevel001").setAttribute("value",incomingChatWarningLevel);
    document.getElementById("chatRendezvousRoomName001").setAttribute("value",incomingChatRoomName);
    document.getElementById("chatRendezvousChatRoomDate").setAttribute("value",incomingChatRoomDate);
    document.getElementById("chatRendezvousInvitationMsg").setAttribute("value", incomingChatRoomInviteMsg);

    //XXXVISHY - unfortunately you need to get the Chat Room 
    // in order to find its name ;-)
    aimChatManager().ExecuteIfReady(myExecutionCallback);
  }

  if(inviteMode && inviteMode=="outgoingchat") {
    setButtons(aimString('chat.InviteButton'), null, aimString('chatInvite.tooltip'), aimString('chatCancel.tooltip'));
    document.getElementById("cibdeck001").setAttribute("selectedIndex",1)
    if (!invitedScreenNames || invitedScreenNames == "") {
      invitedScreenNames = "";
      document.getElementById("invitedscreennames").focus();
    }

    document.getElementById("invitedscreennames").value = invitedScreenNames;
    if (inviteMsg)
      document.getElementById("invitationmsg").value=inviteMsg;
    else
      document.getElementById("invitationmsg").value=aimString("chat.JoinMe");

    if(inviteToExistingRoom) {
      document.getElementById("buddychatroomname").value = inviteToExistingRoom;
      document.getElementById("buddychatroomname").setAttribute("readonly","true");
    }
    else
      chatPreFillRoomName();
  }

}

function onCancel(){
   return true;
}

function chatInviteBuddyCmdInvite() {
  document.getElementById("cibdeck001").setAttribute("selectedIndex",3);
  if(!inviteToExistingWindow) {
    var invitedScreenNames = document.getElementById("invitedscreennames").value;
    var cp = new String(invitedScreenNames);
    if (!IsValidChar(cp)) {
      // Cannot contain invalid characters 
      aimErrorBox(aimString("msg.InvalidScreenName"));
      document.getElementById("cibdeck001").setAttribute("selectedIndex",1)
      return;
    }
    var chatRoomName = document.getElementById("buddychatroomname").value;
    var chatMsg = document.getElementById("invitationmsg").value;

    // just send one argument to window.openDialog - but build an object. This way you dont have to worry about
    // keeping track of the argument's order.
    chatContentArgs = new Object();
    chatContentArgs.invitedScreenNames = invitedScreenNames;
    chatContentArgs.chatRoomName = chatRoomName;
    chatContentArgs.chatMsg = chatMsg;
    // not incoming chat
    chatContentArgs.incomingChat = false;
    chatContentArgs.incomingChatInviteProposalScreenName = ''
    chatContentArgs.incomingChatInviteProposalObj=null
    chatContentArgs.incomingChatRoom=null;
    window.openDialog("chrome://aim/content/chatContent.xul","","chrome,all,dialog=no",chatContentArgs);
  }
  else {
    window.opener.chatContentInviteMany(document.getElementById("invitedscreennames").value,document.getElementById("invitationmsg").value);
    window.opener.chatMsg = document.getElementById("invitationmsg").value;
    window.close();
  }

}

function cmdChatIncomingWarn()
{
  var warnUserArgs = new Object();
  warnUserArgs.screenName = incomingChatScreenName;
  window.openDialog("chrome://aim/content/WarnUser.xul","_blank", "chrome,dialog=no",warnUserArgs)
}

function cmdChatIncomingBlock()
{
  var pIAimPrivacy = aimPrivacy();
  if ( !pIAimPrivacy )
    return false;

  pIAimPrivacy.BlockUser(incomingChatScreenName);
  inviteProposalObj.Reject();
  window.close();
}

function cmdChatIncomingIM()
{
  aimIMInvokeIMForm(incomingChatScreenName);
}

function chatInviteBuddyCmdDeclineRendezvous()
{
  inviteProposalObj.Reject();
  window.close();
}

function chatInviteBuddyCmdAcceptRendezvous()
{
  document.getElementById("cibdeck001").setAttribute("selectedIndex",3)
  // code to accept rendezvous here
  var invitedScreenNames = "";
  var chatRoomName=incomingChatRoomName
  var chatMsg = "";

  // just send one argument to window.openDialog - but build an object. This way you dont have to worry about
  // keeping track of the argument's order.
  chatContentArgs = new Object();
  chatContentArgs.invitedScreenNames = invitedScreenNames;
  chatContentArgs.chatRoomName = chatRoomName;
  chatContentArgs.chatMsg = chatMsg;
  chatContentArgs.incomingChat = true;
  chatContentArgs.incomingChatInviteProposalScreenName = inviteProposalScreenName;
  chatContentArgs.incomingChatInviteProposalObj=inviteProposalObj
  chatContentArgs.incomingChatRoom=incomingChatRoom;
  window.openDialog("chrome://aim/content/chatContent.xul","","chrome,all,dialog=no",chatContentArgs);
}

function chatPreFillRoomName() {
  if(aimManager()) {
    var currentScreenName = aimSessionCurrentScreenName()
    var someRandomNumber = Math.ceil(Math.random()*100);
    document.getElementById("buddychatroomname").value = currentScreenName + " " + aimString("chat.roomname") + " " + someRandomNumber;
  }
}

