// Setting up stage to have one main Observer, so we dont have tons of observers for Aim state changes 

// Global variables which get set based on the buddylist panel  is Sidebar/App
var IsApp =false;
var IsSidebar = true;

/*
 * Function: CheckIfApp(inType)
 * Arguments: 
 *      inType -- the name of the window type 
 * Return: Boolean
 * Description: This function is called on load of buddylist panel. It will check if the window is standalone
 * type and return true if it is. It uses the window manager interface to check if any window of input type exists.
*/

function CheckIfApp(inType)
{
  const nsIWindowMediator = Components.interfaces.nsIWindowMediator;
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(nsIWindowMediator);
  //var windowManagerInterface = windowManagerDS.QueryInterface( Components.interfaces.nsIWindowMediator);
  var topWindow = windowManager.getMostRecentWindow( inType );
  if (topWindow) {
      IsApp=true;
      return true
    }
  return false;
}                     

/*
 * Function: CheckIfSidebar()
 * Arguments: None
 * Return: Boolean
 * Description: This function is called on load of buddylist panel. It will check if the window is sidebar.
 * It basically looks for the ad-box which is missing in sidebar. If there is no adbox, then it is sidebar, if it
 * exists then it is standalone.
*/

function CheckIfSidebar()
{
  if (top.document.getElementById("ad-box"))
  {
      IsSidebar=false;
      return false;
    }
  return true;
}      
