
const MSG_FLAG_NEW = 0x10000;
const MSG_FLAG_READ = 0x0001;
const MSG_FOLDER_FLAG_INBOX = 0x1000;
var gArray = null;  //holds the screen name, email address and msg keys for new msgs sent by this buddy
var gInboxDB = null;
var gObserverService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
var gHeaderParser = null;

var gAimMailObserver =
{
    observe: function(aSubject, aTopic, aData)
    {
      if (aTopic == "defaultInboxLoadedOnStartup")
      {
        if (!gArray)
        {
          var emailArray = GetBuddiesEmailAddress();
          CreateAimMailBridge(emailArray);
        }
        gObserverService.removeObserver(gAimMailObserver, "defaultInboxLoadedOnStartup");
      } 
      else if (aTopic == "mailDefaultAccountChanged")
      {
        CleanupGlobals();
        var emailArray = GetBuddiesEmailAddress();
        CreateAimMailBridge(emailArray);
      }
    }
}

var gDBChangeListener = 
{
    OnKeyChange: function(keyChanged, oldFlags, newFlags, instigator) 
   {
     if (!(oldFlags & MSG_FLAG_READ) && (newFlags & MSG_FLAG_READ))
       UpdateMsgKeyArray(gInboxDB.GetMsgHdrForKey(keyChanged), false);
   },

   OnKeyDeleted: function(keyChanged, parentKey, flags, instigator) 
   {
     if (!(flags & MSG_FLAG_READ))
       UpdateMsgKeyArray(gInboxDB.GetMsgHdrForKey(keyChanged), false); 
   },

   OnKeyAdded: function(keyChanged, parentKey, flags, instigator) 
   {
     if (flags & MSG_FLAG_NEW)
       UpdateMsgKeyArray(gInboxDB.GetMsgHdrForKey(keyChanged), true);
   },

   OnParentChanged: function(keyChanged, oldParentKey, newParentKey, instigator) { },

   OnAnnouncerGoingAway: function(instigator) 
   {
     CleanupGlobals();
   },

   OnReadChanged: function(instigator) {}
}

function CleanupGlobals()
{
  if (gArray)
    gArray = null;
  if (gInboxDB)
  {
    gInboxDB.RemoveListener(gDBChangeListener);
    gInboxDB = null;
  }
  try
  {
    gObserverService.removeObserver(gAimMailObserver, "mailDefaultAccountChanged"); 
  }
  catch (ex)
  {}
}

function GetEmailAddress(line)
{
  if (!gHeaderParser)
    gHeaderParser = Components.classes["@mozilla.org/messenger/headerparser;1"].getService(Components.interfaces.nsIMsgHeaderParser);

  var reformattedLine = gHeaderParser.reformatUnquotedAddresses(line);
  var addresses = new Object;
  gHeaderParser.extractHeaderAddressMailboxes(null, reformattedLine, addresses);
  return addresses.value;
}

function UpdateMsgKeyArray(msgHdr, add)
{
  var from = GetEmailAddress(msgHdr.author);

  var msgKey = msgHdr.messageKey;
  for (var i=0; i <gArray.length; i++)       //you can have two buddies w/ same email address - as per suresh
  {
    if (gArray[i].emailAddress && from == gArray[i].emailAddress)
    {
      var msgKeyArray = gArray[i].msgKeyArray;
      if(add)
        msgKeyArray[msgKeyArray.length] = msgKey;
      else
      {
        for (var j=0;j<msgKeyArray.length;j++)
        {
          if (msgKeyArray[j] == msgKey)
          {
            msgKeyArray.splice(j,1);
            break;
          }
        }
      }

      gArray[i].msgKeyArray = msgKeyArray;

      if (msgKeyArray.length == 0)
        NotifyChange(gArray[i].screenName, false);

      else if (msgKeyArray.length == 1)
        NotifyChange(gArray[i].screenName, true);

    }
  }
}

function IsMailRunning()
{
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var mailWindow = windowManagerInterface.getMostRecentWindow("mail:3pane");
  if (mailWindow)
    return true;
  else
    return false;
}

function CreateAimMailBridge(buddyListEmailAddresses)
{
  var supportmailim = aimPrefsManager().GetBoolPref("aim.session.supportmailim", null, false);
  if (!supportmailim)
    return;
  
  if (!IsMailRunning())
  {
    //we need to listen when mail starts-up
    gObserverService.addObserver(gAimMailObserver, "defaultInboxLoadedOnStartup", false);  //looks like js objects cannot have weak reference
    return;
  }

  var inboxFolder = GetInboxFolderForDefaultAccount();
  if (!inboxFolder)
  {
    gObserverService.addObserver(gAimMailObserver, "defaultInboxLoadedOnStartup", false);  //looks like js objects cannot have weak reference
    return;
  }

  gObserverService.addObserver(gAimMailObserver, "mailDefaultAccountChanged", false);  //looks like js objects cannot have weak reference 

  gArray = new Array(buddyListEmailAddresses.length);
  for (var i=0; i <gArray.length; i++)    //initialize gArray
  {
    var obj = new Object;
    obj.emailAddress = buddyListEmailAddresses[i].EmailID;
    obj.screenName = buddyListEmailAddresses[i].ScreenName;
    obj.msgKeyArray = new Array;
    gArray[i] = obj;
  }

  gInboxDB = inboxFolder.getMsgDatabase(null);

  gInboxDB.AddListener(gDBChangeListener);

  if (gInboxDB.HasNew()) //need to find out if any buddy has sent new mail
  {
    var msgEnumerator = gInboxDB.EnumerateMessages();
    while (msgEnumerator.hasMoreElements())
    {
      var msgSupports = msgEnumerator.getNext();
      var msgHdr = msgSupports.QueryInterface(Components.interfaces.nsIMsgDBHdr);
      if (msgHdr.flags & MSG_FLAG_NEW)
        UpdateMsgKeyArray(msgHdr, true);
    }
  }
}
  
function GetInboxFolderForDefaultAccount()
{
  var inboxFolder = null;
  var accountManager = null;
  
  try 
  {
    accountManager = Components.classes["@mozilla.org/messenger/account-manager;1"].getService(Components.interfaces.nsIMsgAccountManager); 
  }
  catch(ex)
  {
    dump("Could not get account manager "+ ex + "\n");
  }
  
  if (!accountManager)
    return null;

  try
  {
    var defaultAccount = accountManager.defaultAccount;
  }
  catch (ex)
  { 
    dump ("Could not get default account" + ex + "\n");
  }

  if (!defaultAccount)
    return null;

  var incomingServer = defaultAccount.incomingServer;
  var rootMsgFolder = incomingServer.rootMsgFolder;
  var outNumFolders = new Object();
  inboxFolder = rootMsgFolder.getFoldersWithFlag(MSG_FOLDER_FLAG_INBOX, 1, outNumFolders);

  return inboxFolder;
}

function NotifyChange(buddyName, displayMailIcon)
{
  //call aim function that would change the status on aim window
  var aimbuddy = aimBuddyManager();
  if (displayMailIcon)
    aimbuddy.SetUserEmailStateinDS(buddyName, Components.interfaces.nsAimBuddyEmailStates.HasNewEmail);
  else
    aimbuddy.SetUserEmailStateinDS(buddyName, Components.interfaces.nsAimBuddyEmailStates.HasNoEmail);
}

function UpdateBuddyEmailAddress(screenName, buddyEmailAddress)
{
  if (!gArray)
    return;
  var index = GetIndexOfBuddyInArray(screenName);
  if (index != -1)
    gArray[index].emailAddress = buddyEmailAddress;
}
    
function AddBuddyEmailAddress(screenName, buddyEmailAddress)
{
  if (!gArray)
    return;
  if (GetIndexOfBuddyInArray(screenName) == -1)
  {
    var obj = new Object;
    obj.emailAddress = buddyEmailAddress;
    obj.screenName = screenName;
    obj.msgKeyArray = new Array;
    gArray[gArray.length] = obj;
  }
}

function RemoveBuddyEmailAddress(screenName)
{
  if (!gArray)
    return;
  var index = GetIndexOfBuddyInArray(screenName);
  if ( index != -1)
    gArray.splice(index,1);
}

function GetIndexOfBuddyInArray(screenName)
{
  for (var i=0; i <gArray.length; i++)
  {
    if (screenName == gArray[i].screenName)
      return i;
  }
  return -1;
}

function ViewUnread(emailAddress)
{
  var inboxFolder = GetInboxFolderForDefaultAccount();
  if (!inboxFolder)
    return OpenMessenger(null, null, null);
  else
    return OpenMessenger(inboxFolder.URI, -1, emailAddress);
}

//TODO when mail is not set up
function OpenMessenger(folder, msg, emailaddress)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"]
             .getService(Components.interfaces.nsIPrefBranch);
  
  var windowDoc = "chrome://messenger/content/messenger.xul";
  try
  {
     var layoutType = pref.getIntPref("mail.pane_config");
     windowDoc = !layoutType ? "chrome://messenger/content/messenger.xul" : 
                               "chrome://messenger/content/mail3PaneWindowVertLayout.xul";
  }
  catch(ex)
  {}

  window.openDialog(windowDoc, "_blank",
    "chrome,extrachrome,menubar,resizable,status,toolbar", folder, msg, emailaddress);
}


