/*
 * Function:  aimIMObject()
 * Arguments: None
 * Return: nsIAimIM interface
 * Description:  This function is queries for it and returns the nsIAimIM interface 
*/

function aimIMObject()
{
	var pIIMManager = aimManager();
	if ( pIIMManager )
		return pIIMManager.QueryInterface(Components.interfaces.nsIAimIM);
	else
		return null;
}

/*
 * Function:  aimIMInvokeIMForm(screenName)
 * Arguments: 
 *    screenName  --  the buddy name which appears on the To field in the IM window (selected  buddy name)
 * Return: None
 * Description:  This function calls the InvokeIMUI function which on the AimIM interface which puts 
 * up the IM conversation window. The Screenname param which is passed, is used to prefill the To field.
*/

function aimIMInvokeIMForm(screenName)
{
	var pIAimIM = aimIMObject();
	if(pIAimIM)
		pIAimIM.InvokeIMUI(screenName, null);
}

/*
 * Function:  aimIMDoesIMExist(screenName)
 * Arguments: 
 *    screenName  --  screen name to be checked
 * Return: Boolean
 * Description:  This function is used to find out if there is already an existing aim conversation 
 * going on with the specified screenname. If there is already a window open with the screenname in 
 * the To:field or title of the window, then this returns true. If no window exists for this screen 
 * name, this returns false;
*/

function aimIMDoesIMExist(screenName)
{
	var pIAimIM = aimIMObject();
	if(pIAimIM)
		{
		var pWindow = pIAimIM.GetExistingIM(screenName);
		if(pWindow)
			return true;
		}
	return false;
}

/**************** Private Methods ***********************/

/*
 * Function:  aimPIMObject()
 * Arguments: None
 * Return: nsPIAimIM interface
 * Description:  This function queries for it and returns the nsPIAimIM interface 
*/

function aimPIMObject()
{
	var pIIMManager = aimManager();
	if(pIIMManager)
		return pIIMManager.QueryInterface(Components.interfaces.nsPIAimIM);
	else
		return null;
}

/*
 * Function:  aimPIMSendIM(wnd, screenName, message)
 * Arguments: 
 *    wnd --    window from which the message is sent
 *    screenName  --  screenname to whom the message is to be sent
 *    message --  message to be sent. 
 * Return:  None 
 * Description:  This function is used to send a instant message from the window 
 * where the Send button is clicked. The message (the formatted contents of the IM window)
 * is sent to the screenname  which is the second input parameter ( from the To:field in IM window). 
*/

function aimPIMSendIM(wnd, screenName, message, text)
{
	var pPIAimIM = aimPIMObject();
	if(pPIAimIM)
		pPIAimIM.SendMsg(wnd, screenName, message, text);
}


/*
 * Function:  setStyles ()
 * Arguments: 
 * Return:  None 
 * Description:  This function is used to set the style elements,
 *               which are read from the prefs, and overridden by
 *               getStyles.
 *               
 * Author: jelwell@netscape.com
*/


var sessionType =aimPrefsManager().GetIntPref("aim.session.sessiontype", null, false);
if(sessionType == 0) {
  var aimStylePrefManager = aimPrefsManager();
  var faceType = aimStylePrefManager.GetCharPref("aim.style.fontface", null, false);
  var fontSize = aimStylePrefManager.GetCharPref("aim.style.fontsize", null, false);
  var textstyles = aimStylePrefManager.GetCharPref("aim.style.textstyles", null, false);
  var italics = aimStylePrefManager.GetBoolPref("aim.style.italics", null, false);
  var bold = aimStylePrefManager.GetBoolPref("aim.style.bold", null, false);
  var underline = aimStylePrefManager.GetBoolPref("aim.style.underline", null, false);
  var currentColor = aimStylePrefManager.GetCharPref("aim.style.forecolor", null, false);
  var backgroundColor = aimStylePrefManager.GetCharPref("aim.style.backcolor", null, false);
}
if (sessionType ==2) {
  var aimStylePrefManager = aimPrefsManager();
  var faceType = aimStylePrefManager.GetCharPref("icq.style.fontface", null, false);
  var fontSize = aimStylePrefManager.GetCharPref("icq.style.fontsize", null, false);
  var textstyles = aimStylePrefManager.GetCharPref("icq.style.textstyles", null, false);
  var italics = aimStylePrefManager.GetBoolPref("icq.style.italics", null, false);
  var bold = aimStylePrefManager.GetBoolPref("icq.style.bold", null, false);
  var underline = aimStylePrefManager.GetBoolPref("icq.style.underline", null, false);
  var currentColor = aimStylePrefManager.GetCharPref("icq.style.forecolor", null, false);
  var backgroundColor = aimStylePrefManager.GetCharPref("icq.style.backcolor", null, false);
}

function setStyles ()
{
  // find body node
  var bodyelement = GetBodyElement();
  if (bodyelement)
  {
    if (backgroundColor && backgroundColor != "")
      bodyelement.setAttribute("bgcolor", backgroundColor);
    var backgroundcolor = document.getElementById("cmd_backgroundColor");
    if (backgroundcolor)
      backgroundcolor.setAttribute("state", backgroundColor);
  }
  if (currentColor && currentColor != "") {
    EditorSetTextProperty("font", "color", currentColor);
//  bodyelement.setAttribute("text", text_color);
    var commandcolor = document.getElementById("cmd_fontColor");
    if (commandcolor)
      commandcolor.setAttribute("state", currentColor);
  }
  if (textstyles && textstyles != "") {
    if (italics)
      EditorSetTextProperty("i", "", "");
    if (bold)
      EditorSetTextProperty("b", "", "");
    if (underline)
      EditorSetTextProperty("u", "", "");
  }
  if (fontSize && fontSize != "")

  EditorSetTextProperty(fontSize, "", "");

  if (faceType == "tt")
  {
    EditorSetTextProperty("tt", "", "");
  }
  else if (faceType && faceType != "")
  {
    EditorRemoveTextProperty("font","face");
    EditorSetTextProperty("font", "face", faceType);
  }
  document.getElementById("cmd_preferences").setAttribute("disabled", "false");
}

function changeFont()
{
  faceType = document.getElementById('FontFaceSelectStyle').value;
  EditorRemoveTextProperty("font","face");
  EditorSetTextProperty("font", "face", faceType);
}
/*
 * Function:  getStyles ()
 * Arguments: 
 * Return:  None 
 * Description:  This function is used to get the style elements,
 *               to be saved for retrieval for the next message
 *               sent in this session.
 *
 * Author: jelwell@netscape.com
*/

function getStyles ()
{
  var editor = GetCurrentEditor();
  if (!editor)
    return;

  editor.selectAll();

  var firstHas = new Object;
  var anyHas = new Object;
  var allHas = new Object;
  allHas.value = false;

  //    Find Font Face
  //    Fixed width (second menu item) is special case: old TT ("teletype") attribute
  EditorGetTextProperty("tt", "", "", firstHas, anyHas, allHas);
  if (!allHas.value)
  {
    var children = top.document.getElementById("FontFacePopupStyle").childNodes;
    // Skip over default, TT, and separator
    for (var i = 0; i < children.length; i++)
    {
      var menuitem = children.item(i);
      faceType = menuitem.getAttribute("value");
      if (faceType)
      {
        EditorGetTextProperty("font", "face", faceType, firstHas, anyHas, allHas);
        if (allHas.value)
        {
          break;
        }
      }
    }
    if (!allHas.value)
    faceType = "";
  }
  else
    faceType = "tt";
  //    End Find Font Face

  //    Find Big or Small
  EditorGetTextProperty("big", "", "", firstHas, anyHas, allHas);
  if (allHas.value)
  {
    fontSize = "big";
  }
  else
  {
    EditorGetTextProperty("small", "", "", firstHas, anyHas, allHas);
  if (allHas.value)
    fontSize = "small";
  else
    fontSize = "";

  }
 //    End Find Big or Small
  EditorGetTextProperty("i", "", "", firstHas, anyHas, allHas);
  if (allHas.value)
    italics = true;
  else
    italics = false;
  EditorGetTextProperty("b", "", "", firstHas, anyHas, allHas);
  if (allHas.value)
    bold = true;
  else
    bold = false;
  EditorGetTextProperty("u", "", "", firstHas, anyHas, allHas);
  if (allHas.value)
    underline = true;
  else
    underline = false;

  if (italics || bold || underline)
    textstyles = 1;
  var commandcolor = document.getElementById("cmd_fontColor");
  if (commandcolor) {
    currentColor = commandcolor.getAttribute("state");
  }
  var backgroundcolor = document.getElementById("cmd_backgroundColor");
  if (backgroundcolor) {
    backgroundColor = backgroundcolor.getAttribute("state");
  }
}
