#ifndef _PSK31_H
#define _PSK31_H

#include "cmplx.h"
#include "trx.h"
#include "viterbi.h"

#define	SampleRate	8000
#define	SymbolLen	256	/* 31.25 symbols per second */
#define	SymbolRate	((double) SampleRate / SymbolLen)

#define PipeLen		64

struct psk31 {
	/*
	 * Common stuff
	 */
	int qpsk;

	double phaseacc;
	complex prevsymbol;
	unsigned int shreg;

	/*
	 * RX related stuff
	 */
	struct filter *fir1;
	struct filter *fir2;

	struct encoder *enc;
	struct viterbi *dec;

	double bitclk;
	float syncbuf[16];

	double pipe[PipeLen];
	unsigned int pipeptr;

	unsigned int dcdshreg;
	int dcd;

	complex quality;

	/*
	 * TX related stuff
	 */
	double txshape[SymbolLen];
	int preamble;
};

/* in psk31.c */
extern void psk31_init(struct trx *trx);

/* in psk31rx.c */
extern int psk31_rxprocess(struct trx *trx, float *buf, int len);

/* in psk31tx.c */
extern int psk31_txprocess(struct trx *trx);

#endif
