/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corp.
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Bill Law (law@netscape.com)
 *  Bhuvan Racham (bhuvan@netscape.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/* This file implements the nsICmdLineHandler interface.  See nsICmdLineHandler.idl
 * at http://lxr.mozilla.org/seamonkey/source/xpfe/appshell/public/nsICmdLineHandler.idl.
 *
 * This component handles the startup command line argument of the form:
 *   -setPref pref1,pref2,pref3
 * in order to change the value for every pref called via this commandline,
 * corresponding implementation is need to added.
 *
 * The module is registered under the contractid
 *   "@mozilla.org/commandlinehandler/general-startup;1?type=setPref"
 *
 * The implementation consists of a JavaScript "class" named nsSetPref,
 * comprised of:
 *   - a JS constructor function
 *   - a prototype providing all the interface methods and implementation stuff
 *
 * In addition, this file implements an nsIModule object that registers the
 * nsSetPref component.
 */

/* ctor
 */
function nsSetPref() {
}

nsSetPref.prototype = {

  // nsICmdLineHandler interface
  get commandLineArgument() { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
  get prefNameForStartup()  { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
  get chromeUrlForTask()    { 
    try {
      // We trust that this has been called during command-line handling during
      // startup from nsAppRunner.cpp.

      // We get the command line service and from that the -setPref argument.
      var cmdLine  = Components.classes[ "@mozilla.org/appshell/commandLineService;1" ]
                       .getService( Components.interfaces.nsICmdLineService );
      var prefList = cmdLine.getCmdLineValue( "-setPref" ).split( "," );

      // Get pref service.
      var prefs    = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

      // For each pref specified on the cmd line, set the default pref value.
      for ( i in prefList ) {
        // Checking to see if we need to default browser.startup.homepage to 
        // our default choice.
        if (prefList[i] == "browser.startup.homepage") {
          try {
            var localizedHomePageUrl = prefs.getComplexValue("browser.default_homepage.url", 
                                                Components.interfaces.nsIPrefLocalizedString).data;
            var str = Components.classes["@mozilla.org/supports-wstring;1"]
                            .createInstance(Components.interfaces.nsISupportsWString);
            str.data = localizedHomePageUrl;
            prefs.setComplexValue(prefList[i],
                            Components.interfaces.nsISupportsWString, str);
          } catch( e ) {
          }
        }
      }
    } catch( e ) {
    }

    // Return an error (so nsAppRunner doesn't think we've opened a window).
    throw Components.results.NS_ERROR_NOT_IMPLEMENTED;
  },
  get helpText()            { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; },
  get handlesArgs()         { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; }, 
  get defaultArgs()         { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; }, 
  get openWindowWithArgs()  { throw Components.results.NS_ERROR_NOT_IMPLEMENTED; }, 

  // nsISupports interface

  // This "class" supports nsICmdLineHandler and nsISupports.
  QueryInterface: function (iid) {
    if (!iid.equals(Components.interfaces.nsICmdLineHandler) &&
        !iid.equals(Components.interfaces.nsISupports)) {
      throw Components.results.NS_ERROR_NO_INTERFACE;
    }
    return this;
  },

  // This Component's module implementation.  All the code below is used to get this
  // component registered and accessible via XPCOM.
  module: {
    // registerSelf: Register this component.
    registerSelf: function (compMgr, fileSpec, location, type) {
      compMgr = compMgr.QueryInterface( Components.interfaces.nsIComponentManagerObsolete );
      compMgr.registerComponentWithType( this.cid,
                                         "Pref Set Component",
                                         this.contractId,
                                         fileSpec,
                                         location,
                                         true,
                                         true,
                                         type );
    },

    // getClassObject: Return this component's factory object.
    getClassObject: function (compMgr, cid, iid) {
      if (!cid.equals(this.cid))
        throw Components.results.NS_ERROR_NO_INTERFACE;

      if (!iid.equals(Components.interfaces.nsIFactory))
        throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

      return this.factory;
    },

    /* CID for this class */
    cid: Components.ID("{15ABFAF7-AD4F-4450-899B-0373EE9FAD95}"),

    /* Contract ID for this class */
    contractId: "@mozilla.org/commandlinehandler/general-startup;1?type=setPref",

    /* factory object */
    factory: {
      // createInstance: Return a new nsSetPref object.
      createInstance: function (outer, iid) {
        if (outer != null)
          throw Components.results.NS_ERROR_NO_AGGREGATION;

        return (new nsSetPref()).QueryInterface(iid);
      }
    },

    // canUnload: n/a (returns true)
    canUnload: function(compMgr) {
      return true;
    }
  }
}

// NSGetModule: Return the nsIModule object.
function NSGetModule(compMgr, fileSpec) {
  return nsSetPref.prototype.module;
}
