var invRDF=null;
var invDS=null;
var invcontainer =null;

var testObserver = {
          onBeginLoad: function(aSink)
            {},

          onInterrupt: function(aSink)
            {},

          onResume: function(aSink)
            {},

          onEndLoad: function(aSink)
            {DoProcessInviteList();},

          onError: function(aSink, aStatus, aErrorMsg)
            {dump("error! " + aErrorMsg); }
};

function getrdfinfo()
{
	
	if (invRDF == null) {
	      invRDF=aimRDF();
	}
	var invfile=GetRdfFileUrl("default-invite.rdf", "invite.rdf");	
	invDS = invRDF.GetDataSource(invfile);
	if (invDS)
                invDS = invDS.QueryInterface(Components.interfaces.nsIRDFDataSource);
 	if (invcontainer == null)
	       invcontainer= Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
}


function ProcessInviteList()
{
	getrdfinfo();
	var remote =invDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
	if (remote.loaded) {
                dump("the datasource was already loaded!");
	        DoProcessInviteList();
        }
        else {
                var sink=remote.QueryInterface(Components.interfaces.nsIRDFXMLSink);
		if (sink)
		        sink.addXMLSinkObserver(testObserver);
        }
}


function DoProcessInviteList()
{
	var containerRes = invRDF.GetResource("NC:AIM/InviteList:root");
	if (invcontainer) {
                invcontainer.Init(invDS, containerRes);
        }
	var elements = invcontainer.GetElements();
	var target, node;
	var nameResource = invRDF.GetResource("http://home.netscape.com/NC-rdf#InviteAddr");
	
	while ( elements.hasMoreElements() ) {
		node = elements.getNext();
		if ( node ) {
			target =invDS.GetTarget( node, nameResource, true );
			
		        if ( target ) {
			        target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
		
		                if (target && target.Value) {
                                        cmdFindScrName(target.Value);
                                }
                        }
		}
	}
	return null;
}

function RemoveFromInviteList (inviteaddr)
{
        getrdfinfo();
        if (invcontainer) {
                var containerRes = invRDF.GetResource("NC:AIM/InviteList:root");
                invcontainer.Init(invDS, containerRes);
        }
	var elements = invcontainer.GetElements();
	var target, node;
	var nameResource = invRDF.GetResource("http://home.netscape.com/NC-rdf#InviteAddr");
				
	while ( elements.hasMoreElements() ) {
		node = elements.getNext();
		if ( node )  {
			target = invDS.GetTarget( node, nameResource, true );
		        if ( target ) {
			        target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
		                if ( target && target.Value == inviteaddr ) {
			                invcontainer.RemoveElement( node, true );
			                invDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
                                }
                        }
		}
	}
	return null;
}


function AddToInviteList(inviteaddr, invitedate)
{
	AssertInvitee( inviteaddr, invitedate ); 
}


function AssertInvitee( inviteaddr, invitedate )
{
	getrdfinfo();
  var invRDFCU= Components.classes['@mozilla.org/rdf/container-utils;1'].getService(Components.interfaces.nsIRDFContainerUtils);
  if (invcontainer) {
    var containerRes = invRDF.GetResource("NC:AIM/InviteList:root");
    var checkIfSeq=invRDFCU.IsSeq(invDS, containerRes);
    if (!checkIfSeq) 
      invRDFCU.MakeSeq(invDS,containerRes);
    invcontainer.Init(invDS, containerRes);
  }
	var newmsg = invRDF.GetAnonymousResource();
	invDS.Assert(newmsg, invRDF.GetResource("http://home.netscape.com/NC-rdf#InviteAddr"), 
	invRDF.GetLiteral(inviteaddr), true);
	invDS.Assert(newmsg, invRDF.GetResource("http://home.netscape.com/NC-rdf#InviteDate"), invRDF.GetLiteral(invitedate), true);
	invcontainer.AppendElement(newmsg);
	invDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
}

var LookCallBack = new Object();
  
LookCallBack.OnRequestScreenNamesComplete = function(email,numScreenNames,pScreenNames) 
{
	RemoveFromInviteList(email);
	screenlistObj = {
			emailAddr:email,
			snNumber:numScreenNames,
			screenList:pScreenNames,
        }
	window.openDialog('chrome://aim/content/Invite_success.xul','_blank','chrome,all,dialog=no',screenlistObj);
}

LookCallBack.OnRequestScreenNamesError = function(email,pErrMsg) 
{
        CheckForRemind(email);
}


function cmdFindScrName(inEmail)
{
    var pIIMManager = aimManager();
	
	if (!pIIMManager) {
		return;
	}
	var pIUserLookupManager = aimUserLookupManager();
	if (!pIUserLookupManager) {
		return;
	}

	pIUserLookupManager.RequestScreenNames(LookCallBack,inEmail);
}

var i=0;
function CheckForRemind(inv_email)
{
	var elements = invcontainer.GetElements();
	var datetarget, addrtarget, node;
	var addrResource = invRDF.GetResource("http://home.netscape.com/NC-rdf#InviteAddr");
	var dateResource = invRDF.GetResource("http://home.netscape.com/NC-rdf#InviteDate");
        var magic1 = 1000 * 60 * 60 * 24;       // XXX
        var magic2 = 14;                        // XXX
	while ( elements.hasMoreElements() ) {
		node = elements.getNext();
		if ( node ) {
			addrtarget = invDS.GetTarget( node, addrResource, true );
		        if ( addrtarget ) {
			        addrtarget = addrtarget.QueryInterface(Components.interfaces.nsIRDFLiteral);
		                if ( addrtarget && addrtarget.Value == inv_email ) {
			                i++;
			                datetarget = invDS.GetTarget( node, dateResource,true );
                                        if ( datetarget ) {
                                                datetarget = datetarget.QueryInterface(Components.interfaces.nsIRDFLiteral);
                                                if ( datetarget ) {
			                                var today= new Date();
			                                var targetdate= new Date(datetarget.Value);
			                                if(Math.floor((today-targetdate) / magic1) >= magic2) {
				                                window.openDialog("chrome://aim/content/Invite_remind.xul","_blank","chrome,dialog=no",addrtarget.Value,datetarget.Value);
				                                //If too many invites, maybe show each reminder after timeouts.
				                                //setTimeout(nextinvite,10000*i,addrtarget.Value,datetarget.Value);
                                                        }
			                        }
                                        }
                                }
			}
                }
	}
	return null;
}

function nextinvite(invperson,invdate)
{
        dump("inside nextinvite");
	window.openDialog("chrome://aim/content/Invite_remind.xul","_blank","chrome,dialog=no",invperson,invdate);
}
