importBuddyListArgsObj = window.arguments[0];
mask = importBuddyListArgsObj.mask;		// import only
groups = importBuddyListArgsObj.groups;		// import only
fileSpec = importBuddyListArgsObj.fileSpec;	// export only

/*
 * Function:  PokePreference( name, listDocument )
 * Arguments: 
 *    name  --  name of the new check box
 *    listDocument  --  the item under which the new check box needs to be added
 * Return: None
 * Description: This function is used to add a new checkbox item in the import buddy list dialog window.
*/

function PokePreference( name, listDocument )
{
	outputElement = document.createElement('checkbox')
	outputElement.setAttribute('id',name)
	outputElement.setAttribute('name',name)
	outputElement.setAttribute('label',name)
	listDocument.appendChild(outputElement)
}

/*
 * Function:  ImportBuddyListOnLoad()
 * Arguments: None
 * Return: None
 * Description: This function is called on the load of ImportBuddylist dialog called when File->Import menu item 
 * is invoked. It first retrieves all the saved preferences using the ImportExportFlags. If a particular preference 
 * setting was saved during export, that item is created as a checkbox and added to the import dialog. All the 
 * groups that were saved are also added as a checkbox item. This gives the user the ability to either save all 
 * original settings or customize the import by using the checkboxes.
 * Bugs: Does preference settings checkboxes work?
*/

function ImportBuddyListOnLoad()
{
	if ( groups.value && groups.value != undefined && groups.value != null )
		groupsv = groups.value.split(",");

  listDocument = document.getElementById("ImportBuddyListCat")
  listDocument.appendChild(document.createElement("spacer"))

	var enums = getEnums( Components.interfaces.nsAimImportExportFlags );

	if ( mask.value & enums.ConnectionPrefs ) 
		PokePreference( aimString( "importexport.connectionprefs" ), listDocument );
	if ( mask.value & enums.PersonalProfile ) 
		PokePreference( aimString( "importexport.personalprofile" ), listDocument );
	if ( mask.value & enums.PrivacyPrefs ) 
		PokePreference( aimString( "importexport.privacyprefs" ), listDocument );
	if ( mask.value & enums.SoundPrefs ) 
		PokePreference( aimString( "importexport.soundprefs" ), listDocument );
	if ( mask.value & enums.TextCompositionAndViewingSetting ) 
		PokePreference( aimString( "importexport.textcompandviewsettings" ), listDocument );

	if ( groups.value && groups.value != undefined && groups.value != null ) {
		listDocument = document.getElementById("ImportBuddyListGroups")
		for( var i = 0; i < groupsv.length; i++ ) 
      PokePreference( groupsv[i], listDocument );
	}
	doSetOKCancel(ImportBuddyListOk, ImportBuddyListCancel);
}

/*
 * Function:  ImportBuddyListOk()
 * Arguments: None
 * Return: None
 * Description: This function is called when the user clicks OK button on the import buddy list dialog window.
 * This takes all the group changes based on the user's input calls  ImportBuddyList function which does the
 * actual import.
*/

function ImportBuddyListOk()
{
  var pIAimBuddy = aimBuddyManager();
	var groups = new Array; 
	var count = 0;
	var enums = getEnums( Components.interfaces.nsAimImportExportFlags );
	var mask = enums.NoMask;

  listDocument = document.getElementById("ImportBuddyListGroups")
	for( var i = 0; i < groupsv.length; i++ ) {
    chkboxname = groupsv[i]; 
    element = document.getElementById(chkboxname);
		if ( element.checked == true ) {
			groups[count] = chkboxname;
			count++;
		}
	}
	window.close();
	if ( count > 0 ) {
		var myStatus = new Object();
		pIAimBuddy.ImportBuddyList( myStatus, mask, groups.length, groups );	
	}
}

/*
 * Function:  ImportBuddyListCancel()
 * Arguments: None
 * Return: None
 * Description: This function is called when the user clicks Cancel button on the import buddy list dialog window.
 * This basically cancels out of the import function and closes import the dialog.
*/

function ImportBuddyListCancel()
{
  var pIAimBuddy = aimBuddyManager();
	pIAimBuddy.ImportBuddyListClear();
	window.close();
}

/*
 * Function:  ExportBuddyListOnLoad()
 * Arguments: None
 * Return: None
 * Description: This function is called on the load of ExportBuddylist dialog called when File->Export menu item 
 * is invoked. It first retrieves all the saved preferences using the ImportExportFlags. According to the preference 
 * settings, a checkbox gets added to the export dialog window. It also shows all the groups as checkboxes so that 
 * only part of buddylist can be saved if user wishes so. The dialog has a Ok and a Cancel button.
 * Bugs: Does preference settings checkboxes work?
*/

function ExportBuddyListOnLoad()
{
  listDocument = document.getElementById("ExportBuddyListCat");
  listDocument.appendChild(document.createElement("spacer"));

	var enums = getEnums( Components.interfaces.nsAimImportExportFlags );

	if ( mask && mask.value ) {
		if ( mask.value & enums.ConnectionPrefs ) 
			PokePreference( aimString( "importexport.connectionprefs" ), listDocument );
		if ( mask.value & enums.PersonalProfile ) 
			PokePreference( aimString( "importexport.personalprofile" ), listDocument );
		if ( mask.value & enums.PrivacyPrefs ) 
			PokePreference( aimString( "importexport.privacyprefs" ), listDocument );
		if ( mask.value & enums.SoundPrefs ) 
			PokePreference( aimString( "importexport.soundprefs" ), listDocument );
		if ( mask.value & enums.TextCompositionAndViewingSetting ) 
			PokePreference( aimString( "importexport.textcompandviewsettings" ), listDocument );
	}

  var pIAimBuddy = aimBuddyManager();
	var groups = new Object();

	pIAimBuddy.ExportBuddyListGetGroups( groups );

	if ( groups.value && groups.value != undefined && groups.value != null ) {
   	groupsv = groups.value.split(",");
		listDocument = document.getElementById("ExportBuddyListGroups")
		for( var i = 0; i < groupsv.length; i++ ) 
			PokePreference( groupsv[i], listDocument );
	}
	doSetOKCancel(ExportBuddyListOk, ExportBuddyListCancel);
}

/*
 * Function:  ExportBuddyListOk()
 * Arguments: None
 * Return: None
 * Description: This function is called when the user clicks OK button on the import buddy list dialog window.
 * This takes all the changes based on the user's input and calls  ExportBuddyList function which does the
 * actual export.
*/

function ExportBuddyListOk()
{
  var pIAimBuddy = aimBuddyManager();
	var groups = new Array; 
	var count = 0;
	var enums = getEnums( Components.interfaces.nsAimImportExportFlags );
	var mask = enums.NoMask;

  listDocument = document.getElementById("ExportBuddyListGroups")
  for( var i = 0; i < groupsv.length; i++ ) {
                chkboxname = groupsv[i]; 
        	element = document.getElementById(chkboxname);
		if ( element.checked == true ) {
			groups[count] = chkboxname;
			count++;
		}
	}
	window.close();
	if ( count > 0 ) {
		var myStatus = new Object();
		pIAimBuddy.ExportBuddyList( fileSpec, myStatus, mask, groups.length, groups );	
    if ( myStatus.value == false )
      aimErrorBox(aimString("msg.exporttryagain"));
    else
     	aimErrorBox(aimString("msg.exportsuccess"));
	}
}

/*
 * Function:  ExportBuddyListCancel()
 * Arguments: None
 * Return: None
 * Description: This function is called when the user clicks Cancel button on the export buddy list dialog window.
 * This closes import the dialog.
*/

function ExportBuddyListCancel()
{
	window.close();
}

