gScreenName="";

/*
* Name: getBuddyState
* Arguments: screenName 
* Description: This function is called during the onload of buddyalert window. It gets the buddystate for the user 
* whose screenname is passed in frm the datasource. If there is a valid user state it returns the user's current state.
* Return Value: buddy state
* Author: Prassanna<prass@netscape.com> 
*/

function getBuddyState(screenName)
{
  var buddyState = aimRDF().GetResource("http://home.netscape.com/NC-rdf#BuddyStateString");
  var buddyResource = aimBuddyManager().GetUserResource(screenName);
  if (buddyResource)
    var target = aimRDFDataSource().GetTarget(buddyResource, buddyState, true);
  if (target) {
    var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    return state;
  }
  return null;
}

/*
* Name: AimBuddyAlertWndOnLoad
* Arguments: None
* Description: This function is called by the onload handler of buddyalert window. It gets the screenname argument which is 
* passed through the  buddy alert window open call and gets the state of the screenname user. It sets the appropriate
* check boxes based on user state and sets the Ok/Cancel button handlers.
* Author: Prassanna<prass@netscape.com> 
*/

function AimBuddyAlertWndOnLoad() {
  // Set the buddyname value from the window argument which has the user selected screenname frm listsetup/online tab
  var buddyelem = document.getElementById('buddyname');
  var winarg = window.arguments[0];
  if (winarg != null) {
    buddyelem.setAttribute('value', '"'+winarg+'"');
    gScreenName=winarg;
  }
  if (window.arguments[1] != null) {
    doEditAlert(gScreenName);
  }
  else
    doSetupAlert(gScreenName);
}

function doSetupAlert(winarg)
{
  // Default the radio button to the right state based on user state
  var state=getBuddyState(winarg);
  switch (state) {
    case "Offline": document.getElementById('onlinestateMsg').checked="true"; break;
    case "Idle":  document.getElementById('idlestateMsg').checked="true"; break;
    case "Away":  document.getElementById('awaystateMsg').checked="true"; break;
    default: break;
  }

  document.getElementById('alertwindow').checked="true";
  doSetOKCancel(onOK, 0);
}

function onOK() {
  
  var alertMaskSet= Components.interfaces.nsAimBuddyAlertMask;
  alertMaskSet=0;
  var alertEnums = Components.interfaces.nsAimBuddyAlertFlags;
  var aimBuddy=aimBuddyManager();
  var gChecked=0;
 

  // Handle save of the alert states
  if (document.getElementById("onlinestateMsg").checked) {
    alertMaskSet |=  alertEnums.AlertFromOffline;
    gChecked=1;
    }
  if (document.getElementById("idlestateMsg").checked) {
    alertMaskSet |=  alertEnums.AlertFromIdle;
    gChecked=1;
   } 
  if (document.getElementById("awaystateMsg").checked) {
    alertMaskSet |=  alertEnums.AlertFromAway;
    gChecked=1;
    }
  if (gChecked == 0)  {
      aimErrorBox(aimString("msg.chooseAlertMethod"));
      return;
      }
  var gChecked2=0;
    
  // Handle save of the alert methods
  if (document.getElementById("alertwindow").checked) {
    alertMaskSet |=  alertEnums.AlertByWindow;
    gChecked2=1;
    }
  if (document.getElementById("alertsound").checked) {
    alertMaskSet |=  alertEnums.AlertBySound;
    gChecked2=1;
    }
  if (gChecked2 == 0)  {
        aimErrorBox(aimString("msg.chooseAlertMethod"));
        return;
        }
  aimBuddy.BuddyAlert(gScreenName, alertMaskSet);
  top.window.close();
  }


function doEditAlert(ScreenName)
{

  var alertEnums = Components.interfaces.nsAimBuddyAlertFlags;
  var res=new Object();
  aimBuddyManager().GetBuddyAlert(ScreenName, res);
  var alertMaskSet = res.value;
  if (alertMaskSet & alertEnums.AlertFromOffline)
      document.getElementById("onlinestateMsg").checked="true"; 
  if (alertMaskSet & alertEnums.AlertFromIdle)
      document.getElementById("idlestateMsg").checked="true" ;
  if (alertMaskSet & alertEnums.AlertFromAway)
      document.getElementById("awaystateMsg").checked="true" ;
  if (alertMaskSet & alertEnums.AlertByWindow)
      document.getElementById("alertwindow").checked="true";
  if (alertMaskSet & alertEnums.AlertBySound)
      document.getElementById("alertsound").checked="true";
  doSetOKCancel(onOK, 0);
}

