/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef nsUCvLatinCID_h___
#define nsUCvLatinCID_h___

#include "nsISupports.h"

// Class ID for our ISO88592ToUnicode charset converter
// {7C657D11-EC5E-11d2-8AAC-00600811A836}
#define NS_ISO88592TOUNICODE_CID \
  { 0x7c657d11, 0xec5e, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our ISO88593ToUnicode charset converter
// {660D8CA0-F763-11d2-8AAD-00600811A836}
#define NS_ISO88593TOUNICODE_CID \
  { 0x660d8ca0, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our ISO88594ToUnicode charset converter
// {660D8CA1-F763-11d2-8AAD-00600811A836}
#define NS_ISO88594TOUNICODE_CID \
  { 0x660d8ca1, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our ISO88595ToUnicode charset converter
// {660D8CA2-F763-11d2-8AAD-00600811A836}
#define NS_ISO88595TOUNICODE_CID \
  { 0x660d8ca2, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our ISO88596ToUnicode charset converter
// {660D8CA3-F763-11d2-8AAD-00600811A836}
#define NS_ISO88596TOUNICODE_CID \
  { 0x660d8ca3, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our ISO88596IToUnicode charset converter
// {495ECA44-0A5C-11d4-A135-005004832142}
#define NS_ISO88596ITOUNICODE_CID \
  { 0x495eca44, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our ISO88596EToUnicode charset converter
// {495ECA45-0A5C-11d4-A135-005004832142}
#define NS_ISO88596ETOUNICODE_CID \
  { 0x495eca45, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our ISO88597ToUnicode charset converter
// {AF7A9951-AA48-11d2-B3AE-00805F8A6670}
#define NS_ISO88597TOUNICODE_CID \
  { 0xaf7a9951, 0xaa48, 0x11d2, {0xb3, 0xae, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our ISO88598ToUnicode charset converter
// {660D8CA4-F763-11d2-8AAD-00600811A836}
#define NS_ISO88598TOUNICODE_CID \
  { 0x660d8ca4, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our ISO88598EToUnicode charset converter
// {495ECA42-0A5C-11d4-A135-005004832142}
#define NS_ISO88598ETOUNICODE_CID \
  { 0x495eca42, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our ISO88598IToUnicode charset converter
// {495ECA43-0A5C-11d4-A135-005004832142}
#define NS_ISO88598ITOUNICODE_CID \
  { 0x495eca43, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our ISO88599ToUnicode charset converter
// {7C657D13-EC5E-11d2-8AAC-00600811A836}
#define NS_ISO88599TOUNICODE_CID \
  { 0x7c657d13, 0xec5e, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our ISO885914ToUnicode charset converter
// {6394EEA1-FC3D-11d2-B3B8-00805F8A6670}
#define NS_ISO885914TOUNICODE_CID \
  { 0x6394eea1, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our ISO885915ToUnicode charset converter
// {6394EEA2-FC3D-11d2-B3B8-00805F8A6670}
#define NS_ISO885915TOUNICODE_CID \
  { 0x6394eea2, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our ISO885916ToUnicode charset converter
// {A0F827E1-8AB6-11d5-A14B-005004832142}
#define NS_ISO885916TOUNICODE_CID \
  { 0xa0f827e1, 0x8ab6, 0x11d5, { 0xa1, 0x4b, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}


// Class ID for our CP1250ToUnicode charset converter
// {7C657D14-EC5E-11d2-8AAC-00600811A836}
#define NS_CP1250TOUNICODE_CID \
  { 0x7c657d14, 0xec5e, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our CP1251ToUnicode charset converter
// {A578E0A1-F76B-11d2-8AAD-00600811A836}
#define NS_CP1251TOUNICODE_CID \
  { 0xa578e0a1, 0xf76b, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our CP1253ToUnicode charset converter
// {AF7A9952-AA48-11d2-B3AE-00805F8A6670}
#define NS_CP1253TOUNICODE_CID \
  { 0xaf7a9952, 0xaa48, 0x11d2, {0xb3, 0xae, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our CP1254ToUnicode charset converter
// {7C657D17-EC5E-11d2-8AAC-00600811A836}
#define NS_CP1254TOUNICODE_CID \
  { 0x7c657d17, 0xec5e, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our CP1257ToUnicode charset converter
// {A578E0A2-F76B-11d2-8AAD-00600811A836}
#define NS_CP1257TOUNICODE_CID \
  { 0xa578e0a2, 0xf76b, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our CP1258ToUnicode charset converter
// {6394EEA3-FC3D-11d2-B3B8-00805F8A6670}
#define NS_CP1258TOUNICODE_CID \
  { 0x6394eea3, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our CP874ToUnicode charset converter
// {6394EEA4-FC3D-11d2-B3B8-00805F8A6670}
#define NS_CP874TOUNICODE_CID \
  { 0x6394eea4, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our KOI8RToUnicode charset converter
// {6394EEA5-FC3D-11d2-B3B8-00805F8A6670}
#define NS_KOI8RTOUNICODE_CID \
  { 0x6394eea5, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our KOI8UToUnicode charset converter
// {6394EEA6-FC3D-11d2-B3B8-00805F8A6670}
#define NS_KOI8UTOUNICODE_CID \
  { 0x6394eea6, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our MacCEToUnicode charset converter
// {7B8556A2-EC79-11d2-8AAC-00600811A836}
#define NS_MACCETOUNICODE_CID \
  { 0x7b8556a2, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our MacGreekToUnicode charset converter
// {7B8556A3-EC79-11d2-8AAC-00600811A836}
#define NS_MACGREEKTOUNICODE_CID \
  { 0x7b8556a3, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our MacTurkishToUnicode charset converter
// {7B8556A4-EC79-11d2-8AAC-00600811A836}
#define NS_MACTURKISHTOUNICODE_CID \
  { 0x7b8556a4, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our MacCroatianToUnicode charset converter
// {6394EEA7-FC3D-11d2-B3B8-00805F8A6670}
#define NS_MACCROATIANTOUNICODE_CID \
  { 0x6394eea7, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our MacRomanianToUnicode charset converter
// {6394EEA8-FC3D-11d2-B3B8-00805F8A6670}
#define NS_MACROMANIANTOUNICODE_CID \
  { 0x6394eea8, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our MacCyrillicToUnicode charset converter
// {6394EEA9-FC3D-11d2-B3B8-00805F8A6670}
#define NS_MACCYRILLICTOUNICODE_CID \
  { 0x6394eea9, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our MacUkrainianToUnicode charset converter
// {6394EEAA-FC3D-11d2-B3B8-00805F8A6670}
#define NS_MACUKRAINIANTOUNICODE_CID \
  { 0x6394eeaa, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our MacIcelandicToUnicode charset converter
// {6394EEAB-FC3D-11d2-B3B8-00805F8A6670}
#define NS_MACICELANDICTOUNICODE_CID \
  { 0x6394eeab, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our GEOSTD8ToUnicode charset converter
// {6394EEAF-FC3D-11d2-B3B8-00805F8A6670}
#define NS_GEOSTD8TOUNICODE_CID \
  { 0x6394eeaf, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our ARMSCII8ToUnicode charset converter
// {6394EEAC-FC3D-11d2-B3B8-00805F8A6670}
#define NS_ARMSCII8TOUNICODE_CID \
  { 0x6394eeac, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our TCVN5712ToUnicode charset converter
// {6394EEAD-FC3D-11d2-B3B8-00805F8A6670}
#define NS_TCVN5712TOUNICODE_CID \
  { 0x6394eead, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our VISCIIToUnicode charset converter
// {6394EEAE-FC3D-11d2-B3B8-00805F8A6670}
#define NS_VISCIITOUNICODE_CID \
  { 0x6394eeae, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our VPSToUnicode charset converter
// {6394EEB0-FC3D-11d2-B3B8-00805F8A6670}
#define NS_VPSTOUNICODE_CID \
  { 0x6394eeb0, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UTF7ToUnicode charset converter
// {77CFAAF1-1CF4-11d3-8AAF-00600811A836}
#define NS_UTF7TOUNICODE_CID \
  { 0x77cfaaf1, 0x1cf4, 0x11d3, {0x8a, 0xaf, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our MUTF7ToUnicode charset converter
// {B57F97C1-0D70-11d3-8AAE-00600811A836}
#define NS_MUTF7TOUNICODE_CID \
  { 0xb57f97c1, 0xd70, 0x11d3, {0x8a, 0xae, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88592 charset converter
// {7B8556A6-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOISO88592_CID \
  { 0x7b8556a6, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88593 charset converter
// {660D8CA5-F763-11d2-8AAD-00600811A836}
#define NS_UNICODETOISO88593_CID \
  { 0x660d8ca5, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88594 charset converter
// {660D8CA6-F763-11d2-8AAD-00600811A836}
#define NS_UNICODETOISO88594_CID \
  { 0x660d8ca6, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88595 charset converter
// {660D8CA7-F763-11d2-8AAD-00600811A836}
#define NS_UNICODETOISO88595_CID \
  { 0x660d8ca7, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88596 charset converter
// {660D8CA8-F763-11d2-8AAD-00600811A836}
#define NS_UNICODETOISO88596_CID \
  { 0x660d8ca8, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88596I charset converter
// {495ECA46-0A5C-11d4-A135-005004832142}
#define NS_UNICODETOISO88596I_CID \
  { 0x495eca46, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our UnicodeToISO88596E charset converter
// {495ECA47-0A5C-11d4-A135-005004832142}
#define NS_UNICODETOISO88596E_CID \
  { 0x495eca47, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our UnicodeToISO88597 charset converter
// {7B8556A8-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOISO88597_CID \
  { 0x7b8556a8, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88598 charset converter
// {660D8CA9-F763-11d2-8AAD-00600811A836}
#define NS_UNICODETOISO88598_CID \
  { 0x660d8ca9, 0xf763, 0x11d2, {0x8a, 0xad, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO88598I charset converter
// {495ECA48-0A5C-11d4-A135-005004832142}
#define NS_UNICODETOISO88598I_CID \
  { 0x495eca48, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our UnicodeToISO88598E charset converter
// {495ECA49-0A5C-11d4-A135-005004832142}
#define NS_UNICODETOISO88598E_CID \
  { 0x495eca49, 0xa5c, 0x11d4, {0xa1, 0x35, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}

// Class ID for our UnicodeToISO88599 charset converter
// {7B8556A9-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOISO88599_CID \
  { 0x7b8556a9, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToISO885914 charset converter
// {6394EEB1-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOISO885914_CID \
  { 0x6394eeb1, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToISO885915 charset converter
// {6394EEB2-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOISO885915_CID \
  { 0x6394eeb2, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToISO885916 charset converter
// {A0F827E2-8AB6-11d5-A14B-005004832142}
#define NS_UNICODETOISO885916_CID \
  { 0xa0f827e2, 0x8ab6, 0x11d5, { 0xa1, 0x4b, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42}}


// Class ID for our UnicodeToCP1250 charset converter
// {7B8556AA-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOCP1250_CID \
  { 0x7b8556aa, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToCP1251 charset converter
// {A578E0A3-F76B-11d2-8AAD-00600811A836}
#define NS_UNICODETOCP1251_CID \
  { 0xa578e0a3, 0xf76b, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToCP1253 charset converter
// {7B8556AD-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOCP1253_CID \
  { 0x7b8556ad, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToCP1254 charset converter
// {7B8556AE-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOCP1254_CID \
  { 0x7b8556ae, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToCP1257 charset converter
// {A578E0A4-F76B-11d2-8AAD-00600811A836}
#define NS_UNICODETOCP1257_CID \
  { 0xa578e0a4, 0xf76b, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToCP1258 charset converter
// {6394EEB3-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOCP1258_CID \
  { 0x6394eeb3, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToCP874 charset converter
// {6394EEB4-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOCP874_CID \
  { 0x6394eeb4, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToKOI8R charset converter
// {6394EEB5-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOKOI8R_CID \
  { 0x6394eeb5, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToKOI8U charset converter
// {6394EEB6-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOKOI8U_CID \
  { 0x6394eeb6, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToMacCE charset converter
// {7B8556B0-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOMACCE_CID \
  { 0x7b8556b0, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToMacGreek charset converter
// {7B8556B1-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOMACGREEK_CID \
  { 0x7b8556b1, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToMacTurkish charset converter
// {7B8556B2-EC79-11d2-8AAC-00600811A836}
#define NS_UNICODETOMACTURKISH_CID \
  { 0x7b8556b2, 0xec79, 0x11d2, {0x8a, 0xac, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToMacCroatian charset converter
// {6394EEB7-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOMACCROATIAN_CID \
  { 0x6394eeb7, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToMacRomanian charset converter
// {6394EEB8-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOMACROMANIAN_CID \
  { 0x6394eeb8, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToMacCyrillic charset converter
// {6394EEB9-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOMACCYRILLIC_CID \
  { 0x6394eeb9, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToMacUkrainian charset converter
// {6394EEBA-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOMACUKRAINIAN_CID \
  { 0x6394eeba, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToMacIcelandic charset converter
// {6394EEBB-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOMACICELANDIC_CID \
  { 0x6394eebb, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToGEOSTD8 charset converter
// {6394EEBE-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOGEOSTD8_CID \
  { 0x6394eebe, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToARMSCII8 charset converter
// {6394EEBC-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOARMSCII8_CID \
  { 0x6394eebc, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToTCVN5712 charset converter
// {6394EEBD-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOTCVN5712_CID \
  { 0x6394eebd, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToVISCII charset converter
// {6394EEBF-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOVISCII_CID \
  { 0x6394eebf, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToVPS charset converter
// {6394EEC0-FC3D-11d2-B3B8-00805F8A6670}
#define NS_UNICODETOVPS_CID \
  { 0x6394eec0, 0xfc3d, 0x11d2, {0xb3, 0xb8, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToUTF7 charset converter
// {77CFAAF2-1CF4-11d3-8AAF-00600811A836}
#define NS_UNICODETOUTF7_CID \
  { 0x77cfaaf2, 0x1cf4, 0x11d3, {0x8a, 0xaf, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our UnicodeToMUTF7 charset converter
// {B57F97C2-0D70-11d3-8AAE-00600811A836}
#define NS_UNICODETOMUTF7_CID \
  { 0xb57f97c2, 0xd70, 0x11d3, {0x8a, 0xae, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

// Class ID for our CP1255ToUnicode charset converter
// {BA6151A1-1DFA-11d3-B3BF-00805F8A6670}
#define NS_CP1255TOUNICODE_CID \
  { 0xba6151a1, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our CP1256ToUnicode charset converter
// {BA6151A2-1DFA-11d3-B3BF-00805F8A6670}
#define NS_CP1256TOUNICODE_CID \
  { 0xba6151a2, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToCP1255 charset converter
// {BA6151A3-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOCP1255_CID \
  { 0xba6151a3, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToCP1256 charset converter
// {BA6151A4-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOCP1256_CID \
  { 0xba6151a4, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToVIQR charset converter
// {BA6151A5-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOVIQR_CID \
  { 0xba6151a5, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our VIQRToUnicode charset converter
// {BA6151A6-1DFA-11d3-B3BF-00805F8A6670}
#define NS_VIQRTOUNICODE_CID \
  { 0xba6151a6, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToVNI charset converter
// {BA6151A7-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOVNI_CID \
  { 0xba6151a7, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our VNIToUnicode charset converter
// {BA6151A8-1DFA-11d3-B3BF-00805F8A6670}
#define NS_VNITOUNICODE_CID \
  { 0xba6151a8, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our CP866ToUnicode charset converter
// {BA6151A9-1DFA-11d3-B3BF-00805F8A6670}
#define NS_CP866TOUNICODE_CID \
  { 0xba6151a9, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToCP866 charset converter
// {BA6151AA-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOCP866_CID \
  { 0xba6151aa, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToISO885910 charset converter
// {BA6151AB-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOISO885910_CID \
  { 0xba6151ab, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToISO885913 charset converter
// {BA6151AC-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOISO885913_CID \
  { 0xba6151ac, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToUTF16BE charset converter
// {BA6151AD-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOUTF16BE_CID \
  { 0xba6151ad, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToUTF32BE charset converter
// {BA6151AE-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOUTF32BE_CID \
  { 0xba6151ae, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToT61 charset converter
// {BA6151AF-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOT61_CID \
  { 0xba6151af, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our ISO885910ToUnicode charset converter
// {BA6151B0-1DFA-11d3-B3BF-00805F8A6670}
#define NS_ISO885910TOUNICODE_CID \
  { 0xba6151b0, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our ISO885913ToUnicode charset converter
// {BA6151B1-1DFA-11d3-B3BF-00805F8A6670}
#define NS_ISO885913TOUNICODE_CID \
  { 0xba6151b1, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UTF16BEToUnicode charset converter
// {BA6151B2-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UTF16BETOUNICODE_CID \
  { 0xba6151b2, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UTF32BEToUnicode charset converter
// {BA6151B3-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UTF32BETOUNICODE_CID \
  { 0xba6151b3, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our T61ToUnicode charset converter
// {BA6151B4-1DFA-11d3-B3BF-00805F8A6670}
#define NS_T61TOUNICODE_CID \
  { 0xba6151b4, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToUTF16LE charset converter
// {BA6151B5-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOUTF16LE_CID \
  { 0xba6151b5, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToUTF32LE charset converter
// {BA6151B6-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UNICODETOUTF32LE_CID \
  { 0xba6151b6, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UTF16LEToUnicode charset converter
// {BA6151B7-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UTF16LETOUNICODE_CID \
  { 0xba6151b7, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UTF32LEToUnicode charset converter
// {BA6151B8-1DFA-11d3-B3BF-00805F8A6670}
#define NS_UTF32LETOUNICODE_CID \
  { 0xba6151b8, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our ISOIR111ToUnicode charset converter
#define NS_ISOIR111TOUNICODE_CID \
  { 0x9416bfb1, 0x1f93, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UserDefinedToUnicode charset converter
#define NS_USERDEFINEDTOUNICODE_CID \
  { 0x9416bfb2, 0x1f93, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToISOIR111 charset converter
#define NS_UNICODETOISOIR111_CID \
  { 0x9416bfb3, 0x1f93, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToUserDefined charset converter
#define NS_UNICODETOUSERDEFINED_CID \
  { 0x9416bfb4, 0x1f93, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our AsciiToUnicode charset converter
#define NS_ASCIITOUNICODE_CID \
  { 0xba6151b9, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToAscii charset converter
#define NS_UNICODETOASCII_CID \
  { 0xba6151ba, 0x1dfa, 0x11d3, {0xb3, 0xbf, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToAscii charset converter
#define NS_UNICODETOSYMBOL_CID \
  { 0x21dd6a02, 0x413c, 0x11d3, {0xb3, 0xc3, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToAscii charset converter
#define NS_UNICODETOZAPFDINGBATS_CID \
  { 0x21dd6a03, 0x413c, 0x11d3, {0xb3, 0xc3, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// Class ID for our UnicodeToAscii charset converter
#define NS_UNICODETOADOBEEURO_CID \
  { 0x822cb9ae, 0x6421, 0x4484, {0xb3, 0xc3, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// {4F26B731-46CB-11d3-B3C3-00805F8A6670}
#define NS_UNICODETOTIS620WIN_CID \
  { 0x4f26b731, 0x46cb, 0x11d3, {0xb3, 0xc3, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// {319FF9C2-51D2-11d3-B3C3-00805F8A6670}
#define NS_UESCAPETOUNICODE_CID \
  { 0x319ff9c2, 0x51d2, 0x11d3, {0xb3, 0xc3, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// {319FF9C3-51D2-11d3-B3C3-00805F8A6670}
#define NS_UNICODETOUESCAPE_CID \
  { 0x319ff9c3, 0x51d2, 0x11d3, {0xb3, 0xc3, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// {49B38F11-6193-11d3-B3C5-00805F8A6670}
#define NS_UNICODETOLANGBOXARABIC8_CID \
  { 0x49b38f11, 0x6193, 0x11d3, {0xb3, 0xc5, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// {49B38F12-6193-11d3-B3C5-00805F8A6670}
#define NS_UNICODETOUTF16_CID \
  { 0x49b38f12, 0x6193, 0x11d3, {0xb3, 0xc5, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// {49B38F14-6193-11d3-B3C5-00805F8A6670}
#define NS_UNICODETOUTF32_CID \
  { 0x49b38f14, 0x6193, 0x11d3, {0xb3, 0xc5, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70}}

// {6803CAC4-1E3B-11d5-A145-005004832142}
#define NS_MACDEVANAGARITOUNICODE_CID \
  { 0x6803cac4, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CAC5-1E3B-11d5-A145-005004832142}
#define NS_UNICODETOMACDEVANAGARI_CID \
  { 0x6803cac5, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CAC6-1E3B-11d5-A145-005004832142}
#define NS_MACARABICTOUNICODE_CID \
  { 0x6803cac6, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CAC7-1E3B-11d5-A145-005004832142}
#define NS_UNICODETOMACARABIC_CID \
  { 0x6803cac7, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CAC8-1E3B-11d5-A145-005004832142}
#define NS_MACFARSITOUNICODE_CID \
  { 0x6803cac8, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CAC9-1E3B-11d5-A145-005004832142}
#define NS_UNICODETOMACFARSI_CID \
  { 0x6803cac9, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CACA-1E3B-11d5-A145-005004832142}
#define NS_MACGUJARATITOUNICODE_CID \
  { 0x6803caca, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CACB-1E3B-11d5-A145-005004832142}
#define NS_UNICODETOMACGUJARATI_CID \
  { 0x6803cacb, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CACC-1E3B-11d5-A145-005004832142}
#define NS_MACHEBREWTOUNICODE_CID \
  { 0x6803cacc, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CACD-1E3B-11d5-A145-005004832142}
#define NS_UNICODETOMACHEBREW_CID \
  { 0x6803cacd, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CACE-1E3B-11d5-A145-005004832142}
#define NS_MACGURMUKHITOUNICODE_CID \
  { 0x6803cace, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {6803CACF-1E3B-11d5-A145-005004832142}
#define NS_UNICODETOMACGURMUKHI_CID \
  { 0x6803cacf, 0x1e3b, 0x11d5, { 0xa1, 0x45, 0x0, 0x50, 0x4, 0x83, 0x21, 0x42 } }

// {4DBBD94F-0153-44cb-966A-7F39B9CB477D}
#define NS_UNICODETOLANGBOXARABIC_CID \
  { 0x4dbbd94f, 0x153, 0x44cb, { 0x96, 0x6a, 0x7f, 0x39, 0xb9, 0xcb, 0x47, 0x7d } }

#endif /* nsUCvLatinCID_h___ */
