/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIImapService.idl
 */

#ifndef __gen_nsIImapService_h__
#define __gen_nsIImapService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIImapUrl_h__
#include "nsIImapUrl.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIImapProtocol; /* forward declaration */

class nsIImapMessageSink; /* forward declaration */

class nsIUrlListener; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIEventQueue; /* forward declaration */

class nsIMsgFolder; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIImapIncomingServer; /* forward declaration */

class nsICacheSession; /* forward declaration */


/* starting interface:    nsIImapService */
#define NS_IIMAPSERVICE_IID_STR "18236127-fa1d-11d3-98ba-001083010e9b"

#define NS_IIMAPSERVICE_IID \
  {0x18236127, 0xfa1d, 0x11d3, \
    { 0x98, 0xba, 0x00, 0x10, 0x83, 0x01, 0x0e, 0x9b }}

class NS_NO_VTABLE nsIImapService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IIMAPSERVICE_IID)

  /* void selectFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
  NS_IMETHOD SelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL) = 0;

  /* void liteSelectFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_IMETHOD LiteSelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) = 0;

  /* void fetchMessage (in nsIImapUrl aUrl, in nsImapState aImapAction, in nsIMsgFolder aImapMailFolder, in nsIImapMessageSink aImapMessageSink, in nsIMsgWindow aMsgWindow, in nsISupports aConsumer, in string aMessageIdentifierList, in boolean convertDataToText, in string additionalHeader, out nsIURI aOutURL); */
  NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const char *aMessageIdentifierList, PRBool convertDataToText, const char *additionalHeader, nsIURI **aOutURL) = 0;

  /* void noop (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_IMETHOD Noop(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) = 0;

  /* void getHeaders (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in boolean aMessageIdsAreUID); */
  NS_IMETHOD GetHeaders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID) = 0;

  /* void expunge (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_IMETHOD Expunge(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) = 0;

  /* void biff (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in unsigned long aUidHighWater); */
  NS_IMETHOD Biff(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, PRUint32 aUidHighWater) = 0;

  /* void deleteMessages (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in boolean aMessageIdsAreUID); */
  NS_IMETHOD DeleteMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID) = 0;

  /* void deleteAllMessages (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_IMETHOD DeleteAllMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) = 0;

  /* void addMessageFlags (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
  NS_IMETHOD AddMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) = 0;

  /* void subtractMessageFlags (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
  NS_IMETHOD SubtractMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) = 0;

  /* void setMessageFlags (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
  NS_IMETHOD SetMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) = 0;

  /* void discoverAllFolders (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
  NS_IMETHOD DiscoverAllFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL) = 0;

  /* void discoverAllAndSubscribedFolders (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
  NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) = 0;

  /* void discoverChildren (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in string folderPath, out nsIURI aURL); */
  NS_IMETHOD DiscoverChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, nsIURI **aURL) = 0;

  /* void discoverLevelChildren (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in string folderPath, in long aLevel, out nsIURI aURL); */
  NS_IMETHOD DiscoverLevelChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, PRInt32 aLevel, nsIURI **aURL) = 0;

  /* void onlineMessageCopy (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aSrcFolder, in string aMessageIds, in nsIMsgFolder aDstFolder, in boolean aIdsAreUids, in boolean aIsMove, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aWindow); */
  NS_IMETHOD OnlineMessageCopy(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const char *aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aWindow) = 0;

  /* void appendMessageFromFile (in nsIEventQueue aClientEventQueue, in nsIFileSpec aFileSpec, in nsIMsgFolder aDstFolder, in string aMessageId, in boolean idsAreUids, in boolean aInSelectedState, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aMsgWindow); */
  NS_IMETHOD AppendMessageFromFile(nsIEventQueue *aClientEventQueue, nsIFileSpec *aFileSpec, nsIMsgFolder *aDstFolder, const char *aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow) = 0;

  /* void downloadMessagesForOffline (in string aMessageIds, in nsIMsgFolder aSrcFolder, in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  NS_IMETHOD DownloadMessagesForOffline(const char *aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) = 0;

  /* nsIURI moveFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aSrcFolder, in nsIMsgFolder aDstFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
  NS_IMETHOD MoveFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval) = 0;

  /* nsIURI renameLeaf (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aSrcFolder, in wstring aLeafName, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
  NS_IMETHOD RenameLeaf(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval) = 0;

  /* nsIURI deleteFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aFolder, in nsIUrlListener aUrlListener); */
  NS_IMETHOD DeleteFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIURI **_retval) = 0;

  /* nsIURI createFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aParentFolder, in wstring aLeafName, in nsIUrlListener aUrlListener); */
  NS_IMETHOD CreateFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval) = 0;

  /* nsIURI listFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIUrlListener aUrlListener); */
  NS_IMETHOD ListFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval) = 0;

  /* nsIURI subscribeFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in wstring mailboxName, in nsIUrlListener aUrlListener); */
  NS_IMETHOD SubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval) = 0;

  /* nsIURI unsubscribeFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in wstring mailboxName, in nsIUrlListener aUrlListener); */
  NS_IMETHOD UnsubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval) = 0;

  /* nsIURI ensureFolderExists (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aParentFolder, in wstring aLeafName, in nsIUrlListener aUrlListener); */
  NS_IMETHOD EnsureFolderExists(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval) = 0;

  /* nsIURI getFolderAdminUrl (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
  NS_IMETHOD GetFolderAdminUrl(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval) = 0;

  /* nsIURI issueCommandOnMsgs (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in string aCommand, in string aMessageIdentifierList); */
  NS_IMETHOD IssueCommandOnMsgs(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aCommand, const char *aMessageIdentifierList, nsIURI **_retval) = 0;

  /* nsIURI fetchCustomMsgAttribute (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in string aAttribute, in string aMessageIdentifierList); */
  NS_IMETHOD FetchCustomMsgAttribute(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aAttribute, const char *aMessageIdentifierList, nsIURI **_retval) = 0;

  /* nsIURI storeCustomKeywords (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in string flagsToAdd, in string flagsToSubtract, in string aMessageIdentifierList); */
  NS_IMETHOD StoreCustomKeywords(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *flagsToAdd, const char *flagsToSubtract, const char *aMessageIdentifierList, nsIURI **_retval) = 0;

  /* void getListOfFoldersOnServer (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow); */
  NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow) = 0;

  /* void getListOfFoldersWithPath (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow, in string folderPath); */
  NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const char *folderPath) = 0;

  /* nsISupports playbackAllOfflineOperations (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
  NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval) = 0;

  /* void downloadAllOffineImapFolders (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
  NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) = 0;

  /* readonly attribute nsICacheSession cacheSession; */
  NS_IMETHOD GetCacheSession(nsICacheSession * *aCacheSession) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIIMAPSERVICE \
  NS_IMETHOD SelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL); \
  NS_IMETHOD LiteSelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL); \
  NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const char *aMessageIdentifierList, PRBool convertDataToText, const char *additionalHeader, nsIURI **aOutURL); \
  NS_IMETHOD Noop(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL); \
  NS_IMETHOD GetHeaders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID); \
  NS_IMETHOD Expunge(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL); \
  NS_IMETHOD Biff(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, PRUint32 aUidHighWater); \
  NS_IMETHOD DeleteMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID); \
  NS_IMETHOD DeleteAllMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL); \
  NS_IMETHOD AddMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID); \
  NS_IMETHOD SubtractMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID); \
  NS_IMETHOD SetMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID); \
  NS_IMETHOD DiscoverAllFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL); \
  NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL); \
  NS_IMETHOD DiscoverChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, nsIURI **aURL); \
  NS_IMETHOD DiscoverLevelChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, PRInt32 aLevel, nsIURI **aURL); \
  NS_IMETHOD OnlineMessageCopy(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const char *aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aWindow); \
  NS_IMETHOD AppendMessageFromFile(nsIEventQueue *aClientEventQueue, nsIFileSpec *aFileSpec, nsIMsgFolder *aDstFolder, const char *aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow); \
  NS_IMETHOD DownloadMessagesForOffline(const char *aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow); \
  NS_IMETHOD MoveFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval); \
  NS_IMETHOD RenameLeaf(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval); \
  NS_IMETHOD DeleteFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIURI **_retval); \
  NS_IMETHOD CreateFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval); \
  NS_IMETHOD ListFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval); \
  NS_IMETHOD SubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval); \
  NS_IMETHOD UnsubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval); \
  NS_IMETHOD EnsureFolderExists(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval); \
  NS_IMETHOD GetFolderAdminUrl(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval); \
  NS_IMETHOD IssueCommandOnMsgs(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aCommand, const char *aMessageIdentifierList, nsIURI **_retval); \
  NS_IMETHOD FetchCustomMsgAttribute(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aAttribute, const char *aMessageIdentifierList, nsIURI **_retval); \
  NS_IMETHOD StoreCustomKeywords(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *flagsToAdd, const char *flagsToSubtract, const char *aMessageIdentifierList, nsIURI **_retval); \
  NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow); \
  NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const char *folderPath); \
  NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval); \
  NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener); \
  NS_IMETHOD GetCacheSession(nsICacheSession * *aCacheSession); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIIMAPSERVICE(_to) \
  NS_IMETHOD SelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL) { return _to SelectFolder(aClientEventQueue, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_IMETHOD LiteSelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return _to LiteSelectFolder(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const char *aMessageIdentifierList, PRBool convertDataToText, const char *additionalHeader, nsIURI **aOutURL) { return _to FetchMessage(aUrl, aImapAction, aImapMailFolder, aImapMessageSink, aMsgWindow, aConsumer, aMessageIdentifierList, convertDataToText, additionalHeader, aOutURL); } \
  NS_IMETHOD Noop(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return _to Noop(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD GetHeaders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID) { return _to GetHeaders(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_IMETHOD Expunge(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return _to Expunge(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD Biff(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, PRUint32 aUidHighWater) { return _to Biff(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aUidHighWater); } \
  NS_IMETHOD DeleteMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID) { return _to DeleteMessages(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_IMETHOD DeleteAllMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return _to DeleteAllMessages(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD AddMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return _to AddMessageFlags(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_IMETHOD SubtractMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return _to SubtractMessageFlags(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_IMETHOD SetMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return _to SetMessageFlags(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_IMETHOD DiscoverAllFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL) { return _to DiscoverAllFolders(aClientEventQueue, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return _to DiscoverAllAndSubscribedFolders(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD DiscoverChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, nsIURI **aURL) { return _to DiscoverChildren(aClientEventQueue, aImapMailFolder, aUrlListener, folderPath, aURL); } \
  NS_IMETHOD DiscoverLevelChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, PRInt32 aLevel, nsIURI **aURL) { return _to DiscoverLevelChildren(aClientEventQueue, aImapMailFolder, aUrlListener, folderPath, aLevel, aURL); } \
  NS_IMETHOD OnlineMessageCopy(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const char *aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aWindow) { return _to OnlineMessageCopy(aClientEventQueue, aSrcFolder, aMessageIds, aDstFolder, aIdsAreUids, aIsMove, aUrlListener, aURL, aCopyState, aWindow); } \
  NS_IMETHOD AppendMessageFromFile(nsIEventQueue *aClientEventQueue, nsIFileSpec *aFileSpec, nsIMsgFolder *aDstFolder, const char *aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow) { return _to AppendMessageFromFile(aClientEventQueue, aFileSpec, aDstFolder, aMessageId, idsAreUids, aInSelectedState, aUrlListener, aURL, aCopyState, aMsgWindow); } \
  NS_IMETHOD DownloadMessagesForOffline(const char *aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return _to DownloadMessagesForOffline(aMessageIds, aSrcFolder, aListener, aMsgWindow); } \
  NS_IMETHOD MoveFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval) { return _to MoveFolder(aClientEventQueue, aSrcFolder, aDstFolder, aUrlListener, msgWindow, _retval); } \
  NS_IMETHOD RenameLeaf(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval) { return _to RenameLeaf(aClientEventQueue, aSrcFolder, aLeafName, aUrlListener, msgWindow, _retval); } \
  NS_IMETHOD DeleteFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIURI **_retval) { return _to DeleteFolder(aClientEventQueue, aFolder, aUrlListener, _retval); } \
  NS_IMETHOD CreateFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return _to CreateFolder(aClientEventQueue, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_IMETHOD ListFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval) { return _to ListFolder(aClientEventQueue, aMailFolder, aUrlListener, _retval); } \
  NS_IMETHOD SubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return _to SubscribeFolder(aClientEventQueue, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_IMETHOD UnsubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return _to UnsubscribeFolder(aClientEventQueue, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_IMETHOD EnsureFolderExists(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return _to EnsureFolderExists(aClientEventQueue, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_IMETHOD GetFolderAdminUrl(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval) { return _to GetFolderAdminUrl(aClientEventQueue, aMailFolder, aMsgWindow, aUrlListener, _retval); } \
  NS_IMETHOD IssueCommandOnMsgs(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aCommand, const char *aMessageIdentifierList, nsIURI **_retval) { return _to IssueCommandOnMsgs(aClientEventQueue, aMailFolder, aMsgWindow, aCommand, aMessageIdentifierList, _retval); } \
  NS_IMETHOD FetchCustomMsgAttribute(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aAttribute, const char *aMessageIdentifierList, nsIURI **_retval) { return _to FetchCustomMsgAttribute(aClientEventQueue, aMailFolder, aMsgWindow, aAttribute, aMessageIdentifierList, _retval); } \
  NS_IMETHOD StoreCustomKeywords(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *flagsToAdd, const char *flagsToSubtract, const char *aMessageIdentifierList, nsIURI **_retval) { return _to StoreCustomKeywords(aClientEventQueue, aMailFolder, aMsgWindow, flagsToAdd, flagsToSubtract, aMessageIdentifierList, _retval); } \
  NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow) { return _to GetListOfFoldersOnServer(aServer, aMsgWindow); } \
  NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const char *folderPath) { return _to GetListOfFoldersWithPath(aServer, aMsgWindow, folderPath); } \
  NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval) { return _to PlaybackAllOfflineOperations(aMsgWindow, aListener, _retval); } \
  NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return _to DownloadAllOffineImapFolders(aMsgWindow, aListener); } \
  NS_IMETHOD GetCacheSession(nsICacheSession * *aCacheSession) { return _to GetCacheSession(aCacheSession); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIIMAPSERVICE(_to) \
  NS_IMETHOD SelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectFolder(aClientEventQueue, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_IMETHOD LiteSelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->LiteSelectFolder(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const char *aMessageIdentifierList, PRBool convertDataToText, const char *additionalHeader, nsIURI **aOutURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchMessage(aUrl, aImapAction, aImapMailFolder, aImapMessageSink, aMsgWindow, aConsumer, aMessageIdentifierList, convertDataToText, additionalHeader, aOutURL); } \
  NS_IMETHOD Noop(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->Noop(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD GetHeaders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHeaders(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_IMETHOD Expunge(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->Expunge(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD Biff(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, PRUint32 aUidHighWater) { return !_to ? NS_ERROR_NULL_POINTER : _to->Biff(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aUidHighWater); } \
  NS_IMETHOD DeleteMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteMessages(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aMessageIdsAreUID); } \
  NS_IMETHOD DeleteAllMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteAllMessages(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD AddMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddMessageFlags(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_IMETHOD SubtractMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->SubtractMessageFlags(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_IMETHOD SetMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMessageFlags(aClientEventQueue, aImapMailFolder, aUrlListener, aURL, aMessageIdentifierList, aFlags, aMessageIdsAreUID); } \
  NS_IMETHOD DiscoverAllFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoverAllFolders(aClientEventQueue, aImapMailFolder, aUrlListener, aMsgWindow, aURL); } \
  NS_IMETHOD DiscoverAllAndSubscribedFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoverAllAndSubscribedFolders(aClientEventQueue, aImapMailFolder, aUrlListener, aURL); } \
  NS_IMETHOD DiscoverChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoverChildren(aClientEventQueue, aImapMailFolder, aUrlListener, folderPath, aURL); } \
  NS_IMETHOD DiscoverLevelChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, PRInt32 aLevel, nsIURI **aURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscoverLevelChildren(aClientEventQueue, aImapMailFolder, aUrlListener, folderPath, aLevel, aURL); } \
  NS_IMETHOD OnlineMessageCopy(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const char *aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnlineMessageCopy(aClientEventQueue, aSrcFolder, aMessageIds, aDstFolder, aIdsAreUids, aIsMove, aUrlListener, aURL, aCopyState, aWindow); } \
  NS_IMETHOD AppendMessageFromFile(nsIEventQueue *aClientEventQueue, nsIFileSpec *aFileSpec, nsIMsgFolder *aDstFolder, const char *aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->AppendMessageFromFile(aClientEventQueue, aFileSpec, aDstFolder, aMessageId, idsAreUids, aInSelectedState, aUrlListener, aURL, aCopyState, aMsgWindow); } \
  NS_IMETHOD DownloadMessagesForOffline(const char *aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadMessagesForOffline(aMessageIds, aSrcFolder, aListener, aMsgWindow); } \
  NS_IMETHOD MoveFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->MoveFolder(aClientEventQueue, aSrcFolder, aDstFolder, aUrlListener, msgWindow, _retval); } \
  NS_IMETHOD RenameLeaf(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->RenameLeaf(aClientEventQueue, aSrcFolder, aLeafName, aUrlListener, msgWindow, _retval); } \
  NS_IMETHOD DeleteFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteFolder(aClientEventQueue, aFolder, aUrlListener, _retval); } \
  NS_IMETHOD CreateFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateFolder(aClientEventQueue, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_IMETHOD ListFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ListFolder(aClientEventQueue, aMailFolder, aUrlListener, _retval); } \
  NS_IMETHOD SubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->SubscribeFolder(aClientEventQueue, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_IMETHOD UnsubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnsubscribeFolder(aClientEventQueue, aMailFolder, mailboxName, aUrlListener, _retval); } \
  NS_IMETHOD EnsureFolderExists(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnsureFolderExists(aClientEventQueue, aParentFolder, aLeafName, aUrlListener, _retval); } \
  NS_IMETHOD GetFolderAdminUrl(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFolderAdminUrl(aClientEventQueue, aMailFolder, aMsgWindow, aUrlListener, _retval); } \
  NS_IMETHOD IssueCommandOnMsgs(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aCommand, const char *aMessageIdentifierList, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IssueCommandOnMsgs(aClientEventQueue, aMailFolder, aMsgWindow, aCommand, aMessageIdentifierList, _retval); } \
  NS_IMETHOD FetchCustomMsgAttribute(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aAttribute, const char *aMessageIdentifierList, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchCustomMsgAttribute(aClientEventQueue, aMailFolder, aMsgWindow, aAttribute, aMessageIdentifierList, _retval); } \
  NS_IMETHOD StoreCustomKeywords(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *flagsToAdd, const char *flagsToSubtract, const char *aMessageIdentifierList, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->StoreCustomKeywords(aClientEventQueue, aMailFolder, aMsgWindow, flagsToAdd, flagsToSubtract, aMessageIdentifierList, _retval); } \
  NS_IMETHOD GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListOfFoldersOnServer(aServer, aMsgWindow); } \
  NS_IMETHOD GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const char *folderPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListOfFoldersWithPath(aServer, aMsgWindow, folderPath); } \
  NS_IMETHOD PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->PlaybackAllOfflineOperations(aMsgWindow, aListener, _retval); } \
  NS_IMETHOD DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener) { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadAllOffineImapFolders(aMsgWindow, aListener); } \
  NS_IMETHOD GetCacheSession(nsICacheSession * *aCacheSession) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCacheSession(aCacheSession); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsImapService : public nsIImapService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIIMAPSERVICE

  nsImapService();
  virtual ~nsImapService();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsImapService, nsIImapService)

nsImapService::nsImapService()
{
  /* member initializers and constructor code */
}

nsImapService::~nsImapService()
{
  /* destructor code */
}

/* void selectFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::SelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void liteSelectFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::LiteSelectFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void fetchMessage (in nsIImapUrl aUrl, in nsImapState aImapAction, in nsIMsgFolder aImapMailFolder, in nsIImapMessageSink aImapMessageSink, in nsIMsgWindow aMsgWindow, in nsISupports aConsumer, in string aMessageIdentifierList, in boolean convertDataToText, in string additionalHeader, out nsIURI aOutURL); */
NS_IMETHODIMP nsImapService::FetchMessage(nsIImapUrl *aUrl, nsImapState aImapAction, nsIMsgFolder *aImapMailFolder, nsIImapMessageSink *aImapMessageSink, nsIMsgWindow *aMsgWindow, nsISupports *aConsumer, const char *aMessageIdentifierList, PRBool convertDataToText, const char *additionalHeader, nsIURI **aOutURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void noop (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::Noop(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getHeaders (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::GetHeaders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void expunge (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::Expunge(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void biff (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in unsigned long aUidHighWater); */
NS_IMETHODIMP nsImapService::Biff(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, PRUint32 aUidHighWater)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteMessages (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::DeleteMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteAllMessages (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DeleteAllMessages(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addMessageFlags (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::AddMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void subtractMessageFlags (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::SubtractMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setMessageFlags (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL, in string aMessageIdentifierList, in imapMessageFlagsType aFlags, in boolean aMessageIdsAreUID); */
NS_IMETHODIMP nsImapService::SetMessageFlags(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL, const char *aMessageIdentifierList, imapMessageFlagsType aFlags, PRBool aMessageIdsAreUID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoverAllFolders (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DiscoverAllFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *aMsgWindow, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoverAllAndSubscribedFolders (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DiscoverAllAndSubscribedFolders(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoverChildren (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in string folderPath, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DiscoverChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void discoverLevelChildren (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aImapMailFolder, in nsIUrlListener aUrlListener, in string folderPath, in long aLevel, out nsIURI aURL); */
NS_IMETHODIMP nsImapService::DiscoverLevelChildren(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aImapMailFolder, nsIUrlListener *aUrlListener, const char *folderPath, PRInt32 aLevel, nsIURI **aURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onlineMessageCopy (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aSrcFolder, in string aMessageIds, in nsIMsgFolder aDstFolder, in boolean aIdsAreUids, in boolean aIsMove, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsImapService::OnlineMessageCopy(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const char *aMessageIds, nsIMsgFolder *aDstFolder, PRBool aIdsAreUids, PRBool aIsMove, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void appendMessageFromFile (in nsIEventQueue aClientEventQueue, in nsIFileSpec aFileSpec, in nsIMsgFolder aDstFolder, in string aMessageId, in boolean idsAreUids, in boolean aInSelectedState, in nsIUrlListener aUrlListener, out nsIURI aURL, in nsISupports aCopyState, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::AppendMessageFromFile(nsIEventQueue *aClientEventQueue, nsIFileSpec *aFileSpec, nsIMsgFolder *aDstFolder, const char *aMessageId, PRBool idsAreUids, PRBool aInSelectedState, nsIUrlListener *aUrlListener, nsIURI **aURL, nsISupports *aCopyState, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void downloadMessagesForOffline (in string aMessageIds, in nsIMsgFolder aSrcFolder, in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::DownloadMessagesForOffline(const char *aMessageIds, nsIMsgFolder *aSrcFolder, nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI moveFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aSrcFolder, in nsIMsgFolder aDstFolder, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsImapService::MoveFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, nsIMsgFolder *aDstFolder, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI renameLeaf (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aSrcFolder, in wstring aLeafName, in nsIUrlListener aUrlListener, in nsIMsgWindow msgWindow); */
NS_IMETHODIMP nsImapService::RenameLeaf(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aSrcFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIMsgWindow *msgWindow, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI deleteFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aFolder, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::DeleteFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aFolder, nsIUrlListener *aUrlListener, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI createFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aParentFolder, in wstring aLeafName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::CreateFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI listFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::ListFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIUrlListener *aUrlListener, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI subscribeFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in wstring mailboxName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::SubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI unsubscribeFolder (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in wstring mailboxName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::UnsubscribeFolder(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, const PRUnichar *mailboxName, nsIUrlListener *aUrlListener, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI ensureFolderExists (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aParentFolder, in wstring aLeafName, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::EnsureFolderExists(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aParentFolder, const PRUnichar *aLeafName, nsIUrlListener *aUrlListener, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI getFolderAdminUrl (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
NS_IMETHODIMP nsImapService::GetFolderAdminUrl(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, nsIUrlListener *aUrlListener, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI issueCommandOnMsgs (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in string aCommand, in string aMessageIdentifierList); */
NS_IMETHODIMP nsImapService::IssueCommandOnMsgs(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aCommand, const char *aMessageIdentifierList, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI fetchCustomMsgAttribute (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in string aAttribute, in string aMessageIdentifierList); */
NS_IMETHODIMP nsImapService::FetchCustomMsgAttribute(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *aAttribute, const char *aMessageIdentifierList, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI storeCustomKeywords (in nsIEventQueue aClientEventQueue, in nsIMsgFolder aMailFolder, in nsIMsgWindow aMsgWindow, in string flagsToAdd, in string flagsToSubtract, in string aMessageIdentifierList); */
NS_IMETHODIMP nsImapService::StoreCustomKeywords(nsIEventQueue *aClientEventQueue, nsIMsgFolder *aMailFolder, nsIMsgWindow *aMsgWindow, const char *flagsToAdd, const char *flagsToSubtract, const char *aMessageIdentifierList, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getListOfFoldersOnServer (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsImapService::GetListOfFoldersOnServer(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getListOfFoldersWithPath (in nsIImapIncomingServer aServer, in nsIMsgWindow aMsgWindow, in string folderPath); */
NS_IMETHODIMP nsImapService::GetListOfFoldersWithPath(nsIImapIncomingServer *aServer, nsIMsgWindow *aMsgWindow, const char *folderPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupports playbackAllOfflineOperations (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
NS_IMETHODIMP nsImapService::PlaybackAllOfflineOperations(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener, nsISupports **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void downloadAllOffineImapFolders (in nsIMsgWindow aMsgWindow, in nsIUrlListener aListener); */
NS_IMETHODIMP nsImapService::DownloadAllOffineImapFolders(nsIMsgWindow *aMsgWindow, nsIUrlListener *aListener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsICacheSession cacheSession; */
NS_IMETHODIMP nsImapService::GetCacheSession(nsICacheSession * *aCacheSession)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIImapService_h__ */
