/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIHTMLEditor.idl
 */

#ifndef __gen_nsIHTMLEditor_h__
#define __gen_nsIHTMLEditor_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

#ifndef __gen_nsIAtom_h__
#include "nsIAtom.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsISupportsArray; /* forward declaration */

#define NS_EDITOR_ELEMENT_NOT_FOUND \
  NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_EDITOR, 1)

/* starting interface:    nsIHTMLEditor */
#define NS_IHTMLEDITOR_IID_STR "4b0fd0d0-1dd2-11b2-bf2e-ef20fbca2c88"

#define NS_IHTMLEDITOR_IID \
  {0x4b0fd0d0, 0x1dd2, 0x11b2, \
    { 0xbf, 0x2e, 0xef, 0x20, 0xfb, 0xca, 0x2c, 0x88 }}

class nsIHTMLEditor : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IHTMLEDITOR_IID)

  typedef short EAlignment;
  enum { eLeft = 0 };

  enum { eCenter = 1 };

  enum { eRight = 2 };

  enum { eJustify = 3 };

  /**
   * SetInlineProperty() sets the aggregate properties on the current selection
   *
   * @param aProperty   the property to set on the selection 
   * @param aAttribute  the attribute of the property, if applicable.
   *                    May be null.
   *                    Example: aProperty="font", aAttribute="color"
   * @param aValue      if aAttribute is not null, the value of the attribute.
   *                    May be null.
   *                    Example: aProperty="font", aAttribute="color",
   *                             aValue="0x00FFFF"
   */
  /* void setCSSInlineProperty (in nsIAtom aProperty, in AString aAttribute, in AString aValue); */
  NS_IMETHOD SetCSSInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue) = 0;

  /* void setInlineProperty (in nsIAtom aProperty, in AString aAttribute, in AString aValue); */
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue) = 0;

  /**
   * getInlineProperty() gets aggregate properties of the current selection.
   * All object in the current selection are scanned and their attributes are
   * represented in a list of Property object.
   *
   * @param aProperty   the property to get on the selection 
   * @param aAttribute  the attribute of the property, if applicable.
   *                    May be null.
   *                    Example: aProperty="font", aAttribute="color"
   * @param aValue      if aAttribute is not null, the value of the attribute.
   *                    May be null.
   *                    Example: aProperty="font", aAttribute="color",
   *                             aValue="0x00FFFF"
   * @param aFirst      [OUT] PR_TRUE if the first text node in the
   *                          selection has the property
   * @param aAny        [OUT] PR_TRUE if any of the text nodes in the
   *                          selection have the property
   * @param aAll        [OUT] PR_TRUE if all of the text nodes in the
   *                          selection have the property
   */
  /* void getInlineProperty (in nsIAtom aProperty, in AString aAttribute, in AString aValue, out boolean aFirst, out boolean aAny, out boolean aAll); */
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll) = 0;

  /* AString getInlinePropertyWithAttrValue (in nsIAtom aProperty, in AString aAttribute, in AString aValue, out boolean aFirst, out boolean aAny, out boolean aAll); */
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAString & _retval) = 0;

  /**
   * removeAllInlineProperties() deletes all the inline properties from all 
   * text in the current selection.
   */
  /* void removeAllInlineProperties (); */
  NS_IMETHOD RemoveAllInlineProperties(void) = 0;

  /**
   * removeInlineProperty() deletes the properties from all text in the current
   * selection.  If aProperty is not set on the selection, nothing is done.
   *
   * @param aProperty   the property to remove from the selection 
   *                    All atoms are for normal HTML tags (e.g.:
   *                    nsIEditorProperty::font) except when you want to
   *                    remove just links and not named anchors.
   *                    For that, use nsIEditorProperty::href
   * @param aAttribute  the attribute of the property, if applicable.
   *                    May be null.
   *                    Example: aProperty=nsIEditorProptery::font,
   *                    aAttribute="color"
   *                    nsIEditProperty::allAttributes is special.
   *                    It indicates that all content-based text properties
   *                    are to be removed from the selection.
   */
  /* void removeInlineProperty (in nsIAtom aProperty, in AString aAttribute); */
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute) = 0;

  /**
   *  Increase font size for text in selection by 1 HTML unit
   *  All existing text is scanned for existing <FONT SIZE> attributes
   *  so they will be incremented instead of inserting new <FONT> tag
   */
  /* void increaseFontSize (); */
  NS_IMETHOD IncreaseFontSize(void) = 0;

  /**
   *  Decrease font size for text in selection by 1 HTML unit
   *  All existing text is scanned for existing <FONT SIZE> attributes
   *  so they will be decreased instead of inserting new <FONT> tag
   */
  /* void decreaseFontSize (); */
  NS_IMETHOD DecreaseFontSize(void) = 0;

  /** 
   * canDrag decides if a drag should be started
   * (for example, based on the current selection and mousepoint).
   */
  /* boolean canDrag (in nsIDOMEvent aEvent); */
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *_retval) = 0;

  /** 
   * doDrag transfers the relevant data (as appropriate)
   * to a transferable so it can later be dropped.
   */
  /* void doDrag (in nsIDOMEvent aEvent); */
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) = 0;

  /** 
   * insertFromDrop looks for a dragsession and inserts the
   * relevant data in response to a drop.
   */
  /* void insertFromDrop (in nsIDOMEvent aEvent); */
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) = 0;

  /**
   * Tests if a node is a BLOCK element according the the HTML 4.0 DTD.
   *   This does NOT consider CSS effect on display type
   *
   * @param aNode      the node to test
   */
  /* boolean nodeIsBlock (in nsIDOMNode node); */
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval) = 0;

  /**
   * Insert some HTML source at the current location
   *
   * @param aInputString   the string to be inserted
   */
  /* void insertHTML (in AString aInputString); */
  NS_IMETHOD InsertHTML(const nsAString & aInputString) = 0;

  /** 
    * Paste the text in the OS clipboard at the cursor position, replacing
    * the selected text (if any), but strip out any HTML styles and formatting
    */
  /* void pasteNoFormatting (in long aSelectionType); */
  NS_IMETHOD PasteNoFormatting(PRInt32 aSelectionType) = 0;

  /** 
   *  Rebuild the entire document from source HTML
   *  Needed to be able to edit HEAD and other outside-of-BODY content
   *
   *  @param aSourceString   HTML source string of the entire new document
   */
  /* void rebuildDocumentFromSource (in AString aSourceString); */
  NS_IMETHOD RebuildDocumentFromSource(const nsAString & aSourceString) = 0;

  /**
   * Insert some HTML source, interpreting
   * the string argument according to the given charset.
   *
   * @param aInputString   the string to be inserted
   * @param aCharset       Charset of string
   * @param aParentNode    Parent to insert under.
   *                       If null, insert at the current location.
   */
  /* void insertHTMLWithCharset (in AString aInputString, in AString aCharset); */
  NS_IMETHOD InsertHTMLWithCharset(const nsAString & aInputString, const nsAString & aCharset) = 0;

  /** 
    * Insert an element, which may have child nodes, at the selection
    * Used primarily to insert a new element for various insert element dialogs,
    *   but it enforces the HTML 4.0 DTD "CanContain" rules, so it should
    *   be useful for other elements.
    *
    * @param aElement           The element to insert
    * @param aDeleteSelection   Delete the selection before inserting
    *     If aDeleteSelection is PR_FALSE, then the element is inserted 
    *     after the end of the selection for all element except
    *     Named Anchors, which insert before the selection
    */
  /* void insertElementAtSelection (in nsIDOMElement aElement, in boolean aDeleteSelection); */
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection) = 0;

  /** 
   *   Set the documents title.
   */
  /* void setDocumentTitle (in AString aTitle); */
  NS_IMETHOD SetDocumentTitle(const nsAString & aTitle) = 0;

  /** 
   *   Set the BaseURL for the document to the current URL
   *     but only if the page doesn't have a <base> tag
   *   This should be done after the document URL has changed,
   *     such as after saving a file
   *   This is used as base for relativizing link and image urls
   */
  /* void updateBaseURL (); */
  NS_IMETHOD UpdateBaseURL(void) = 0;

  /** 
    * Set the selection at the suppled element
    *
    * @param aElement   An element in the document
    */
  /* void selectElement (in nsIDOMElement aElement); */
  NS_IMETHOD SelectElement(nsIDOMElement *aElement) = 0;

  /** 
    * Create a collapsed selection just after aElement
    * 
    * XXX could we parameterize SelectElement(before/select/after>?
    *
    * The selection is set to parent-of-aElement with an
    *   offset 1 greater than aElement's offset
    *   but it enforces the HTML 4.0 DTD "CanContain" rules, so it should
    *   be useful for other elements.
    *
    * @param aElement  An element in the document
    */
  /* void setCaretAfterElement (in nsIDOMElement aElement); */
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement) = 0;

  /**
   * SetParagraphFormat       Insert a block paragraph tag around selection
   * @param aParagraphFormat  "p", "h1" to "h6", "address", "pre", or "blockquote"
   */
  /* void setParagraphFormat (in AString aParagraphFormat); */
  NS_IMETHOD SetParagraphFormat(const nsAString & aParagraphFormat) = 0;

  /**
   * getParagraphState returns what block tag paragraph format is in
   * the selection.
   * @param aMixed     True if there is more than one format
   * @return           Name of block tag. "" is returned for none.
   */
  /* AString getParagraphState (out boolean aMixed); */
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAString & _retval) = 0;

  /** 
   * getFontFaceState returns what font face is in the selection.
   * @param aMixed    True if there is more than one font face
   * @return          Name of face.  Note: "tt" is returned for
   *                  tt tag.  "" is returned for none.
   */
  /* AString getFontFaceState (out boolean aMixed); */
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAString & _retval) = 0;

  /** 
   * getFontColorState returns what font face is in the selection.
   * @param aMixed     True if there is more than one font color
   * @return           Color string. "" is returned for none.
   */
  /* AString getFontColorState (out boolean aMixed); */
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAString & _retval) = 0;

  /** 
   * getFontColorState returns what font face is in the selection.
   * @param aMixed     True if there is more than one font color
   * @return           Color string. "" is returned for none.
   */
  /* AString getBackgroundColorState (out boolean aMixed); */
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAString & _retval) = 0;

  /** 
   * getHighlightColorState returns what the highlight color of the selection.
   * @param aMixed     True if there is more than one font color
   * @return           Color string. "" is returned for none.
   */
  /* AString getHighlightColorState (out boolean aMixed); */
  NS_IMETHOD GetHighlightColorState(PRBool *aMixed, nsAString & _retval) = 0;

  /** 
   * getListState returns what list type is in the selection.
   * @param aMixed    True if there is more than one type of list, or
   *                  if there is some list and non-list
   * @param aOL       The company that employs me.  No, really, it's 
   *                  true if an "ol" list is selected.
   * @param aUL       true if an "ul" list is selected.
   * @param aDL       true if a "dl" list is selected.
   */
  /* void getListState (out boolean aMixed, out boolean aOL, out boolean aUL, out boolean aDL); */
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL) = 0;

  /** 
   * getListItemState returns what list item type is in the selection.
   * @param aMixed    True if there is more than one type of list item, or
   *                  if there is some list and non-list
   * @param aLI       true if "li" list items are selected.
   * @param aDT       true if "dt" list items are selected.
   * @param aDD       true if "dd" list items are selected.
   */
  /* void getListItemState (out boolean aMixed, out boolean aLI, out boolean aDT, out boolean aDD); */
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD) = 0;

  /** 
   * getAlignment     returns what alignment is in the selection.
   * @param aMixed    True if there is more than one type of list item, or
   *                  if there is some list and non-list
   * @param aAlign    enum value for first encountered alignment
   *                  (left/center/right)
   */
  /* void getAlignment (out boolean aMixed, out short aAlign); */
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign) = 0;

  /**
   * Document me!
   * 
   */
  /* void getIndentState (out boolean aCanIndent, out boolean aCanOutdent); */
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent) = 0;

  /**
   * Document me!
   * 
   */
  /* void makeOrChangeList (in AString aListType, in boolean entireList, in AString aBulletType); */
  NS_IMETHOD MakeOrChangeList(const nsAString & aListType, PRBool entireList, const nsAString & aBulletType) = 0;

  /**
   * Document me!
   * 
   */
  /* void removeList (in AString aListType); */
  NS_IMETHOD RemoveList(const nsAString & aListType) = 0;

  /**
   * Document me!
   * 
   */
  /* void indent (in AString aIndent); */
  NS_IMETHOD Indent(const nsAString & aIndent) = 0;

  /**
   * Document me!
   * 
   */
  /* void align (in AString aAlign); */
  NS_IMETHOD Align(const nsAString & aAlign) = 0;

  /** 
    * Return the input node or a parent matching the given aTagName,
    *   starting the search at the supplied node.
    * An example of use is for testing if a node is in a table cell
    *   given a selection anchor node.
    *
    * @param aTagName  The HTML tagname
    *  Special input values:
    *    Use "href" to get a link node 
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    *    Use "list" to get an OL, UL, or DL list node
    *    Use "td" to get either a TD or TH cell node
    *
    * @param aNode    The node in the document to start the search.
    *     If it is null, the anchor node of the current selection is used.
    * @return         NS_EDITOR_ELEMENT_NOT_FOUND if an element is not found
    *                 (passes NS_SUCCEEDED macro)
    */
  /* nsIDOMElement getElementOrParentByTagName (in AString aTagName, in nsIDOMNode aNode); */
  NS_IMETHOD GetElementOrParentByTagName(const nsAString & aTagName, nsIDOMNode *aNode, nsIDOMElement **_retval) = 0;

  /** 
    * Return an element only if it is the only node selected,
    *    such as an image, horizontal rule, etc.
    * The exception is a link, which is more like a text attribute:
    *    The Anchor tag is returned if the selection is within the textnode(s)
    *    that are children of the "A" node.
    *    This could be a collapsed selection, i.e., a caret
    *    within the link text.
    *
    * @param aTagName  The HTML tagname or and empty string 
    *       to get any element (but only if it is the only element selected)
    *    Special input values for Links and Named anchors:
    *    Use "href" to get a link node
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    * @return          NS_EDITOR_ELEMENT_NOT_FOUND if an element is not found
    *                  (passes NS_SUCCEEDED macro)
    */
  /* nsIDOMElement getSelectedElement (in AString aTagName); */
  NS_IMETHOD GetSelectedElement(const nsAString & aTagName, nsIDOMElement **_retval) = 0;

  /** 
    * Output the contents of the <HEAD> section as text/HTML format
    */
  /* AString getHeadContentsAsHTML (); */
  NS_IMETHOD GetHeadContentsAsHTML(nsAString & _retval) = 0;

  /** 
    * Replace all children of <HEAD> with string of HTML source
    */
  /* void replaceHeadContentsWithHTML (in AString aSourceToInsert); */
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAString & aSourceToInsert) = 0;

  /** 
    * Return a new element with default attribute values
    * 
    * This does not rely on the selection, and is not sensitive to context.
    * 
    * Used primarily to supply new element for various insert element dialogs
    *  (Image, Link, NamedAnchor, Table, and HorizontalRule 
    *   are the only returned elements as of 7/25/99)
    *
    * @param aTagName  The HTML tagname
    *    Special input values for Links and Named anchors:
    *    Use "href" to get a link node
    *      (an "A" tag with the "href" attribute set)
    *    Use "anchor" or "namedanchor" to get a named anchor node
    *      (an "A" tag with the "name" attribute set)
    * @return          The new element created.
    */
  /* nsIDOMElement createElementWithDefaults (in AString aTagName); */
  NS_IMETHOD CreateElementWithDefaults(const nsAString & aTagName, nsIDOMElement **_retval) = 0;

  /** 
    * Insert an link element as the parent of the current selection
    *
    * @param aElement   An "A" element with a non-empty "href" attribute
    */
  /* void insertLinkAroundSelection (in nsIDOMElement aAnchorElement); */
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement) = 0;

  /** 
    * Set the value of the "bgcolor" attribute on the document's <body> element
    *
    * @param aColor  The HTML color string, such as "#ffccff" or "yellow"
    */
  /* void setBackgroundColor (in AString aColor); */
  NS_IMETHOD SetBackgroundColor(const nsAString & aColor) = 0;

  /** 
    * Set an attribute on the document's <body> element
    *    such as text, link, background colors
    *
    * 8/31/00 THIS ISN'T BEING USED? SHOULD WE DROP IT?
    *
    * @param aAttr   The attribute to be set
    * @param aValue  The value of the attribute
    */
  /* void setBodyAttribute (in AString aAttr, in AString aValue); */
  NS_IMETHOD SetBodyAttribute(const nsAString & aAttr, const nsAString & aValue) = 0;

  /** 
    * XXX Used to suppress spurious drag/drop events to workaround bug 50703
    * Don't use this method! It will go away after first release!
    */
  /* void ignoreSpuriousDragEvent (in boolean aIgnoreSpuriousDragEvent); */
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent) = 0;

  /**
   * Find all the nodes in the document which contain references
   * to outside URIs (e.g. a href, img src, script src, etc.)
   * The objects in the array will be type nsIURIRefObject.
   *
   * @return aNodeList    the linked nodes found
   */
  /* nsISupportsArray getLinkedObjects (); */
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval) = 0;

  /** 
    * A boolean which is true is the HTMLEditor has been instantiated
    * with CSS knowledge and if the CSS pref is currently checked
    *
    * @return    true if CSS handled and enabled
    */
  /* attribute boolean isCSSEnabled; */
  NS_IMETHOD GetIsCSSEnabled(PRBool *aIsCSSEnabled) = 0;
  NS_IMETHOD SetIsCSSEnabled(PRBool aIsCSSEnabled) = 0;

  /* nsIDOMCSSStyleRule parseStyleAttrIntoCSSRule (in AString aString); */
  NS_IMETHOD ParseStyleAttrIntoCSSRule(const nsAString & aString, nsIDOMCSSStyleRule **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTMLEDITOR \
  NS_IMETHOD SetCSSInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue); \
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue); \
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll); \
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAString & _retval); \
  NS_IMETHOD RemoveAllInlineProperties(void); \
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute); \
  NS_IMETHOD IncreaseFontSize(void); \
  NS_IMETHOD DecreaseFontSize(void); \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *_retval); \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent); \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent); \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval); \
  NS_IMETHOD InsertHTML(const nsAString & aInputString); \
  NS_IMETHOD PasteNoFormatting(PRInt32 aSelectionType); \
  NS_IMETHOD RebuildDocumentFromSource(const nsAString & aSourceString); \
  NS_IMETHOD InsertHTMLWithCharset(const nsAString & aInputString, const nsAString & aCharset); \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection); \
  NS_IMETHOD SetDocumentTitle(const nsAString & aTitle); \
  NS_IMETHOD UpdateBaseURL(void); \
  NS_IMETHOD SelectElement(nsIDOMElement *aElement); \
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement); \
  NS_IMETHOD SetParagraphFormat(const nsAString & aParagraphFormat); \
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAString & _retval); \
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAString & _retval); \
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAString & _retval); \
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAString & _retval); \
  NS_IMETHOD GetHighlightColorState(PRBool *aMixed, nsAString & _retval); \
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL); \
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD); \
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign); \
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent); \
  NS_IMETHOD MakeOrChangeList(const nsAString & aListType, PRBool entireList, const nsAString & aBulletType); \
  NS_IMETHOD RemoveList(const nsAString & aListType); \
  NS_IMETHOD Indent(const nsAString & aIndent); \
  NS_IMETHOD Align(const nsAString & aAlign); \
  NS_IMETHOD GetElementOrParentByTagName(const nsAString & aTagName, nsIDOMNode *aNode, nsIDOMElement **_retval); \
  NS_IMETHOD GetSelectedElement(const nsAString & aTagName, nsIDOMElement **_retval); \
  NS_IMETHOD GetHeadContentsAsHTML(nsAString & _retval); \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAString & aSourceToInsert); \
  NS_IMETHOD CreateElementWithDefaults(const nsAString & aTagName, nsIDOMElement **_retval); \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement); \
  NS_IMETHOD SetBackgroundColor(const nsAString & aColor); \
  NS_IMETHOD SetBodyAttribute(const nsAString & aAttr, const nsAString & aValue); \
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent); \
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval); \
  NS_IMETHOD GetIsCSSEnabled(PRBool *aIsCSSEnabled); \
  NS_IMETHOD SetIsCSSEnabled(PRBool aIsCSSEnabled); \
  NS_IMETHOD ParseStyleAttrIntoCSSRule(const nsAString & aString, nsIDOMCSSStyleRule **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTMLEDITOR(_to) \
  NS_IMETHOD SetCSSInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue) { return _to SetCSSInlineProperty(aProperty, aAttribute, aValue); } \
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue) { return _to SetInlineProperty(aProperty, aAttribute, aValue); } \
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll) { return _to GetInlineProperty(aProperty, aAttribute, aValue, aFirst, aAny, aAll); } \
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAString & _retval) { return _to GetInlinePropertyWithAttrValue(aProperty, aAttribute, aValue, aFirst, aAny, aAll, _retval); } \
  NS_IMETHOD RemoveAllInlineProperties(void) { return _to RemoveAllInlineProperties(); } \
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute) { return _to RemoveInlineProperty(aProperty, aAttribute); } \
  NS_IMETHOD IncreaseFontSize(void) { return _to IncreaseFontSize(); } \
  NS_IMETHOD DecreaseFontSize(void) { return _to DecreaseFontSize(); } \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *_retval) { return _to CanDrag(aEvent, _retval); } \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) { return _to DoDrag(aEvent); } \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) { return _to InsertFromDrop(aEvent); } \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval) { return _to NodeIsBlock(node, _retval); } \
  NS_IMETHOD InsertHTML(const nsAString & aInputString) { return _to InsertHTML(aInputString); } \
  NS_IMETHOD PasteNoFormatting(PRInt32 aSelectionType) { return _to PasteNoFormatting(aSelectionType); } \
  NS_IMETHOD RebuildDocumentFromSource(const nsAString & aSourceString) { return _to RebuildDocumentFromSource(aSourceString); } \
  NS_IMETHOD InsertHTMLWithCharset(const nsAString & aInputString, const nsAString & aCharset) { return _to InsertHTMLWithCharset(aInputString, aCharset); } \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection) { return _to InsertElementAtSelection(aElement, aDeleteSelection); } \
  NS_IMETHOD SetDocumentTitle(const nsAString & aTitle) { return _to SetDocumentTitle(aTitle); } \
  NS_IMETHOD UpdateBaseURL(void) { return _to UpdateBaseURL(); } \
  NS_IMETHOD SelectElement(nsIDOMElement *aElement) { return _to SelectElement(aElement); } \
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement) { return _to SetCaretAfterElement(aElement); } \
  NS_IMETHOD SetParagraphFormat(const nsAString & aParagraphFormat) { return _to SetParagraphFormat(aParagraphFormat); } \
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAString & _retval) { return _to GetParagraphState(aMixed, _retval); } \
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAString & _retval) { return _to GetFontFaceState(aMixed, _retval); } \
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAString & _retval) { return _to GetFontColorState(aMixed, _retval); } \
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAString & _retval) { return _to GetBackgroundColorState(aMixed, _retval); } \
  NS_IMETHOD GetHighlightColorState(PRBool *aMixed, nsAString & _retval) { return _to GetHighlightColorState(aMixed, _retval); } \
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL) { return _to GetListState(aMixed, aOL, aUL, aDL); } \
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD) { return _to GetListItemState(aMixed, aLI, aDT, aDD); } \
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign) { return _to GetAlignment(aMixed, aAlign); } \
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent) { return _to GetIndentState(aCanIndent, aCanOutdent); } \
  NS_IMETHOD MakeOrChangeList(const nsAString & aListType, PRBool entireList, const nsAString & aBulletType) { return _to MakeOrChangeList(aListType, entireList, aBulletType); } \
  NS_IMETHOD RemoveList(const nsAString & aListType) { return _to RemoveList(aListType); } \
  NS_IMETHOD Indent(const nsAString & aIndent) { return _to Indent(aIndent); } \
  NS_IMETHOD Align(const nsAString & aAlign) { return _to Align(aAlign); } \
  NS_IMETHOD GetElementOrParentByTagName(const nsAString & aTagName, nsIDOMNode *aNode, nsIDOMElement **_retval) { return _to GetElementOrParentByTagName(aTagName, aNode, _retval); } \
  NS_IMETHOD GetSelectedElement(const nsAString & aTagName, nsIDOMElement **_retval) { return _to GetSelectedElement(aTagName, _retval); } \
  NS_IMETHOD GetHeadContentsAsHTML(nsAString & _retval) { return _to GetHeadContentsAsHTML(_retval); } \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAString & aSourceToInsert) { return _to ReplaceHeadContentsWithHTML(aSourceToInsert); } \
  NS_IMETHOD CreateElementWithDefaults(const nsAString & aTagName, nsIDOMElement **_retval) { return _to CreateElementWithDefaults(aTagName, _retval); } \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement) { return _to InsertLinkAroundSelection(aAnchorElement); } \
  NS_IMETHOD SetBackgroundColor(const nsAString & aColor) { return _to SetBackgroundColor(aColor); } \
  NS_IMETHOD SetBodyAttribute(const nsAString & aAttr, const nsAString & aValue) { return _to SetBodyAttribute(aAttr, aValue); } \
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent) { return _to IgnoreSpuriousDragEvent(aIgnoreSpuriousDragEvent); } \
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval) { return _to GetLinkedObjects(_retval); } \
  NS_IMETHOD GetIsCSSEnabled(PRBool *aIsCSSEnabled) { return _to GetIsCSSEnabled(aIsCSSEnabled); } \
  NS_IMETHOD SetIsCSSEnabled(PRBool aIsCSSEnabled) { return _to SetIsCSSEnabled(aIsCSSEnabled); } \
  NS_IMETHOD ParseStyleAttrIntoCSSRule(const nsAString & aString, nsIDOMCSSStyleRule **_retval) { return _to ParseStyleAttrIntoCSSRule(aString, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTMLEDITOR(_to) \
  NS_IMETHOD SetCSSInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCSSInlineProperty(aProperty, aAttribute, aValue); } \
  NS_IMETHOD SetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetInlineProperty(aProperty, aAttribute, aValue); } \
  NS_IMETHOD GetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInlineProperty(aProperty, aAttribute, aValue, aFirst, aAny, aAll); } \
  NS_IMETHOD GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInlinePropertyWithAttrValue(aProperty, aAttribute, aValue, aFirst, aAny, aAll, _retval); } \
  NS_IMETHOD RemoveAllInlineProperties(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveAllInlineProperties(); } \
  NS_IMETHOD RemoveInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveInlineProperty(aProperty, aAttribute); } \
  NS_IMETHOD IncreaseFontSize(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->IncreaseFontSize(); } \
  NS_IMETHOD DecreaseFontSize(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DecreaseFontSize(); } \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CanDrag(aEvent, _retval); } \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoDrag(aEvent); } \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertFromDrop(aEvent); } \
  NS_IMETHOD NodeIsBlock(nsIDOMNode *node, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NodeIsBlock(node, _retval); } \
  NS_IMETHOD InsertHTML(const nsAString & aInputString) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertHTML(aInputString); } \
  NS_IMETHOD PasteNoFormatting(PRInt32 aSelectionType) { return !_to ? NS_ERROR_NULL_POINTER : _to->PasteNoFormatting(aSelectionType); } \
  NS_IMETHOD RebuildDocumentFromSource(const nsAString & aSourceString) { return !_to ? NS_ERROR_NULL_POINTER : _to->RebuildDocumentFromSource(aSourceString); } \
  NS_IMETHOD InsertHTMLWithCharset(const nsAString & aInputString, const nsAString & aCharset) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertHTMLWithCharset(aInputString, aCharset); } \
  NS_IMETHOD InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertElementAtSelection(aElement, aDeleteSelection); } \
  NS_IMETHOD SetDocumentTitle(const nsAString & aTitle) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentTitle(aTitle); } \
  NS_IMETHOD UpdateBaseURL(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateBaseURL(); } \
  NS_IMETHOD SelectElement(nsIDOMElement *aElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectElement(aElement); } \
  NS_IMETHOD SetCaretAfterElement(nsIDOMElement *aElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCaretAfterElement(aElement); } \
  NS_IMETHOD SetParagraphFormat(const nsAString & aParagraphFormat) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetParagraphFormat(aParagraphFormat); } \
  NS_IMETHOD GetParagraphState(PRBool *aMixed, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParagraphState(aMixed, _retval); } \
  NS_IMETHOD GetFontFaceState(PRBool *aMixed, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFontFaceState(aMixed, _retval); } \
  NS_IMETHOD GetFontColorState(PRBool *aMixed, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFontColorState(aMixed, _retval); } \
  NS_IMETHOD GetBackgroundColorState(PRBool *aMixed, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBackgroundColorState(aMixed, _retval); } \
  NS_IMETHOD GetHighlightColorState(PRBool *aMixed, nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHighlightColorState(aMixed, _retval); } \
  NS_IMETHOD GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListState(aMixed, aOL, aUL, aDL); } \
  NS_IMETHOD GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetListItemState(aMixed, aLI, aDT, aDD); } \
  NS_IMETHOD GetAlignment(PRBool *aMixed, PRInt16 *aAlign) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAlignment(aMixed, aAlign); } \
  NS_IMETHOD GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIndentState(aCanIndent, aCanOutdent); } \
  NS_IMETHOD MakeOrChangeList(const nsAString & aListType, PRBool entireList, const nsAString & aBulletType) { return !_to ? NS_ERROR_NULL_POINTER : _to->MakeOrChangeList(aListType, entireList, aBulletType); } \
  NS_IMETHOD RemoveList(const nsAString & aListType) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveList(aListType); } \
  NS_IMETHOD Indent(const nsAString & aIndent) { return !_to ? NS_ERROR_NULL_POINTER : _to->Indent(aIndent); } \
  NS_IMETHOD Align(const nsAString & aAlign) { return !_to ? NS_ERROR_NULL_POINTER : _to->Align(aAlign); } \
  NS_IMETHOD GetElementOrParentByTagName(const nsAString & aTagName, nsIDOMNode *aNode, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetElementOrParentByTagName(aTagName, aNode, _retval); } \
  NS_IMETHOD GetSelectedElement(const nsAString & aTagName, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectedElement(aTagName, _retval); } \
  NS_IMETHOD GetHeadContentsAsHTML(nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHeadContentsAsHTML(_retval); } \
  NS_IMETHOD ReplaceHeadContentsWithHTML(const nsAString & aSourceToInsert) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReplaceHeadContentsWithHTML(aSourceToInsert); } \
  NS_IMETHOD CreateElementWithDefaults(const nsAString & aTagName, nsIDOMElement **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateElementWithDefaults(aTagName, _retval); } \
  NS_IMETHOD InsertLinkAroundSelection(nsIDOMElement *aAnchorElement) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertLinkAroundSelection(aAnchorElement); } \
  NS_IMETHOD SetBackgroundColor(const nsAString & aColor) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBackgroundColor(aColor); } \
  NS_IMETHOD SetBodyAttribute(const nsAString & aAttr, const nsAString & aValue) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBodyAttribute(aAttr, aValue); } \
  NS_IMETHOD IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent) { return !_to ? NS_ERROR_NULL_POINTER : _to->IgnoreSpuriousDragEvent(aIgnoreSpuriousDragEvent); } \
  NS_IMETHOD GetLinkedObjects(nsISupportsArray **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLinkedObjects(_retval); } \
  NS_IMETHOD GetIsCSSEnabled(PRBool *aIsCSSEnabled) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsCSSEnabled(aIsCSSEnabled); } \
  NS_IMETHOD SetIsCSSEnabled(PRBool aIsCSSEnabled) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsCSSEnabled(aIsCSSEnabled); } \
  NS_IMETHOD ParseStyleAttrIntoCSSRule(const nsAString & aString, nsIDOMCSSStyleRule **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ParseStyleAttrIntoCSSRule(aString, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHTMLEditor : public nsIHTMLEditor
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTMLEDITOR

  nsHTMLEditor();
  virtual ~nsHTMLEditor();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHTMLEditor, nsIHTMLEditor)

nsHTMLEditor::nsHTMLEditor()
{
  /* member initializers and constructor code */
}

nsHTMLEditor::~nsHTMLEditor()
{
  /* destructor code */
}

/* void setCSSInlineProperty (in nsIAtom aProperty, in AString aAttribute, in AString aValue); */
NS_IMETHODIMP nsHTMLEditor::SetCSSInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setInlineProperty (in nsIAtom aProperty, in AString aAttribute, in AString aValue); */
NS_IMETHODIMP nsHTMLEditor::SetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getInlineProperty (in nsIAtom aProperty, in AString aAttribute, in AString aValue, out boolean aFirst, out boolean aAny, out boolean aAll); */
NS_IMETHODIMP nsHTMLEditor::GetInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getInlinePropertyWithAttrValue (in nsIAtom aProperty, in AString aAttribute, in AString aValue, out boolean aFirst, out boolean aAny, out boolean aAll); */
NS_IMETHODIMP nsHTMLEditor::GetInlinePropertyWithAttrValue(nsIAtom *aProperty, const nsAString & aAttribute, const nsAString & aValue, PRBool *aFirst, PRBool *aAny, PRBool *aAll, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeAllInlineProperties (); */
NS_IMETHODIMP nsHTMLEditor::RemoveAllInlineProperties()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeInlineProperty (in nsIAtom aProperty, in AString aAttribute); */
NS_IMETHODIMP nsHTMLEditor::RemoveInlineProperty(nsIAtom *aProperty, const nsAString & aAttribute)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void increaseFontSize (); */
NS_IMETHODIMP nsHTMLEditor::IncreaseFontSize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void decreaseFontSize (); */
NS_IMETHODIMP nsHTMLEditor::DecreaseFontSize()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean canDrag (in nsIDOMEvent aEvent); */
NS_IMETHODIMP nsHTMLEditor::CanDrag(nsIDOMEvent *aEvent, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void doDrag (in nsIDOMEvent aEvent); */
NS_IMETHODIMP nsHTMLEditor::DoDrag(nsIDOMEvent *aEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void insertFromDrop (in nsIDOMEvent aEvent); */
NS_IMETHODIMP nsHTMLEditor::InsertFromDrop(nsIDOMEvent *aEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean nodeIsBlock (in nsIDOMNode node); */
NS_IMETHODIMP nsHTMLEditor::NodeIsBlock(nsIDOMNode *node, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void insertHTML (in AString aInputString); */
NS_IMETHODIMP nsHTMLEditor::InsertHTML(const nsAString & aInputString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void pasteNoFormatting (in long aSelectionType); */
NS_IMETHODIMP nsHTMLEditor::PasteNoFormatting(PRInt32 aSelectionType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void rebuildDocumentFromSource (in AString aSourceString); */
NS_IMETHODIMP nsHTMLEditor::RebuildDocumentFromSource(const nsAString & aSourceString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void insertHTMLWithCharset (in AString aInputString, in AString aCharset); */
NS_IMETHODIMP nsHTMLEditor::InsertHTMLWithCharset(const nsAString & aInputString, const nsAString & aCharset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void insertElementAtSelection (in nsIDOMElement aElement, in boolean aDeleteSelection); */
NS_IMETHODIMP nsHTMLEditor::InsertElementAtSelection(nsIDOMElement *aElement, PRBool aDeleteSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setDocumentTitle (in AString aTitle); */
NS_IMETHODIMP nsHTMLEditor::SetDocumentTitle(const nsAString & aTitle)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void updateBaseURL (); */
NS_IMETHODIMP nsHTMLEditor::UpdateBaseURL()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectElement (in nsIDOMElement aElement); */
NS_IMETHODIMP nsHTMLEditor::SelectElement(nsIDOMElement *aElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCaretAfterElement (in nsIDOMElement aElement); */
NS_IMETHODIMP nsHTMLEditor::SetCaretAfterElement(nsIDOMElement *aElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setParagraphFormat (in AString aParagraphFormat); */
NS_IMETHODIMP nsHTMLEditor::SetParagraphFormat(const nsAString & aParagraphFormat)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getParagraphState (out boolean aMixed); */
NS_IMETHODIMP nsHTMLEditor::GetParagraphState(PRBool *aMixed, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getFontFaceState (out boolean aMixed); */
NS_IMETHODIMP nsHTMLEditor::GetFontFaceState(PRBool *aMixed, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getFontColorState (out boolean aMixed); */
NS_IMETHODIMP nsHTMLEditor::GetFontColorState(PRBool *aMixed, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getBackgroundColorState (out boolean aMixed); */
NS_IMETHODIMP nsHTMLEditor::GetBackgroundColorState(PRBool *aMixed, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getHighlightColorState (out boolean aMixed); */
NS_IMETHODIMP nsHTMLEditor::GetHighlightColorState(PRBool *aMixed, nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getListState (out boolean aMixed, out boolean aOL, out boolean aUL, out boolean aDL); */
NS_IMETHODIMP nsHTMLEditor::GetListState(PRBool *aMixed, PRBool *aOL, PRBool *aUL, PRBool *aDL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getListItemState (out boolean aMixed, out boolean aLI, out boolean aDT, out boolean aDD); */
NS_IMETHODIMP nsHTMLEditor::GetListItemState(PRBool *aMixed, PRBool *aLI, PRBool *aDT, PRBool *aDD)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getAlignment (out boolean aMixed, out short aAlign); */
NS_IMETHODIMP nsHTMLEditor::GetAlignment(PRBool *aMixed, PRInt16 *aAlign)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getIndentState (out boolean aCanIndent, out boolean aCanOutdent); */
NS_IMETHODIMP nsHTMLEditor::GetIndentState(PRBool *aCanIndent, PRBool *aCanOutdent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void makeOrChangeList (in AString aListType, in boolean entireList, in AString aBulletType); */
NS_IMETHODIMP nsHTMLEditor::MakeOrChangeList(const nsAString & aListType, PRBool entireList, const nsAString & aBulletType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeList (in AString aListType); */
NS_IMETHODIMP nsHTMLEditor::RemoveList(const nsAString & aListType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void indent (in AString aIndent); */
NS_IMETHODIMP nsHTMLEditor::Indent(const nsAString & aIndent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void align (in AString aAlign); */
NS_IMETHODIMP nsHTMLEditor::Align(const nsAString & aAlign)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement getElementOrParentByTagName (in AString aTagName, in nsIDOMNode aNode); */
NS_IMETHODIMP nsHTMLEditor::GetElementOrParentByTagName(const nsAString & aTagName, nsIDOMNode *aNode, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement getSelectedElement (in AString aTagName); */
NS_IMETHODIMP nsHTMLEditor::GetSelectedElement(const nsAString & aTagName, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AString getHeadContentsAsHTML (); */
NS_IMETHODIMP nsHTMLEditor::GetHeadContentsAsHTML(nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void replaceHeadContentsWithHTML (in AString aSourceToInsert); */
NS_IMETHODIMP nsHTMLEditor::ReplaceHeadContentsWithHTML(const nsAString & aSourceToInsert)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMElement createElementWithDefaults (in AString aTagName); */
NS_IMETHODIMP nsHTMLEditor::CreateElementWithDefaults(const nsAString & aTagName, nsIDOMElement **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void insertLinkAroundSelection (in nsIDOMElement aAnchorElement); */
NS_IMETHODIMP nsHTMLEditor::InsertLinkAroundSelection(nsIDOMElement *aAnchorElement)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setBackgroundColor (in AString aColor); */
NS_IMETHODIMP nsHTMLEditor::SetBackgroundColor(const nsAString & aColor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setBodyAttribute (in AString aAttr, in AString aValue); */
NS_IMETHODIMP nsHTMLEditor::SetBodyAttribute(const nsAString & aAttr, const nsAString & aValue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ignoreSpuriousDragEvent (in boolean aIgnoreSpuriousDragEvent); */
NS_IMETHODIMP nsHTMLEditor::IgnoreSpuriousDragEvent(PRBool aIgnoreSpuriousDragEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupportsArray getLinkedObjects (); */
NS_IMETHODIMP nsHTMLEditor::GetLinkedObjects(nsISupportsArray **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean isCSSEnabled; */
NS_IMETHODIMP nsHTMLEditor::GetIsCSSEnabled(PRBool *aIsCSSEnabled)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHTMLEditor::SetIsCSSEnabled(PRBool aIsCSSEnabled)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMCSSStyleRule parseStyleAttrIntoCSSRule (in AString aString); */
NS_IMETHODIMP nsHTMLEditor::ParseStyleAttrIntoCSSRule(const nsAString & aString, nsIDOMCSSStyleRule **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIHTMLEditor_h__ */
