#% -*- mode: textmac; mode: fold; eval: .0 =TAB -*-
#%{{{ Macros 

#i linuxdoc.tm

#d slang \bf{S-lang}
#d jed \bf{JED}
#d kw#1 \tt{$1}
#d exmp#1 \tt{$1}
#d var#1 \tt{$1}
#d ldots ...
#d chapter#1 <chapt>$1<p>
#d preface <preface>
#d tag#1 <tag>$1</tag>

#d function#1 \section{<bf>$1</bf>\label{$1}}<descrip>
#d variable#1 \section{<bf>$1</bf>\label{$1}}<descrip>
#cd function#1 <p><bf>$1</bf>\label{$1}<p><descrip>
#d synopsis#1 <tag> Synopsis </tag> $1
#d keywords#1 <tag> Keywords </tag> $1
#d usage#1 <tag> Usage </tag> <tt>$1</tt>
#d description <tag> Description </tag>
#d example <tag> Example </tag>
#d notes <tag> Notes </tag>
#d seealso#1 <tag> See Also </tag> <tt>$1</tt>
#d documentstyle article
#d r#1 \ref{$1}{$1}
#d done </descrip><p>

#d -1 <tt>-1</tt>
#d 0 <tt>0</tt>
#d 1 <tt>1</tt>
#d 2 <tt>2</tt>
#d 3 <tt>3</tt>
#d 4 <tt>4</tt>
#d 5 <tt>5</tt>
#d NULL <tt>NULL</tt>
#d documentstyle book
#d sect1 \chapter
#d sect2 \section
#d sect3 \subsection
#d sect4 \subsubsection

#%}}}

\linuxdoc
\begin{\documentstyle}

\title Jed Intrinsic Function Reference Manual
\author John E. Davis, \tt{davis@space.mit.edu}
\date \__today__

\toc

\sect1{Movement Functions}
#i rtl/move.tm

\sect1{Insertion/Deletions Functions}
#i rtl/insdel.tm

\sect1{Search Functions}
#i rtl/search.tm

\sect1{Buffer Related Functions}
#i rtl/buffer.tm

\sect1{Abbreviation Functions}
#i rtl/abbrev.tm

\sect1{Buffer-Local Variable Functions}
#i rtl/blocal.tm

\sect1{Color Functions}
#i rtl/color.tm

\sect1{Loading and Evaluation of S-Lang Code Functions}
#i rtl/eval.tm

\sect1{File Related Functions}
#i rtl/file.tm

\sect1{Functions that work with Hidden Lines}
#i rtl/hidden.tm

\sect1{Functions dealing with hooks}
#i rtl/hooks.tm

\sect1{Informational Functions}
#i rtl/info.tm

\sect1{Keymaps and Key Input Functions}
#i rtl/keys.tm

\sect1{Mark and Spot Functions}
#i rtl/mark.tm

\sect1{Menu Functions}
#i rtl/menu.tm

\sect1{Message Functions}
#i rtl/message.tm

\sect1{Mini-Buffer Functions}
#i rtl/mini.tm

\sect1{Mouse Functions}
#i rtl/mouse.tm

\sect1{Subprocess Functions}
#i rtl/process.tm

\sect1{Rectangle Functions}
#i rtl/rect.tm

\sect1{Functions that Involve Regions}
#i rtl/region.tm

\sect1{Search/Replace Functions}
#i rtl/search.tm

\sect1{Syntax Highlighting and Parsing Functions}
#i rtl/syntax.tm

\sect1{Terminal Functions}
#i rtl/terminal.tm

\sect1{User and Host Functions}
#i rtl/userinfo.tm

\sect1{Display and Window Functions}
#i rtl/window.tm

\sect1{Xjed-specific Functions}
#i rtl/xjed.tm

\sect1{Miscellaneous Functions}
#i rtl/misc.tm

\end{\documentstyle}

