/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.ClassAttributes;
import classycle.UnresolvedNode;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class GraphBuilder {
    GraphBuilder() {
    }

    public static void sort(AtomicVertex[] vertices) {
        Arrays.sort(vertices, new Comparator<AtomicVertex>(){

            @Override
            public int compare(AtomicVertex v1, AtomicVertex v2) {
                return this.getName(v1).compareTo(this.getName(v2));
            }

            private String getName(AtomicVertex vertex) {
                return ((NameAttributes)vertex.getAttributes()).getName();
            }
        });
    }

    static AtomicVertex[] createGraph(UnresolvedNode[] unresolvedNodes, boolean mergeInnerClasses) {
        Arrays.sort(unresolvedNodes);
        Map<String, AtomicVertex> vertices = GraphBuilder.createVertices(unresolvedNodes, mergeInnerClasses);
        AtomicVertex[] result = vertices.values().toArray(new AtomicVertex[0]);
        GraphBuilder.sort(result);
        for (int i = 0; i < unresolvedNodes.length; ++i) {
            UnresolvedNode node = unresolvedNodes[i];
            String name = GraphBuilder.normalize(node.getAttributes().getName(), mergeInnerClasses);
            AtomicVertex vertex = vertices.get(name);
            Iterator<String> iterator = node.linkIterator();
            while (iterator.hasNext()) {
                name = GraphBuilder.normalize(iterator.next(), mergeInnerClasses);
                AtomicVertex head = vertices.get(name);
                if (head == null) {
                    head = new AtomicVertex(ClassAttributes.createUnknownClass(name, 0));
                    vertices.put(name, head);
                }
                if (vertex == head) continue;
                vertex.addOutgoingArcTo(head);
            }
        }
        return result;
    }

    private static Map<String, AtomicVertex> createVertices(UnresolvedNode[] unresolvedNodes, boolean mergeInnerClasses) {
        HashMap<String, AtomicVertex> vertices = new HashMap<String, AtomicVertex>();
        for (int i = 0; i < unresolvedNodes.length; ++i) {
            ClassAttributes attributes = unresolvedNodes[i].getAttributes();
            String type = attributes.getType();
            String originalName = attributes.getName();
            int size = attributes.getSize();
            String name = GraphBuilder.normalize(originalName, mergeInnerClasses);
            AtomicVertex vertex = (AtomicVertex)vertices.get(name);
            if (vertex != null) {
                ClassAttributes vertexAttributes = (ClassAttributes)vertex.getAttributes();
                size += vertexAttributes.getSize();
                if (!name.equals(originalName)) {
                    type = vertexAttributes.getType();
                }
                attributes.addSourcesOf(vertexAttributes);
            }
            ClassAttributes newAttributes = new ClassAttributes(name, null, type, size);
            newAttributes.addSourcesOf(attributes);
            vertex = new AtomicVertex(newAttributes);
            vertices.put(name, vertex);
        }
        return vertices;
    }

    private static String normalize(String name, boolean mergeInnerClasses) {
        int index;
        if (mergeInnerClasses && (index = name.indexOf(36)) >= 0) {
            name = name.substring(0, index);
        }
        return name;
    }
}

