#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Keep same perms on rc.hald.new:
if [ -e etc/rc.d/rc.hald ]; then
  cp -a etc/rc.d/rc.hald etc/rc.d/rc.hald.new.incoming
  cat etc/rc.d/rc.hald.new > etc/rc.d/rc.hald.new.incoming
  mv etc/rc.d/rc.hald.new.incoming etc/rc.d/rc.hald.new
fi

config etc/rc.d/rc.hald.new
config etc/dbus-1/system.d/hal.conf.new

( cd usr/lib ; rm -rf libhal.so.1 )
( cd usr/lib ; ln -sf libhal.so.1.0.0 libhal.so.1 )
( cd usr/lib ; rm -rf libhal.so )
( cd usr/lib ; ln -sf libhal.so.1.0.0 libhal.so )
( cd usr/lib ; rm -rf libhal-storage.so.1 )
( cd usr/lib ; ln -sf libhal-storage.so.1.0.0 libhal-storage.so.1 )
( cd usr/lib ; rm -rf libhal-storage.so )
( cd usr/lib ; ln -sf libhal-storage.so.1.0.0 libhal-storage.so )
( cd usr/doc/hal-0.5.10 ; rm -rf libhal )
( cd usr/doc/hal-0.5.10 ; ln -sf ../../share/gtk-doc/html/libhal libhal )
( cd usr/doc/hal-0.5.10 ; rm -rf libhal-storage )
( cd usr/doc/hal-0.5.10 ; ln -sf ../../share/gtk-doc/html/libhal-storage libhal-storage )
