/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.ExtensionInstallHandler;
import com.sun.javaws.Globals;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LaunchSelection;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.NoLocalJREException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.ui.DownloadWindow;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SecureStaticVersioning;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.ui.UpdateDialog;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import com.sun.jnlp.AppletContainer;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Launcher
implements Runnable {
    private DownloadWindow _downloadWindow = null;
    private LaunchDesc _launchDesc;
    private String[] _args;
    private boolean _exit = true;
    private JAuthenticator _ja;
    private LocalApplicationProperties _lap = null;
    private JNLPClassLoader _jnlpClassLoader = null;
    private static final int NUM_RETRIES = 2;
    private boolean updateShortcutBeforeRelaunch = false;
    private boolean _shownDownloadWindow = false;

    public Launcher(LaunchDesc launchDesc) {
        this._launchDesc = launchDesc;
        this._downloadWindow = new DownloadWindow();
        Trace.println((String)("new Launcher: " + launchDesc.toString()), (TraceLevel)TraceLevel.BASIC);
    }

    public void launch(String[] stringArray, boolean bl) {
        this._args = stringArray;
        this._exit = bl;
        if (this.prepareToLaunch()) {
            new Thread(Main.getLaunchThreadGroup(), this, "javawsApplicationMain").start();
        }
    }

    public void run() {
        block3: {
            try {
                this.doLaunchApp();
            }
            catch (Throwable throwable) {
                int n;
                ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 2);
                int n2 = n = exitException.getReason() == 0 ? 0 : -1;
                if (exitException.getReason() == 2) {
                    LaunchErrorDialog.show(this._downloadWindow == null ? null : this._downloadWindow.getOwner(), exitException.getException(), this._exit);
                }
                if (!this._exit) break block3;
                Main.systemExit(n);
            }
        }
    }

    private boolean prepareToLaunch() {
        LaunchDesc launchDesc = this._launchDesc;
        URL uRL = launchDesc.getLocation();
        if (uRL != null) {
            Cache.removeRemovedApp((String)uRL.toString(), (String)launchDesc.getInformation().getTitle());
        }
        boolean bl = LaunchDownload.updateLaunchDescInCache(launchDesc, this._args[0]);
        Trace.println((String)("isUpdated: " + bl), (TraceLevel)TraceLevel.NETWORK);
        this.removeTempJnlpFile(launchDesc);
        if (launchDesc.getResources() != null) {
            Globals.getDebugOptionsFromProperties(launchDesc.getResources().getResourceProperties());
        }
        if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
            this._ja = JAuthenticator.getInstance(this._downloadWindow.getOwner());
            Authenticator.setDefault((Authenticator)((Object)this._ja));
        }
        boolean bl2 = Globals.isSilentMode();
        boolean bl3 = Environment.isImportMode() || launchDesc.getLaunchType() == 3;
        try {
            for (int i = 0; i < 2 && launchDesc != null; ++i) {
                if (!bl2) {
                    this._downloadWindow.initialize(launchDesc, true, false);
                }
                launchDesc = this.prepareLaunchFile(launchDesc, this._args, i < 1, bl3, bl2, bl);
            }
        }
        catch (Throwable throwable) {
            int n;
            ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 2);
            int n2 = n = exitException.getReason() == 0 ? 0 : -1;
            if (exitException.getReason() == 2) {
                LaunchErrorDialog.show(this._downloadWindow == null ? null : this._downloadWindow.getOwner(), exitException.getException(), this._exit);
            }
            if (this._exit) {
                Main.systemExit(n);
            }
            return false;
        }
        return true;
    }

    private void removeTempJnlpFile(LaunchDesc launchDesc) {
        File file = null;
        if (launchDesc.isApplicationDescriptor()) {
            try {
                file = DownloadEngine.getCachedFile((URL)launchDesc.getCanonicalHome());
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        if (file == null) {
            return;
        }
        if (this._args != null && file != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = file.getPath();
        }
    }

    private LaunchDesc prepareLaunchFile(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ExitException {
        boolean bl5;
        String string;
        Object object;
        Object object2;
        boolean bl6;
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (String)launchDesc.getSpecVersion()), null));
        }
        if (!(bl2 || launchDesc.isLibrary() || launchDesc.isJRESpecified())) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
            this.handleJnlpFileException(launchDesc, launchDescException);
        }
        boolean bl7 = launchDesc.isInstaller();
        JNLPException.setDefaultLaunchDesc(launchDesc);
        if (!launchDesc.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException(new OfflineLaunchException(1), 2);
        }
        Component component = null;
        JREInfo jREInfo = null;
        jREInfo = launchDesc.getSelectedJRE();
        URL uRL = launchDesc.getCanonicalHome();
        if (uRL == null) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException(launchDescException, 2);
        }
        if (bl7) {
            this._lap = Cache.getLocalApplicationProperties((String)stringArray[0]);
            if (this._lap == null || !Environment.isInstallMode()) {
                this.handleJnlpFileException(launchDesc, new MissingFieldException(launchDesc.getSource(), "<application-desc>|<applet-desc>"));
            }
            uRL = this._lap.getLocation();
        } else if (!launchDesc.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)uRL);
        }
        Trace.println((String)("LaunchDesc location: " + uRL), (TraceLevel)TraceLevel.BASIC);
        boolean bl8 = LaunchDownload.isInCache(launchDesc);
        if (!bl8 && DeployOfflineManager.isForcedOffline()) {
            DeployOfflineManager.setForcedOffline((boolean)false);
            if (!DeployOfflineManager.askUserGoOnline((URL)launchDesc.getLocation())) {
                DeployOfflineManager.setForcedOffline((boolean)true);
            }
        }
        boolean bl9 = bl6 = bl8 && DeployOfflineManager.isGlobalOffline();
        if (!bl2 && jREInfo == null) {
            JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
            if (jREDesc != null) {
                boolean bl10;
                String string2 = Config.getProperty((String)"deployment.javaws.autodownload");
                if (string2 != null && string2.equalsIgnoreCase("NEVER")) {
                    throw new ExitException(new NoLocalJREException(launchDesc, jREDesc.getVersion(), false), 2);
                }
                object2 = jREDesc.getSource();
                object = jREDesc.getHref();
                boolean bl11 = bl10 = object == null;
                if (bl10) {
                    string = Config.getProperty((String)"deployment.javaws.installURL");
                    try {
                        object = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new ExitException(malformedURLException, 2);
                    }
                }
                if ((string = DownloadEngine.getAvailableVersion((URL)object, (String)jREDesc.getVersion(), (boolean)bl10, (String)JREInfo.getKnownPlatforms())) == null) {
                    string = jREDesc.getVersion();
                }
                if (SecureStaticVersioning.promptRequired(launchDesc, this._lap, true, string) ? !SecureStaticVersioning.promptDownload(component, launchDesc, this._lap, string, (String)object2) : string2 != null && string2.equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt(component, launchDesc)) {
                    throw new ExitException(null, 0);
                }
            }
        } else if (!bl2 && SecureStaticVersioning.promptRequired(launchDesc, this._lap, false, jREInfo.getProduct()) && !SecureStaticVersioning.promptUse(component, launchDesc, this._lap, jREInfo)) {
            throw new ExitException(null, 0);
        }
        int n = Config.getIntProperty((String)"deployment.javaws.update.timeout");
        boolean bl12 = bl5 = !bl8 || !bl2 && jREInfo == null || bl7;
        if (bl5 && bl6) {
            throw new ExitException(new OfflineLaunchException(0), 2);
        }
        boolean bl13 = bl5 || !bl6 && (this._lap != null && this._lap.forceUpdateCheck() || new RapidUpdateCheck().doUpdateCheck(launchDesc, this._lap, n));
        Trace.println((String)("Offline mode: " + bl6 + "\nIsInCache: " + bl8 + "\nforceUpdate: " + bl5 + "\nneedUpdate: " + bl13 + "\nInstalled JRE: " + jREInfo + "\nIsInstaller: " + bl7), (TraceLevel)TraceLevel.BASIC);
        if (bl13) {
            if (!bl7 && bl && (object2 = this.downloadJNLPFile(launchDesc, bl3)) != null) {
                this.updateShortcutBeforeRelaunch = true;
                this._launchDesc = object2;
                this.removeTempJnlpFile(launchDesc);
                return object2;
            }
            switch (launchDesc.getUpdate().getPolicy()) {
                default: {
                    bl5 = true;
                    break;
                }
                case 1: {
                    if (bl5) break;
                    bl5 = UpdateDialog.showUpdateDialog(launchDesc, this._downloadWindow);
                    break;
                }
                case 2: {
                    if (!bl5) {
                        bl5 = UpdateDialog.showUpdateDialog(launchDesc, this._downloadWindow);
                    }
                    if (bl5) break;
                    Trace.println((String)"Exiting after user chose not to update", (TraceLevel)TraceLevel.BASIC);
                    throw new ExitException(null, 0);
                }
            }
        }
        if (bl5 && bl6) {
            throw new ExitException(new OfflineLaunchException(0), 2);
        }
        object2 = new ArrayList();
        if (bl5) {
            if (!bl2 && jREInfo == null) {
                this.downloadJREResource(launchDesc, (ArrayList)object2, bl3);
                if (!((ArrayList)object2).isEmpty()) {
                    this.executeInstallers((ArrayList)object2);
                    if (!this.isValidSpecificationVersion(launchDesc)) {
                        Config.getInstance().resetJavaHome();
                    }
                }
                object = Config.getJavaHome() + File.separator + "bin" + File.separator;
                Config.getInstance().notifyJREInstalled((String)object);
            } else {
                this.downloadResources(launchDesc, (ArrayList)object2, bl3);
            }
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                this._lap.setForceUpdateCheck(false);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
        if (jREInfo != null || bl2) {
            if (SingleInstanceManager.isServerRunning((String)launchDesc.getCanonicalHome().toString())) {
                object = Globals.getApplicationArgs();
                if (object != null) {
                    launchDesc.getApplicationDescriptor().setArguments((String[])object);
                }
                if (SingleInstanceManager.connectToServer((String)launchDesc.toString())) {
                    throw new ExitException(null, 0);
                }
            }
            if (!bl3) {
                SplashScreen.generateCustomSplash(component, launchDesc, bl5 || bl4);
            }
            if (!bl2 && !((ArrayList)object2).isEmpty()) {
                if (bl7) {
                    // empty if block
                }
                this.executeInstallers((ArrayList)object2);
            }
            if (!bl3 && this._downloadWindow.getOwner() != null) {
                object = ResourceManager.getString((String)"progress.title.app");
                if (launchDesc.getLaunchType() == 4) {
                    object = ResourceManager.getString((String)"progress.title.installer");
                }
                this._downloadWindow.showLaunchingApplication((String)object);
            }
        }
        if (!bl2) {
            if (!this.isValidSpecificationVersion(launchDesc)) {
                JNLPException.setDefaultLaunchDesc(launchDesc);
                this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (String)launchDesc.getSpecVersion()), null));
            }
            if (jREInfo == null) {
                Config.refreshProps();
                jREInfo = LaunchSelection.selectJRE(launchDesc);
                if (jREInfo == null) {
                    object = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException((Throwable)object, 2);
                }
            }
            object = launchDesc.getResources().getSelectedJRE();
            long l = ((JREDesc)object).getMinHeap();
            long l2 = ((JREDesc)object).getMaxHeap();
            boolean bl14 = JnlpxArgs.isCurrentRunningJREHeap(l, l2);
            Properties properties = launchDesc.getResources().getResourceProperties();
            String string3 = ((JREDesc)object).getVmArgs();
            boolean bl15 = JnlpxArgs.isAuxArgsMatch(properties, string3);
            if (!(JnlpxArgs.getJVMCommand().equals(new File(jREInfo.getPath())) && bl14 && bl15)) {
                if (this.updateShortcutBeforeRelaunch && Cache.isCacheEnabled() && this._lap.isLocallyInstalled()) {
                    this.notifyLocalInstallHandler(this._launchDesc, this._lap, true, false, bl3, this._downloadWindow.getOwner());
                }
                try {
                    stringArray = this.insertApplicationArgs(stringArray);
                    Launcher.execProgram(jREInfo, stringArray, l, l2, properties, string3, false);
                }
                catch (IOException iOException) {
                    throw new ExitException(new JreExecException(jREInfo.getPath(), iOException), 2);
                }
                if (JnlpxArgs.shouldRemoveArgumentFile()) {
                    JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
                }
                throw new ExitException(null, 0);
            }
        }
        JnlpxArgs.removeArgumentFile(stringArray[0]);
        if (bl2) {
            this._downloadWindow.disposeWindow();
            boolean bl16 = LaunchDownload.isJnlpCached(launchDesc) && (bl5 || bl4);
            this.notifyLocalInstallHandler(launchDesc, this._lap, bl16, true, bl3, null);
            Trace.println((String)"Exiting after import", (TraceLevel)TraceLevel.BASIC);
            throw new ExitException(null, 0);
        }
        object = ResourceManager.getMessage((String)"console.caption") + " - " + launchDesc.getInformation().getTitle();
        SwingUtilities.invokeLater(new Runnable((String)object){
            private final /* synthetic */ String val$title;
            {
                this.val$title = string;
            }

            public void run() {
                JavawsConsoleController.setTitle(this.val$title);
                JavawsConsoleController.showConsoleIfEnable();
            }
        });
        AppPolicy appPolicy = AppPolicy.createInstance(this._launchDesc.getCanonicalHome().getHost());
        try {
            LaunchDownload.checkSignedResources(this._launchDesc);
            LaunchDownload.checkSignedLaunchDesc(this._launchDesc);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
        this._jnlpClassLoader = JNLPClassLoader.createClassLoader(this._launchDesc, appPolicy);
        System.setSecurityManager(new JavaWebStartSecurity());
        try {
            BasicServiceImpl.initialize(this._launchDesc.getCodebase(), BrowserSupport.isWebBrowserSupported());
            if (this._launchDesc.getLaunchType() == 4) {
                string = this._lap.getInstallDirectory();
                if (string == null) {
                    string = Cache.getNewExtensionInstallDirectory();
                    this._lap.setInstallDirectory(string);
                }
                ExtensionInstallerServiceImpl.initialize(string, this._lap, this._downloadWindow);
            }
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 2);
        }
        if (Cache.isCacheEnabled()) {
            this.notifyLocalInstallHandler(this._launchDesc, this._lap, bl5 || bl4, false, bl3, this._downloadWindow.getOwner());
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
        return null;
    }

    private boolean isValidSpecificationVersion(LaunchDesc launchDesc) {
        VersionString versionString = new VersionString(launchDesc.getSpecVersion());
        return versionString.contains(new VersionID("6.0")) || versionString.contains(new VersionID("1.5")) || versionString.contains(new VersionID("1.0"));
    }

    private String[] insertApplicationArgs(String[] stringArray) {
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i++] = stringArray[i];
        }
        return stringArray3;
    }

    private static String sizeString(long l) {
        if (l > 0x100000L) {
            return "" + l / 0x100000L + "Mb";
        }
        return "" + l + "bytes";
    }

    private void executeInstallers(ArrayList arrayList) throws ExitException {
        if (this._downloadWindow.getOwner() != null) {
            String string = ResourceManager.getString((String)"progress.title.installer");
            this._downloadWindow.showLaunchingApplication(string);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Launcher.this._downloadWindow.setVisible(false);
                }
            }).start();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
                localApplicationProperties.setLocallyInstalled(false);
                localApplicationProperties.store();
                Trace.println((String)("Installing extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                String[] stringArray = new String[]{"-installer", file.getAbsolutePath()};
                JREInfo jREInfo = LaunchSelection.selectJRE(launchDesc);
                if (jREInfo == null) {
                    this._downloadWindow.setVisible(true);
                    LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(launchDescException, 2);
                }
                boolean bl = JnlpxArgs.shouldRemoveArgumentFile();
                JnlpxArgs.setShouldRemoveArgumentFile("false");
                Properties properties = launchDesc.getResources().getResourceProperties();
                Process process = Launcher.execProgram(jREInfo, stringArray, -1L, -1L, properties, null, true);
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(bl));
                localApplicationProperties.refresh();
                if (localApplicationProperties.isRebootNeeded()) {
                    boolean bl2 = false;
                    ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                    if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions(this._downloadWindow.getOwner())) {
                        bl2 = true;
                    }
                    localApplicationProperties.setLocallyInstalled(true);
                    localApplicationProperties.setRebootNeeded(false);
                    localApplicationProperties.store();
                    if (bl2 && extensionInstallHandler.doReboot()) {
                        throw new ExitException(null, 1);
                    }
                }
                if (localApplicationProperties.isLocallyInstalled()) continue;
                this._downloadWindow.setVisible(true);
                throw new ExitException(new LaunchDescException(launchDesc, ResourceManager.getString((String)"Launch.error.installfailed"), null), 2);
            }
            catch (JNLPException jNLPException) {
                this._downloadWindow.setVisible(true);
                throw new ExitException(jNLPException, 2);
            }
            catch (IOException iOException) {
                this._downloadWindow.setVisible(true);
                throw new ExitException(iOException, 2);
            }
            catch (InterruptedException interruptedException) {
                this._downloadWindow.setVisible(true);
                throw new ExitException(interruptedException, 2);
            }
        }
    }

    public static void executeUninstallers(ArrayList arrayList) throws ExitException {
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            try {
                Serializable serializable;
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file);
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
                Trace.println((String)("uninstalling extension: " + file), (TraceLevel)TraceLevel.EXTENSIONS);
                String[] stringArray = new String[]{"-silent", "-secure", "-installer", file.getAbsolutePath()};
                JREInfo jREInfo = LaunchSelection.selectJRE(launchDesc);
                if (jREInfo == null) {
                    serializable = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException((Throwable)serializable, 2);
                }
                serializable = launchDesc.getResources().getResourceProperties();
                Process process = Launcher.execProgram(jREInfo, stringArray, -1L, -1L, serializable, null, true);
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                localApplicationProperties.refresh();
                if (!localApplicationProperties.isRebootNeeded()) continue;
                boolean bl = false;
                ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions(null)) {
                    bl = true;
                }
                localApplicationProperties.setRebootNeeded(false);
                localApplicationProperties.setLocallyInstalled(false);
                localApplicationProperties.store();
                if (!bl || !extensionInstallHandler.doReboot()) continue;
                throw new ExitException(null, 1);
            }
            catch (JNLPException jNLPException) {
                throw new ExitException(jNLPException, 2);
            }
            catch (IOException iOException) {
                throw new ExitException(iOException, 2);
            }
            catch (InterruptedException interruptedException) {
                throw new ExitException(interruptedException, 2);
            }
        }
    }

    private static Process execProgram(JREInfo jREInfo, String[] stringArray, long l, long l2, Properties properties, String string, boolean bl) throws IOException {
        int n;
        String string2 = null;
        String string3 = null;
        string3 = jREInfo.getPath();
        string2 = Config.isDebugMode() && Config.isDebugVMMode() ? jREInfo.getDebugJavaPath() : jREInfo.getPath();
        if (string2.length() == 0 || string3.length() == 0) {
            throw new IllegalArgumentException("must exist");
        }
        String[] stringArray2 = JnlpxArgs.getArgumentList(string3, l, l2, properties, string, bl);
        int n2 = 1 + stringArray2.length + stringArray.length;
        String[] stringArray3 = new String[n2];
        int n3 = 0;
        stringArray3[n3++] = string2;
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n3++] = stringArray2[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n3++] = stringArray[n];
        }
        Trace.println((String)("Launching new JRE version: " + jREInfo), (TraceLevel)TraceLevel.BASIC);
        for (n = 0; n < stringArray3.length; ++n) {
            Trace.println((String)("cmd " + n + " : " + stringArray3[n]), (TraceLevel)TraceLevel.BASIC);
        }
        if (Globals.TCKHarnessRun) {
            Main.tckprintln("JVM Starting");
        }
        Trace.flush();
        return Runtime.getRuntime().exec(stringArray3);
    }

    private void doLaunchApp() throws ExitException {
        Object object;
        final JNLPClassLoader jNLPClassLoader = this._jnlpClassLoader;
        Thread.currentThread().setContextClassLoader(jNLPClassLoader);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(jNLPClassLoader);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Trace.ignoredException((Exception)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.ignoredException((Exception)invocationTargetException);
        }
        String string = null;
        Class<?> clazz = null;
        try {
            string = LaunchDownload.getMainClassName(this._launchDesc, true);
            Trace.println((String)("Main-class: " + string), (TraceLevel)TraceLevel.BASIC);
            if (string == null) {
                throw new ClassNotFoundException(string);
            }
            clazz = jNLPClassLoader.loadClass(string);
            if (this.getClass().getPackage().equals(clazz.getPackage())) {
                throw new ClassNotFoundException(string);
            }
            object = clazz.getClassLoader();
            if (object != jNLPClassLoader) {
                SecurityException securityException = new SecurityException("Bad main-class name");
                throw new ExitException(securityException, 2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExitException(classNotFoundException, 2);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (Exception exception) {
            throw new ExitException(exception, 2);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 2);
        }
        try {
            object = this._downloadWindow;
            this._downloadWindow = null;
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("JNLP Launching");
            }
            this.executeMainClass(this._launchDesc, this._lap, clazz, (DownloadWindow)object);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExitException(illegalAccessException, 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExitException(illegalArgumentException, 2);
        }
        catch (InstantiationException instantiationException) {
            throw new ExitException(instantiationException, 2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exception exception = invocationTargetException;
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                exception = (Exception)invocationTargetException.getTargetException();
            } else {
                throwable.printStackTrace();
            }
            throw new ExitException(exception, 2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExitException(noSuchMethodException, 2);
        }
        catch (Throwable throwable) {
            throw new ExitException(throwable, 2);
        }
        if (this._launchDesc.getLaunchType() == 4) {
            throw new ExitException(null, 0);
        }
    }

    private LaunchDesc downloadJNLPFile(LaunchDesc launchDesc, boolean bl) throws ExitException {
        try {
            return LaunchDownload.getUpdatedLaunchDesc(launchDesc);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
    }

    private void downloadJREResource(LaunchDesc launchDesc, ArrayList arrayList, boolean bl) throws ExitException {
        if (!this._shownDownloadWindow && !bl) {
            this._shownDownloadWindow = true;
            this._downloadWindow.showLoadingProgressScreen();
            this._downloadWindow.setVisible(true);
        }
        try {
            if (!Cache.isCacheEnabled()) {
                throw new IOException("Cache disabled, cannot download JRE");
            }
            LaunchDownload.downloadJRE(launchDesc, this._downloadWindow, arrayList);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 2);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
            throw new ExitException(new NoLocalJREException(launchDesc, launchDesc.getResources().getSelectedJRE().getVersion(), false), 2);
        }
    }

    private void downloadResources(LaunchDesc launchDesc, ArrayList arrayList, boolean bl) throws ExitException {
        if (!this._shownDownloadWindow && !bl) {
            this._shownDownloadWindow = true;
            this._downloadWindow.showLoadingProgressScreen();
            this._downloadWindow.setVisible(true);
        }
        try {
            LaunchDownload.downloadExtensions(launchDesc, this._downloadWindow, 0, arrayList);
            LaunchDownload.checkJNLPSecurity(launchDesc);
            LaunchDownload.downloadEagerorAll(launchDesc, false, this._downloadWindow, false);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException, 2);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException(jNLPException, 2);
        }
        catch (IOException iOException) {
            throw new ExitException(iOException, 2);
        }
    }

    private void notifyLocalInstallHandler(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, boolean bl3, Component component) {
        LocalInstallHandler localInstallHandler;
        if (localApplicationProperties == null) {
            return;
        }
        localApplicationProperties.setLastAccessed(new Date());
        if (!bl2) {
            localApplicationProperties.incrementLaunchCount();
        }
        if ((localInstallHandler = LocalInstallHandler.getInstance()) != null) {
            localInstallHandler.install(launchDesc, localApplicationProperties, bl, bl3, component);
        }
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.println((String)("Couldn't save LAP: " + iOException), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private void executeMainClass(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (launchDesc.getLaunchType() == 2) {
            this.executeApplet(launchDesc, clazz, downloadWindow);
        } else {
            this.executeApplication(launchDesc, localApplicationProperties, clazz, downloadWindow);
        }
    }

    private void executeApplication(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        String[] stringArray = null;
        if (launchDesc.getLaunchType() == 4) {
            downloadWindow.reset();
            stringArray = new String[]{localApplicationProperties.isLocallyInstalled() ? "uninstall" : "install"};
            localApplicationProperties.setLocallyInstalled(false);
            localApplicationProperties.setRebootNeeded(false);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        } else {
            downloadWindow.disposeWindow();
            SplashScreen.hide();
            stringArray = Globals.getApplicationArgs() != null ? Globals.getApplicationArgs() : launchDesc.getApplicationDescriptor().getArguments();
        }
        Object[] objectArray = new Object[]{stringArray};
        Class[] classArray = new Class[]{new String[0].getClass()};
        Method method = clazz.getMethod("main", classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(ResourceManager.getString((String)"launch.error.nonstaticmainmethod"));
        }
        method.setAccessible(true);
        PerfLogger.setEndTime((String)"Calling Application main");
        PerfLogger.outputLog();
        method.invoke(null, objectArray);
    }

    private void executeApplet(LaunchDesc launchDesc, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException {
        AppletDesc appletDesc = launchDesc.getAppletDescriptor();
        int n = appletDesc.getWidth();
        int n2 = appletDesc.getHeight();
        Applet applet = null;
        applet = (Applet)clazz.newInstance();
        downloadWindow.disposeWindow();
        SplashScreen.hide();
        final JFrame jFrame = new JFrame();
        boolean bl = BrowserSupport.isWebBrowserSupported();
        AppletContainerCallback appletContainerCallback = new AppletContainerCallback(){

            public void showDocument(URL uRL) {
                BrowserSupport.showDocument(uRL);
            }

            public void relativeResize(Dimension dimension) {
                Dimension dimension2 = jFrame.getSize();
                dimension2.width += dimension.width;
                dimension2.height += dimension.height;
                jFrame.setSize(dimension2);
            }
        };
        URL uRL = BasicServiceImpl.getInstance().getCodeBase();
        URL uRL2 = appletDesc.getDocumentBase();
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        final AppletContainer appletContainer = new AppletContainer(appletContainerCallback, applet, appletDesc.getName(), uRL2, uRL, n, n2, appletDesc.getParameters());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                appletContainer.stopApplet();
            }
        });
        jFrame.setTitle(launchDesc.getInformation().getTitle());
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", appletContainer);
        jFrame.pack();
        Dimension dimension = appletContainer.getPreferredFrameSize(jFrame);
        jFrame.setSize(dimension);
        jFrame.getRootPane().revalidate();
        jFrame.getRootPane().repaint();
        jFrame.setResizable(false);
        if (!jFrame.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jFrame.setVisible(true);
                }
            });
        }
        appletContainer.startApplet();
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        DownloadEngine.removeCachedResource((URL)launchDesc.getCanonicalHome(), null, null);
        throw new ExitException(exception, 2);
    }

    private static class EatInput
    implements Runnable {
        private InputStream _is;

        EatInput(InputStream inputStream) {
            this._is = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[1024];
            try {
                int n = 0;
                while (n != -1) {
                    n = this._is.read(byArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void eatInput(InputStream inputStream) {
            EatInput eatInput = new EatInput(inputStream);
            new Thread(eatInput).start();
        }
    }

    private class RapidUpdateCheck
    extends Thread {
        private LaunchDesc _ld = null;
        private LocalApplicationProperties _lap;
        private boolean _updateAvailable;
        private boolean _checkCompleted;
        private boolean _checkFaulted = false;
        private Object _signalObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doUpdateCheck(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, int n) {
            this._ld = launchDesc;
            this._lap = localApplicationProperties;
            boolean bl = false;
            Object object = this._signalObject;
            synchronized (object) {
                this._updateAvailable = false;
                this._checkCompleted = false;
                this.start();
                do {
                    if (launchDesc.getUpdate().getCheck() == 1) {
                        try {
                            this._signalObject.wait(n);
                            bl = this._updateAvailable;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = false;
                        }
                        continue;
                    }
                    if (launchDesc.getUpdate().getCheck() == 0) {
                        try {
                            this._signalObject.wait(n);
                            bl = this._updateAvailable || !this._checkCompleted;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                        continue;
                    }
                    try {
                        this._signalObject.wait(1L);
                        bl = this._updateAvailable;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = false;
                    }
                } while (!this._checkFaulted && (this._ld.isHttps() && !this._checkCompleted || Launcher.this._ja != null && Launcher.this._ja.isChallanging()));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                bl = LaunchDownload.isUpdateAvailable(this._ld);
                bl2 = true;
            }
            catch (FailedDownloadingResourceException failedDownloadingResourceException) {
                Throwable throwable;
                if (this._ld.isHttps() && (throwable = failedDownloadingResourceException.getWrappedException()) != null && throwable instanceof SSLHandshakeException) {
                    Main.systemExit(0);
                }
                bl3 = true;
                Trace.ignoredException((Exception)failedDownloadingResourceException);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            Object object = this._signalObject;
            synchronized (object) {
                this._updateAvailable = bl;
                this._checkCompleted = bl2;
                this._checkFaulted = bl3;
                this._signalObject.notify();
            }
            if (this._updateAvailable) {
                this._lap.setForceUpdateCheck(true);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
        }
    }
}

