/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectName
implements Comparable<ObjectName>,
QueryExp {
    private static final long oldSerialVersionUID = -5467795090068647408L;
    private static final long newSerialVersionUID = 1081892073854801359L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", String.class), new ObjectStreamField("propertyList", Hashtable.class), new ObjectStreamField("propertyListString", String.class), new ObjectStreamField("canonicalName", String.class), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private static final Property[] _Empty_property_array;
    private transient String _canonicalName;
    private transient Property[] _kp_array;
    private transient Property[] _ca_array;
    private transient int _domain_length = 0;
    private transient Map<String, String> _propertyList;
    private transient boolean _domain_pattern = false;
    private transient boolean _property_list_pattern = false;
    private transient boolean _property_value_pattern = false;
    public static final ObjectName WILDCARD;

    private void construct(String string) throws MalformedObjectNameException, NullPointerException {
        char c;
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (string.length() == 0) {
            this._canonicalName = "*:*";
            this._kp_array = _Empty_property_array;
            this._ca_array = _Empty_property_array;
            this._domain_length = 1;
            this._propertyList = null;
            this._domain_pattern = true;
            this._property_list_pattern = true;
            this._property_value_pattern = false;
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        int n3 = 0;
        block19: while (n3 < n) {
            c = cArray[n3];
            switch (c) {
                case ':': {
                    this._domain_length = n3++;
                    break block19;
                }
                case '=': {
                    int n4 = ++n3;
                    while (n4 < n && cArray[n4++] != ':') {
                        if (n4 != n) continue;
                        throw new MalformedObjectNameException("Domain part must be specified");
                    }
                    continue block19;
                }
                case '\n': {
                    throw new MalformedObjectNameException("Invalid character '\\n' in domain name");
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                    ++n3;
                    continue block19;
                }
                default: {
                    ++n3;
                    continue block19;
                }
            }
        }
        if (n3 == n) {
            throw new MalformedObjectNameException("Key properties cannot be empty");
        }
        System.arraycopy(cArray, 0, cArray2, 0, this._domain_length);
        cArray2[this._domain_length] = 58;
        n2 = this._domain_length + 1;
        HashMap<String, Property> hashMap = new HashMap<String, Property>();
        int n5 = 0;
        String[] stringArray = new String[10];
        this._kp_array = new Property[10];
        this._property_list_pattern = false;
        this._property_value_pattern = false;
        while (n3 < n) {
            Property property;
            String[] stringArray2;
            int n6;
            boolean bl;
            char c2;
            int n7;
            c = cArray[n3];
            if (c == '*') {
                if (this._property_list_pattern) {
                    throw new MalformedObjectNameException("Cannot have several '*' characters in pattern property list");
                }
                this._property_list_pattern = true;
                if (++n3 < n && cArray[n3] != ',') {
                    throw new MalformedObjectNameException("Invalid character found after '*': end of name or ',' expected");
                }
                if (n3 == n) {
                    if (n5 != 0) break;
                    this._kp_array = _Empty_property_array;
                    this._ca_array = _Empty_property_array;
                    this._propertyList = Collections.emptyMap();
                    break;
                }
                ++n3;
                continue;
            }
            int n8 = n7 = n3;
            if (cArray[n7] == '=') {
                throw new MalformedObjectNameException("Invalid key (empty)");
            }
            while (n7 < n && (c2 = cArray[n7++]) != '=') {
                switch (c2) {
                    case '\n': 
                    case '*': 
                    case ',': 
                    case ':': 
                    case '?': {
                        String string2 = c2 == '\n' ? "\\n" : "" + c2;
                        throw new MalformedObjectNameException("Invalid character '" + string2 + "' in key part of property");
                    }
                }
            }
            if (cArray[n7 - 1] != '=') {
                throw new MalformedObjectNameException("Unterminated key property part");
            }
            int n9 = n7;
            int n10 = n9 - n8 - 1;
            boolean bl2 = false;
            if (n7 < n && cArray[n7] == '\"') {
                bl = true;
                block23: while (++n7 < n && (c2 = cArray[n7]) != '\"') {
                    if (c2 == '\\') {
                        if (++n7 == n) {
                            throw new MalformedObjectNameException("Unterminated quoted value");
                        }
                        c2 = cArray[n7];
                        switch (c2) {
                            case '\"': 
                            case '*': 
                            case '?': 
                            case '\\': 
                            case 'n': {
                                continue block23;
                            }
                        }
                        throw new MalformedObjectNameException("Invalid escape sequence '\\" + c2 + "' in quoted value");
                    }
                    if (c2 == '\n') {
                        throw new MalformedObjectNameException("Newline in quoted value");
                    }
                    switch (c2) {
                        case '*': 
                        case '?': {
                            bl2 = true;
                        }
                    }
                }
                if (n7 == n) {
                    throw new MalformedObjectNameException("Unterminated quoted value");
                }
                n6 = ++n7 - n9;
            } else {
                bl = false;
                block24: while (n7 < n && (c2 = cArray[n7]) != ',') {
                    switch (c2) {
                        case '*': 
                        case '?': {
                            bl2 = true;
                            ++n7;
                            continue block24;
                        }
                        case '\n': 
                        case '\"': 
                        case ':': 
                        case '=': {
                            stringArray2 = c2 == '\n' ? "\\n" : "" + c2;
                            throw new MalformedObjectNameException("Invalid character '" + c2 + "' in value part of property");
                        }
                    }
                    ++n7;
                }
                n6 = n7 - n9;
            }
            if (n7 == n - 1) {
                if (bl) {
                    throw new MalformedObjectNameException("Invalid ending character `" + cArray[n7] + "'");
                }
                throw new MalformedObjectNameException("Invalid ending comma");
            }
            ++n7;
            if (!bl2) {
                property = new Property(n8, n10, n6);
            } else {
                this._property_value_pattern = true;
                property = new PatternProperty(n8, n10, n6);
            }
            String string3 = string.substring(n8, n8 + n10);
            if (n5 == stringArray.length) {
                stringArray2 = new String[n5 + 10];
                System.arraycopy(stringArray, 0, stringArray2, 0, n5);
                stringArray = stringArray2;
            }
            stringArray[n5] = string3;
            this.addProperty(property, n5, hashMap, string3);
            ++n5;
            n3 = n7;
        }
        this.setCanonicalName(cArray, cArray2, stringArray, hashMap, n2, n5);
    }

    private void construct(String string, Map<String, String> map) throws MalformedObjectNameException, NullPointerException {
        Object object;
        if (string == null) {
            throw new NullPointerException("domain cannot be null");
        }
        if (map == null) {
            throw new NullPointerException("key property list cannot be null");
        }
        if (map.isEmpty()) {
            throw new MalformedObjectNameException("key property list cannot be empty");
        }
        if (!this.isDomain(string)) {
            throw new MalformedObjectNameException("Invalid domain: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(':');
        this._domain_length = string.length();
        int n = map.size();
        this._kp_array = new Property[n];
        String[] stringArray = new String[n];
        HashMap<String, Property> hashMap = new HashMap<String, Property>();
        int n2 = 0;
        for (Map.Entry<String, String> object22 : map.entrySet()) {
            Property property;
            String string2;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            object = object22.getKey();
            try {
                string2 = object22.getValue();
            }
            catch (ClassCastException classCastException) {
                throw new MalformedObjectNameException(classCastException.getMessage());
            }
            int n3 = stringBuilder.length();
            ObjectName.checkKey((String)object);
            stringBuilder.append((String)object);
            stringArray[n2] = object;
            stringBuilder.append("=");
            boolean classCastException = ObjectName.checkValue(string2);
            stringBuilder.append(string2);
            if (!classCastException) {
                property = new Property(n3, ((String)object).length(), string2.length());
            } else {
                this._property_value_pattern = true;
                property = new PatternProperty(n3, ((String)object).length(), string2.length());
            }
            this.addProperty(property, n2, hashMap, (String)object);
            ++n2;
        }
        int n4 = stringBuilder.length();
        char[] cArray = new char[n4];
        stringBuilder.getChars(0, n4, cArray, 0);
        object = new char[n4];
        System.arraycopy(cArray, 0, object, 0, this._domain_length + 1);
        this.setCanonicalName(cArray, (char[])object, stringArray, hashMap, this._domain_length + 1, this._kp_array.length);
    }

    private void addProperty(Property property, int n, Map<String, Property> map, String string) throws MalformedObjectNameException {
        if (map.containsKey(string)) {
            throw new MalformedObjectNameException("key `" + string + "' already defined");
        }
        if (n == this._kp_array.length) {
            Property[] propertyArray = new Property[n + 10];
            System.arraycopy(this._kp_array, 0, propertyArray, 0, n);
            this._kp_array = propertyArray;
        }
        this._kp_array[n] = property;
        map.put(string, property);
    }

    private void setCanonicalName(char[] cArray, char[] cArray2, String[] objectArray, Map<String, Property> map, int n, int n2) {
        if (this._kp_array != _Empty_property_array) {
            int n3;
            Object[] objectArray2 = new String[n2];
            Property[] propertyArray = new Property[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            Arrays.sort(objectArray2);
            objectArray = objectArray2;
            System.arraycopy(this._kp_array, 0, propertyArray, 0, n2);
            this._kp_array = propertyArray;
            this._ca_array = new Property[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this._ca_array[n3] = map.get(objectArray[n3]);
            }
            n3 = n2 - 1;
            for (int i = 0; i <= n3; ++i) {
                Property property = this._ca_array[i];
                int n4 = property._key_length + property._value_length + 1;
                System.arraycopy(cArray, property._key_index, cArray2, n, n4);
                property.setKeyIndex(n);
                n += n4;
                if (i == n3) continue;
                cArray2[n] = 44;
                ++n;
            }
        }
        if (this._property_list_pattern) {
            if (this._kp_array != _Empty_property_array) {
                cArray2[n++] = 44;
            }
            cArray2[n++] = 42;
        }
        this._canonicalName = new String(cArray2, 0, n).intern();
    }

    private static int parseKey(char[] cArray, int n) throws MalformedObjectNameException {
        int n2 = n;
        int n3 = n;
        int n4 = cArray.length;
        block4: while (n2 < n4) {
            char c = cArray[n2++];
            switch (c) {
                case '\n': 
                case '*': 
                case ',': 
                case ':': 
                case '?': {
                    String string = c == '\n' ? "\\n" : "" + c;
                    throw new MalformedObjectNameException("Invalid character in key: `" + string + "'");
                }
                case '=': {
                    n3 = n2 - 1;
                    break block4;
                }
                default: {
                    if (n2 < n4) continue block4;
                    n3 = n2;
                    break block4;
                }
            }
        }
        return n3;
    }

    private static int[] parseValue(char[] cArray, int n) throws MalformedObjectNameException {
        int n2;
        boolean bl;
        block23: {
            int n3;
            int n4;
            block20: {
                bl = false;
                n4 = n;
                n2 = n;
                n3 = cArray.length;
                char c = cArray[n];
                if (c != '\"') break block20;
                if (++n4 == n3) {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                while (n4 < n3) {
                    char c2;
                    block22: {
                        block21: {
                            c2 = cArray[n4];
                            if (c2 != '\\') break block21;
                            if (++n4 == n3) {
                                throw new MalformedObjectNameException("Invalid unterminated quoted character sequence");
                            }
                            c2 = cArray[n4];
                            switch (c2) {
                                case '*': 
                                case '?': 
                                case '\\': 
                                case 'n': {
                                    break block22;
                                }
                                case '\"': {
                                    if (n4 + 1 == n3) {
                                        throw new MalformedObjectNameException("Missing termination quote");
                                    }
                                    break block22;
                                }
                                default: {
                                    throw new MalformedObjectNameException("Invalid quoted character sequence '\\" + c2 + "'");
                                }
                            }
                        }
                        if (c2 == '\n') {
                            throw new MalformedObjectNameException("Newline in quoted value");
                        }
                        if (c2 == '\"') {
                            ++n4;
                            break;
                        }
                        switch (c2) {
                            case '*': 
                            case '?': {
                                bl = true;
                            }
                        }
                    }
                    if (++n4 < n3 || c2 == '\"') continue;
                    throw new MalformedObjectNameException("Missing termination quote");
                }
                n2 = n4;
                if (n4 < n3 && cArray[n4++] != ',') {
                    throw new MalformedObjectNameException("Invalid quote");
                }
                break block23;
            }
            block13: while (n4 < n3) {
                char c = cArray[n4++];
                switch (c) {
                    case '*': 
                    case '?': {
                        bl = true;
                        if (n4 < n3) continue block13;
                        n2 = n4;
                        break block13;
                    }
                    case '\n': 
                    case ':': 
                    case '=': {
                        String string = c == '\n' ? "\\n" : "" + c;
                        throw new MalformedObjectNameException("Invalid character `" + string + "' in value");
                    }
                    case ',': {
                        n2 = n4 - 1;
                        break block13;
                    }
                    default: {
                        if (n4 < n3) continue block13;
                        n2 = n4;
                        break block13;
                    }
                }
            }
        }
        return new int[]{n2, bl ? 1 : 0};
    }

    private static boolean checkValue(String string) throws MalformedObjectNameException {
        boolean bl;
        if (string == null) {
            throw new NullPointerException("Invalid value (null)");
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = ObjectName.parseValue(cArray, 0);
        int n2 = nArray[0];
        boolean bl2 = bl = nArray[1] == 1;
        if (n2 < n) {
            throw new MalformedObjectNameException("Invalid character in value: `" + cArray[n2] + "'");
        }
        return bl;
    }

    private static void checkKey(String string) throws MalformedObjectNameException, NullPointerException {
        if (string == null) {
            throw new NullPointerException("Invalid key (null)");
        }
        int n = string.length();
        if (n == 0) {
            throw new MalformedObjectNameException("Invalid key (empty)");
        }
        char[] cArray = string.toCharArray();
        int n2 = ObjectName.parseKey(cArray, 0);
        if (n2 < n) {
            throw new MalformedObjectNameException("Invalid character in value: `" + cArray[n2] + "'");
        }
    }

    private static boolean wildmatch(char[] cArray, char[] cArray2, int n, int n2) {
        int n3 = cArray.length;
        int n4 = cArray2.length;
        while (n2 < n4) {
            char c;
            if ((c = cArray2[n2++]) == '?') {
                if (++n <= n3) continue;
                return false;
            }
            if (c == '*') {
                if (n2 >= n4) {
                    return true;
                }
                do {
                    if (!ObjectName.wildmatch(cArray, cArray2, n, n2)) continue;
                    return true;
                } while (++n < n3);
                return false;
            }
            if (n < n3 && c == cArray[n++]) continue;
            return false;
        }
        return n == n3;
    }

    private boolean isDomain(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2++];
            switch (c) {
                case '\n': 
                case ':': {
                    return false;
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            string = (String)getField.get("domain", "default") + ":" + (String)getField.get("propertyListString", "");
        } else {
            objectInputStream.defaultReadObject();
            string = (String)objectInputStream.readObject();
        }
        try {
            this.construct(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidObjectException(nullPointerException.toString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new InvalidObjectException(malformedObjectNameException.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("domain", this._canonicalName.substring(0, this._domain_length));
            putField.put("propertyList", this.getKeyPropertyList());
            putField.put("propertyListString", this.getKeyPropertyListString());
            putField.put("canonicalName", this._canonicalName);
            putField.put("pattern", this._domain_pattern || this._property_list_pattern);
            putField.put("propertyPattern", this._property_list_pattern);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.getSerializedNameString());
        }
    }

    public static ObjectName getInstance(String string) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string);
    }

    public static ObjectName getInstance(String string, String string2, String string3) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string, string2, string3);
    }

    public static ObjectName getInstance(String string, Hashtable<String, String> hashtable) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(string, hashtable);
    }

    public static ObjectName getInstance(ObjectName objectName) throws NullPointerException {
        if (objectName.getClass().equals(ObjectName.class)) {
            return objectName;
        }
        try {
            return new ObjectName(objectName.getSerializedNameString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("Unexpected: " + malformedObjectNameException);
        }
    }

    public ObjectName(String string) throws MalformedObjectNameException, NullPointerException {
        this.construct(string);
    }

    public ObjectName(String string, String string2, String string3) throws MalformedObjectNameException, NullPointerException {
        Map<String, String> map = Collections.singletonMap(string2, string3);
        this.construct(string, map);
    }

    public ObjectName(String string, Hashtable<String, String> hashtable) throws MalformedObjectNameException, NullPointerException {
        this.construct(string, hashtable);
    }

    public boolean isPattern() {
        return this._domain_pattern || this._property_list_pattern || this._property_value_pattern;
    }

    public boolean isDomainPattern() {
        return this._domain_pattern;
    }

    public boolean isPropertyPattern() {
        return this._property_list_pattern || this._property_value_pattern;
    }

    public boolean isPropertyListPattern() {
        return this._property_list_pattern;
    }

    public boolean isPropertyValuePattern() {
        return this._property_value_pattern;
    }

    public boolean isPropertyValuePattern(String string) throws NullPointerException, IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("key property can't be null");
        }
        for (int i = 0; i < this._ca_array.length; ++i) {
            Property property = this._ca_array[i];
            String string2 = property.getKeyString(this._canonicalName);
            if (!string2.equals(string)) continue;
            return property instanceof PatternProperty;
        }
        throw new IllegalArgumentException("key property not found");
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public String getDomain() {
        return this._canonicalName.substring(0, this._domain_length);
    }

    public String getKeyProperty(String string) throws NullPointerException {
        return this._getKeyPropertyList().get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> _getKeyPropertyList() {
        ObjectName objectName = this;
        synchronized (objectName) {
            if (this._propertyList == null) {
                this._propertyList = new HashMap<String, String>();
                int n = this._ca_array.length;
                for (int i = n - 1; i >= 0; --i) {
                    Property property = this._ca_array[i];
                    this._propertyList.put(property.getKeyString(this._canonicalName), property.getValueString(this._canonicalName));
                }
            }
        }
        return this._propertyList;
    }

    public Hashtable<String, String> getKeyPropertyList() {
        return new Hashtable<String, String>(this._getKeyPropertyList());
    }

    public String getKeyPropertyListString() {
        if (this._kp_array.length == 0) {
            return "";
        }
        int n = this._canonicalName.length() - this._domain_length - 1 - (this._property_list_pattern ? 2 : 0);
        char[] cArray = new char[n];
        char[] cArray2 = this._canonicalName.toCharArray();
        this.writeKeyPropertyListString(cArray2, cArray, 0);
        return new String(cArray);
    }

    private String getSerializedNameString() {
        int n = this._canonicalName.length();
        char[] cArray = new char[n];
        char[] cArray2 = this._canonicalName.toCharArray();
        int n2 = this._domain_length + 1;
        System.arraycopy(cArray2, 0, cArray, 0, n2);
        int n3 = this.writeKeyPropertyListString(cArray2, cArray, n2);
        if (this._property_list_pattern) {
            if (n3 == n2) {
                cArray[n3] = 42;
            } else {
                cArray[n3] = 44;
                cArray[n3 + 1] = 42;
            }
        }
        return new String(cArray);
    }

    private int writeKeyPropertyListString(char[] cArray, char[] cArray2, int n) {
        if (this._kp_array.length == 0) {
            return n;
        }
        char[] cArray3 = cArray2;
        char[] cArray4 = this._canonicalName.toCharArray();
        int n2 = n;
        int n3 = this._kp_array.length;
        int n4 = n3 - 1;
        for (int i = 0; i < n3; ++i) {
            Property property = this._kp_array[i];
            int n5 = property._key_length + property._value_length + 1;
            System.arraycopy(cArray4, property._key_index, cArray3, n2, n5);
            n2 += n5;
            if (i >= n4) continue;
            cArray3[n2++] = 44;
        }
        return n2;
    }

    public String getCanonicalKeyPropertyListString() {
        if (this._ca_array.length == 0) {
            return "";
        }
        int n = this._canonicalName.length();
        if (this._property_list_pattern) {
            n -= 2;
        }
        return this._canonicalName.substring(this._domain_length + 1, n);
    }

    public String toString() {
        return this.getSerializedNameString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectName)) {
            return false;
        }
        ObjectName objectName = (ObjectName)object;
        String string = objectName._canonicalName;
        return this._canonicalName == string;
    }

    public int hashCode() {
        return this._canonicalName.hashCode();
    }

    public static String quote(String string) throws NullPointerException {
        StringBuilder stringBuilder = new StringBuilder("\"");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    c = 'n';
                    stringBuilder.append('\\');
                    break;
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String unquote(String string) throws IllegalArgumentException, NullPointerException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        if (n < 2 || string.charAt(0) != '\"' || string.charAt(n - 1) != '\"') {
            throw new IllegalArgumentException("Argument not quoted");
        }
        for (int i = 1; i < n - 1; ++i) {
            char c;
            block11: {
                block10: {
                    c = string.charAt(i);
                    if (c != '\\') break block10;
                    if (i == n - 2) {
                        throw new IllegalArgumentException("Trailing backslash");
                    }
                    c = string.charAt(++i);
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break block11;
                        }
                        case '\"': 
                        case '*': 
                        case '?': 
                        case '\\': {
                            break block11;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad character '" + c + "' after backslash");
                        }
                    }
                }
                switch (c) {
                    case '\n': 
                    case '\"': 
                    case '*': 
                    case '?': {
                        throw new IllegalArgumentException("Invalid unescaped character '" + c + "' in the string to unquote");
                    }
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean apply(ObjectName objectName) throws NullPointerException {
        if (objectName == null) {
            throw new NullPointerException();
        }
        if (objectName._domain_pattern || objectName._property_list_pattern || objectName._property_value_pattern) {
            return false;
        }
        if (!(this._domain_pattern || this._property_list_pattern || this._property_value_pattern)) {
            return this._canonicalName.equals(objectName._canonicalName);
        }
        return this.matchDomains(objectName) && this.matchKeys(objectName);
    }

    private final boolean matchDomains(ObjectName objectName) {
        if (this._domain_pattern) {
            char[] cArray = this.getDomain().toCharArray();
            char[] cArray2 = objectName.getDomain().toCharArray();
            return ObjectName.wildmatch(cArray2, cArray, 0, 0);
        }
        return this.getDomain().equals(objectName.getDomain());
    }

    private final boolean matchKeys(ObjectName objectName) {
        if (this._property_value_pattern && !this._property_list_pattern && objectName._ca_array.length != this._ca_array.length) {
            return false;
        }
        if (this._property_value_pattern || this._property_list_pattern) {
            Map<String, String> map = objectName._getKeyPropertyList();
            Property[] propertyArray = this._ca_array;
            String string = this._canonicalName;
            for (int i = propertyArray.length - 1; i >= 0; --i) {
                Property property = propertyArray[i];
                String string2 = property.getKeyString(string);
                String string3 = map.get(string2);
                if (string3 == null) {
                    return false;
                }
                if (this._property_value_pattern && property instanceof PatternProperty) {
                    char[] cArray = property.getValueString(string).toCharArray();
                    char[] cArray2 = string3.toCharArray();
                    if (ObjectName.wildmatch(cArray2, cArray, 0, 0)) continue;
                    return false;
                }
                if (string3.equals(property.getValueString(string))) continue;
                return false;
            }
            return true;
        }
        String string = objectName.getCanonicalKeyPropertyListString();
        String string4 = this.getCanonicalKeyPropertyListString();
        return string.equals(string4);
    }

    @Override
    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    @Override
    public int compareTo(ObjectName objectName) {
        int n;
        int n2 = this.getDomain().compareTo(objectName.getDomain());
        if (n2 != 0) {
            return n2;
        }
        String string = this.getKeyProperty("type");
        String string2 = objectName.getKeyProperty("type");
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = string.compareTo(string2)) != 0) {
            return n;
        }
        return this.getCanonicalName().compareTo(objectName.getCanonicalName());
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -5467795090068647408L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 1081892073854801359L;
        }
        _Empty_property_array = new Property[0];
        try {
            WILDCARD = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error("Can't initialize wildcard name", malformedObjectNameException);
        }
    }

    private static class PatternProperty
    extends Property {
        PatternProperty(int n, int n2, int n3) {
            super(n, n2, n3);
        }
    }

    private static class Property {
        int _key_index;
        int _key_length;
        int _value_length;

        Property(int n, int n2, int n3) {
            this._key_index = n;
            this._key_length = n2;
            this._value_length = n3;
        }

        void setKeyIndex(int n) {
            this._key_index = n;
        }

        String getKeyString(String string) {
            return string.substring(this._key_index, this._key_index + this._key_length);
        }

        String getValueString(String string) {
            int n = this._key_index + this._key_length + 1;
            int n2 = n + this._value_length;
            return string.substring(n, n2);
        }
    }
}

