/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKDefaultStyle;
import com.sun.java.swing.plaf.gtk.GTKNativeEngine;
import com.sun.java.swing.plaf.gtk.GTKNativeStyle;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.awt.UNIXToolkit;

class GTKStyleFactory
extends SynthStyleFactory {
    private static final boolean isNativeGtk;
    private final Map<Object, GTKStyle> stylesCache = new HashMap<Object, GTKStyle>();
    private Font defaultFont;

    GTKStyleFactory() {
    }

    public synchronized SynthStyle getStyle(JComponent jComponent, Region region) {
        GTKStyle gTKStyle;
        GTKNativeEngine.WidgetType widgetType = GTKNativeEngine.getWidgetType(jComponent, region);
        Object object = null;
        if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
            if (jComponent != null) {
                boolean bl = jComponent.getComponentOrientation().isLeftToRight();
                object = new ComplexKey(widgetType, bl);
            }
        } else if (region == Region.BUTTON && jComponent != null) {
            JButton jButton = (JButton)jComponent;
            boolean bl = jButton.getParent() instanceof JToolBar;
            boolean bl2 = jButton.isDefaultCapable();
            object = new ComplexKey(widgetType, bl, bl2);
        }
        if (object == null) {
            object = widgetType;
        }
        if ((gTKStyle = this.stylesCache.get(object)) == null) {
            gTKStyle = isNativeGtk ? new GTKNativeStyle(this.defaultFont, widgetType) : new GTKDefaultStyle(this.defaultFont);
            this.stylesCache.put(object, gTKStyle);
        }
        return gTKStyle;
    }

    void initStyles(Font font) {
        this.defaultFont = font;
        this.stylesCache.clear();
    }

    /*
     * Unable to fully structure code
     */
    static {
        var0 = Toolkit.getDefaultToolkit();
        if (!(var0 instanceof UNIXToolkit)) ** GOTO lbl-1000
        (UNIXToolkit)var0;
        if (UNIXToolkit.checkGTK()) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        GTKStyleFactory.isNativeGtk = v0;
    }

    private static class ComplexKey {
        private final GTKNativeEngine.WidgetType wt;
        private final Object[] args;

        ComplexKey(GTKNativeEngine.WidgetType widgetType, Object ... objectArray) {
            this.wt = widgetType;
            this.args = objectArray;
        }

        public int hashCode() {
            int n = this.wt.hashCode();
            if (this.args != null) {
                for (Object object : this.args) {
                    n = n * 29 + (object == null ? 0 : object.hashCode());
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComplexKey)) {
                return false;
            }
            ComplexKey complexKey = (ComplexKey)object;
            if (this.wt == complexKey.wt) {
                if (this.args == null && complexKey.args == null) {
                    return true;
                }
                if (this.args != null && complexKey.args != null && this.args.length == complexKey.args.length) {
                    for (int i = 0; i < this.args.length; ++i) {
                        Object object2 = this.args[i];
                        Object object3 = complexKey.args[i];
                        if (object2 != null ? object2.equals(object3) : object3 == null) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            String string = "ComplexKey[wt=" + (Object)((Object)this.wt);
            if (this.args != null) {
                string = string + ",args=[";
                for (int i = 0; i < this.args.length; ++i) {
                    string = string + this.args[i];
                    if (i >= this.args.length - 1) continue;
                    string = string + ",";
                }
                string = string + "]";
            }
            string = string + "]";
            return string;
        }
    }
}

