#!/bin/sh
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/mke2fs.conf.new
if [ -x /usr/bin/install-info ]; then
  install-info --info-dir=/usr/info /usr/info/libext2fs.info.gz 2> /dev/null
fi
( cd sbin ; rm -rf mkfs.ext2 )
( cd sbin ; ln -sf mke2fs mkfs.ext2 )
( cd sbin ; rm -rf mkfs.ext3 )
( cd sbin ; ln -sf mke2fs mkfs.ext3 )
( cd sbin ; rm -rf e2label )
( cd sbin ; ln -sf tune2fs e2label )
( cd sbin ; rm -rf findfs )
( cd sbin ; ln -sf tune2fs findfs )
( cd lib ; rm -rf libcom_err.so.2 )
( cd lib ; ln -sf libcom_err.so.2.1 libcom_err.so.2 )
( cd lib ; rm -rf libss.so.2 )
( cd lib ; ln -sf libss.so.2.0 libss.so.2 )
( cd lib ; rm -rf libe2p.so.2 )
( cd lib ; ln -sf libe2p.so.2.3 libe2p.so.2 )
( cd lib ; rm -rf libext2fs.so.2 )
( cd lib ; ln -sf libext2fs.so.2.4 libext2fs.so.2 )
( cd lib ; rm -rf libuuid.so.1 )
( cd lib ; ln -sf libuuid.so.1.2 libuuid.so.1 )
( cd lib ; rm -rf libblkid.so.1 )
( cd lib ; ln -sf libblkid.so.1.0 libblkid.so.1 )
( cd usr/lib ; rm -rf libblkid.so )
( cd usr/lib ; ln -sf /lib/libblkid.so.1 libblkid.so )
( cd usr/lib ; rm -rf libcom_err.so )
( cd usr/lib ; ln -sf /lib/libcom_err.so.2 libcom_err.so )
( cd usr/lib ; rm -rf libe2p.so )
( cd usr/lib ; ln -sf /lib/libe2p.so.2 libe2p.so )
( cd usr/lib ; rm -rf libext2fs.so )
( cd usr/lib ; ln -sf /lib/libext2fs.so.2 libext2fs.so )
( cd usr/lib ; rm -rf libss.so )
( cd usr/lib ; ln -sf /lib/libss.so.2 libss.so )
( cd usr/lib ; rm -rf libuuid.so )
( cd usr/lib ; ln -sf /lib/libuuid.so.1 libuuid.so )
( cd usr/man/man8 ; rm -rf fsck.ext2.8.gz )
( cd usr/man/man8 ; ln -sf e2fsck.8.gz fsck.ext2.8.gz )
( cd usr/man/man8 ; rm -rf fsck.ext3.8.gz )
( cd usr/man/man8 ; ln -sf e2fsck.8.gz fsck.ext3.8.gz )
( cd usr/man/man8 ; rm -rf mkfs.ext2.8.gz )
( cd usr/man/man8 ; ln -sf mke2fs.8.gz mkfs.ext2.8.gz )
( cd usr/man/man8 ; rm -rf mkfs.ext3.8.gz )
( cd usr/man/man8 ; ln -sf mke2fs.8.gz mkfs.ext3.8.gz )
( cd usr/man/man3 ; rm -rf uuid_generate_random.3.gz )
( cd usr/man/man3 ; ln -sf uuid_generate.3.gz uuid_generate_random.3.gz )
( cd usr/man/man3 ; rm -rf uuid_generate_time.3.gz )
( cd usr/man/man3 ; ln -sf uuid_generate.3.gz uuid_generate_time.3.gz )
