/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM mozIStorageService.idl
 */

#ifndef __gen_mozIStorageService_h__
#define __gen_mozIStorageService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class mozIStorageConnection; /* forward declaration */

class nsIFile; /* forward declaration */


/* starting interface:    mozIStorageService */
#define MOZISTORAGESERVICE_IID_STR "22cff01c-1a5a-4b11-9e27-f8f832226489"

#define MOZISTORAGESERVICE_IID \
  {0x22cff01c, 0x1a5a, 0x4b11, \
    { 0x9e, 0x27, 0xf8, 0xf8, 0x32, 0x22, 0x64, 0x89 }}

class NS_NO_VTABLE mozIStorageService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(MOZISTORAGESERVICE_IID)

  /**
   * Get a connection to the local profile storage.
   *
   * @param aStorageKey a string key identifying the type of storage
   * requested.  Valid values include: "profile", "cert".
   *
   * @returns a mozIStorageConnection corresponding to
   * the appropriate storage for the current thread.
   * (XXX - always returns same one for now, need to add threading)
   */
  /* mozIStorageConnection getProfileStorage (in string aStorageKey); */
  NS_IMETHOD GetProfileStorage(const char *aStorageKey, mozIStorageConnection **_retval) = 0;

  /**
   * Open a connection to the specified file.
   *
   * @param aDatabaseFile a nsIFile of the database to open.
   *
   * @returns a mozIStorageConnection corresponding to
   * the appropriate storage for the current thread.
   * (XXX - always returns same one for now, need to add threading)
   */
  /* mozIStorageConnection openDatabase (in nsIFile aDatabaseFile); */
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_MOZISTORAGESERVICE \
  NS_IMETHOD GetProfileStorage(const char *aStorageKey, mozIStorageConnection **_retval); \
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_MOZISTORAGESERVICE(_to) \
  NS_IMETHOD GetProfileStorage(const char *aStorageKey, mozIStorageConnection **_retval) { return _to GetProfileStorage(aStorageKey, _retval); } \
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval) { return _to OpenDatabase(aDatabaseFile, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_MOZISTORAGESERVICE(_to) \
  NS_IMETHOD GetProfileStorage(const char *aStorageKey, mozIStorageConnection **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProfileStorage(aStorageKey, _retval); } \
  NS_IMETHOD OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenDatabase(aDatabaseFile, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public mozIStorageService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MOZISTORAGESERVICE

  _MYCLASS_();

private:
  ~_MYCLASS_();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, mozIStorageService)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* mozIStorageConnection getProfileStorage (in string aStorageKey); */
NS_IMETHODIMP _MYCLASS_::GetProfileStorage(const char *aStorageKey, mozIStorageConnection **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* mozIStorageConnection openDatabase (in nsIFile aDatabaseFile); */
NS_IMETHODIMP _MYCLASS_::OpenDatabase(nsIFile *aDatabaseFile, mozIStorageConnection **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_mozIStorageService_h__ */
