/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.reflect.Reflection;

public class Logger {
    private static final Handler[] emptyHandlers = new Handler[0];
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager;
    private String name;
    private ArrayList handlers;
    private String resourceBundleName;
    private boolean useParentHandlers = true;
    private Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static Object treeLock = new Object();
    private Logger parent;
    private ArrayList kids;
    private Level levelObject;
    private volatile int levelValue;
    public static final Logger global = new Logger("global");

    protected Logger(String string, String string2) {
        this.manager = LogManager.getLogManager();
        if (string2 != null) {
            this.setupResourceInfo(string2);
        }
        this.name = string;
        this.levelValue = Level.INFO.intValue();
    }

    private Logger(String string) {
        this.name = string;
        this.levelValue = Level.INFO.intValue();
    }

    void setLogManager(LogManager logManager) {
        this.manager = logManager;
    }

    private void checkAccess() throws SecurityException {
        if (!this.anonymous) {
            if (this.manager == null) {
                this.manager = LogManager.getLogManager();
            }
            this.manager.checkAccess();
        }
    }

    public static synchronized Logger getLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            logger = new Logger(string, null);
            logManager.addLogger(logger);
            logger = logManager.getLogger(string);
        }
        return logger;
    }

    public static synchronized Logger getLogger(String string, String string2) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            logger = new Logger(string, string2);
            logManager.addLogger(logger);
            logger = logManager.getLogger(string);
        }
        if (logger.resourceBundleName == null) {
            logger.setupResourceInfo(string2);
        } else if (!logger.resourceBundleName.equals(string2)) {
            throw new IllegalArgumentException(logger.resourceBundleName + " != " + string2);
        }
        return logger;
    }

    public static synchronized Logger getAnonymousLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = new Logger(null, null);
        logger.anonymous = true;
        Logger logger2 = logManager.getLogger("");
        logger.doSetParent(logger2);
        return logger;
    }

    public static synchronized Logger getAnonymousLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = new Logger(null, string);
        logger.anonymous = true;
        Logger logger2 = logManager.getLogger("");
        logger.doSetParent(logger2);
        return logger;
    }

    public ResourceBundle getResourceBundle() {
        return this.findResourceBundle(this.getResourceBundleName());
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setFilter(Filter filter) throws SecurityException {
        this.checkAccess();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogRecord logRecord) {
        if (logRecord.getLevel().intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        Logger logger = this;
        synchronized (logger) {
            if (this.filter != null && !this.filter.isLoggable(logRecord)) {
                return;
            }
        }
        for (logger = this; logger != null; logger = logger.getParent()) {
            Handler[] handlerArray = logger.getHandlers();
            if (handlerArray != null) {
                for (int i = 0; i < handlerArray.length; ++i) {
                    handlerArray[i].publish(logRecord);
                }
            }
            if (!logger.getUseParentHandlers()) break;
        }
    }

    private void doLog(LogRecord logRecord) {
        logRecord.setLoggerName(this.name);
        String string = this.getEffectiveResourceBundleName();
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string));
        }
        this.log(logRecord);
    }

    public void log(Level level, String string) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    private void doLog(LogRecord logRecord, String string) {
        logRecord.setLoggerName(this.name);
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string));
        }
        this.log(logRecord);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord, string3);
    }

    public void entering(String string, String string2) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, string, string2, "ENTRY");
    }

    public void entering(String string, String string2, Object object) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.logp(Level.FINER, string, string2, "ENTRY {0}", objectArray);
    }

    public void entering(String string, String string2, Object[] objectArray) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        String string3 = "ENTRY";
        if (objectArray == null) {
            this.logp(Level.FINER, string, string2, string3);
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            string3 = string3 + " {" + i + "}";
        }
        this.logp(Level.FINER, string, string2, string3, objectArray);
    }

    public void exiting(String string, String string2) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, string, string2, "RETURN");
    }

    public void exiting(String string, String string2, Object object) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.logp(Level.FINER, string, string2, "RETURN {0}", object);
    }

    public void throwing(String string, String string2, Throwable throwable) {
        if (Level.FINER.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(Level.FINER, "THROW");
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void severe(String string) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, string);
    }

    public void warning(String string) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, string);
    }

    public void config(String string) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, string);
    }

    public void fine(String string) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, string);
    }

    public void finer(String string) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, string);
    }

    public void finest(String string) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level level) throws SecurityException {
        this.checkAccess();
        Object object = treeLock;
        synchronized (object) {
            this.levelObject = level;
            this.updateEffectiveLevel();
        }
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        this.checkAccess();
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(handler);
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        this.checkAccess();
        if (handler == null) {
            return;
        }
        if (this.handlers == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public synchronized Handler[] getHandlers() {
        if (this.handlers == null) {
            return emptyHandlers;
        }
        Handler[] handlerArray = new Handler[this.handlers.size()];
        handlerArray = this.handlers.toArray(handlerArray);
        return handlerArray;
    }

    public synchronized void setUseParentHandlers(boolean bl) {
        this.checkAccess();
        this.useParentHandlers = bl;
    }

    public synchronized boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private synchronized ResourceBundle findResourceBundle(String string) {
        if (string == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        if (this.catalog != null && locale == this.catalogLocale && string == this.catalogName) {
            return this.catalog;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        catch (MissingResourceException missingResourceException) {
            Class clazz;
            int n = 0;
            while ((clazz = Reflection.getCallerClass(n)) != null) {
                ClassLoader classLoader2 = clazz.getClassLoader();
                if (classLoader2 == null) {
                    classLoader2 = ClassLoader.getSystemClassLoader();
                }
                if (classLoader != classLoader2) {
                    classLoader = classLoader2;
                    try {
                        this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
                        this.catalogName = string;
                        this.catalogLocale = locale;
                        return this.catalog;
                    }
                    catch (MissingResourceException missingResourceException2) {
                        // empty catch block
                    }
                }
                ++n;
            }
            if (string.equals(this.catalogName)) {
                return this.catalog;
            }
            return null;
        }
    }

    private synchronized void setupResourceInfo(String string) {
        if (string == null) {
            return;
        }
        ResourceBundle resourceBundle = this.findResourceBundle(string);
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find " + string + " bundle", string, "");
        }
        this.resourceBundleName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getParent() {
        Object object = treeLock;
        synchronized (object) {
            return this.parent;
        }
    }

    public void setParent(Logger logger) {
        if (logger == null) {
            throw new NullPointerException();
        }
        this.manager.checkAccess();
        this.doSetParent(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetParent(Logger logger) {
        Object object = treeLock;
        synchronized (object) {
            if (this.parent != null) {
                Iterator iterator = this.parent.kids.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    Logger logger2 = (Logger)weakReference.get();
                    if (logger2 != this) continue;
                    iterator.remove();
                    break;
                }
            }
            this.parent = logger;
            if (this.parent.kids == null) {
                this.parent.kids = new ArrayList(2);
            }
            this.parent.kids.add(new WeakReference<Logger>(this));
            this.updateEffectiveLevel();
        }
    }

    private void updateEffectiveLevel() {
        int n = this.levelObject != null ? this.levelObject.intValue() : (this.parent != null ? this.parent.levelValue : Level.INFO.intValue());
        if (this.levelValue == n) {
            return;
        }
        this.levelValue = n;
        if (this.kids != null) {
            for (int i = 0; i < this.kids.size(); ++i) {
                WeakReference weakReference = (WeakReference)this.kids.get(i);
                Logger logger = (Logger)weakReference.get();
                if (logger == null) continue;
                logger.updateEffectiveLevel();
            }
        }
    }

    private String getEffectiveResourceBundleName() {
        for (Logger logger = this; logger != null; logger = logger.getParent()) {
            String string = logger.getResourceBundleName();
            if (string == null) continue;
            return string;
        }
        return null;
    }
}

