/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exchanger<V> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition taken = this.lock.newCondition();
    private V item;
    private int arrivalCount;

    private V doExchange(V v, boolean bl, long l) throws InterruptedException, TimeoutException {
        this.lock.lock();
        try {
            int n;
            while (this.arrivalCount == 2) {
                if (!bl) {
                    this.taken.await();
                    continue;
                }
                if (l > 0L) {
                    l = this.taken.awaitNanos(l);
                    continue;
                }
                throw new TimeoutException();
            }
            if ((n = ++this.arrivalCount) == 2) {
                V v2 = this.item;
                this.item = v;
                this.taken.signal();
                V v3 = v2;
                return v3;
            }
            this.item = v;
            InterruptedException interruptedException = null;
            try {
                while (this.arrivalCount != 2) {
                    if (!bl) {
                        this.taken.await();
                        continue;
                    }
                    if (l > 0L) {
                        l = this.taken.awaitNanos(l);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException2) {
                interruptedException = interruptedException2;
            }
            V v4 = this.item;
            this.item = null;
            n = this.arrivalCount;
            this.arrivalCount = 0;
            this.taken.signal();
            if (n == 2) {
                if (interruptedException != null) {
                    Thread.currentThread().interrupt();
                }
                V v5 = v4;
                return v5;
            }
            if (interruptedException != null) {
                throw interruptedException;
            }
            throw new TimeoutException();
        }
        finally {
            this.lock.unlock();
        }
    }

    public V exchange(V v) throws InterruptedException {
        try {
            return this.doExchange(v, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            throw new Error(timeoutException);
        }
    }

    public V exchange(V v, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return this.doExchange(v, true, timeUnit.toNanos(l));
    }
}

