/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.AxesWalker;
import com.sun.org.apache.xpath.internal.axes.FilterExprIteratorSimple;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.axes.WalkingIterator;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import com.sun.org.apache.xpath.internal.objects.XNodeSet;
import com.sun.org.apache.xpath.internal.operations.Variable;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient XNodeSet m_exprObj;
    private boolean m_mustHardReset = false;
    private boolean m_canDetachNodeset = true;

    public FilterExprWalker(WalkingIterator walkingIterator) {
        super(walkingIterator, 20);
    }

    public void init(Compiler compiler, int n, int n2) throws TransformerException {
        super.init(compiler, n, n2);
        switch (n2) {
            case 24: 
            case 25: {
                this.m_mustHardReset = true;
            }
            case 22: 
            case 23: {
                this.m_expr = compiler.compile(n);
                this.m_expr.exprSetParent(this);
                if (!(this.m_expr instanceof Variable)) break;
                this.m_canDetachNodeset = false;
                break;
            }
            default: {
                this.m_expr = compiler.compile(n + 2);
                this.m_expr.exprSetParent(this);
            }
        }
    }

    public void detach() {
        super.detach();
        if (this.m_canDetachNodeset) {
            this.m_exprObj.detach();
        }
        this.m_exprObj = null;
    }

    public void setRoot(int n) {
        super.setRoot(n);
        this.m_exprObj = FilterExprIteratorSimple.executeFilterExpr(n, this.m_lpi.getXPathContext(), this.m_lpi.getPrefixResolver(), this.m_lpi.getIsTopLevel(), this.m_lpi.m_stackFrame, this.m_expr);
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker filterExprWalker = (FilterExprWalker)super.clone();
        if (null != this.m_exprObj) {
            filterExprWalker.m_exprObj = (XNodeSet)this.m_exprObj.clone();
        }
        return filterExprWalker;
    }

    public short acceptNode(int n) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
    }

    public int getNextNode() {
        if (null != this.m_exprObj) {
            int n = this.m_exprObj.nextNode();
            return n;
        }
        return -1;
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.m_exprObj.getLength();
    }

    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        this.m_expr.fixupVariables(vector, n);
    }

    public Expression getInnerExpression() {
        return this.m_expr;
    }

    public void setInnerExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_expr = expression;
    }

    public int getAnalysisBits() {
        if (null != this.m_expr && this.m_expr instanceof PathComponent) {
            return ((PathComponent)((Object)this.m_expr)).getAnalysisBits();
        }
        return 0x4000000;
    }

    public boolean isDocOrdered() {
        return this.m_exprObj.isDocOrdered();
    }

    public int getAxis() {
        return this.m_exprObj.getAxis();
    }

    public void callPredicateVisitors(XPathVisitor xPathVisitor) {
        this.m_expr.callVisitors(new filterExprOwner(), xPathVisitor);
        super.callPredicateVisitors(xPathVisitor);
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        FilterExprWalker filterExprWalker = (FilterExprWalker)expression;
        return this.m_expr.deepEquals(filterExprWalker.m_expr);
    }

    class filterExprOwner
    implements ExpressionOwner {
        filterExprOwner() {
        }

        public Expression getExpression() {
            return FilterExprWalker.this.m_expr;
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(FilterExprWalker.this);
            FilterExprWalker.this.m_expr = expression;
        }
    }
}

