/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jlex.internal;

import com.sun.jlex.internal.CDTrans;
import com.sun.jlex.internal.CSpec;
import com.sun.jlex.internal.CUtility;
import com.sun.jlex.internal.SparseBitSet;
import java.util.Vector;

class CMinimize {
    CSpec m_spec;
    Vector m_group;
    int[] m_ingroup;

    CMinimize() {
        this.reset();
    }

    private void reset() {
        this.m_spec = null;
        this.m_group = null;
        this.m_ingroup = null;
    }

    private void set(CSpec cSpec) {
        CUtility._assert(null != cSpec);
        this.m_spec = cSpec;
        this.m_group = null;
        this.m_ingroup = null;
    }

    void min_dfa(CSpec cSpec) {
        this.set(cSpec);
        this.minimize();
        this.reduce();
        this.reset();
    }

    private void col_copy(int n, int n2) {
        int n3 = this.m_spec.m_dtrans_vector.size();
        for (int i = 0; i < n3; ++i) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            cDTrans.m_dtrans[n] = cDTrans.m_dtrans[n2];
        }
    }

    private void trunc_col() {
        int n = this.m_spec.m_dtrans_vector.size();
        for (int i = 0; i < n; ++i) {
            int[] nArray = new int[this.m_spec.m_dtrans_ncols];
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            System.arraycopy(cDTrans.m_dtrans, 0, nArray, 0, nArray.length);
            cDTrans.m_dtrans = nArray;
        }
    }

    private void row_copy(int n, int n2) {
        CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
        this.m_spec.m_dtrans_vector.setElementAt(cDTrans, n);
    }

    private boolean col_equiv(int n, int n2) {
        int n3 = this.m_spec.m_dtrans_vector.size();
        for (int i = 0; i < n3; ++i) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            if (cDTrans.m_dtrans[n] == cDTrans.m_dtrans[n2]) continue;
            return false;
        }
        return true;
    }

    private boolean row_equiv(int n, int n2) {
        CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n);
        CDTrans cDTrans2 = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
        for (int i = 0; i < this.m_spec.m_dtrans_ncols; ++i) {
            if (cDTrans.m_dtrans[i] == cDTrans2.m_dtrans[i]) continue;
            return false;
        }
        return true;
    }

    private void reduce() {
        int n;
        int n2;
        SparseBitSet sparseBitSet = new SparseBitSet();
        int n3 = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_anchor_array = new int[n3];
        this.m_spec.m_accept_vector = new Vector();
        for (n2 = 0; n2 < n3; ++n2) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
            this.m_spec.m_accept_vector.addElement(cDTrans.m_accept);
            this.m_spec.m_anchor_array[n2] = cDTrans.m_anchor;
            cDTrans.m_accept = null;
        }
        this.m_spec.m_col_map = new int[this.m_spec.m_dtrans_ncols];
        for (n2 = 0; n2 < this.m_spec.m_dtrans_ncols; ++n2) {
            this.m_spec.m_col_map[n2] = -1;
        }
        int n4 = 0;
        while (true) {
            for (n2 = 0; n2 < n4; ++n2) {
                CUtility._assert(-1 != this.m_spec.m_col_map[n2]);
            }
            for (n2 = n4; n2 < this.m_spec.m_dtrans_ncols && -1 != this.m_spec.m_col_map[n2]; ++n2) {
            }
            if (n2 >= this.m_spec.m_dtrans_ncols) break;
            CUtility._assert(false == sparseBitSet.get(n2));
            CUtility._assert(-1 == this.m_spec.m_col_map[n2]);
            sparseBitSet.set(n2);
            this.m_spec.m_col_map[n2] = n4;
            for (n = n2 + 1; n < this.m_spec.m_dtrans_ncols; ++n) {
                if (-1 != this.m_spec.m_col_map[n] || !this.col_equiv(n2, n)) continue;
                this.m_spec.m_col_map[n] = n4;
            }
            ++n4;
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.m_spec.m_dtrans_ncols; ++n2) {
            if (!sparseBitSet.get(n2)) continue;
            ++n5;
            sparseBitSet.clear(n2);
            n = this.m_spec.m_col_map[n2];
            CUtility._assert(n <= n2);
            if (n == n2) continue;
            this.col_copy(n, n2);
        }
        this.m_spec.m_dtrans_ncols = n4;
        this.trunc_col();
        CUtility._assert(n5 == n4);
        int n6 = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_row_map = new int[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            this.m_spec.m_row_map[n2] = -1;
        }
        int n7 = 0;
        while (true) {
            for (n2 = 0; n2 < n7; ++n2) {
                CUtility._assert(-1 != this.m_spec.m_row_map[n2]);
            }
            for (n2 = n7; n2 < n6 && -1 != this.m_spec.m_row_map[n2]; ++n2) {
            }
            if (n2 >= n6) break;
            CUtility._assert(false == sparseBitSet.get(n2));
            CUtility._assert(-1 == this.m_spec.m_row_map[n2]);
            sparseBitSet.set(n2);
            this.m_spec.m_row_map[n2] = n7;
            for (n = n2 + 1; n < n6; ++n) {
                if (-1 != this.m_spec.m_row_map[n] || !this.row_equiv(n2, n)) continue;
                this.m_spec.m_row_map[n] = n7;
            }
            ++n7;
        }
        n5 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            if (!sparseBitSet.get(n2)) continue;
            ++n5;
            sparseBitSet.clear(n2);
            n = this.m_spec.m_row_map[n2];
            CUtility._assert(n <= n2);
            if (n == n2) continue;
            this.row_copy(n, n2);
        }
        this.m_spec.m_dtrans_vector.setSize(n7);
        CUtility._assert(n5 == n7);
    }

    private void fix_dtrans() {
        int n;
        Vector<CDTrans> vector = new Vector<CDTrans>();
        int n2 = this.m_spec.m_state_dtrans.length;
        for (n = 0; n < n2; ++n) {
            if (-1 == this.m_spec.m_state_dtrans[n]) continue;
            this.m_spec.m_state_dtrans[n] = this.m_ingroup[this.m_spec.m_state_dtrans[n]];
        }
        n2 = this.m_group.size();
        for (n = 0; n < n2; ++n) {
            Vector vector2 = (Vector)this.m_group.elementAt(n);
            CDTrans cDTrans = (CDTrans)vector2.elementAt(0);
            vector.addElement(cDTrans);
            for (int i = 0; i < this.m_spec.m_dtrans_ncols; ++i) {
                if (-1 == cDTrans.m_dtrans[i]) continue;
                cDTrans.m_dtrans[i] = this.m_ingroup[cDTrans.m_dtrans[i]];
            }
        }
        this.m_group = null;
        this.m_spec.m_dtrans_vector = vector;
    }

    private void minimize() {
        this.init_groups();
        int n = this.m_group.size();
        int n2 = n - 1;
        while (n2 != n) {
            n2 = n;
            CUtility._assert(this.m_group.size() == n);
            for (int i = 0; i < n; ++i) {
                Vector vector = (Vector)this.m_group.elementAt(i);
                int n3 = vector.size();
                if (n3 <= 1) continue;
                Vector<CDTrans> vector2 = new Vector<CDTrans>();
                boolean bl = false;
                CDTrans cDTrans = (CDTrans)vector.elementAt(0);
                block2: for (int j = 1; j < n3; ++j) {
                    CDTrans cDTrans2 = (CDTrans)vector.elementAt(j);
                    for (int k = 0; k < this.m_spec.m_dtrans_ncols; ++k) {
                        int n4 = cDTrans.m_dtrans[k];
                        int n5 = cDTrans2.m_dtrans[k];
                        if (n4 == n5 || n4 != -1 && n5 != -1 && this.m_ingroup[n5] == this.m_ingroup[n4]) continue;
                        CUtility._assert(vector.elementAt(j) == cDTrans2);
                        vector.removeElementAt(j);
                        --j;
                        --n3;
                        vector2.addElement(cDTrans2);
                        if (!bl) {
                            bl = true;
                            ++n;
                            this.m_group.addElement(vector2);
                        }
                        this.m_ingroup[cDTrans2.m_label] = this.m_group.size() - 1;
                        CUtility._assert(this.m_group.contains(vector2));
                        CUtility._assert(this.m_group.contains(vector));
                        CUtility._assert(vector.contains(cDTrans));
                        CUtility._assert(!vector.contains(cDTrans2));
                        CUtility._assert(!vector2.contains(cDTrans));
                        CUtility._assert(vector2.contains(cDTrans2));
                        CUtility._assert(vector.size() == n3);
                        CUtility._assert(i == this.m_ingroup[cDTrans.m_label]);
                        CUtility._assert(this.m_group.size() - 1 == this.m_ingroup[cDTrans2.m_label]);
                        continue block2;
                    }
                }
            }
        }
        System.out.println(this.m_group.size() + " states after removal of redundant states.");
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.fix_dtrans();
    }

    private void init_groups() {
        this.m_group = new Vector();
        int n = 0;
        int n2 = this.m_spec.m_dtrans_vector.size();
        this.m_ingroup = new int[n2];
        for (int i = 0; i < n2; ++i) {
            Vector<CDTrans> vector;
            boolean bl = false;
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            CUtility._assert(i == cDTrans.m_label);
            CUtility._assert(false == bl);
            CUtility._assert(n == this.m_group.size());
            for (int j = 0; j < n; ++j) {
                vector = (Vector<CDTrans>)this.m_group.elementAt(j);
                CUtility._assert(false == bl);
                CUtility._assert(0 < vector.size());
                CDTrans cDTrans2 = (CDTrans)vector.elementAt(0);
                int n3 = vector.size();
                CUtility._assert(0 < n3);
                for (int k = 1; k < n3; ++k) {
                    CDTrans cDTrans3 = (CDTrans)vector.elementAt(k);
                    CUtility._assert(cDTrans3.m_accept == cDTrans2.m_accept);
                }
                if (cDTrans2.m_accept != cDTrans.m_accept) continue;
                vector.addElement(cDTrans);
                this.m_ingroup[i] = j;
                bl = true;
                CUtility._assert(j == this.m_ingroup[cDTrans.m_label]);
                break;
            }
            if (bl) continue;
            vector = new Vector<CDTrans>();
            vector.addElement(cDTrans);
            this.m_ingroup[i] = this.m_group.size();
            this.m_group.addElement(vector);
            ++n;
        }
        if (this.m_spec.m_verbose) {
            // empty if block
        }
    }

    private void pset(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            CDTrans cDTrans = (CDTrans)vector.elementAt(i);
            System.out.print(cDTrans.m_label + " ");
        }
    }

    private void pgroups() {
        int n;
        int n2 = this.m_group.size();
        for (n = 0; n < n2; ++n) {
            System.out.print("\tGroup " + n + " {");
            this.pset((Vector)this.m_group.elementAt(n));
            System.out.println("}");
            System.out.println();
        }
        System.out.println();
        int n3 = this.m_spec.m_dtrans_vector.size();
        for (n = 0; n < n3; ++n) {
            System.out.println("\tstate " + n + " is in group " + this.m_ingroup[n]);
        }
    }
}

