/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsDesktopManager;
import com.sun.java.swing.plaf.windows.WindowsInternalFrameTitlePane;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class WindowsInternalFrameUI
extends BasicInternalFrameUI {
    XPStyle xp = XPStyle.getXP();

    public void installDefaults() {
        super.installDefaults();
        if (this.xp != null) {
            this.frame.setBorder(new XPBorder());
        } else {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.border"));
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        LookAndFeel.installProperty(jComponent, "opaque", this.xp == null ? Boolean.TRUE : Boolean.FALSE);
    }

    public void uninstallDefaults() {
        this.frame.setBorder(null);
        super.uninstallDefaults();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsInternalFrameUI((JInternalFrame)jComponent);
    }

    public WindowsInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected DesktopManager createDesktopManager() {
        return new WindowsDesktopManager();
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new WindowsInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    private class XPBorder
    extends AbstractBorder {
        private XPStyle.Skin leftSkin;
        private XPStyle.Skin rightSkin;
        private XPStyle.Skin bottomSkin;

        private XPBorder() {
            this.leftSkin = WindowsInternalFrameUI.this.xp.getSkin("window.frameleft");
            this.rightSkin = WindowsInternalFrameUI.this.xp.getSkin("window.frameright");
            this.bottomSkin = WindowsInternalFrameUI.this.xp.getSkin("window.framebottom");
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            boolean bl2 = ((JInternalFrame)component).isSelected();
            int n6 = WindowsInternalFrameUI.this.titlePane != null ? ((WindowsInternalFrameUI)WindowsInternalFrameUI.this).titlePane.getSize().height : 0;
            this.bottomSkin.paintSkin(graphics, 0, n5 - this.bottomSkin.getHeight(), n4, this.bottomSkin.getHeight(), bl2 ? 0 : 1);
            this.leftSkin.paintSkin(graphics, 0, n6 - 1, this.leftSkin.getWidth(), n5 - n6 - this.bottomSkin.getHeight() + 2, bl2 ? 0 : 1);
            this.rightSkin.paintSkin(graphics, n4 - this.rightSkin.getWidth(), n6 - 1, this.rightSkin.getWidth(), n5 - n6 - this.bottomSkin.getHeight() + 2, bl2 ? 0 : 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 4;
            insets.left = this.leftSkin.getWidth();
            insets.right = this.rightSkin.getWidth();
            insets.bottom = this.bottomSkin.getHeight();
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

