/*
 * Copyright © 2001 Red Hat, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Red Hat not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Red Hat makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * RED HAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL RED HAT
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Owen Taylor, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *          Olivier Fourdan: adapted to the "multi-channel" concept
 */

#ifndef MCS_COMMON_H
#define MCS_COMMON_H

#include <X11/Xlib.h>

#include <glib.h>

#ifdef __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

    typedef struct _McsBuffer McsBuffer;
    typedef struct _McsColor McsColor;
    typedef struct _McsList McsList;
    typedef struct _McsChannel McsChannel;
    typedef struct _McsChannelList McsChannelList;
    typedef struct _McsSetting McsSetting;

/* Types of settings possible. Enum values correspond to
 * protocol values.
 */
    typedef enum
    {
        MCS_TYPE_INT = 0,
        MCS_TYPE_STRING = 1,
        MCS_TYPE_COLOR = 2
    }
    McsType;

    typedef enum
    {
        MCS_SUCCESS,
        MCS_NO_MEM,
        MCS_ACCESS,
        MCS_FAILED,
        MCS_NO_ENTRY,
        MCS_DUPLICATE_ENTRY,
        MCS_NO_CHANNEL
    }
    McsResult;

    typedef enum
    {
        MCS_MANAGER_NONE,
        MCS_MANAGER_STD,
        MCS_MANAGER_MULTI_CHANNEL,
        MCS_MANAGER_BOTH
    }
    McsManagerCheck;

    struct _McsBuffer
    {
        gchar byte_order;
        size_t len;
        guchar *data;
        guchar *pos;
    };

    struct _McsColor
    {
        guint16 red, green, blue, alpha;
    };

    struct _McsList
    {
        McsSetting *setting;
        McsList *next;
    };

    struct _McsChannel
    {
        gchar *channel_name;
        Atom channel_atom;
        McsList *settings;
        int ref_count;
    };

    struct _McsChannelList
    {
        McsChannel *channel;
        McsChannelList *next;
    };

    struct _McsSetting
    {
        gchar *name;
        gchar *channel_name;
        McsType type;

        union
        {
            int v_int;
            gchar *v_string;
            McsColor v_color;
        }
        data;

        unsigned long last_change_serial;
    };

    McsManagerCheck mcs_manager_check_running(Display * display, int screen);

    McsSetting *mcs_setting_copy(McsSetting * setting);
    void mcs_setting_free(McsSetting * setting);
    int mcs_setting_equal(McsSetting * setting_a, McsSetting * setting_b);

    void mcs_list_free(McsList * list);
    McsList *mcs_list_copy(McsList * list);
    McsResult mcs_list_insert(McsList ** list, McsSetting * setting);
    McsSetting *mcs_list_lookup(McsList * list, const gchar *name);
    McsResult mcs_list_delete(McsList ** list, const gchar *name);

    gchar mcs_byte_order(void);

#define MCS_PAD(n,m) ((n + m - 1) & (~(m-1)))

#ifdef __cplusplus
}
#endif                          /* __cplusplus */

#endif                          /* MCS_COMMON_H */
