var gObserverService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService); 

var mailComposeWindowExtrasObserver = {
  observe: function(subject, topic, state) {
    dump("XXX composeWindowExtrasObserver: " + subject + " " + topic + "\n");
    if (topic == "mail:composeOnSend")
      CheckForMDNRequest(subject);
  }
}

function CheckForMDNRequest(subject)
{
  // not our window, so ignore it.
  if (subject != window)
    return;
  var msgCompFields = gMsgCompose.compFields;
  // we're going to steal the otherRandomHeaders for aol return receipts.
  // N.B., we're crunching whatever the current value is because we
  // don't think we're going to expose otherRandomHeaders to aol users
  if (msgCompFields.returnReceipt)
  {
    // if the current identity ends with "aol.com", we'll send out an aol return receipt request
    var domain = "@aol.com";
    if ((gCurrentIdentity.email.length > domain.length) && (gCurrentIdentity.email.length - domain.length == gCurrentIdentity.email.indexOf(domain))) 
    {
      msgCompFields.otherRandomHeaders += "X-AOL-Return-Receipt: yes\r\n";
      // don't let this into the back end c++ code; We've already set up the return receipt
      // with the aol check box.
      msgCompFields.returnReceipt = false;
    }
  }
}

function mailComposeWindowExtrasOnUnload()
{
  gObserverService.removeObserver(mailComposeWindowExtrasObserver, "mail:composeOnSend");
}

// our observer is not a weak ref, so we need to remove it when we unload
addEventListener("unload", mailComposeWindowExtrasOnUnload, false);

gObserverService.addObserver(mailComposeWindowExtrasObserver, "mail:composeOnSend", false);
dump("loading mailComposeExtrasOverlays.js\n");

