// Various IDL interfaces 
var CachedAimServiceClass = null;
var CachedAimManager = null;
var CachedAimSession = null;
var CachedAimLocateManager = null;
var CachedAimBuddyManager = null;
var CachedAimOdirManager = null;
var CachedAimUserLookupManager = null;
var CachedAimChatManager = null;
var CachedAimTalkAgent = null;
var CachedAimFileXfer = null;
var CachedAimInviteManager = null;
var CachedAimPrivacy = null;
var CachedAimIM = null;
var CachedAimPIM = null;
var CachedAimAdminManager = null;
var CachedAimABInfo = null;
var CachedAimFeedbagManager = null;
var CachedAimWarnings = null;
var CachedAimPrefsManager = null;
var CachedAimStringBundle = null;
var CachedAimSoundManager = null;
var CachedAimDataSource = null;
var CachedAimRDFServiceClass  = null;
var CachedAimRDFService = null;
var CachedAimRDF  = null;
var CachedSessionType= null;
var CachedUserConnection = null;
var CachedFileProtocolHandler = null;

/* Various IDL that represent enumerated types */
var CachedAimAuthorizerState = null;
var CachedAimInsertionStyles = null;
var CachedAimPrivacyModes = null;
var CachedAimTalkAudioMode = null;

/*
 * Function: aimFileProtocolHandler()
 * Arguments: None
 * Return: the cached file:// protocol handler
 */
function aimFileProtocolHandler()
{
  try {
    if (CachedFileProtocolHandler == null) {
      var ios = Components.classes["@mozilla.org/network/io-service;1"]
                          .getService(Components.interfaces.nsIIOService);
      CachedFileProtocolHandler = ios.getProtocolHandler("file")
                                     .QueryInterface(Components.interfaces.nsIFileProtocolHandler);
    }
  } catch (e) {};
  return CachedFileProtocolHandler;
}

/*
 * Function: aimRDFServiceClass()
 * Arguments: None
 * Return: the cached RDF service class
 * Description: This function checks to see is there is already an existing CachedAimRDFServiceClass.
 * If so, then the cached service class is returned. If not, then the rdf-service object is got from Components.classes
 * and stored as CachedAimRDFSeriveClass.
*/

function aimRDFServiceClass() 
{
	 try {
	  if (CachedAimRDFServiceClass == null)
	    CachedAimRDFServiceClass = Components.classes["@mozilla.org/rdf/rdf-service;1"];
  } catch (e) {};
  return CachedAimRDFServiceClass;
}

/*
 * Function: aimRDF()
 * Arguments: None
 * Return: the cached RDF service
 * Description: This function checks to see is there is already an existing CachedAimRDFService.
 * If so, then the cached service is returned. If not, then a getService function is called 
 * on aimRDFServiceClass (See Above) and stored as CachedAimRDFSerive.
*/

function aimRDF()
{
  try {
	  if (CachedAimRDFService == null)
	    CachedAimRDFService = aimRDFServiceClass().getService(Components.interfaces.nsIRDFService);
  } catch (e) {};
  return CachedAimRDFService;
}

/*
 * Function: aimRDFDataSource()
 * Arguments: None
 * Return: the cached Aim DataSource
 * Description: This function is called whenever the Aim DataSource is needed.
 * This function checks to see is there is already an existing CachedAimDataSource.
 * If so, then the cahced datasource is returned. If not, then an RDFservice is accessed through
 * the RDFclass object from Components.classes array by using getservice. From the RDF service,
 * the aimDataSource is obtained by using getdataSource function. This gets stored in the global 
 * variable CachedAimDataSource and this gets returned.
*/

function aimRDFDataSource()
{
	try {
		if (CachedAimDataSource == null) {
			var RDFClass = Components.classes["@mozilla.org/rdf/rdf-service;1"];
			var RDF = RDFClass.getService(Components.interfaces.nsIRDFService);
			CachedAimDataSource = RDF.GetDataSource("rdf:AIM");
		}
	} catch (e) {};

	return CachedAimDataSource;
}

/*
 * Function: aimServiceClass()
 * Arguments: None
 * Return: the cached Aim Service class
 * Description: This function returns the IMService class object.
 * IMService class is one of the classes in the Components.classes array which can be
 * uniquely identified by the ProgID of "@netscape.com/aim/IMManager;1". 
*/

function aimServiceClass() 
{
  try {
	  if (CachedAimServiceClass == null)
	    CachedAimServiceClass = Components.classes['@netscape.com/aim/IMManager;1'];
  } catch (e) {};
  return CachedAimServiceClass;
}

/*
 * Function: aimManager()
 * Arguments: None
 * Return: the IMManager service
 * Description: This function is called whenever the Aim Manager service is needed.
 * It checks to see if there is an existing instance of CachedAimManager available. If it does, that is returned.
 * If not, then the AimManager service is obtained from the aimServiceClass() (See Above) 
 * and stored in the CachedAimManager which is returned.
*/

function aimManager()
{
  try {
	  if (CachedAimManager == null)
	    CachedAimManager = aimServiceClass().getService(Components.interfaces.nsIIMManager);
  } catch (e) {};
  return CachedAimManager;
}

/*
 * Function: aimSession()
 * Arguments: None
 * Return: the AimSession interface
 * Description: This function is either returns(if it already exists) or queries for it and
 * holds the nsIAimSession interface in the CachedAimSession global variable.
*/

function aimSession()
{
  try {
	  if(CachedAimSession == null)
	    CachedAimSession = aimManager().QueryInterface(Components.interfaces.nsIAimSession);
  } catch (e) {}; 
  return CachedAimSession;
}

/*
 * Function: aimPrivacy()
 * Arguments: None
 * Return: the AimPrivacy interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimPrivacy interface in the CachedAimPrivacy global variable.
*/

function aimPrivacy()
{
  try {
	  if(CachedAimPrivacy == null)
	    CachedAimPrivacy = aimManager().QueryInterface(Components.interfaces.nsIAimPrivacy);
  } catch (e) {}; 
  return CachedAimPrivacy;
}

/*
 * Function: aimBuddyManager()
 * Arguments: None
 * Return: the AimBuddy interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimBuddy interface in the CachedAimBuddyManager global variable.
*/

function aimBuddyManager()
{
  try {
	  if(CachedAimBuddyManager == null)
	    CachedAimBuddyManager = aimManager().QueryInterface(Components.interfaces.nsIAimBuddy);
  } catch (e) {}; 
  return CachedAimBuddyManager;
}

/*
 * Function: aimLocateManager()
 * Arguments: None
 * Return: the AimLocateManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimLocateManager interface in the CachedAimLocateManager global variable.
*/

function aimLocateManager()
{
  try {
	  if(CachedAimLocateManager == null)
	    CachedAimLocateManager = aimManager().QueryInterface(Components.interfaces.nsIAimLocateManager);
  } catch (e) {}; 
  return CachedAimLocateManager;
}


/*
 * Function: aimOdirManager()
 * Arguments: None
 * Return: the AimOdirManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimOdirManager interface in the CachedAimOdirManager global variable.
*/

function aimOdirManager()
{
  try {
	  if(CachedAimOdirManager == null)
	    CachedAimOdirManager = aimManager().QueryInterface(Components.interfaces.nsIAimOdirManager);
  } catch (e) {}; 
  return CachedAimOdirManager;
}

/*
 * Function: aimUserLookupManager()
 * Arguments: None
 * Return: the AimUserLookupManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimUserLookupManager interface in the CachedAimUserLookupManager global variable.
*/

function aimUserLookupManager()
{
  try {
	  if(CachedAimUserLookupManager == null)
	    CachedAimUserLookupManager = aimManager().QueryInterface(Components.interfaces.nsIAimUserLookupManager);
  } catch (e) {}; 
  return CachedAimUserLookupManager;
}

/*
 * Function: aimChatManager()
 * Arguments: None
 * Return: the AimChatManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimChatManager interface in the CachedAimChatManager global variable.
*/

function aimChatManager()
{
  try {
	  if(CachedAimChatManager == null)
	    CachedAimChatManager = aimManager().QueryInterface(Components.interfaces.nsIAimChatManager);
  } catch (e) {}; 
  return CachedAimChatManager;
}

/*
 * Function: aimLocateManager()
 * Arguments: None
 * Return: the AimTalkAgent interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimTalkAgent interface in the CachedAimTalkAgent global variable.
*/

function aimTalkAgent()
{
  try {
	  if(CachedAimTalkAgent == null)
	    CachedAimTalkAgent = aimManager().QueryInterface(Components.interfaces.nsIAimTalkAgent);
  } catch (e) {}; 
  return CachedAimTalkAgent;
}



function fileXfer()
{
  try {
          if(CachedAimFileXfer == null)
            CachedAimFileXfer = aimManager().QueryInterface(Components.interfaces.nsIAimFileXfer);
  } catch (e) {};
  return CachedAimFileXfer;
}


/*
 * Function: aimInviteManager()
 * Arguments: None
 * Return: the AimInviteManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimInviteManager interface in the CachedAimInviteManager global variable.
*/

function aimInviteManager()
{
  try {
	  if(CachedAimInviteManager == null)
	    CachedAimInviteManager = aimManager().QueryInterface(Components.interfaces.nsIAimInviteManager);
  } catch (e) {}; 
  return CachedAimInviteManager;
}

/*
 * Function: aimSoundManager()
 * Arguments: None
 * Return: the AimSoundManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimSoundManager interface in the CachedAimSoundManager global variable.
*/

function aimSoundManager()
{
  try {
	  if(CachedAimSoundManager == null)
	    CachedAimSoundManager = aimManager().QueryInterface(Components.interfaces.nsIAimSoundManager);
  } catch (e) {}; 
  return CachedAimSoundManager;
}

/*
 * Function: aimIM()
 * Arguments: None
 * Return: the AimIM interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimIM interface in the CachedAimIM global variable.
*/

function aimIM()
{
  try {
	  if(CachedAimIM == null)
	    CachedAimIM = aimManager().QueryInterface(Components.interfaces.nsIAimIM);
  } catch (e) {}; 
  return CachedAimIM;
}

/*
 * Function: aimAdminManager()
 * Arguments: None
 * Return: the AimAdminManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimAdminManager interface in the CachedAimAdminManager global variable.
*/

function aimAdminManager()
{
  try {
	  if(CachedAimAdminManager == null)
	    CachedAimAdminManager = aimManager().QueryInterface(Components.interfaces.nsIAimAdminManager);
  } catch (e) {}; 
  return CachedAimAdminManager;
}

/*
 * Function: aimABInfo()
 * Arguments: None
 * Return: the AimABInfo interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimABInfo interface in the CachedAimABInfo global variable.
*/

function aimABInfo()
{
  try {
	  if(CachedAimABInfo == null)
	    CachedAimABInfo = aimManager().QueryInterface(Components.interfaces.nsIAimABInfo);
  } catch (e) {}; 
  return CachedAimABInfo;
}

/*
 * Function: aimFeedbagManager()
 * Arguments: None
 * Return: the AimFeedbagManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimFeedbagManager interface in the CachedAimFeedbagManager global variable.
*/

function aimFeedbagManager()
{
  try {
	  if(CachedAimFeedbagManager == null)
	    CachedAimFeedbagManager = aimManager().QueryInterface(Components.interfaces.nsIAimFeedbagManager);
  } catch (e) {}; 
  return CachedAimFeedbagManager;
}

/*
 * Function: aimWarnings()
 * Arguments: None
 * Return: the AimWarnings interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimWarnings interface in the CachedAimWarnings global variable.
*/

function aimWarnings()
{
  try {
	  if(CachedAimWarnings == null)
	    CachedAimWarnings = aimManager().QueryInterface(Components.interfaces.nsIAimWarnings);
  } catch (e) {}; 
  return CachedAimWarnings;
}

/*
 * Function: aimPrefsManager()
 * Arguments: None
 * Return: the AimPrefsManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimPrefsManager interface in the CachedAimPrefsManager global variable.
*/

function aimPrefsManager()
{
  try {
	  if(CachedAimPrefsManager == null)
	    CachedAimPrefsManager = aimManager().QueryInterface(Components.interfaces.nsIPrefsManager);
  } catch (e) {}; 
  return CachedAimPrefsManager;
}

/*
 * Function: aimStringBundle()
 * Arguments: None
 * Return: the AimLocateManager interface
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIStringBundle interface in the CachedAimStringBundle global variable.
*/

function aimStringBundle()
{
  try {
	  if(CachedAimStringBundle == null)
	    CachedAimStringBundle = aimManager().QueryInterface(Components.interfaces.nsIStringBundle);
  } catch (e) {}; 
  return CachedAimStringBundle;
}


// The various enumerated types/interfaces
/*
 * Function: aimInsertionStyles()
 * Arguments: None
 * Return: the AimInsertionStyles  
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimInsertionStyles enumerated type in the CachedAimInsertionStyles global variable.
*/

function aimInsertionStyles()
{
  try {
	  if(CachedAimInsertionStyles == null)
	    CachedAimInsertionStyles = Components.interfaces.nsAimInsertionStyles;
  } catch (e) {}; 
  return CachedAimInsertionStyles;
}

/*
 * Function: aimPrivacyModes()
 * Arguments: None
 * Return: the AimPrivacyModes  
 * Description: This function either returns(if it already exists) or queries for it and
 * holds the nsIAimPrivacyModes enumerated type in the CachedAimPrivacyModes global variable.
*/

function aimPrivacyModes()
{
  try {
	  if(CachedAimPrivacyModes == null)
	    CachedAimPrivacyModes = Components.interfaces.nsAimPrivacyModes;
  } catch (e) {}; 
  return CachedAimPrivacyModes;
}

/*
 * Function: aimNormalizeScreenName()
 * Arguments: 
 *    oldSN -- The original screen name
 * Return: the normalised formatted screenname  
 * Description: This function takes a screen name and formats all the white space charaters with 
 * empty string and converts the screen name into lowercase word.
*/

function aimNormalizeScreenName(oldSN)
{
	return (oldSN.replace(/\s/gi,"")).toLowerCase();
}

/*
 * Function: aimIsSameScreenName()
 * Arguments: 
 *  sN1 -- Screen name one
 *  sN2 --  Screen name two
 * Return: true if both screen names are same, false if not  
 * Description: It is is used to know if two formatted screen names are the same.
 * The aimNormalizeScreenName (See Above) function is used to get the formatted screen names.
*/

function aimIsSameScreenName(sN1, sN2)
{
 	return (aimNormalizeScreenName(sN1) == aimNormalizeScreenName(sN2))
}

/* 
 * Function: aimMigrateBuddyList( who )
 * Arguments: 
 *    who --  screen name whose buddy list needs to be migrated.
 * Return: None
 * Description: This function is used to migrate the buddylist of the screen name with
 * which the user has signed on to the aim session. This used thr AimMigratorMigrateBuddyList 
 * function of the AimMigrator service which does the actual migration.
 *
*/

function aimMigrateBuddyList( who )
{
	var whoMigrate = aimPrefsManager().GetCharPref("aim.session.migrateBuddyList",null, true);
	if ( !whoMigrate || whoMigrate == null || whoMigrate == undefined || whoMigrate != who ) {
		return;
	}
	var IMServiceClass;
	var pAimMigrator;
	try { 
		IMServiceClass = Components.classes['@netscape.com/aim/AimMigrator;1'];
		if ( IMServiceClass != null ) {
			try {
				pAimMigrator = IMServiceClass.getService(Components.interfaces.nsIAimMigrator);
				if ( pAimMigrator != null ) {
					pAimMigrator.AimMigratorMigrateBuddyList( who );
					aimPrefsManager().SetCharPref("aim.session.migrateBuddyList", "nobody", null, true);
				}
			}
			catch ( exception ) {
				// nothing
			}
		}
	}
	catch ( exception ) {
		// nothing
	}
}

/*
 * Function: html( node )
 * Arguments: 
 *    node  --  the parent node
 * Return: the entire text content of the document tree
 * Description: This function recursively walks through the entire conversation window doucment
 * and stores all the values in the variable answer.
 *
*/

function html(node)
{
    var answer = "";
    var type = node.nodeType;
    if (type == Node.ELEMENT_NODE) {
      answer += "<" + node.tagName;
        attributes = node.attributes;
        if (null != attributes) {
            var countAttrs = attributes.length;
            var index = 0;
            while(index < countAttrs) {
                att = attributes[index];
                if (null != att) {
                    answer += " " + att.name + "=\"" + att.value + "\"";
                }
                index++
            }
        }

        // close tag
        answer += ">";

        // recursively dump the children
        if (node.hasChildNodes()) {
            // get the children
            var children = node.childNodes;
            var length = children.length;
            var count = 0;
            while(count < length) {
                child = children[count]
                answer += html(child)
                count++
            }
            answer += "</" + node.tagName + ">";
        }


    }
    // if it's a piece of text just dump the text
    else if (type == Node.TEXT_NODE) {
        answer += node.data;
    }
    return answer;
}

/*
 * Function: createInstance( contractid, iidName  )
 * Arguments: 
 *    contractid  --  'ProgID' of the component class.
 *    iidName -- Interface id for the object
 * Return: the XPConnect wrapper for the object with the given iid
 * Description: This function is used to create an instance of class. According to the progID
 * and interface ID, the instance gets created and returned.
 *
*/

function createInstance( contractid, iidName ) {
  var iid = eval( "Components.interfaces." + iidName );
  return Components.classes[ contractid ].createInstance( iid );
}

/*
 * Function: cmdFileSave()
 * Arguments: None
 * Return: None;
 * Description: This function is called from File_>Save menu option in the IM window.
 * It takes the converstaion window document and recursively walk through each documentElement
 * and stores them in a variable called answer. After traversing the entire document,
 * it displays the file picker dialog. Once the user chooses a filename, the SaveConversation
 * function is used to write the contents of variable into the chosen file.
*/

function cmdFileSave()
{
  var answer;
  var wind = top.document.getElementById("LogWnd").contentWindow;
  if ( wind ) {
	  myhead = wind.document.getElementsByTagName("HEAD").item(0);
		if (myhead == null) {
			myhead = wind.document.createElement("HEAD");
			myhtml = wind.document.getElementsByTagName("HTML").item(0);
			myhtml.appendChild(myhead);
		}
		mymeta = wind.document.createElement("META");
		mymeta.setAttribute("HTTP-EQUIV", "Content-Type");
		mymeta.setAttribute("CONTENT", "text/html; charset=UTF-8");
		myhead.appendChild(mymeta);
    answer = html(wind.document.documentElement);
    answer += "\n";
  }
  else {
    return;
  }
  try {
    var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
    // XXX i18n
    fp.init(window, aimString( "title.saveconversation" ),  nsIFilePicker.modeSave);
    fp.appendFilters(nsIFilePicker.filterHTML | nsIFilePicker.filterAll );
    fp.defaultString = aimString("log.defaultfilename") + ".html";
    var returnCode = fp.show();
    if (returnCode == nsIFilePicker.returnOK || returnCode == nsIFilePicker.returnReplace) {
      var pPAimIM = aimPIMObject();
      if (pPAimIM)
      {
        pPAimIM.SaveConversation(fp.file.path, answer);
      }
    }
  } catch (ex) { }
}

/*
 * Function: cmdFileClose()
 * Arguments: None
 * Return: None
 * Description: This function is called from File_>Close menu item.
 * It closes the current window( does not exit app).
*/

function cmdFileClose()
{
  top.close();
}

/*
 * Function: cmdFilePrint()
 * Arguments: None 
 * Return: None
 * Description: This function is used to print the IM conversation window. 
 * It accesses the Log window and calls the print function to print the contents.
*/

function cmdFilePrint(window)
{
  switch(window) {
  case "im":
          if (top.document.getElementById("LogWnd").contentWindow.document.documentElement.lastChild.firstChild != null) {
            // print the contents of log window
            top.document.getElementById("LogWnd").contentWindow.print();
            return;
          }
          // No log window yet - print the compose window
          NSPrint();
          break;
  case "chat":
          top.document.getElementById("LogWnd").contentWindow.print();
          break;
  }
}

/*
 * Function: getEnums( myInterface )
 * Arguments: 
 *    myInterface --  Interface whose enums needs to be obtained 
 * Return: all the enumerated types in the interface
 * Description: This function is used to get all the enumerated types defined in the interface.
 * It loops through all the variables and checks to see if it is of type number. If it is then,
 * it stores all the enums os that variable in a array called enums which is returned.
*/

function getEnums( myInterface )
{
  var enums = {};
  for ( var i in myInterface ) {
    if ( typeof myInterface[i] == "number" ) {
      enums[i] = myInterface[i];
    }
  }
  return enums;
}

/*
 * Function: MigrateDiscover()
 * Arguments: None
 * Return: Boolean
 * Description: This function uses the Aim migrator serice to see what instant messenger 
 * has been used ( to migrate from). Once that version  has been determined, it then checks
 * to see if there is any defaultscreen name and password stored.
 * Return true, if present. Return false if not and set screen name and password to be empty.
*/

function MigrateDiscover()
{
  var IMServiceClass;
  var pAimMigrator;
	try { 
	  IMServiceClass = Components.classes['@netscape.com/aim/AimMigrator;1'];
		if ( IMServiceClass != null ) {
			try {
				pAimMigrator = IMServiceClass.getService(Components.interfaces.nsIAimMigrator);
				if ( pAimMigrator != null ) {
					version = pAimMigrator.AimMigratorDiscover();
					parent.migrationSource = version;
					if ( version == null || version == "" ) {
						return false;
					}

					var stringPref = {};
					var stringPref2 = {};
					var enums = getEnums( Components.interfaces.nsIAimMigrator );
					// get the default screen name

					var ret = pAimMigrator.AimMigratorGetStringPref2( enums.DefaultScreenName, stringPref, stringPref2 );

					if ( ret == true ) {
						parent.migrationScreenName = stringPref.value;
						parent.migrationPassword = stringPref2.value;
					}
					else {
						parent.migrationScreenName = "";
						parent.migrationPassword = "";
					}

					// get the remaining screen names, if any
					var stringPrefVec = {}; 
					var vecSize = {};
					stringPrefVec = pAimMigrator.AimMigratorGetStringVectorPref( enums.ScreenName, vecSize );

					var i;
					parent.migrationScreenNameVecSize = vecSize;
					parent.migrationScreenNameVec = stringPrefVec;

					return ret;		// all we care about is did we get a default screenname
				}
			}
			catch(exception) {
				return false;
			}
		}	
	}
  catch(exception) {
		return false;
	}
}

/*
 * Function: AimOnlineAway()
 * Arguments: None 
 * Return: Boolean
 * Description: This function is used to check whether user is in away state. 
 * This function uses the RDF service to access Aim Session from the Aimdatasource.
 * From the aimSession, the value of the Sessionstate is retrieved and checked to see if it
 * is "OnlineAway". If it is return true, otherwise return false.
*/

function AimOnlineAway()
{
	var SessionState = aimRDF().GetResource("http://home.netscape.com/NC-rdf#OnlineState");
	var dataSource = aimRDFDataSource();
	var AimSession = aimRDF().GetResource("NC:AIM/Session");
	var target = dataSource.GetTarget(AimSession, SessionState, true);
	var state = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
	if ("OnlineAway" == state)
		return true;
	return false;
}

/*
 * Function: ComeBack()
 * Arguments: None 
 * Return: None
 * Description: This function is used when the I'mBack button is clicked or 
 * whenever the user needs to get out of the "Away" state. It sets a null away message
 * using the SetUserInfoAwayMessage function. 
*/

function ComeBack()
{
	locateManager = aimLocateManager();
	if ( locateManager ) 
		locateManager.SetUserInfoAwayMessage(null);
}

/*
 * Function: AimtoOpenWindowByType( inType, uri )
 * Arguments:  
 *    inType  --  name of the window type
 *    uri   --  uri of the window to be opened
 * Return: None
 * Description: This function uses the windows mediator service to get the most recent window
 * of the given type. If there is a window with the same type, then that window is brought to 
 * focus. If no window exists, then a new window get opened.
*/

function AimtoOpenWindowByType( inType, uri )
{
  //var windowManager = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator'].getService();
  //var     windowManagerInterface = windowManager.QueryInterface( Components.interfaces.nsIWindowMediator);
  var windowManagerInterface = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
  var topWindow = windowManagerInterface.getMostRecentWindow( inType );
  if ( topWindow ) {
    topWindow.focus();
  } 
  else
    window.openDialog(uri, "_blank", "chrome,all,dialog=no", "Setup");
}                     

/*
 * Function: aimGlobalCmdHelp()
 * Arguments: None 
 * Return: None
 * Description: For netbusiness instant messenger client, this will call the AimtoOpenWindwoByType 
 * (See Above) function with help_nim.xul. For NIM, it is called with help.xul?im. 
 * These files in turn contain the help contents for the respective products.
*/

function aimGlobalCmdHelp()
{
  if (isIcq())
    openHelp("icq");
  else
    openHelp("im");
}

/*
 * Function: AimgoClickThrobber(urlPref)
 * Arguments: 
 *  urlPref --  input url which should be loaded
 * Return: None
 * Description: For netbusiness instant messenger client, this will get the localised url.
 * This url is then loaded in the default browser.
 * for NIM, this just loads the given url in the browser.
*/

function AimgoClickThrobber(urlPref)
{
		goClickThrobber( urlPref );
}

/*
 * Function: GetRdfFileUrl(def_name, chg_name)
 * Arguments: 
 *    def_name  --  default file that needs to be copied in the case of new profile  
 *    chg_name  --  the name of the file which will be appended to screen name and stores the data.
 * Return: the url of the file
 * Description: This function is used to get the rdf file for away messages/sign on a friend invites 
 * for a given screen name. Using the directory service, the default profile and the user profile is
 * obtained.  A default file is created by making a copy of the default profile file.
 * This will be named after the def_name (first input parameter). e.g. in the case of away messages 
 * it will be called default-messages.rdf.  A new file which is a copy of the user's profile is created.
 * It will be named after the screen name for the current session. According to the second input 
 * parameter it will be further identified. So e.g. in case of away message, the file will be named 
 * as <screenname><chg_name>.rdf. If this file cannot be created from the user's profile, then default 
 * profile file is copied over and this will now be called after the session's screen name and chg_name param. 
 * The exact identity and location of this file is then obtained  by using nsIFileProtocolHandler and 
 * the unique url gets returned.
*/
function GetRdfFileUrl(def_name, chg_name, skipScreenName)
{                                                                               
	var directoryService  =  Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);
	var userProfile = directoryService.get("ProfD", Components.interfaces.nsIFile);
	var defaultProfile = directoryService.get("profDef", Components.interfaces.nsIFile); // profile defaults
	if (!defaultProfile.exists())                                   
		defaultProfile = directoryService.get("ProfDefNoLoc", Components.interfaces.nsIFile); // profile defaults
	var defaultInviteFile = defaultProfile.clone();                         
	defaultInviteFile.append(def_name);                                     
  var screenName = "";                                                
  myPref = aimPrefsManager();                                         
  if ( myPref && !skipScreenName )
  {                                                         
    try {                                                           
      screenName = myPref.GetCharPref( "aim.session.screenname" , null, false);
    }
    catch(e)
    {                                                      
      screenName = "";                                        
    }
  }   
  if ( screenName != "" )
  {                                               
    screenName = screenName + ".";                                  
  }
  else if(!skipScreenName)                                                   
  {
    return;                                         
  }
  var InviteListFile = userProfile.clone();
  InviteListFile.append(screenName+chg_name);                             
    if (!InviteListFile.exists()) {                                         
		  try {
			  defaultInviteFile.copyTo(userProfile,screenName+chg_name);     
        }
			catch (e) {
			          }
			InviteListFile = userProfile.clone();                           
      InviteListFile.append(screenName+chg_name);                     
      if (!InviteListFile.exists())    {
        // Something is wrong - This should never happen
        return;
      }                             
    }                                                                       
    return aimFileProtocolHandler().getURLSpecFromFile(InviteListFile);
}  

/*
 * Function: getsidebarframe()
 * Arguments: None
 * Return: the frame which contains the sidebarbarpanel.xul
 * Description: This function walks through the list of frames. If there is only one frame, then that frame is
 * returned. Otherwise from the list, the frame which contains SidebarPanel.xul is returned.
*/

function getsidebarframe()
{
  var frame_list=window.frames;
 	if (frame_list.length==0)
 	  return window;
  for (var i=0; i<frame_list.length; i++) {
 	  if (frame_list[i].location =="chrome://aim/content/SidebarPanel.xul")
 			return frame_list[i];
 	}
	return window;	
} 
                                                                             
function aimString(name)
{

	var myAimSession = aimSession();
	if ( myAimSession ) {
		var pIStringBundle = aimSession().QueryInterface(Components.interfaces.nsIStringBundle);
		if (pIStringBundle)
			return pIStringBundle.GetStringFromName(name);
	}
	return "";
}

function aimErrorBox(errorText)
{
	top.alert(errorText);
}


/*
 * Function: processAwayMsg(msg)
 *
 * Arguments: msg
 * 
 * Return: msg with real away msgs.
 *
 * Description: This fn takes a msg (like "Hi %n, howdy?") and converts to real away msgs (like "Hi screenname, howdy?").
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 12/10/01
 *              
*/

function processAwayMsg(msg)
{
  var sn;
  var pIAimSession = aimSession();
  if(pIAimSession)
    sn = pIAimSession.CurrentScreenName;
  else
    sn = "";
  var date = new Date();
  var dateService = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].getService(Components.interfaces.nsIScriptableDateFormat);
  var time =  dateService.FormatTime(
                              "",
                              dateService.timeFormatNoSeconds,
                              date.getHours(),
                              date.getMinutes(),
                              date.getSeconds());

  var day =  dateService.FormatDate(
                              "",
                              dateService.dateFormatShort,
                              date.getFullYear(),
                              date.getMonth()+1,
                              date.getDate());

  msg = msg.replace(/%t/gi, time);
  msg = msg.replace(/%d/gi, day);
  msg = msg.replace(/%n/gi, sn);
  return msg;
}


 /******
  * Returns a string with the difference between two dates looking like: "x days, x hours, x minutes."
  * Both parameters are dates in seconds since 1/1/1970 00:00:00.
  ******/
 
function getPrettyDateDiff(aDate2, aDate1)
{
  var diff = aDate2-aDate1;
  var pretty = "";
   
  var dayDiff = Math.floor(diff / 86400);
  diff %= 86400;
  if (dayDiff > 0) {
    pretty += dayDiff + " " + (dayDiff == 1 ? aimString("tooltip.day") : aimString("tooltip.days"));
  }
   
  var hourDiff = Math.floor(diff / 3600);
  diff %= 3600;
  if (hourDiff > 0) {
    pretty += (pretty.length > 0 ? ", " : "") + hourDiff + " " + (hourDiff == 1 ? aimString("tooltip.hour") : aimString("tooltip.hours"));
  }
   
  var minDiff = Math.floor(diff / 60);
  if (minDiff > 0) {
    pretty += (pretty.length > 0 ? ", " : "") + minDiff + " " + (minDiff == 1 ? aimString("tooltip.minute") : aimString("tooltip.minutes"));
  }
   
  return pretty;
}


/*
 * Function: validateEmailAddress()
 *
 * Arguments: email address
 * 
 * Return: boolean true if the email address is valid
 *         boolean false if the email address is invalid
 *
 * Description: Called from the above function to validate the email address. Length and special characters are validated.
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 11/15/01
 *		
*/

function validateEmailAddress(emailElement)
{
  // var email = emailElement.value;
  var emailArray = emailElement.split('@');

  if (emailArray.length != 2 ||
      !emailArray[0].length ||
      !emailArray[1].length || 
      containsIllegalCharacter(emailArray[0]) ||
      containsIllegalCharacter(emailArray[1]) ) {
        // aimErrorBox(aimString("msg.enterValidEmail"));
        return false;
  }
    
  return true;
}

/*
 * Function: containsIllegalCharacter()
 *
 * Arguments: string
 * 
 * Return: boolean true if the string doesnot contain illegal characters.
 *         boolean false if the string contain illegal characters.
 *
 * Description: This function checks for common illegal characters. 
 *
 * Author: Suresh Kasinathan<suresh@netscape.com> 11/15/01
 *		
*/

function containsIllegalCharacter(aString)
{
  for (var i=0; i < aString.length; i++) {
    var code = aString.charCodeAt(i);
    if (code > 127)
      return true; // non-ASCII
    else if (code == 9 || code == 10 || code == 11 || code == 32)
      return true; // white space
    else if (code == 64)
      return true; // '@'
  }
  return false;
} 


/* Returns the selected tree/tree name based on the selected tab (online or listsetup) */
function getSelectedTreeName()
{
  var sidebarframe=getsidebarframe();
  var tab = sidebarframe.document.getElementById("OnlineOrgTabPanel");
  var tree;
  if (tab.selectedIndex == 0)
    tree = sidebarframe.document.getElementById("OnlineBuddies");
  else
    tree = sidebarframe.document.getElementById("ListSetup");

  return tree;
}

/* Returns the column name for the selected tab*/
function getSelectedTabName()
{
  var sidebarframe=getsidebarframe();
  var tab = sidebarframe.document.getElementById("OnlineOrgTabPanel");
  if (tab.selectedIndex == 0)
    return "BuddiesCol"
  else
    return "ListSetupCol"
}

/*this returns the target for the given source, attribute(property) in the tree*/
function GetBuddyAttribute(tree, source, attribute)
{
  var RDF = aimRDF();
  var property = RDF.GetResource("http://home.netscape.com/NC-rdf#" + attribute);
  var target = tree.database.GetTarget(source, property, true);
  if (target)
    target = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
  return target;
}

/* returns the resource at the given index */
function GetBuddyResource(tree, index)
{
  var RDF = aimRDF();
  var item = tree.contentView.getItemAtIndex(index);
  return RDF.GetUnicodeResource(item.id);
}

/*
* Name: getSelectedScreenName
* Arguments: tree 
* Description:
*  This function returns the selected item's screenname value if selected item has this attribute. 
* Return Value: screenName
* Author: Prassanna<prass@netscape.com>, Joseph Elwell<jelwell@netscape.com>
*/

function getSelectedScreenName()
{
  var tree = getSelectedTreeName();
  var col = getSelectedTabName();
  if (!tree || !col) return;
  var screenName = null;
  var currentIndex = tree.currentIndex;
  if (currentIndex > 0) {
    var isContainer = tree.treeBoxObject.view.isContainer(currentIndex);
    //if it is a container (groups or Offline group) return null
    if (!isContainer) {
      var buddyResource = GetBuddyResource(tree, currentIndex);
      var screenName = GetBuddyAttribute(tree, buddyResource, "ScreenName");
    }
  }
  return screenName;
}


function getGroupForScreenName()
{
  var tree = getSelectedTreeName();
  var col = getSelectedTabName();
  if (!tree || !col) return;
  var groupName = null;
  var currentIndex = tree.currentIndex;
  if (currentIndex > 0) {
    var parentIndex = tree.treeBoxObject.view.getParentIndex(currentIndex);
    var parentResource = GetBuddyResource(tree, parentIndex);
    groupName = GetBuddyAttribute(tree, parentResource, "Name");
  }
  return groupName;
}


/*
* Name: checkInputEmail
* Arguments: input email value 
* Description:
*  This function returns a boolean value based on whether the input is a valid email-address
* Return Value: boolean
* Author: Prassanna<prass@netscape.com> 
*/


function checkInputEmail( email)
{
  var emailArray=email.split('@');
  var emailArray2=email.split('.');
  var alertText;
  if (email.length =="") {
    aimErrorBox(aimString("msg.Invalidemail"));
    return false;
  }
  if (emailArray.length != 2 || emailArray[0] == "" || emailArray[1] == "") {
    aimErrorBox(aimString("msg.Invalidemail"));
    return false;
  }
  if (emailArray2.length < 2) { 
    aimErrorBox(aimString("msg.Invalidemail"));
    return false;
  }
  for (i=0; i<emailArray2.length; i++)
  {
    if (emailArray2[i] == "") {
      aimErrorBox(aimString("msg.Invalidemail"));
      return false;
    }
  }
  return true;
}

/*
* Name: setConnectionInfo
* Arguments: connectionName, aClient, screenName
* Description:
*  This function sets current connection
* Return Value: true
* Author: A Averbukh<anatoliya@netscape.com> 
*/
function setConnectionInfo (connectionName, aClient, screenName)
{
    var curSession;
    if (connectionName =="AIM")
        curSession = 0;
    else // ICQ
        curSession = 2;

    	

    manPref = aimPrefsManager();
            
    var Host           = manPref.GetCharPrefEdit ("aim.session.host",           null, 2, "", curSession);
    var Port           = manPref.GetIntPrefEdit  ("aim.session.port",           null, 2, "", curSession);
    var ProxyHost      = manPref.GetCharPrefEdit ("aim.session.proxyhost",      null, 2, "", curSession);
    var ProxyPort      = manPref.GetIntPrefEdit  ("aim.session.proxyport",      null, 2, "", curSession);
    var ProxyUser      = manPref.GetWCharPrefEdit("aim.session.proxyuser",      null, 2, "", curSession);
    var ProxyPassword  = manPref.GetWCharPrefEdit("aim.session.proxypassword",  null, 2, "", curSession);
    var ProxyProtocol  = manPref.GetIntPrefEdit  ("aim.session.proxyprotocol",  null, 2, "", curSession);
    var useProxy       = manPref.GetBoolPrefEdit ("aim.session.isproxy",        null, 2, "", curSession);
    var ConnectionType = manPref.GetIntPrefEdit  ("aim.session.connectiontype", null, 2, "", curSession);                                                

dump("Host=" + Host + " Port=" + Port + " ProxyHost=" + ProxyHost + " ProxyPort=" + ProxyPort + "\n");
dump("ProxyUser=" + ProxyUser + " ProxyPassword=" + ProxyPassword + " ProxyProtocol=" + ProxyProtocol + "\n");
dump("useProxy=" + useProxy + " ConnectionType=" + ConnectionType + "\n");


        if (aClient == "im") { // internal session

        manPref.SetIntPrefEdit  ("aim.internal.intsessiontype",  curSession,    
                                     null, 1, "", -1);
        manPref.SetWCharPrefEdit("aim.internal.intname",         connectionName, 
                                     null, 1, "", -1);
        manPref.SetCharPrefEdit("aim.internal.inthost",             Host,           
                                     null, 1, "", -1);
        manPref.SetIntPrefEdit  ("aim.internal.intport",            Port,           
                                     null, 1, "", -1);
        manPref.SetCharPrefEdit("aim.internal.intproxyhost",        ProxyHost,      
                                     null, 1, "", -1);
        manPref.SetIntPrefEdit  ("aim.internal.intproxyport",       ProxyPort,      
                                     null, 1, "", -1);
        manPref.SetWCharPrefEdit("aim.internal.intproxyuser",       ProxyUser,      
                                     null, 1, "", -1);
        manPref.SetWCharPrefEdit("aim.internal.intproxypassword",   ProxyPassword,  
                                     null, 1, "", -1);
        manPref.SetIntPrefEdit  ("aim.internal.intproxyprotocol",   ProxyProtocol,  
                                     null, 1, "", -1);
            manPref.SetBoolPrefEdit ("aim.internal.intisproxy",      useProxy,                 
                                     null, 1, "", -1);
        manPref.SetIntPrefEdit  ("aim.internal.intconnectiontype",  ConnectionType,                 
                                     null, 1, "", -1);                                           
        }
        else { //external session

        manPref.SetIntPrefEdit  ("aim.internal.extsessiontype",  curSession,    
                                     null, 1, "", -1);
        manPref.SetWCharPrefEdit("aim.internal.extname",         connectionName, 
                                     null, 1, "", -1);
        manPref.SetCharPrefEdit("aim.internal.exthost",           Host,           
                                     null, 1, "", -1);
        manPref.SetIntPrefEdit  ("aim.internal.extport",          Port,           
                                     null, 1, "", -1);
        manPref.SetCharPrefEdit("aim.internal.extproxyhost",      ProxyHost,      
                                     null, 1, "", -1);
        manPref.SetIntPrefEdit  ("aim.internal.extproxyport",     ProxyPort,      
                                     null, 1, "", -1);
        manPref.SetWCharPrefEdit("aim.internal.extproxyuser",     ProxyUser,      
                                     null, 1, "", -1);
        manPref.SetWCharPrefEdit("aim.internal.extproxypassword", ProxyPassword,  
                                     null, 1, "", -1);
        manPref.SetIntPrefEdit  ("aim.internal.extproxyprotocol", ProxyProtocol,  
                                     null, 1, "", -1);
            manPref.SetBoolPrefEdit ("aim.internal.extisproxy",      useProxy,   
                                     null, 1, "", -1);  
        manPref.SetIntPrefEdit  ("aim.internal.extconnectiontype", ConnectionType,   
                                     null, 1, "", -1);  
        }

        return true;

    }


/*
 * Function: GetPanelSessionType 
 * Arguments: 
 * Return: the url of the file
 * Description: returns current pref panel type
 * The function is used for preferences
 * Author: A Averbukh<anatoliya@netscape.com> 
*/

function GetPanelSessionType()
{

    if (document.documentElement.getAttribute("isIcqPanel") == "true")
        return 2;
    else//AIM
        return 0;

}

/*
 * Function: CopynGetUrl (def_name, chg_name)
 * Arguments: 
 *    def_name  --  default file that needs to be copied in the case of new profile  
 *    chg_name  --  the name of the file which will be appended to screen name and stores the data.
 * Return: the url of the file
 * Description: The same one as GetRdfFileUrl, except: it copies file to user's profile without adding SN to the file name
 * The function is used for connection settings
*/
function CopynGetUrl (def_name, chg_name) 
{
	var directoryService  =  Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);
	
	var userProfile = directoryService.get("ProfD", Components.interfaces.nsIFile);
	var defaultProfile = directoryService.get("profDef", Components.interfaces.nsIFile);
	if (!defaultProfile.exists())                                   
		defaultProfile = directoryService.get("ProfDefNoLoc", Components.interfaces.nsIFile); 


	var defaultConnections = defaultProfile.clone();                         
	defaultConnections.append(def_name);                                 

	var UserConnections = userProfile.clone();
	UserConnections.append(chg_name); 
	
    if (!UserConnections.exists()) 
	{ 
	  try 
	  {
		defaultConnections.copyTo(userProfile, chg_name);     
	  }
	  catch (e) 
	  {

		return null;
	  }
			          
	  UserConnections = userProfile.clone();                           
      UserConnections.append(chg_name);   

    }  

    return aimFileProtocolHandler().getURLSpecFromFile(UserConnections);
}

/*
 * Function: isIcq
 * Arguments: 
 * Return: boolean
 * Description: returns true is it is icq session, false if not
  * Author: Prassanna<prass@netscape.com> 
*/
function isIcq()
{
  var SessionType=getCurrentSessionType();
  if (SessionType == "ICQ")
  {
    return true;
   }
   return false;
}

/*
 * Function: getCurrentSessionType
 * Arguments: 
 * Return: Value of sessionType
 * Description: If cached sessionType value exists, return that value, else obtain sessionType from prefs.
 * This will be used in most windows where the user is logged in and is attached to one session and is safe to 
 * look at cached value.
 * Author: Prassanna<prass@netscape.com> 
*/
function getCurrentSessionType()
{
 try {
	  // if(CachedSessionType == null)
            CachedSessionType = aimPrefsManager().GetCharPref("aim.session.userconnectionname", null, true);
  } catch (e) {}; 
  return CachedSessionType;
 }
 
function setCurrentSessionType(conval)
{
   CachedSessionType=conval;
   aimPrefsManager().SetCharPref("aim.session.userconnectionname", conval, null, true);
}

/*
 * Function: getSessionType
 * Arguments: 
 * Return: Value of sessionType
 * Description: Obtain the sessionType from prefs everytime. Differnt from the above where a cahced value is used.
 * This will be used in sidebarpanel and app windows where user could change it before loggin in.
 * Author: Prassanna<prass@netscape.com> 
*/

function getSessionType() {
  return(aimPrefsManager().GetSessionType());
}

/*
 * Function: IsServiceCorrect (curSN, curConnName)
 * Arguments: 
 *    curSN        --  cureent SN
 *    curConnName  --  cureent connection name
 * Return: true/false 
 * Description: Check, if curSN can be used to sign on to service curConnName
 * Author: Anatoliy Averbukh<anatoliya@netscape.com> 
*/
function IsServiceCorrect (curSN, curConnName)
{
   var curTypeperSN = aimPrefsManager().GetSessionTypeEdit (curSN);

   var nCurConn;

   if (curConnName =="AIM") {
      nCurConn = 0;
   }
   else if (curConnName =="ICQ"){
      nCurConn = 2;
   }
   else {
      return false;
   }

   if (nCurConn == curTypeperSN) {
       return true;
   }
   else {
       if (curConnName =="AIM")
        aimErrorBox(aimString("msg.wrongsrv").replace(/%ScreenName%/, '"' + curSN + '"'));
       else
        aimErrorBox(aimString("msgICQ.wrongsrv").replace(/%ScreenName%/, '"' + curSN + '"'));

        return false;
   }

      

}



/*
 * Function:  openRegisterLink(sessionID)
 *
 * Arguments: sessionID
 * Possible values: sessionWatcher (inside sidebar), sessionAppWatcher (from menu)
 *
 * Return: None
 *
 * Description: This function is called when the register link in sigon overlay is invoked. It opens 
 * registration url for icq if session is icq. If session is Aim, it opens the regitration wizard.
 * Note: this is a clone of the function openRegisterLink() in SidebarPanel.js except this getting a  
 * app-level session element
 *
 * Author: Prassanna 4/06/2002
 */

function openRegisterLink(sessionID)
{
 if(sessionID != null  && sessionID  !=""){
 
  var checkSession=window.document.getElementById(sessionID).getAttribute('sessionMode'); 
  if (checkSession == "Aim")
    {
      aimGlobalCmdStartupWizard();
      return;
    }
  else
    {
      regLink = aimRegionString("icq.register.url");
      openTopWin(regLink);  
      return;
    }
 } 
}

/*
 * Function:  cmdIcqSearch()
 *
 * Arguments: None
 * Return: None
 *
 * Description: This function is used as a workaround to go to a web page and do user search since we do not support
 * server side search for Machv.
 *
 * Author: Prassanna 4/29/2002
 */


function cmdIcqSearch()
{
   var url=aimRegionString("icq.search.url");
   if (window.opener) {
       // From add buddy modal dialog
       window.opener.openDialog("chrome://navigator/content/navigator.xul", "_blank","modal=no,chrome,all,dialog=no", url);
       return;
       //Since we have a modal window opening some other window (yuk!), this opener stuff is there
      // Clean this up post-Machv when real icq search is supported
   }
   openDialog("chrome://navigator/content/navigator.xul", "_blank","modal=no,chrome,all,dialog=no", url);
}

/*
 * Function: openPrefWindow
 * Arguments: none
 * Return: none
 * Description: opens the pref window based on session type.
 * Author: Suresh <suresh@netscape.com> 
*/
function openPrefWindow()
{
  if (isIcq())
    goPreferences('instantmessenger', 'chrome://aim/content/pref-Icq_icq.xul','icq');
  else
    goPreferences('instantmessenger', 'chrome://aim/content/pref-IM_instantmessage.xul','instantmessenger');
}


/*
 * Function: cachedUserConnection
 * Arguments: None
 * Return: connection name
 * Description: returns AIM or ICQ
  * Author: Prassanna<prass@netscape.com> 
*/
function cachedUserConnection()
{
  try {
	  if(CachedUserConnection== null)
            CachedUserConnection= aimPrefsManager().GetCharPref("aim.session.userconnectionname", null, true);
  } catch (e) {}; 
  return CachedUserConnection;
}
      
function getSelectedDisplayName()
{
  var tree = getSelectedTreeName();
  var col = getSelectedTabName();
  if (!tree || !col) return;
  var displayName = null;
  var currentIndex = tree.currentIndex;
  if (currentIndex > 0) {
    var isContainer = tree.treeBoxObject.view.isContainer(currentIndex);
    //if it is a container (groups or Offline group) return null
    if (!isContainer) {
      var buddyResource = GetBuddyResource(tree, currentIndex);
      var displayName = GetBuddyAttribute(tree, buddyResource, "Name");
    }
  }
  return displayName;
}

/* Selects the given index in the buddy list */
function SelectIndex(index)
{
  if (aimSession().IsOnline()) {
    var tree = getSelectedTreeName();
    var treeselection = tree.treeBoxObject.selection;
    treeselection.select(index);
  }
}

function openMailCompose(emailaddresses)
{
  var msgComposeType = Components.interfaces.nsIMsgCompType;
  var msgComposFormat = Components.interfaces.nsIMsgCompFormat;
  var msgComposeService = Components.classes["@mozilla.org/messengercompose;1"].getService();
  msgComposeService = msgComposeService.QueryInterface(Components.interfaces.nsIMsgComposeService);

  var params = Components.classes["@mozilla.org/messengercompose/composeparams;1"].createInstance(Components.interfaces.nsIMsgComposeParams);
  if (params)
  {
    params.type = msgComposeType.New;
    params.format = msgComposFormat.Default;
    var composeFields = Components.classes["@mozilla.org/messengercompose/composefields;1"].createInstance(Components.interfaces.nsIMsgCompFields);
    if (composeFields)
    {
      composeFields.to = emailaddresses;
      params.composeFields = composeFields;
      msgComposeService.OpenComposeWindowWithParams(null, params);
    }
  }
}

function sendfile(screenName) {
  inviteArgsObj = {
    inviteProposalScreenName: screenName,
    inviteProposalObj: null,
    inviteToExistingWindow: false,
    inviteMode: 'outgoingfile'
  }
  window.openDialog('chrome://aim/content/sendfile.xul','_blank','chrome,all,dialog=no',inviteArgsObj);
}


/*
 * Function: isValidChar
 * Arguments: string
 * Return: boolean
 * Description: Checks for invalid characters for buddynames. Except for alphanumeric chars, digits, 
 * comma, colon, underscore and forward slash, other special chars are invalid.
 * Author: Prassanna<prass@netscape.com> 
*/

function IsValidChar(cp)
{
  var c;
  var j;
  for (j=0; j < cp.length; j++)
  {
    c= cp.charCodeAt(j);
    if ( ((c > 32) &&  (c < 44)) || ((c > 57) &&  (c < 64)) || ((c > 90) &&  (c < 95)) || (c == 96) || c > 122 )
      return false;
  }  
  return true;
}


function IsValidLength(screenName)
{
  var nLen;
  if ((!screenName) || (screenName == null) || (screenName == ''))
  {
    return false;
  }
  nLen = screenName.length;
  if (nLen > 16 || nLen < 3) {
    return false;
  }
  return true;
}

function getPreaknessFlag()
{
  var myaimSession = aimSession();
  if (myaimSession) {
    return myaimSession.preaknessFlag;
  }
  else
    return false;
}

function IsIcqServiceUser(buddy)
{
  var isAllDigits = false;
  var cp = new String(buddy);
  if ((cp.charCodeAt(0) > 47) && (cp.charCodeAt(0) < 58))
  // Begins with a number - so icq
    isAllDigits=true;
  return isAllDigits;
}
