#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "fft.h"
#include "misc.h"

/* ---------------------------------------------------------------------- */

#define	FLAGS	(FFTW_ESTIMATE | FFTW_OUT_OF_PLACE | FFTW_USE_WISDOM)

struct fft *fft_init(int len, int dir)
{
	struct fft *s;

	if ((s = calloc(1, sizeof(struct fft))) == NULL)
		return NULL;

	s->plan = fftw_create_plan(len, dir, FLAGS);

	if (!s->plan) {
		fft_free(s);
		return NULL;
	}

	return s;
}

void fft_free(struct fft *s)
{
	if (s) {
		fftw_destroy_plan(s->plan);
		free(s);
	}
}

void fft_run(struct fft *s, complex *in, complex *out)
{
	fftw_one(s->plan, in, out);
}

/* ---------------------------------------------------------------------- */

