/* 
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY
*/
/* Routines for talking to the Gantt chart display */
/* @(#)ganttChart.c	1.2 11/25/92 */

#include <setjmp.h>
#include "local.h"
#include "err.h"
#include "vemInterface.h"

static jmp_buf env;

boolean
displayGanttChart(fileName)
char* fileName;
{
	extern char* xDisplay;
	if (setjmp(env)) {
		return (FALSE);
	} else {
		display_schedule(xDisplay, 1, fileName, "");
		return (TRUE);
	}
}

/* 8/12/89
Save the error message for GGI and exit from display_schedule().
*/
void
GanttErr(msg)
char *msg;
{
    ErrAdd("Internal error in Gantt chart display\n");
    ErrAdd(msg);
    PrintErr(ErrGet());
    longjmp(env, 1);
}

int
GanttMan(name)			/* ARGSUSED */
char *name;
{
    win_msg("Gantt chart help not yet implemented\nFor more information, see the file ~ptolemy/lib/gantt.help");
    return 0;
}
