/**************************************************************************
Version identification:
@(#)utils.c	2.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)utils.c	2.2	11/25/92";
#endif /* not lint */

#include "displaysched.h"
#include <stdio.h>

extern char *malloc();
extern int no_procs;
int max_end_time=0;
extern struct processor *proc_table;

void print_stars(file)
char *file;
/*
 * Print stars and summary statistics to file "file".
 * If "file" is null, print output to stdout.
 *
 */
{
    register int i, j, len;
    register struct star *star;
    register FILE *out = (strlen(file)==0) ? stdout :
	fopen(file,"w");
    extern int runtime, max_end_time, min;
    extern double percentage, optimum;

    if (out==NULL) err("displaysched: could not open output file");

    (void)fprintf(out,"\n\n\n");

    /* print out the schedule */

    for (i=0; i<no_procs; i++) {
	(void)fprintf(out,"\nschedule for processor %d:\n",i);
	len = proc_table[i].length;
	for (j=0; j<len; j++) {
	    star = &(proc_table[i].star_table[j]);
	    (void)fprintf(out,"   %s", star->name);
	    if (star->instance!=NULL)
		(void)fprintf(out,"%s", star->instance);
	    (void)fprintf(out," over time (%d,%d)\n",
			  star->start, star->stop);
	}
	(void)fprintf(out,"\n\n");
    } /*for*/

    /* print out summary information */

    (void)fprintf(out,"\n\n\n");
    (void)fprintf(out,"The period of the schedule is %d, ", max_end_time);
    (void)fprintf(out,"compared to the minimum %d\n", min);
    (void)fprintf(out,"\nThe percentage of available computation used is %f",
		  percentage);
    (void)fprintf(out,"\n   compared to the optimum %f\n", optimum);
    (void)fprintf(out,"\nThe total runtime is %d\n", runtime);


    (void)fprintf(out,"\n\n\n");

    /* close the output file */

    if (out!=stdout) (void)fclose(out);

} /*print_stars*/







/*
 *
 * alloc_node
 *
 * This function allocates a node for a star and fills the
 * fields of the new star with the parameters passed.
 * only if GABRIEL is controlling display_schedule ; otherwise
 * it is ignored.
 *
 */

/*ARGSUSED*/  /* ind is not used if independent version is being compiled */
struct starnode *alloc_node(name, inst, start, stop)
     char *name, *inst;
     int start, stop;
{
    struct starnode *newnode =
	(struct starnode *)(malloc(sizeof(struct starnode)));
    if (newnode==NULL) err("displaysched: Out of memory\n");
    newnode->next = NULL;
    newnode->data.start = start;
    newnode->data.name_length = strlen(name);
    newnode->data.stop = stop;
    newnode->data.name = name;
    newnode->data.instance = inst;
    return(newnode);
}  /* alloc_node */






extern char *nops;

void free_proc_list()
     /* free the list of processors */
{
    register int i, j;

    if (proc_table!=NULL) {
	for (i=0; i<no_procs; i++)  {
	    /* first free all the star names */
	    for (j=0; j< proc_table[i].length - 1; j++) {
		char* nm = proc_table[i].star_table[j].name;
		/* avoid freeing the common "nops" string */
		if (nm != nops) (void) free(nm);
	    }

	    /* free the star table */
	    (void)free((char*)proc_table[i].star_table);

	}

	/* free the processor table */
	(void)free((char*)proc_table);
    }
} /*free_proc_list*/





