/**************************************************************************
Version identification:
@(#)resize.c	2.3	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)resize.c	2.3	11/25/92";
#endif /* not lint */

#include "displaysched.h"
#include <stdio.h>
#include <math.h>

extern int no_procs_dis;
extern int no_procs;
extern int window_time;
extern int top_proc;
extern int start;
extern int cntrlW_width, cntrlW_height, w_width, w_height;
extern Window markerW, cntrlW;
extern int max_end_time;
extern XEvent event;
extern void update_box_height(), draw_gantt_chart();
extern Window AwaitInput();
extern int depth, screen;
extern Display *display;
extern GC gc_grid;

int left_fixed;  /* 1=> x coord of left edge is fixed during resize, else -1*/
int top_fixed;   /* 1=> y coord of top  edge is fixed during resize, else -1*/
int box_ht;      /* height in pixels of each box in the Gantt chart */
int pix_per_time_unit;   /* width in pixels of a time unit in the Gantt chart */

/* the total space at the bottom of the Gantt chart which is not to be used
   for displaying the Gantt chart itself : */
int bottom_margin = BOTTOM_SPACING + STAT_STR_SPACING + PROMPT_STR_SPACING;

/* the coordinates of the corner of the window that
   remains fixed during the resize operation */
int fix_x, fix_y;

XWindowAttributes markerW_info;







int ConfigDispWin(x, y, w, h)
     register int x, y, *w, *h;
     /* Reset parameters of display window for new dimensions/location
	of marker winow.
	(mx,my) = new marker coords relative to disp cntrl window
	(mw,mh) = width and height of marker window

	If the display window is not large enough to handle the desired
	reconfiguration, return 0 and don't do it,
	otherwise reset the parameters appropriately and return 1.

	(x,y) are coords of new marker relative to control window
	(w,h) are pointers to the proposed new width and height.
	if the width/height given are unnacceptable, the
	closest allowable values are used, and these values are
	returned in (*w)/(*h).

	Return 0 if the (w,h) given were used,
	1 if w needed to be modified
	2 if h needed to be modified
	3 if both needed to be modified.
	*/


{
    int modified = 0;
    int temp;


    temp = MAX(((*w) * max_end_time) / cntrlW_width,1);
    pix_per_time_unit = (w_width-2*X_MARGIN)/temp;
    if (pix_per_time_unit<MIN_PIX) {
	pix_per_time_unit = MIN_PIX;
	window_time = (w_width-2*X_MARGIN)/MIN_PIX;
	(*w) = (window_time * cntrlW_width)/max_end_time;
	if ((*w) < MIN_MARKER_WIDTH)
	    err("displaysched: duration of schedule is too long for given control window size");
	modified = 1;
    }
    else window_time = (w_width-2*X_MARGIN)/pix_per_time_unit;


    ASSIGN(no_procs_dis, (no_procs * (*h)) / cntrlW_height + 1,
	   1, no_procs);
    box_ht = MIN((w_height-AXIS_HT-bottom_margin) /
		 no_procs_dis,MAX_BOX_HT);
    if (box_ht<MIN_BOX_HT) {
	box_ht = MIN_BOX_HT;
	ASSIGN(no_procs_dis,
	       (w_height-AXIS_HT-bottom_margin)/box_ht, 1, no_procs);
	(*h) = no_procs_dis * cntrlW_height / no_procs;
	if ((*h) < MIN_MARKER_HEIGHT)
	    err("displaysched: too many processors for given control window size");
	modified += 2;
    }

    /* change the parameters of the display window */
    box_ht =  box_ht;
    update_box_height(box_ht); /* update vertex list for new height */


    top_proc = MIN((y * no_procs)/cntrlW_height,no_procs-no_procs_dis);


    ASSIGN(start,
	   nearest_int(((double)x * (double)max_end_time)
		     / (double)cntrlW_width),
	   0,
	   abs(max_end_time-window_time));

    return(modified);
}








int ConfigMarkerWin(x,y,w,h)
     /*
       move/reconfigure the marker window as specified by :
       (mx,my) -> top left of marker relative to disp cntrl window
       (mw,mh) -> dimensions (width & height) of marker

       also modify the parameters of the display window
       appropriately
       */
     int x, y, w, h;
{
    int new_x, new_y;
    XWindowChanges changes;

    (void)(ConfigDispWin(x, y, &w, &h));
    new_x = (left_fixed==1) ?  fix_x : fix_x - w + 1;
    new_y = (top_fixed==1) ?  fix_y : fix_y - h + 1;
    if ((left_fixed==1) && (top_fixed==1)) {
	XResizeWindow(display,markerW,w,h);
    }
    else {
	changes.x = new_x;
	changes.y = new_y;
	changes.width=w;
	changes.height=h;
	XConfigureWindow(display, markerW, CWX|CWY|CWWidth|CWHeight,
			 &changes);
    } /*else*/
    draw_gantt_chart(start, top_proc);
    return(1);
}

/*
 * resize_marker
 *
 * This function changes the size of the shaded area inside the
 * display control window. The argument is the button (either
 * LeftButton or RightButton) which was pressed by the user to
 * cause this function to be invoked.
 *
 */

void resize_marker(button)
     int button ;
{

    /* mouse position relative to top left of display control
       window used to track the mouse and determine x & y deltas: */

    int new_x, new_y;
    int old_x, old_y;
    int old_width, old_height;

    int x3rd, y3rd; /* 0,1, or 2 depending on which third of
		       the window the mouse is in horizontally
		       and vertically */
    /* x and y coordinates of mouse relative to the
       display control window */
    int mx = (int)(((XButtonEvent*)(&event))->x);
    int my = (int)(((XButtonEvent*)(&event))->y);
    /* if user moves cursor to the right D pixels, the window
       increases in width by (D*xmult) pixels */
    int xmult;
    /* if user moves cursor down D pixels, the window
       increases in height by (D*ymult) pixels */
    int ymult;
    /* xmult & ymult are either 0,1 or -1 */

    int var_x, var_y;
    int height, width;   /* current dimensions of marker */
    int done = 0;
    Window root, child;
    int root_x, root_y;
    unsigned int keys_buttons;
    unsigned long button_motion_mask;
    Window win;







    if (XGetWindowAttributes(display, markerW, &markerW_info)==0)
	err("displaysched: couldn't query window");



    if (button==Button1) button_motion_mask = Button1MotionMask;
    else if (button==Button3) button_motion_mask = Button3MotionMask;
    else err("displaysched : bad button parameter passed to resize_marker");

    /* if mouse is on left half of window ->
     *   fix the right x coord & make the width vary inversely
     *   with mouse movement.
     * if mouse is on right half of window ->
     *   fix the left x coord & make the width vary directly
     *   with mouse movement.
     * if mouse is on top half of window ->
     *   fix the bottom y coord & make the height vary inversely
     *   with mouse movement.
     * if mouse is on bottom half of window ->
     *   fix the top y coord & make the width vary directly
     *   with mouse movement.
     */

    if (mx < (markerW_info.width/2)) {
	xmult = -1;
	fix_x = markerW_info.x+markerW_info.width;
	var_x = markerW_info.x;
	left_fixed = -1;
    }
    else {
	xmult = 1;
	fix_x = markerW_info.x;
	var_x = markerW_info.x+markerW_info.width;
	left_fixed = 1;
    }
    if (my < (markerW_info.height/2)) {
	ymult = -1;
	fix_y = markerW_info.y+markerW_info.height;
	var_y = markerW_info.y;
	top_fixed = -1;
    }
    else {
	ymult = 1;
	fix_y = markerW_info.y;
	var_y = markerW_info.y+markerW_info.height;
	top_fixed = 1;
    }


    /* A : mouse is in the center 3rd of the window horizontally,
       B : mouse is in the center 3rd vertically

       if A occurs & B does not => don't make any change in width
       if B occurs & A does not => don't make any change in height
       if both or none occur => make changes in height & width */

    x3rd = (mx * 3) / markerW_info.width;
    y3rd = (my * 3) / markerW_info.height;
    if ((x3rd+y3rd)&1) {
	if (x3rd & 1)
	    xmult = 0;
	else
	    ymult = 0;
    }

    old_x = mx + markerW_info.x;
    old_y = my + markerW_info.y;
    old_width = markerW_info.width;
    old_height = markerW_info.height;
    DrawGrid(fix_x,fix_y,var_x,var_y);   /* draw initial grid */


    while (!done) {
	while (1) {
	    win=AwaitInput(PointerMotionMask|LeaveWindowMask|
			   ButtonReleaseMask);
	    if (win==cntrlW) break;
	    else if (win==markerW) break;
	}
	switch (event.type) {
	case ButtonRelease:
	    /* if a button other than the correct button was released during
	       resizing, ignore that event */
	    if ((((XButtonEvent*)(&event))->button) != button)
		continue;
	    new_x = ((XButtonEvent*)(&event))->x + markerW_info.x;
	    new_y = ((XButtonEvent*)(&event))->y + markerW_info.y;
	    done = 1;
	    break;

	case LeaveNotify:
	    new_x = ((XLeaveWindowEvent*)(&event))->x;
	    new_y = ((XLeaveWindowEvent*)(&event))->y;
	    done = 1;
	    break;

	case MotionNotify:
	    while (XCheckMaskEvent(display, button_motion_mask, &event));
	    if (!XQueryPointer(display, cntrlW, &root, &child, &root_x,
			       &root_y, &new_x, &new_y, &keys_buttons));
	} /*switch*/

	DrawGrid(fix_x,fix_y,var_x,var_y);  /* erase old grid */
	ASSIGN(new_x, new_x, 0, cntrlW_width);
	ASSIGN(new_y, new_y, 0, cntrlW_height);
	width =
	    MAX(old_width + (new_x - old_x) * xmult, MIN_MARKER_WIDTH);
	height =
	    MAX(old_height + (new_y - old_y) * ymult, MIN_MARKER_HEIGHT);
	ASSIGN(var_x, fix_x+width*left_fixed, 0, cntrlW_width);
	ASSIGN(var_y, fix_y+height*top_fixed, 0, cntrlW_height);
	if (done)
	    (void)ConfigMarkerWin(MIN(fix_x, var_x), MIN(fix_y, var_y),
				  abs(fix_x-var_x)+1, abs(fix_y-var_y)+1);
	else {
	    DrawGrid(fix_x,fix_y,var_x,var_y);  /* draw new grid */
	}

    } /* while */
    while (XCheckMaskEvent(display, ALL_EVENTS, &event));
}
