/**************************************************************************
Version identification:
@(#)gantt_main.c	2.3	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/

#ifndef lint
static char sccsid[] = "@(#)gantt_main.c	2.3 11/25/92";
#endif /* not lint */

#include <stdio.h>
#ifdef USG
int sprintf();
#else
char *sprintf();
#endif
#include <string.h>
#include "displaysched.h"
#include "highlight.h"

/* main "C" file for Gantt chart display program */
/* this display routine uses three windows: a display window
   where the Gantt chart is displayed; a time marker window,
   which gets slided up and down to change the interval covered
   by the Gantt chart; and a time window which encloses the
   marker window, and represents the entire duration of the
   schedule
*/


Window w=NULL;   /* main display window */
Window cntrlW=NULL;  /* window in which the segment of the chart to be
	       displayed is selected */
Window markerW;  /* marker window inside time window */

extern int simplebar;

/* the following variable is the pixmap for storing
 * the region underneath a bar dur non-"simple" bar
 * drawing mode (see SIMPLEBAR in displaysched.h)
 */

#if (!SIMPLEBAR)
Pixmap w_pixmap;
#endif

#if CONSOLE
Window consoleW=NULL;   /* window for prompting user */
#endif
XEvent event;  /* buffer for receiving information about events */
XWindowAttributes dispWinfo;  /* information about display window */
XWindowAttributes cntrlWinfo;  /* information about display window */
XSetWindowAttributes attributes;
int start=0;    /* time corresponding to the left edge of the current chart */
int top_proc=0;   /* processor corresponding to the top edge of current chart */
GC console_gc, w_gc_axis, w_label_gc,
   w_gc_box, w_gc_prompt, w_gc_stat, w_gc_100plus,
   gc_grid;

int PIGI_GABRIEL_RPC;
unsigned long InputMask = ButtonPressMask | KeyPressMask;
XGCValues w_gc_bar_values,
          gc_grid_values;

unsigned long console_brdr_color;
unsigned long console_bgnd_color;
unsigned long display_fgnd;
unsigned long display_bgnd;
unsigned long w_brdr_color;
unsigned long w_bgnd_color;
unsigned long cntrlw_brdr_color;
unsigned long cntrlw_bgnd_color;

Colormap cmap;

XWindowAttributes control_inf;
XSizeHints  console_hints,
            w_hints,
            cntrlw_hints;

#define BUFLEN 256
char msgbuf[BUFLEN];

XFontStruct *console_fontinfo=NULL,
            *w_stat_fontinfo=NULL,
            *w_100plus_fontinfo=NULL,
            *w_prompt_fontinfo=NULL;

extern XFontStruct *w_box_fontinfo,
                   *w_axis_fontinfo;
extern Pixmap w_pixmap;
extern GC pixmap_gc;

XColor colorcell_def;
XColor rgb_db_def;
int box_font_height;

extern int w_width, w_height, cntrlW_width, cntrlW_height;
extern int  handler(), IOErrorHandler();
extern void draw_gantt_chart(), initialize_drawing(), print_stars();
extern int ConfigDispWin();
extern void resize_marker(), free_proc_list(), move_bar_to_mouse();
extern int ConfigDispWin();
extern int bar_x;
extern Display *display;
extern int screen;
extern int depth;   /* number of bits representing a pixel (1=>monochrome) */
extern GC w_gc_bar;
extern Window AwaitInput();

/*
 AllocatePixelValue

 Allocate & return the pixel value specified by "color_name" if the
 display is a color display, otherwise return "bw" (either
 BlackPixel or WhitePixel).
*/
unsigned long AllocatePixelValue(color_name,bw)
char *color_name;
unsigned long bw;
{
    if (depth==1) return (bw);
    else {
#if DEBUG
	printf("debug: allocating color {%s}\n", color_name);
#endif
	if (!XAllocNamedColor(display, cmap, color_name,
			      &colorcell_def, &rgb_db_def)) {
	    sprintf(msgbuf,"color {%s} not available\n",
			color_name);
	    err(msgbuf);
	    /*NOTREACHED*/
	}
	else return(colorcell_def.pixel);
    }
}



Window
gantt_create_window(x, y, w, h, minw, minh, hints, brdr, bgnd, bw, name)
     int x, y;
     unsigned int w, h;
     int minw, minh;
     int bw;
     unsigned long brdr, bgnd;
     XSizeHints *hints;
     char *name;

{
    Window win;

  /* Create the window */
  if ((win=XCreateSimpleWindow(display, RootWindow(display, screen),
			       x, y, w, h, bw,
			       brdr, bgnd)) == NULL)

      err("\nCould not create window\n");


    hints->flags = PSize | PMinSize | PPosition;
    hints->width = w;
    hints->height = h;
    hints->min_width = minw;
    hints->min_height = minh;
    hints->x = x;
    hints->y = y;

    XSetStandardProperties(display, win, name, name,
			   NULL, NULL, 0, hints);

    return(win);

}


Font get_font(fname, fstruct)
char *fname;
XFontStruct **fstruct;
{
    (*fstruct) =  XLoadQueryFont(display, fname);
    if ((*fstruct)==NULL) {
	sprintf(msgbuf,"\nCould not load font %s\n", fname);
	err(msgbuf);
    }
    return((*fstruct)->fid);
}



void create_windows()
/*
 * This procedure creates & maps all winows and takes care of
 * initialization for their use.
 *
 */
{

#if CONSOLE
    char *msg1 =  "Create the display window";
    char *msg2 =  "Create the display control window";
#endif
    int mw, mh;   /* initial width and height of marker window */

#if DEBUG
    printf("debug: depth = %d\n",depth);
#endif

    /* Invoke X error handlers */

    XSetErrorHandler(handler);
    XSetIOErrorHandler(IOErrorHandler);

    /* obtain necessary colors */
    console_brdr_color = AllocatePixelValue(CONSOLEW_BRDR,
					    BlackPixel(display, screen));
    console_bgnd_color = AllocatePixelValue(CONSOLEW_BGND,
					    WhitePixel(display, screen));
    w_brdr_color = AllocatePixelValue(DISPW_BRDR,
				      BlackPixel(display, screen));
    w_bgnd_color = AllocatePixelValue(DISPW_BGND,
				      WhitePixel(display, screen));
    cntrlw_brdr_color = AllocatePixelValue(CNTRLW_BRDR,
					   BlackPixel(display, screen));
    cntrlw_bgnd_color = AllocatePixelValue(CNTRLW_BGND,
					   WhitePixel(display, screen));

    /* create the console window */

#if CONSOLE
    consoleW = gantt_create_window(CONSOLEW_X, CONSOLEW_Y,
				   CONSOLEW_W, CONSOLEW_H,
				   MIN_CONSOLEW_W, MIN_CONSOLEW_H,
				   &console_hints,
				   console_brdr_color,
				   console_bgnd_color,
				   CONSOLEW_BW,
				   "Gantt_console");

    /* set up graphics context for console window */
    console_gc = XCreateGC(display, RootWindow(display, screen),
			   (unsigned long)0, (XGCValues*)NULL);
    XSetForeground(display, console_gc,
		   AllocatePixelValue(CONSOLEW_FGND, BlackPixel(display, screen)));
    XSetBackground(display, console_gc,
		   AllocatePixelValue(CONSOLEW_BGND, WhitePixel(display, screen)));
    XSetFont(display, console_gc, get_font(CONSOLEW_FONT, &console_fontinfo));
#endif

    simplebar = (SIMPLEBAR || (depth <= 1));
    if (simplebar) {
	w_gc_bar_values.function = GXxor;
	w_gc_bar_values.foreground = BlackPixel(display, screen);
	w_gc_bar_values.background = BlackPixel(display, screen);
    }
    else {
	w_gc_bar_values.function = GXcopy;
	w_gc_bar_values.foreground = WhitePixel(display, screen);
	w_gc_bar_values.background = WhitePixel(display, screen);
	if ((pixmap_gc = XCreateGC(display, RootWindow(display, screen),
				   (unsigned long)0, (XGCValues*)NULL)) == NULL)
	    err("\nCould not create the graphics context\n");
	XSetFunction(display, pixmap_gc, GXcopy);
	XSetPlaneMask(display, pixmap_gc, AllPlanes);
    }




    w_gc_bar = XCreateGC(display, RootWindow(display, screen),
			 (unsigned long)(GCFunction|GCForeground|
					 GCBackground),
			 &w_gc_bar_values);

    gc_grid_values.function = GXxor;
    gc_grid_values.foreground = BlackPixel(display, screen);
    gc_grid_values.background = BlackPixel(display, screen);
    gc_grid = XCreateGC(display, RootWindow(display, screen),
			(unsigned long)(GCFunction|GCForeground|
					GCBackground),
			&gc_grid_values);
    XSetSubwindowMode(display, gc_grid, IncludeInferiors);

#if CONSOLE
    XSelectInput(display, consoleW, ExposureMask);
    XMapWindow(display, consoleW);
    XMaskEvent(display, ExposureMask, &event);
    while (XCheckTypedEvent(display, Expose, &event));

  /* prompt for creating the display window */

    XDrawString(display, consoleW, console_gc, 0, 20, msg1,
		strlen(msg1));
    XFlush(display);
#endif

    /* create the display window */

    w = gantt_create_window(DISPW_X, DISPW_Y, DISPW_W, DISPW_H,
			    MIN_DISPW_W, MIN_DISPW_H,
			    &w_hints, w_brdr_color, w_bgnd_color,
			    DISPW_BW, "Gantt");

    /* set up graphics contexts for the display window */

    display_fgnd = AllocatePixelValue(DISPW_FGND, BlackPixel(display,screen));
    display_bgnd = AllocatePixelValue(DISPW_BGND, WhitePixel(display,screen));

    w_gc_axis = XCreateGC(display, RootWindow(display, screen),
			  (unsigned long)0,
			  (XGCValues*)NULL);
    XSetForeground(display, w_gc_axis, display_fgnd);
    XSetBackground(display, w_gc_axis, display_bgnd);
    XSetFont(display, w_gc_axis, get_font(AXIS_FONT, &w_axis_fontinfo));

    w_gc_100plus = XCreateGC(display, RootWindow(display, screen),
			     (unsigned long)0, (XGCValues*)NULL);
    XSetForeground(display, w_gc_100plus, display_fgnd);
    XSetBackground(display, w_gc_100plus, display_bgnd);
    XSetFont(display, w_gc_100plus, get_font(HUNDRED_PLUS_FONT, &w_100plus_fontinfo));

    w_gc_prompt = XCreateGC(display, RootWindow(display, screen),
			    (unsigned long)0, (XGCValues*)NULL);
    XSetForeground(display, w_gc_prompt, display_bgnd);
    XSetBackground(display, w_gc_prompt, display_fgnd);
    XSetFont(display, w_gc_prompt, get_font(PROMPT_FONT, &w_prompt_fontinfo));

    w_gc_stat = XCreateGC(display, RootWindow(display, screen),
			  (unsigned long)0, (XGCValues*)NULL);
    XSetForeground(display, w_gc_stat, display_fgnd);
    XSetBackground(display, w_gc_stat, display_bgnd);
    XSetFont(display, w_gc_stat, get_font(STAT_FONT, &w_stat_fontinfo));

    w_gc_box = XCreateGC(display, RootWindow(display, screen),
			 (unsigned long)0, (XGCValues*)NULL);
    if (depth==1) XSetForeground(display, w_gc_box, WhitePixel(display,screen));
    else  XSetForeground(display, w_gc_box, display_fgnd);
    XSetBackground(display, w_gc_box, display_bgnd);
    XSetFont(display, w_gc_box, get_font(BOX_FONT, &w_box_fontinfo));
    w_label_gc = XCreateGC(display, RootWindow(display, screen),
			   (unsigned long)0, (XGCValues*)NULL);
    if (depth==1) XSetForeground(display, w_label_gc, BlackPixel(display,screen));
    else  XSetForeground(display, w_label_gc, display_fgnd);
    XSetBackground(display, w_label_gc, display_bgnd);
    XSetFont(display, w_label_gc, get_font(BOX_FONT, &w_box_fontinfo));
    box_font_height = w_box_fontinfo->max_bounds.ascent +
	w_box_fontinfo->max_bounds.descent;
    XSelectInput(display, w, DISPLAY_EVENTS|PointerMotionHintMask);
    XMapWindow (display, w);
    XWindowEvent(display, w, ExposureMask, &event);
    while(XCheckTypedEvent(display,Expose,&event));
    XFlush(display);

    if (!simplebar)
	w_pixmap = XCreatePixmap(display, w,
				 DisplayWidth(display, screen),
				 DisplayHeight(display, screen),
				 depth);



    /* create the display control window */

#if CONSOLE
    XClearWindow(display, consoleW);
    XDrawString(display, consoleW, console_gc, 0, 20, msg2,
		strlen(msg2));
    XFlush(display);
#endif

    cntrlW = gantt_create_window(CNTRLW_X, CNTRLW_Y, CNTRLW_W, CNTRLW_H,
                                 MIN_CNTRLW_W, MIN_CNTRLW_H,
                                 &cntrlw_hints,
                                 cntrlw_brdr_color,
                                 cntrlw_bgnd_color,
                                 CNTRLW_BW,
                                 "Gantt");

    XSelectInput(display, cntrlW, CONTROL_EVENTS|PointerMotionHintMask);
    XMapWindow(display, cntrlW);
    XWindowEvent(display, cntrlW, ExposureMask, &event);
#if CONSOLE
    XDestroyWindow(display, consoleW);
    consoleW = NULL;
#endif
    XFlush(display);

    /* initialize size information about the display window & display
       control window */

    if (XGetWindowAttributes(display, w, &dispWinfo)==0)
	err("displaysched: couldn't query window\n");
    if (XGetWindowAttributes(display, cntrlW, &cntrlWinfo)==0)
	err("displaysched: couldn't query window\n");
    cntrlW_height = cntrlWinfo.height;
    cntrlW_width = cntrlWinfo.width;
    w_height = dispWinfo.height;
    w_width = dispWinfo.width;

    /* Configure the parameters of the display window (e.g box height, number of procs
       displayed, etc.). Try to show as much information as possible by setting the
       width and height of the marker window to be as large as possible. */

    mw = cntrlW_width;
    mh = cntrlW_height;
    (void)ConfigDispWin(0, 0, &mw, &mh);

    /* create the marker window */

    if ((markerW=XCreateSimpleWindow(display, cntrlW, 0, 0, (unsigned int)mw,
				     (unsigned int)mh, 0,
				     BlackPixel(display,screen),
				     BlackPixel(display,screen)))==NULL)
	err("displaysched: could not create marker window\n");

    XSelectInput(display, markerW, MARKER_EVENTS);
    XMapWindow(display, markerW);
    attributes.do_not_propagate_mask =  LeaveWindowMask;
    XWindowEvent(display, markerW, ExposureMask, &event);
    XFlush(display);

    initialize_drawing();

    /* configure parameters of the Gantt chart display w.r.t. the sizes of
       the marker window, control window and display window */

    (void)(ConfigDispWin(0,0,&mw,&mh));

} /* create_windows */








void destroy_windows()
/*
 * free all X resources used and destroy all windows created
 *
 */
{

  close_frames();
  (void)FreeColors();
  (void)close_draw_fonts();
  if (console_fontinfo!=NULL) XFreeFont(display,console_fontinfo);
  if (w!=NULL) {
   XDestroyWindow(display, w);
   w = NULL;
   XFlush(display);
  }
  if (cntrlW!=NULL) {
    XDestroyWindow(display, cntrlW);
    cntrlW = NULL;
    XFlush(display);
  }
#if CONSOLE
  if (consoleW!=NULL) {
    XDestroyWindow(display, consoleW);
    consoleW = NULL;
    XFlush(display);
  }
#endif
}




/*
 *    get_help
 *
 * This function is called when the user clicks a button in the
 * "help" window.
 *
 */

void get_help()
{

  (void)GanttMan(MAN_PAGE_NAME);

}



/*
 * display_schedule
 *
 * main routine for the Gantt chart display
 *
 * return value : always returns 0
 *
 * ARGUMENTS :
 * char *display_name;   Name of display for X windows ; null string if
 *                       no display is present. If the display named
 *                       here can't be opened, displaysched will give
 *                       only textual output.
 * int PIGI_present;      1 if graphics interface is being used, else 0
 * char *input_file;     file from which the scheduler output is read
 * char *output_file;    file to write formatted schedule to
 *                       ("" [null string] if no output file is desired)
 *
 *
 */

int display_schedule(display_name, PIGI_present,
                     input_file, output_file)
char *display_name;
int PIGI_present;
char *input_file;
char *output_file;
{
  register Window event_win;
  register XButtonEvent *bev = (XButtonEvent*)(&event);
  register XKeyEvent *kev = (XKeyEvent*)(&event);
  int display_available;
  void move_bar();
  int finished = 0;   /* main loop control */
  KeySym keysym;

    /* set the exported variable which indicates whether the
       graphics interface is being used  */

    PIGI_GABRIEL_RPC = PIGI_present;

    /* read the schedules for each processor into a linked list */
  display_available = read_sched(input_file, display_name);

    /* print the schedule on standard output */
  if (!display_available) print_stars("");

    /* print the schedule into an output file */
  if (strlen(output_file) > 0) print_stars(output_file);

    /* stop here if X is not available, otherwise continue with
       the graphical display of the Gantt chart for this schedule */

  if (display_available) {

      /* create all the neccessary windows and initialize associated data */
    create_windows();

#if DEBUG
  (void)fprintf(stdout,"finished creating windows\n");
#endif


      /*
       *  keep checking for the following events :
       * (1) press of middle button in marker window   => move the marker
       * (2) press of right button in marker window    => change size of marker
       * (3) press of middle button close to the bar   => move the bar
       * (4) press of right button in display window   => move mouse to the bar
       * (5) press of left button in display window   => move bar to the mouse
       * (6) control-L in display window => redraw
       * (7) h in display window => help
       * (8) control-D in display window -> exit
       *
       */

    while(!finished) {
          event_win = AwaitInput(InputMask);
          if (event_win==markerW) {
            if ((bev->button)==Button2)
              (void)move_marker();
            else if ((bev->button)==Button3)
              resize_marker(Button3);
            else if ((bev->button)==Button1)
              resize_marker(Button1);
          }
          else if (event_win==w) {
            if (event.type == ButtonPress) {
              if ((bev->button) == Button2) {
                   if (abs(bev->x-bar_x) < BAR_SENSE) move_bar(w);
              }
              else if  ((bev->button) == Button3)
              {
                   move_mouse_to_bar(bev->y);
              }
              else if  ((bev->button) == Button1)
              {
                   move_bar_to_mouse(bev->x);
              }
            }
            else {
              if (XLookupString(kev, msgbuf, BUFLEN,
                                    &keysym, NULL) >= 1) {
                switch (msgbuf[0]) {
                case '' : finished =1;
                            break;
                case 'h'  : get_help();
                            break;
                case '' : draw_gantt_chart(start, top_proc);
                            XFlush(display);
                            break;
                } /*switch*/
              } /*if*/
            } /*else*/
          } /*else if*/

    } /*while*/
  } /* if */

  /* before exiting, free all allocated memory and destroy the windows created */

  free_proc_list();
  destroy_windows();

  return(0);

}
/* o

*/
