/**************************************************************************
Version identification:
@(#)events.c	2.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)events.c	2.2	11/25/92";
#endif /* not lint */

#include <stdio.h>
#include <strings.h>
#include "displaysched.h"
#include "highlight.h"
#ifdef DEBUG
extern char* event_names[];
#endif

int window_time;
int no_procs_dis;
int no_procs;
int beginning=1;
int w_width, w_height, cntrlW_width, cntrlW_height;
XWindowAttributes w_info, cntrlW_info, mw_info, window_info;


extern int max_end_time;
extern Window w, markerW, cntrlW;
extern XEvent event;
extern int start, top_proc;
extern void draw_gantt_chart();
extern int ConfigDispWin();
extern int screen;
extern Display *display;
extern GC gc_grid;

/*
 * check_disp_win
 *
 * This function is called after an exposure event on the
 * display window. It first checks whether the size of the
 * display window has changed. If it hasn't changed, the function
 * returns immediately. Otherwise, the parameters of the
 * display (e.g. the number of time units displayed) are
 * are updated.
 *
 */

void check_disp_win(config_ev)
XConfigureEvent *config_ev;
{
    int change = 0;
    int wid, ht;
    XWindowAttributes marker_info;

    if ((config_ev->width==w_width)&&
	(config_ev->height==w_height)) return;

    w_width = config_ev->width;
    w_height = config_ev->height;

    if (w_width < MIN_DISPW_W) {
	w_width = MIN_DISPW_W;
	change = 1;
    }
    if (w_height < MIN_DISPW_H) {
	w_height = MIN_DISPW_H;
	change = 1;
    }

    if (change) XResizeWindow(display, w, w_width, w_height);
    if (XGetWindowAttributes(display, markerW, &marker_info)==0)
	err("\ndisplaysched: error in getting window attributes\n");
    wid = marker_info.width;
    ht = marker_info.height;
    if (ConfigDispWin(marker_info.x, marker_info.y, &wid, &ht)!=0)
	XResizeWindow(display,markerW, wid, ht);
} /* check_disp_win */


/*
 * check_cntrl_win
 *
 * This function is called after an exposure event is generated
 * on the display control window. It checks to see if the size
 * of the window has been changed (by the user's window manager).
 * If the size has been changed, the parameters of the display
 * (e.g. box height, number of processors displayed) are changed
 * accordingly.
 *
 */

void check_cntrl_win(config_ev)
XConfigureEvent *config_ev;
{
    register int change = 0;
    XWindowAttributes marker_info;
    int wid, ht;
    register double wmult, hmult;
    XWindowChanges changes;

    if ((config_ev->width==cntrlW_width)&&
	(config_ev->height==cntrlW_height)) return;

    /* compute the factor by which the width and height of
       the control window have changed */

    wmult = ((double)config_ev->width)/((double)cntrlW_width);
    hmult = ((double)config_ev->height)/((double)cntrlW_height);

    cntrlW_width = config_ev->width;
    cntrlW_height = config_ev->height;

    /* check against width and height minimums (resize hints
       don't guarantee these) */

    if (cntrlW_width < MIN_CNTRLW_W) {
	cntrlW_width = MIN_CNTRLW_W;
	change = 1;
    }
    if (cntrlW_height < MIN_CNTRLW_H) {
	cntrlW_height = MIN_CNTRLW_H;
	change = 1;
    }

    if (change) XResizeWindow(display, cntrlW, cntrlW_width, cntrlW_height);

    /* determine new size/location of marker window */

    if (XGetWindowAttributes(display, markerW, &marker_info)==0)
	err("\ndisplaysched: error in getting window attributes\n");

    if (((marker_info.x + marker_info.width) > cntrlW_width) ||
	((marker_info.y + marker_info.height) > cntrlW_height)) {
	ASSIGN(wid, (int)(wmult*((double)marker_info.width)),
	       MIN_MARKER_WIDTH,  cntrlW_width);
	ASSIGN(ht, (int)(hmult*((double)marker_info.height)),
	       MIN_MARKER_HEIGHT, cntrlW_height);
	changes.x = 0;
	changes.y = 0;
	changes.width=wid;
	changes.height=ht;
#if DEBUG
	printf("changing marker w = %d, h= %d, call XConfigWin\n", wid, ht);
#endif
	XConfigureWindow(display, markerW, CWX|CWY|CWWidth|CWHeight,
			 &changes);
	if (ConfigDispWin(0, 0, &wid, &ht)!=0) {
#if DEBUG
	    printf("rechanging marker w = %d, h= %d\n", wid, ht);
#endif
	    XResizeWindow(display, markerW, wid, ht);
	}
    }
    else {
	wid = marker_info.width;
	ht = marker_info.height;
	if (ConfigDispWin(marker_info.x, marker_info.y, &wid, &ht)!=0)  {
#if DEBUG
	    printf("Resizing the marker\n");
#endif
	    XResizeWindow(display, markerW, wid, ht);
	}
    }
}

/*
 * AwaitInput
 *
 * Wait for an event contained in "mask", while handling exposure
 * events as they occur. Return the window the event occured in.
 *
 */

Window AwaitInput(mask)
register unsigned long mask;
{
    register int done=0;
    Window win;

    while(!done) {
	XMaskEvent(display,ALL_EVENTS,&event);
#if DEBUG
	fprintf(stdout,"AwaitInput : event = %s\n", event_names[event.type]);
#endif
	win = event.xany.window;
	switch (event.type)  {
	case ConfigureNotify :
	    if (win==w) check_disp_win((XConfigureEvent*)(&event));
	    else check_cntrl_win((XConfigureEvent*)(&event));
	    if (!beginning) draw_gantt_chart(start,top_proc);
	    beginning=0;
	    break;
	case Expose :
	    while (XCheckTypedEvent(display,Expose,&event));
	    if (win==w) draw_gantt_chart(start,top_proc);
	    XFlush(display);
	    break;
	case KeyPress :
	    if ((mask & KeyPressMask)!=0) done=1;
	    break;
	case ButtonPress :
	    if ((mask & ButtonPressMask)!=0) done=1;
	    break;
	case LeaveNotify :
	    if ((mask & LeaveWindowMask)!=0) done=1;
	    break;
	case ButtonRelease :
	    if ((mask & ButtonReleaseMask)!=0) done=1;
	    break;
	case MotionNotify :
	    if ((mask & PointerMotionMask)!=0) done=1;
	    break;
	case ReparentNotify :
	    break;
	    default : ;
	} /* switch */
    } /*while*/
    return (win);
} /*AwaitInput*/

/*
 * move_bar
 *
 * This function moves the bar window along with the mouse. The mouse is
 * to be dragged with the middle button down. The bar window keeps
 * following the mouse around until (A) the middle button is released
 * or (B) the mouse leaves the display window. Once (A) or (B) occurs
 * the function returns.
 *
 * ARGUMENT  w = display window
 *
 */

void move_bar(w)
register Window w;

{
    int x, y;
    register int done=0;
    Window root, child;
    int root_x, root_y;
    unsigned int keys_buttons;




    /* wait for one of the desired events while dealing with
       exposure events */

    while(!done) {
	while (AwaitInput(ButtonReleaseMask|PointerMotionMask|
			  LeaveWindowMask)!=w);
	switch (event.type) {
	case MotionNotify:
	    while (XCheckMaskEvent(display, Button2MotionMask, &event));
	    if (!XQueryPointer(display, w, &root, &child, &root_x,
			       &root_y, &x, &y, &keys_buttons))
		err("Could not query pointer");
	    break;

	case ButtonRelease:
	    if ((((XButtonEvent*)(&event))->button)==Button2) {
		x = ((XButtonEvent*)(&event))->x;
		y = ((XButtonEvent*)(&event))->y;
		done = 1;
		break;
	    }
	    else continue;
	case LeaveNotify:
	    if ((((XCrossingEvent*)(&event))->window)==w) {
		x = ((XLeaveWindowEvent*)(&event))->x;
		y = ((XLeaveWindowEvent*)(&event))->y;
		done = 1;
		break;
	    }
	    else continue;
	} /* switch */

	erase_bar();                         /* erase old bar */
	set_bar(x);                          /* move the bar  */
	draw_bar();                      /* draw new bar  */
    } /* while */
    while (XCheckMaskEvent(display, ALL_EVENTS, &event));
} /* move_bar */













/*
 * move_marker
 *
 * This function is used to move the marker window around
 * inside the display control window.
 *
 */

int move_marker()

{
    int x, y;  /* coordinates of mouse relative to time window */
    register int new_x, new_y;
    int mw_ht, mw_width;
    register int done=0;
    Window root, child;
    int root_x, root_y;
    unsigned int keys_buttons;
    Window win;
    int wait_for_button_release = 0;




    if (XGetWindowAttributes(display, markerW, &mw_info)==0)
	err("\ndisplaysched: error in getting window attributes\n");

    /* wait for one of the desired events while dealing with
       Expose Windows as they occur */;

    new_x = mw_info.x;
    new_y = mw_info.y;
    mw_width = mw_info.width;
    mw_ht = mw_info.height;

    /* Draw initial grid */
    DrawGrid(new_x,new_y,new_x+mw_width,new_y+mw_ht);

    while (1) {
	while (1) {
	    win=AwaitInput(PointerMotionMask|LeaveWindowMask|
			   ButtonReleaseMask);
	    if (win==cntrlW) break;
	    else if (win==markerW) break;
	}
	switch (event.type) {
	case MotionNotify:
	    while (XCheckMaskEvent(display, Button2MotionMask, &event));
	    if (!XQueryPointer(display, cntrlW, &root, &child, &root_x,
			       &root_y, &x, &y, &keys_buttons))
		err("Could not query pointer");
	    break;

	case ButtonRelease:
	    if ((((XButtonEvent*)(&event))->button)==Button2) {
		x = ((XButtonEvent*)(&event))->x + mw_info.x;
		y = ((XButtonEvent*)(&event))->y + mw_info.y;
		done = 1;
		break;
	    }
	    else continue;

	case LeaveNotify:

	    /***********************************************************
	      Tricky X10 code section commented out:
	      The following is dealt with by setting the do_not_propagate
              window attribute (main.c) of  markerW :
	      " if an event occurs in a window that doesn't have that event
	      XSelected, it propagates to the nearest ancestor who has it
	      XSelected. thus, we must check to make sure "markerW" wasn't the
	      window LeaveWindowed "   (comment for code below)

	      detail = (((XButtonEvent*)(&event))->detail)&ValueMask;
	      if ((detail==VirtualCrossing)||
              ((event.subwindow==0)&&(detail==0))) {
	      done = 1;
	      x = ((XLeaveWindowEvent*)(&event))->x;
	      y = ((XLeaveWindowEvent*)(&event))->y;
	      break;
	      }
	      **************************************************************/
	    done = 1;
	    x = ((XLeaveWindowEvent*)(&event))->x;
	    y = ((XLeaveWindowEvent*)(&event))->y;
	    wait_for_button_release = 1;
	    break;
	} /* switch */

	/* erase old grid */
	DrawGrid(new_x,new_y,new_x+mw_width,new_y+mw_ht);

	if (x<=(mw_width/2)) new_x=0;
	else if ((x+mw_width/2+1)>=cntrlW_width)
	    new_x=cntrlW_width-mw_width+1;
	else new_x=x-mw_width/2;

	if (y<=(mw_ht/2)) new_y=0;
	else if ((y+mw_ht/2+1)>=cntrlW_height)
	    new_y=cntrlW_height-mw_ht+1;
	else new_y=y-mw_ht/2;

	if (done) {
	    /* move the marker window and configure the display window
	       according the new position */
	    (void)(ConfigDispWin(new_x, new_y, &mw_width, &mw_ht));
	    XMoveWindow(display, markerW, new_x, new_y);
	    draw_gantt_chart(start,top_proc);
	    if (wait_for_button_release)
		XWindowEvent(display, markerW, ButtonReleaseMask, &event);
	    while (XCheckMaskEvent(display, ALL_EVENTS, &event));
	    return(1);
	}
	else {      /* draw new grid */
	    DrawGrid(new_x,new_y,new_x+mw_width,new_y+mw_ht);
	}
    } /* while */
    /*NOTREACHED*/
}
