/**************************************************************************
Version identification:
@(#)error.c	2.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)error.c	2.2	11/25/92";
#endif /* not lint */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <stdio.h>

extern void free_proc_list();
extern void destroy_windows();
extern void exit(), GanttErr();



/*
 * gantt_chart_error
 * (also, the macro err(msg) calls this)
 * displaysched error routine. This routine prints a message to stderr and exits
 * appropriately.
 *
 */

void gantt_chart_error(msg)
     char *msg;
{

    destroy_windows();    /* clean up windows and associated data structures */
    free_proc_list();     /* free the list of processors */

    (void)fprintf(stderr,"\n%s\n",msg);     /* print message */

    /* call gabriel error routine */

    (void)GanttErr(msg);
    exit(1);

}


/*
 * X error handlers.
 *
 * Note that the display cannot be modified when an X error occurs --
 * thus we can't call the gabriel error routine. Instead, these functions
 * print messages to stderr and exit with status 1
 *
 */


/*ARGSUSED*/
int handler(disp, err_ev)
Display *disp;
XErrorEvent *err_ev;
{
    char msg[64];
    extern Display *display;

    (void)fprintf(stderr, "************************************************\n");
    (void)fprintf(stderr, "displaysched: X Error has occured \n");
    XGetErrorText(display, err_ev->error_code, msg, 64);
    (void)fprintf(stderr, "Error code %s\n", msg);
    (void)fprintf(stderr, "Goodbye from displaysched.\n");
    (void)fprintf(stderr, "************************************************\n");
    exit(1);
}



/*ARGSUSED*/
int IOErrorHandler(disp)
Display *disp;
{
    (void)fprintf(stderr, "************************************************\n");
    (void)fprintf(stderr,"\ndisplaysched: fatal X IO error has occurred, aborting .....\n");
    (void)fprintf(stderr, "************************************************\n");
    exit(1);
}
