/**************************************************************************
Version identification:
@(#)colors.c	2.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  S. Bhattacharyya

 This file was originally part of the Gabriel system.

**************************************************************************/
#ifndef lint
static char sccsid[] = "@(#)colors.c	2.2	11/25/92";
#endif /* not lint */

#include "colors.h"
#include "displaysched.h"
#include "ganttIfc.h"

char msgbuf[64];
extern int depth, screen;
extern Display *display;
unsigned long *processor_colors=NULL;
extern char *calloc();
XColor *colorcell_defs;
extern Colormap cmap;

/*  AllocateColors
 *
 *  Allocate n colors. Return a pointer to an array of n
 *  pixel values
 *
 *  If the current display doesn't have color available OR if the
 *  number of processors is greater than the size of the current
 *  color table (in "color.h") return NULL.
 *
 */

unsigned long  *AllocateColors(n)
     register int n;

{
    register int i;
    int ncolors= (sizeof(colors))/(sizeof(char*));
    /* number of colors in colors array */
    extern unsigned long AllocatePixelValue();

#if DEBUG
    printf("Inside AllocateColors\n");
#endif DEBUG

    if (n>ncolors) {
	printf("*************************************************\n");
	printf("The number of processors (%d) is greater than the\n", n);
	printf("number of colors (%d) in the GANTT program's color table",
	       ncolors);
	printf(".\nSo, we'll be using black & white\n");
	printf("*************************************************\n");
	printf("The number of processors (%d) is greater than the\n", n);
	return(NULL);
    }

    if (depth <= 1) return(NULL);

    if ((processor_colors=((unsigned long*)
			   (calloc((unsigned)n,sizeof(unsigned long)))))==NULL)
	err("displaysched: not enough memory\n");
#if DEBUG
    printf("Allocating processor colors\n");
#endif
    for (i=0; i<n; i++)
	processor_colors[i] = AllocatePixelValue(colors[i], WhitePixel(display, screen));
#if DEBUG
    printf("Finished allocating processor colors\n");
#endif
    return(processor_colors);
} /*AllocateColors*/



FreeColors()
/*
 * Free all of the colors allocated by AllocateColors().
 * Return the value returned by free.
 */
{
    if (processor_colors!=NULL) (void)(free((char*)(processor_colors)));
    return(1);
}


unsigned long *get_colors(no_procs)
int no_procs;
/*
 * get color information (pixel value/rgb intensities for processors
 * and put it in the processor list. return NULL on failure;
 * otherwise return the array created.
 *
 * call AFTER checking that this is a color display.
 */
{
    extern unsigned long *AllocateColors();
    register int i;
    register unsigned long *ctable;
    extern RgbValue *processor_rgb_values;
    extern char *mem_msg;
    extern struct processor *proc_table;

    if (depth<=1) {
#if DEBUG
	printf("depth is one, aborting get_colors()\n");
#endif
	return(NULL);
}

#if DEBUG
    printf("proceeding with get_colors, # procs = %d\n",
	   no_procs);
#endif

    if ((ctable = AllocateColors(no_procs))!=NULL) {
	if ((colorcell_defs = (XColor*)
	     (calloc((unsigned)no_procs, sizeof(XColor))))==NULL)
	    err(mem_msg);
	for (i=0; i<no_procs; i++) {
	    proc_table[i].color = ctable[i];
	    colorcell_defs[i].pixel = ctable[i];
	}
	XQueryColors(display, cmap, colorcell_defs, no_procs);

	if ((processor_rgb_values = (RgbValue*)
	     (calloc((unsigned)no_procs, sizeof(RgbValue))))==NULL)
	    err(mem_msg);
	for (i=0; i<no_procs; i++) {
	    processor_rgb_values[i].red = colorcell_defs[i].red;
	    processor_rgb_values[i].green = colorcell_defs[i].green;
	    processor_rgb_values[i].blue = colorcell_defs[i].blue;
	}
    }
    return(ctable);
}
