static const char file_id[] = "RanGen.cc";
/******************************************************************
Version identification:
@(#)RanGen.cc	1.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  J. Buck
 Date of creation: 1/9/92

This module provides the common seed for random-number generation.
It was formerly in Star.cc.

*******************************************************************/

#include <ACG.h>
#include "logNew.h"

// common random number generator for all Star classes.
// default seed is 1.

ACG* gen = 0;

// This class serves to initialize and clean up gen.  A pointer is
// used rather than a plain object so that the seed can be changed.

class RanGenOwner {
public:
	RanGenOwner() {
		LOG_NEW; gen = new ACG(1);
	}
	~RanGenOwner() {
		LOG_DEL; delete gen;
	}
};

static RanGenOwner buildIt;
