static const char file_id[] = "interpmain.cc";
/******************************************************************
Version identification:
@(#)interpmain.cc	1.15	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  J. T. Buck
 Date of creation: 3/19/90

 This is the main program for the Ptolemy interpreter.  It should
 be linked with the Ptolemy library together with all the star
 object files for stars that are to be compiled in.  New known
 stars can be added simply by linking them in; later, we will attempt
 to support dynamic linking.

*******************************************************************/

#include "Interpreter.h"
#include "SimControl.h"
#include "Linker.h"
#include "KnownBlock.h"
#include <stream.h>

#ifndef DEFAULT_DOMAIN
#define DEFAULT_DOMAIN "SDF"
#endif

// create and run the interpreter.
main(int argc, char** argv) {
	SimControl::catchInt();
	Linker::init (*argv);
	KnownBlock::setDomain(DEFAULT_DOMAIN);
	int status;
	if (argc == 1) {
		Interpreter interp;
		status = interp.commandRouter();
	}
	else {
		Interpreter interp(argv[1]);
		status = interp.commandRouter();
	}
	// return 0 (success) if commandRouter returns TRUE,
	// else return 1 (failure).
	return !status;
}

// the following stub is here until we support the Gantt chart
// under the interpreter.

extern "C" int displayGanttChart(const char*) {
	Error::error("Gantt chart display not implemented for the interpreter");
	return 0;
}
