/******************************************************************
Version identification:
@(#)Interpreter.h	2.14	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  J. Buck
 Date of creation: 3/19/90

 Interpreter is the Ptolemy interpreter.  It allows the user to
 dynamically build galaxies composed of the stars known to the system
 and to schedule and run them.

 Changed to support any domain type, using static Domain class funcs.

*******************************************************************/
#ifndef _Interpreter_h
#define _Interpreter_h 1

#ifdef __GNUG__
#pragma interface
#endif

#include "InterpUniverse.h"

#include "Tokenizer.h"

const int TOKSIZE = 80;

class Interpreter
{
	InterpUniverse* universe;	// Universe to execute
	InterpGalaxy* currentGalaxy;	// current galaxy to make things in
	Target* currentTarget;		// target for currentGalaxy, if
					// explicitly set.
	Tokenizer tin;			// reader for input tokens
	int depth;			// current depth of nesting
	int errorFlag;			// flags InterpGalaxy errors
	int terminalInput;		// flag indicating reading from tty
	int quitFlag;			// flag set by (quit) command
	double stopTime;		// when simulation should stop
	double lastTime;		// last argument to "run" or "cont"

	void say(const char* a);			// msg
	void say(const char* a, const char* b);		// msg, 2 args
	void say(const char* a, const char* b, const char* c);	// msg, 3 args

	void welcome();
	void prompt();

	// functions for error reporting
	int expect(const char*);
	int badname(const char*);
	char* where();			// give file and linenum for load file
	void unknown();			// process "unknown command"
	void recover();			// recover from InterpGalaxy error
	int genSched();			// generate schedule, return true/false
	// functions for processing interpreter commands
	void dispatch(const char* verb);
// "dispatch" calls one of the following functions:


	void schedule();		// schedule the universe, display it
	void run();			// run iterations of simulation
	void wrapup();			// wrap up the simulation
	void cont();			// continue the simulation
	void quit();			// exit the simulation
	void help();			// give help
	void animation();		// turn animation on and off

	void star();			// add a new star
	void delstar();			// delete a star
	void connect();			// add an internal connection
	void busconnect();		// add a bus connection
	void alias();			// add a new alias
	void disconnect();		// disconnect a porthole
	void numports();		// create portholes in a multiporthole
	void node();			// add a node for netlist connections
	void delnode();			// delete a node
	void nodeconnect();		// connect a porthole to a node
	void state();			// add a state
	void setstate();		// set (change) a state
	void descriptor();		// set the descriptor
	void defgalaxy();		// define a new galaxy
	void knownlist();		// display the known list
	void domain();			// display or change the domain
	void domains();			// list domains
	void target();			// display or change the target
	void targets();			// display available targets
	void targetparam();		// edit target parameters
	void seed();			// set the seed of random number

	void show();			// show the current galaxy
	void dump();			// like show, only recursive
	void showfunc(int);		// implements show and dump

	void initstate();		// initialize all states

	void reset();			// interface for resetUniverse
	void load();			// load a file of interpreter commands
	void chdir();			// change working directory
	void echo();			// print a message
	void exec();			// execute a shell command
	void link();			// dynamic-link a file
// end of interpreter command functions

	void newUniverse();		// attach to a new universe
	void resetUniverse();		// wipe out current universe, make anew

public:
	Interpreter();			// constructor
	Interpreter(const char*);	// constructor for reading from file
	int commandRouter();		// processes input
	~Interpreter();			// destructor
};

#endif
