static const char file_id[] = "Thorxx74.cc";

////////////////////////////////////////////////////////////////////////
// @(#)Thorxx74.cc	1.3 11/26/92
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice,
// limitation of liability, and disclaimer of warranty provisions.
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/07, 11:34:19 by pepp version 2.6.
//  Input is coming from file "Thorxx74.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
/*
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;
*/

/*	xx74a()
 *	D-type pos-edge triggered flip-flop w/ preset & clear
 *
 *	4 inputs	2 outputs	2 internal states
 *
 *								EJF 11/17/82
 */

const char *star_nm_Thorxx74 = "Thorxx74";

class Thorxx74 : public ThorStar
{
private:

//	    Inport list: (between lines 12 and 17)
    InThorPort		Pre_b;
    InThorPort		Clk;
    InThorPort		D;
    InThorPort		Clr_b;

//	    Outport list: (between lines 19 and 22)
    OutThorPort		Q;
    OutThorPort		Q_b;

//	    State list: (between lines 24 and 27)
    int			SavQ;
    ThorState		_SavQ_;
    int			LastClk;
    ThorState		_LastClk_;

public:
    int			isItModel() { return TRUE; }
    Thorxx74();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new Thorxx74; }
int flag;
};

Thorxx74 :: Thorxx74 ()	// Constructor
{
    setDescriptor("\n"
"** This star's code has been changed after pepp. **\n""\n"

"/*	xx74a()\n"
" *	D-type pos-edge triggered flip-flop w/ preset & clear\n"
" *\n"
" *	4 inputs	2 outputs	2 internal states\n"
" *\n"
" *								EJF 11/17/82\n"
" */\n");

//	Ports:

    addPort(Pre_b.setPort("Pre_b",this));
    addPort(Clk.setPort("Clk",this));
    addPort(D.setPort("D",this));
    addPort(Clr_b.setPort("Clr_b",this));

    addPort(Q.setPort("Q",this));
    addPort(Q_b.setPort("Q_b",this));

//	States:

    addState(_SavQ_.setThorState("SavQ",this,"0",&SavQ));
    addState(_LastClk_.setThorState("LastClk",this,"0",&LastClk));
}

void Thorxx74 :: setup()
{
//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;

// line 30 "Thorxx74.chdl"
        SavQ = ONE;
        flag=0;
}

static Thorxx74 proto;
static KnownBlock entry(proto,"xx74");

void Thorxx74 :: go()
{
#define index  strchr
#define new   _new_

//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;

// line 10 "Thorxx74.chdl"

// line 18 "Thorxx74.chdl"

// line 23 "Thorxx74.chdl"

// line 28 "Thorxx74.chdl"

// line 33 "Thorxx74.chdl"

	if ( Clk >= UNDEF )		/* undefined clock input	*/
		SavQ = UNDEF;

	else if ( vrise[LastClk][Clk] == 1 )
	{
		/*   rising edge	*/
		if(flag==0)
		{
			SavQ = 1;
			flag=1;
		}
                else
		{
			SavQ = vmap[ D ];
		}
	}

	if ( Pre_b >= UNDEF  ||  Clr_b >= UNDEF ) /* undefined PR or CLR */
		SavQ = UNDEF;

	else if ( Pre_b == ZERO )
			/* actually might be unstable ONE */
		SavQ = (Clr_b == ZERO) ? UNDEF : ONE;

	else if ( Clr_b == ZERO )	/* check active low clear	*/
		SavQ = ZERO;

	Q_b = vinv[ (Q = SavQ) ];

	LastClk = Clk;			/* store last CK input		*/

	EXITMOD(0);
}

