static const char file_id[] = "../../../../src/domains/thor/stars/ThorXOR.chdl";

////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice, 
// limitation of liability, and disclaimer of warranty provisions. 
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/26, 12:42:24 by pepp version 2.6.
//  Input is coming from file "../../../../src/domains/thor/stars/ThorXOR.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;

/*	XOR()
 *
 *		Generic mult-input XOR gate
 * 			(may be thought of as an even parity generator)
 */

const char *star_nm_ThorXOR = "ThorXOR";

class ThorXOR : public ThorStar
{
private:

//	    Inport list: (between lines 11 and 13)
    MultiInThorPort	indat;

//	    Outport list: (between lines 15 and 17)
    OutThorPort		fun;

public:
    int			isItModel() { return TRUE; }
    ThorXOR();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorXOR; }

};

ThorXOR :: ThorXOR ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is generated by pepp, version 2.6, from a chdl model. **\n""\n"

"/*	XOR()\n"
" *\n"
" *		Generic mult-input XOR gate\n"
" * 			(may be thought of as an even parity generator)\n"
" */\n");

//	Ports:

    addPort(indat.setPort("indat",this));

    addPort(fun.setPort("fun",this));
}

void ThorXOR :: setup()
{
}

static ThorXOR proto;
static KnownBlock entry(proto,"XOR");

void ThorXOR :: go()
{
#define index  strchr
#define new   _new_

    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
    StatErrHandler = &errHandler;

// line 8 "../../../../src/domains/thor/stars/ThorXOR.chdl"

#define	RCSID "$Header: XOR.c,v 1.2 86/12/31 14:34:01 div Exp $"

// line 14 "../../../../src/domains/thor/stars/ThorXOR.chdl"

// line 18 "../../../../src/domains/thor/stars/ThorXOR.chdl"

	register int i;

	if ( OUT_COUNT != 1 )
	{
		fprintf(stderr,"ERROR: XOR(): wrong # of outputs\n");
		fprintf(stderr,"\tThe polycell XOR is now called: xorx()\n");
		EXITMOD(-2);
	}

	fun = ZERO;

	for ( i = IN_COUNT-1; i>=0; --i)
	{
		fun = vxor[fun][indat[i]];
	}

	EXITMOD(0);
}

