static const char file_id[] = "ThorSer2Par.cc";

////////////////////////////////////////////////////////////////////////
// @(#)ThorSer2Par.cc	1.3 11/26/92
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice,
// limitation of liability, and disclaimer of warranty provisions.
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/06, 11:13:28 by pepp version 2.6.
//  Input is coming from file "ThorSer2Par.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "IntState.h"
#include "libarp.h"
#include "KnownBlock.h"

/*
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;
*/

/*	Ser2Par()
Receives serial bit stream of `bits' length and converts it to a bus of
width `bits' after `bits' clock cycles.
*/

const char *star_nm_ThorSer2Par = "ThorSer2Par";

class ThorSer2Par : public ThorStar
{
private:

//	    Inport list: (between lines 9 and 12)
    InThorPort		databit;
    InThorPort		clock;

//	    Outport list: (between lines 14 and 16)
    MultiOutThorPort	bus;

//	    State list: (between lines 18 and 22)
    MultiThorState	ev;
    int			busWidth;
    ThorState		_busWidth_;
    int 		codesDemo;
    ThorState 		_codesDemo_;

public:
    int			isItModel() { return TRUE; }
    ThorSer2Par();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorSer2Par; }

const char* mname() {return name();}
const char* instance_name;
int length;
int value[16];

};

ThorSer2Par :: ThorSer2Par ()	// Constructor
{
    setDescriptor("\n"
"** This star's code has been changed after pepp. **\n""\n"

"/*	Ser2Par()\n"
"Receives serial bit stream of `bits' length and converts it to a bus of\n"
"width `bits' after `bits' clock cycles.\n"
"*/\n");

//	Ports:

    addPort(databit.setPort("databit",this));
    addPort(clock.setPort("clock",this));

    addPort(bus.setPort("bus",this));

//	States:

    addState(ev.setThorState("ev",this,32));
    addState(_busWidth_.setThorState("busWidth",this,"8",&busWidth));
    addState(_codesDemo_.setThorState("codesDemo",this,"0",&codesDemo));
}

void ThorSer2Par :: setup()
{
//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//   StatErrHandler = &errHandler;

// line 30 "ThorSer2Par.chdl"
	instance_name = mname();
	//fsetword(bus,busWidth,0,FLOAT);	
	length=0;
}

static ThorSer2Par proto;
static KnownBlock entry(proto,"Ser2Par");

void ThorSer2Par :: go()
{
#define index  strchr
#define new   _new_

//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;

// this is to avoid false triggering of this block in codes demos
	if(codesDemo==1)		/* Serial Comm. */
	{
		if(current_time < 2666) EXITMOD(0);
	}

	if(codesDemo==2)		/* Shared Memory */
	{
		if(current_time < 4000) EXITMOD(0);
		if((strcmp(instance_name,"Ser2Par.bus=82")==0) &&
			(current_time<5000))	EXITMOD(0);
		if(((current_time-fpack(ev,31,0))<=20) ||
			((current_time-fpack(ev,31,0))>1500)) ;
		else EXITMOD(0);
	}

	if(codesDemo==3)		/* Single DSP models */
	{
		if(current_time < 1550) EXITMOD(0);
		if((strcmp(instance_name,"Ser2Par.bus=82")==0) &&
			(current_time==1551))	 EXITMOD(0);
		if(((current_time-fpack(ev,31,0))<=20) &&
                        (length==0)) EXITMOD(0);
		if(((current_time-fpack(ev,31,0))<=20) ||
			((current_time-fpack(ev,31,0))>1500));
		else EXITMOD(0);
	}

//prevent multiple evaluations
 	if (fpack(ev,31,0)==current_time)  EXITMOD(0);
	funpack(ev,31,0,current_time);

       	int in = databit;
	if(in==3) EXITMOD(0);		// tristate

        value[busWidth-1-length] = in;
	length++;
        if(length==busWidth)
        {
                for(int i=0; i< busWidth; i++)
		{
                bus[i] = value [i];
		}
                length = 0;
        }
        else
	{
                fsetword(bus,(busWidth-1),0,FLOAT);
		//float bus between successive cycles
	}
        EXITMOD(0);
}

