static const char file_id[] = "../../../../src/domains/thor/stars/ThorDeMUX.chdl";

////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice, 
// limitation of liability, and disclaimer of warranty provisions. 
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/26, 12:42:05 by pepp version 2.6.
//  Input is coming from file "../../../../src/domains/thor/stars/ThorDeMUX.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;

/*	DeMUX()
 *		DeMultiplexes Input to outputs 
 * @(#)ThorDeMUX.chdl	1.1 11/16/92
 */

const char *star_nm_ThorDeMUX = "ThorDeMUX";

class ThorDeMUX : public ThorStar
{
private:

//	    Inport list: (between lines 10 and 13)
    InThorPort		input;
    MultiInThorPort	select;

//	    Outport list: (between lines 15 and 17)
    MultiOutThorPort	output;

//	    State list: (between lines 19 and 22)
    int			numOutputs;
    ThorState		_numOutputs_;
    int			numSelect;
    ThorState		_numSelect_;

public:
    int			isItModel() { return TRUE; }
    ThorDeMUX();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorDeMUX; }

};

ThorDeMUX :: ThorDeMUX ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is generated by pepp, version 2.6, from a chdl model. **\n""\n"

"/*	DeMUX()\n"
" *		DeMultiplexes Input to outputs \n"
" * @(#)ThorDeMUX.chdl	1.1 11/16/92\n"
" */\n");

//	Ports:

    addPort(input.setPort("input",this));
    addPort(select.setPort("select",this));

    addPort(output.setPort("output",this));

//	States:

    addState(_numOutputs_.setThorState("numOutputs",this,"0",&numOutputs));
    addState(_numSelect_.setThorState("numSelect",this,"0",&numSelect));
}

void ThorDeMUX :: setup()
{
}

static ThorDeMUX proto;
static KnownBlock entry(proto,"DeMUX");

void ThorDeMUX :: go()
{
#define index  strchr
#define new   _new_

    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
    StatErrHandler = &errHandler;

// line 7 "../../../../src/domains/thor/stars/ThorDeMUX.chdl"

#define	RCSID "$Header: AND.c,v 1.2 86/12/30 23:49:00 div Exp $"

// line 14 "../../../../src/domains/thor/stars/ThorDeMUX.chdl"

// line 18 "../../../../src/domains/thor/stars/ThorDeMUX.chdl"

// line 23 "../../../../src/domains/thor/stars/ThorDeMUX.chdl"

	int numOut = 2 << (numSelect-1);
	if( numOut != numOutputs)
	{
	fprintf(stderr,"ERROR: DeMUX(): wrong # of output/select lines\n");
	EXITMOD(-2);
	}

	int sel;
	sel = fpack(select,(numSelect-1),0);

	for(int i=0; i<numOutputs; i++)
	{
		if(i==sel) output[sel] = input;
		else 	   output[i] = FLOAT;
	}

	EXITMOD(0);
}

