static const char file_id[] = "ThorDSP56000.cc";

////////////////////////////////////////////////////////////////////////
// @(#)ThorDSP56000.cc	1.5 12/8/92
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice,
// limitation of liability, and disclaimer of warranty provisions.
//
////////////////////////////////////////////////////////////////////////

////

//  Note: This file has been changed after pepp
#include "ThorStar.h"
#include "ThorState.h"
#include "IntState.h"
#include "StringState.h"
#include "StringList.h"
#include "lib.h"
#include "uarp.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "paths.h"
/*
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;
*/

/* ThorDSP56000.c
 * This is the Thor model which models a DSP56000 processor.
 * It's function is to send its inputs out to the 56000
 * simulator over the IPC connection, and to receive it outputs
 * back over the same connection.
 *
 */

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/times.h>
#include <netinet/in.h>
#include <signal.h>
#include <netdb.h>

#define PORT 6400 
// This is not really used bec the program RPCSocket is used to give a port #

#define NUM_PINS 74
#define NUM_I_PINS 6
#define NUM_O_PINS 22
#define NUM_B_PINS 48

#define DSP_PINVAL_LOW 0
#define DSP_PINVAL_HIGH 1
#define DSP_PINVAL_FLOAT 2

extern "C" {
int server_talk(int, char[], int);
int RPCSetUpSocket(char[], int*);
}


  char *getenv();
  char *display;

// these two functions are converted to C++ ...
extern const char* sperror(const char* =0, const char* =0, const char* =0);
extern void clrErrNo();

const int  hostnamelen = 32;

const char *star_nm_ThorDSP56000 = "ThorDSP56000";

class ThorDSP56000 : public ThorStar
{
private:

//	    Inport list: (between lines 71 and 87)
    InThorPort		clock;
    InThorPort		reset;
    InThorPort		IRQA;
    InThorPort		IRQB;
    InThorPort		BR;
    InThorPort		SRD;
    InThorPort		RXD;
    InThorPort		HACK;
    InThorPort		HEN;
    InThorPort		HRW;
    InThorPort		HA2;
    InThorPort		HA1;
    InThorPort		HA0;

    InThorPort		PDataIn;
    InThorPort		HDataIn;

//	    Outport list: (between lines 89 and 107)
    OutThorPort		PS;
    OutThorPort		DS;
    OutThorPort		RD;
    OutThorPort		WR;
    OutThorPort		XY;
    OutThorPort		BG;
    OutThorPort		PAddress;
    OutThorPort		STD;
    OutThorPort		SCK;
    OutThorPort		SC2;
    OutThorPort		SC1;
    OutThorPort		SC0;
    OutThorPort		SCLK;
    OutThorPort		TXD;
    OutThorPort		HREQ;

    OutThorPort		PDataOut;
    OutThorPort		HDataOut;

//	    State list: (between lines 119 and 123)
    MultiThorState	ev;
    MultiThorState	sock;
    IntState		identifier;
    StringState		destDirectory;
    StringState		cmdFileName;

public:
    int			isItModel() { return TRUE; }
    ThorDSP56000();		// Constructor
    void		go();
    void		setup();
    int			pack(int *arin,  int msb, int lsb);
    void		unpack(int *arout,  int msb, int lsb, int number);
    Block*		makeNew() const { LOG_NEW; return new ThorDSP56000; }


const char* mname() { return name(); }
  int i;
  int pin;
  char pin_vals[NUM_PINS];
  char opins[NUM_O_PINS];
  char ipins[NUM_I_PINS];
  char *instance_name;
  int id;
  char argid[9];
  char cmdfile[99];

  char command[600];
  char protocol[20];
  int port;
  int s;
  int tmp_sock;
  struct sockaddr from;
  int fromlen;

  char hostname[hostnamelen];
  char *geometry;

  FILE *fd;
  char clientname[32];

  int PA[16],PD_in[24],PD_out[24],H_in[8],H_out[8];

};

ThorDSP56000 :: ThorDSP56000 ()	// Constructor
{
  setDescriptor("\n"
"** This file has been changed after running pepp. **\n""\n");

//	Ports:

    addPort(clock.setPort("clock",this));
    addPort(reset.setPort("reset",this));
    addPort(IRQA.setPort("IRQA",this));
    addPort(IRQB.setPort("IRQB",this));
    addPort(BR.setPort("BR",this));
    addPort(SRD.setPort("SRD",this));
    addPort(RXD.setPort("RXD",this));
    addPort(HACK.setPort("HACK",this));
    addPort(HEN.setPort("HEN",this));
    addPort(HRW.setPort("HRW",this));
    addPort(HA2.setPort("HA2",this));
    addPort(HA1.setPort("HA1",this));
    addPort(HA0.setPort("HA0",this));

    addPort(PS.setPort("PS",this));
    addPort(DS.setPort("DS",this));
    addPort(RD.setPort("RD",this));
    addPort(WR.setPort("WR",this));
    addPort(XY.setPort("XY",this));
    addPort(BG.setPort("BG",this));
    addPort(PAddress.setPort("PAddress",this));
    addPort(STD.setPort("STD",this));
    addPort(SCK.setPort("SCK",this));
    addPort(SC2.setPort("SC2",this));
    addPort(SC1.setPort("SC1",this));
    addPort(SC0.setPort("SC0",this));
    addPort(SCLK.setPort("SCLK",this));
    addPort(TXD.setPort("TXD",this));
    addPort(HREQ.setPort("HREQ",this));

    addPort(PDataIn.setPort("PDataIn",this));
    addPort(PDataOut.setPort("PDataOut",this));
    addPort(HDataIn.setPort("HDataIn",this));
    addPort(HDataOut.setPort("HDataOut",this));

//	States:

    addState(ev.setThorState("ev",this,32));
    addState(sock.setThorState("sock",this,32));
    addState(identifier.setState("identifier",this,"0","identifier for the DSP, any integer may be used"));
    addState(cmdFileName.setState("cmdFileName",this,"0command.cmd","File name for the command file, assuming it is in the destDirectory"));
    addState(destDirectory.setState("destDirectory",this,"~/DSPcode","Directory where the command and load files will be written by CG56, relative to $HOME"));
}

void ThorDSP56000 :: setup()
{

// line 126 "ThorDSP56000.chdl"
					/* INITIALIZATION SECTION */

/* note:
  though 2 for thor is undef, undef & float for the DSP is 2 
*/	
// This is a mapping between the thor model and the sim56000 for
// reference 
/*  reset                	 	pinval 0 DSP_pin 0 */
/*  IRQA			 	pinval 1 DSP_pin 1 */
/*  IRQB				pinval 2 DSP_pin 2 */
/*  BR				 	pinval 3 DSP_pin 8 */
/*  HACK			 	pinval 35 DSP_pin 19 (biput ) */
/*  HEN			 		pinval 37 DSP_pin 21 (biput ) */
/*  HRW			 		pinval 38 DSP_pin 22 (biput ) */
/*  HA2			 		pinval 39 DSP_pin 23 (biput ) */
/*  HA1			 		pinval 40 DSP_pin 24 (biput ) */
/*  HA0			 		pinval 41 DSP_pin 25 (biput ) */
/*  PS=FLOAT;				pinval 4 DSP_pin 3 */
/*  DS=FLOAT;				pinval 5 DSP_pin 4 */
/*  RD=FLOAT;				pinval 6 DSP_pin 5 */
/*  WR=FLOAT;				pinval 7 DSP_pin 6 */
/*  XY=FLOAT;				pinval 8 DSP_pin 7 */
/*  BG=FLOAT;				pinval 9 DSP_pin 9 */
/* PAddress, Pdata and Hdata are the port names while PA PD H are internal
arrays for passing to the simulator */
/*  for(i=0;i<16;i++)					*/
/*  PA[i]=FLOAT;			pinval 10-25 DSP_pin PA15=34-49 */
/*  SC1=FLOAT;				pinval 30 DSP_pin 14 (biput ) */
/*  SC0=FLOAT;				pinval 31 DSP_pin 15 (biput ) */
/*  SCLK=FLOAT;				pinval 32 DSP_pin 16 (biput ) */
/*  HREQ=FLOAT;				pinval 36 DSP_pin 20 (biput ) */
/*  for (i = 0; i < 24; i++)            pinval 50-73 DSP_pin PD24=50-73 */
/*  PD[i] = FLOAT;			NO also tied to Z in cct */
/*  for (i = 0; i < 8; i++)             pinval 42-49 DSP_pin H7=26-33 */
/*  H[i] = FLOAT;			NO also tied to Z in cct */
/* STD					pinval 26 DSP_pin 10 */
/* SRD					pinval 27 DSP_pin 11 */
/* SCK					pinval 28 DSP_pin 12 */
/* SC2					pinval 29 DSP_pin 13 */
/* TXD					pinval 33 DSP_pin 17 */	
/* RXD					pinval 34 DSP_pin 18 */

				/* run 56000 simulator, IPC client */

        // test for existence of program.
	if (progNotFound("ModSim56000", "Cant run DSP model without it. \n"))
                return;

    	fromlen = sizeof(from);
    	const char *instance_name;
    	instance_name = mname();
	port = PORT;
	sprintf(protocol, "inet");

	s = RPCSetUpSocket(protocol, &port);
	if (s<0) 
	{
		fprintf(stderr,"thor56k: socket setup failed.\n");
		exit(-1);
	}

	funpack(ev,(32)-1,0,-1);
	sprintf(argid, "%d", int(identifier));

	if ( (gethostname(hostname, hostnamelen)) != 0) 	
	{
		fprintf(stderr, "thor56k: gethostname() failed.\n");
		exit(-1);
	}	

	switch (int(identifier)) 
	{
        case 0:
            geometry = "80x25+0+500";
            break;
        case 1:
            geometry = "80x25+500+500";
            break;
        case 2:
            geometry = "80x25+0+300";
            break;
        case 3:
            geometry = "80x25+500+300";
            break;
        default:
            geometry = "80x25+300+300";
           break;
	}

        strcpy(clientname, hostname);
	display = getenv("DISPLAY");

        strcpy(cmdfile, cmdFileName);

sprintf(command,"cd %s; xterm -fg white -bg black -bd gray -bw 5 -display %s -geometry %s -name ptolemy_sim -title %s -e ModSim56000 %d %s %s %d &", expandPathName(destDirectory),display, geometry, mname(), int(identifier), cmdfile, hostname, port);

fprintf(stderr,"establishing RPC connection of DSP#%1d with Sim56000 ...\n",int(identifier));

	system(command); 

	/* accept on socket */
	tmp_sock = accept(s, &from, &fromlen);

	if (tmp_sock < 0) 
	{
	    fprintf(stderr, "RPC Error: cannot accept stream\n");
 	    return;
	}

	funpack(sock,(32)-1,0,tmp_sock);

fprintf(stderr, "RPC connection of DSP#%1d with sim56000 established \n",int(identifier));
}

static ThorDSP56000 proto;
static KnownBlock entry(proto,"DSP56000");

void ThorDSP56000 :: go()
{
#define index  strchr
#define new   _new_

//    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
//    StatErrHandler = &errHandler;


					/* BEHAVIOR SECTION */
  funpack(ev,(32)-1,0,current_time);

    				/* convert between Thor and sim56k pin vals */
				/* THOR --> 56000 */
/* INPUTS: */
    	ipins[0]=reset;
    	ipins[1]=IRQA;
    	ipins[2]=IRQB;
	ipins[3]=BR;
 	ipins[4]=SRD;
	ipins[5]=RXD;


  for (i = 0; i < 4; i++)
    switch(ipins[i]) {
      case ZERO:
        pin_vals[i] = (char) DSP_PINVAL_LOW;
        break;
      case ONE:
        pin_vals[i] = (char) DSP_PINVAL_HIGH;
	break;
      case FLOAT:
        pin_vals[i] = (char) DSP_PINVAL_FLOAT;
	break;
      default:
        pin_vals[i] = (char) DSP_PINVAL_FLOAT;
	break;
      }

/* SRD */
    switch(ipins[4]) {
      case ZERO:
        pin_vals[27] = (char) DSP_PINVAL_LOW;
        break;
      case ONE:
        pin_vals[27] = (char) DSP_PINVAL_HIGH;
	break;
      case FLOAT:
        pin_vals[27] = (char) DSP_PINVAL_FLOAT;
	break;
      default:
        pin_vals[27] = (char) DSP_PINVAL_FLOAT;
	break;
      }

/* RXD */
    switch(ipins[5]) {
      case ZERO:
        pin_vals[34] = (char) DSP_PINVAL_LOW;
        break;
      case ONE:
        pin_vals[34] = (char) DSP_PINVAL_HIGH;
	break;
      case FLOAT:
        pin_vals[34] = (char) DSP_PINVAL_FLOAT;
	break;
      default:
        pin_vals[34] = (char) DSP_PINVAL_FLOAT;
	break;
      }

				/* OUTPUTS: NOTE: 56000 outputs are NOT  */
				/* updated for transfer back to sim56000 */

/* BIPUTS: */

unpack(PD_in,23,0,PDataIn);
unpack(H_in,7,0,HDataIn);


  for (i = 0; i < 24; i++)
    switch(PD_in[23-i]) {
      case ZERO:
        pin_vals[50+i] = (char) DSP_PINVAL_LOW;
        break;
      case ONE:
        pin_vals[50+i] = (char) DSP_PINVAL_HIGH;
	break;
      case FLOAT:
        pin_vals[50+i] = (char) DSP_PINVAL_FLOAT;
	break;
      default:
        pin_vals[50+i] = (char) DSP_PINVAL_FLOAT;
	break;
      }

  for (i = 0; i < 8; i++)
    switch(H_in[7-i]) {
      case ZERO:
        pin_vals[42+i] = (char) DSP_PINVAL_LOW;
        break;
      case ONE:
        pin_vals[42+i] = (char) DSP_PINVAL_HIGH;
	break;
      case FLOAT:
        pin_vals[42+i] = (char) DSP_PINVAL_FLOAT;
	break;
      default:
        pin_vals[42+i] = (char) DSP_PINVAL_FLOAT;
	break;
      }

  server_talk(fpack(sock,(32)-1,0), pin_vals, NUM_PINS);

    				/* convert between Thor and sim56k pin vals */
				/* 56000 --> THOR */

				/* INPUTS: NOTE: 56000 inputs are not read  */
				/* back from sim56000.			    */

/* OUTPUTS: */
/* receive the values for outputs (biput actually) into array and
later pack it to the number to be sent on the port */

  for (i = 0; i < 16; i++) {
    switch((int) pin_vals[10+i]) {
      case DSP_PINVAL_LOW:
        PA[15-i] = ZERO;
        break;
      case DSP_PINVAL_HIGH:
        PA[15-i] = ONE;
	break;
      case DSP_PINVAL_FLOAT:
        PA[15-i] = FLOAT;
	break;
      default:
	break;
      }
    }

PAddress=pack(PA,15,0);

  for (i = 0; i < 6; i++) {
    switch((int) pin_vals[4+i]) {
      case DSP_PINVAL_LOW:
        opins[i] = ZERO;
        break;
      case DSP_PINVAL_HIGH:
        opins[i] = ONE;
	break;
      case DSP_PINVAL_FLOAT:
        opins[i] = FLOAT;
	break;
      default:
	break;
      }
    }

	PS=opins[0];
	DS=opins[1];
	RD=opins[2];
	WR=opins[3];
	XY=opins[4];
	BG=opins[5];

  for (i = 0; i < 8; i++) {
    switch((int) pin_vals[26+i]) {
      case DSP_PINVAL_LOW:
        opins[i] = ZERO;
        break;
      case DSP_PINVAL_HIGH:
        opins[i] = ONE;
	break;
      case DSP_PINVAL_FLOAT:
        opins[i] = FLOAT;
	break;
      default:
	break;
      }
    }

	STD=opins[0];    /* pin_val[26] */
	SCK=opins[2];	 /* pin_val[28] */
	SC2=opins[3];	 /* pin_val[29] */
	SC1=opins[4]; 	 /* pin_val[30] */
	SC0=opins[5]; 	 /* pin_val[31] */
	SCLK=opins[6]; 	 /* pin_val[32] */
	TXD=opins[7];	 /* pin_val[33] */

/* BIPUTS: */

  for (i = 0; i < 24; i++) {
    switch((int) pin_vals[50+i]) {
      case DSP_PINVAL_LOW:
        PD_out[23-i] = ZERO;
        break;
      case DSP_PINVAL_HIGH:
        PD_out[23-i] = ONE;
	break;
      case DSP_PINVAL_FLOAT:
        PD_out[23-i] = FLOAT;
	break;
      default:
	break;
      }
    }


PDataOut=pack(PD_out,23,0);

  for (i = 0; i < 8; i++) {
    switch((int) pin_vals[42+i]) {
      case DSP_PINVAL_LOW:
        H_out[7-i] = ZERO;
        break;
      case DSP_PINVAL_HIGH:
        H_out[7-i] = ONE;
	break;
      case DSP_PINVAL_FLOAT:
        H_out[7-i] = FLOAT;
	break;
      default:
	break;
      }
    }


HDataOut = pack(H_out,7,0);

  EXITMOD(0);
}

int ThorDSP56000 :: pack(int *arin, int  msb, int lsb)

{

/*  Packs an array into a 32 bit integer. signed.
 * If the array (representing the bus input) consists of all
 * FLOAT or UNDEF, then converts it to a number which is FLOAT or UNDEF
*/

        int error,number=0;
        int dir;
        int     m1,l1;  /* used by FDUMP */

        m1 = msb; l1 = lsb;

        error = PASSED;
        error |= fckmsize(msb,lsb);

        if (error == PASSED)
        {
                number = 0;
                dir = DIR(msb,lsb);

                while ( (lsb != msb) && (error >= PASSED) )
                {
                    switch ( arin[msb] )
                    {
                        case ZERO:
                                number <<= 1;
                                /* number += 0;*/
                                break;

                        case ONE:
                                number <<= 1;
		                number += 1;
                                break;

                        case UNDEF:
                                number = -2;
                                /*number = UNDEF; */
                                break;

                        case FLOAT:
                                number = -3;
                                /*number = FLOAT; */
                                break;

                        default:
                                error |= FAILED;
                                break;
                    }
                    msb -= dir;
                }
                                        /* now the case: (msb==lsb) */
                if (error == PASSED)
                {
                    switch ( arin[msb] )
                    {
                        case ZERO:
                                number <<= 1;
                                /* number += 0;*/
                                break;

                        case ONE:
                                number <<= 1;
                                number += 1;
                                break;

                        case UNDEF:
                                number = -2;
                                /*number = UNDEF; */
                                break;

                        case FLOAT:
                                number = -3;
                                /*number = FLOAT; */
                                break;

                        default:
                                error |= FAILED;
                                break;
                    }
                }
        }/*end if (error == PASSED ) */

        if (error < PASSED)
        {
                ferr(error,"PACK: Array not packed due to:");
        }

/*      put call sequence here as a reminder
int pack(arin,msb,lsb)
*/

        return(number);

} /* end pack() */



void ThorDSP56000 :: unpack(int *arout, int msb, int lsb, int number)
{
int     test=0;

if(number==FLOAT) test=3;
else if(number==UNDEF) test=2;
else test=0;

        switch(number) {

        case -3:

                if (lsb >= msb)
                {
                        while (msb <= lsb)
                        {
                        arout[lsb--] = FLOAT;
                        }
                }
                else
                {
                        while (lsb <= msb)
                        {
                        arout[lsb++] = FLOAT;
                        }
                }
                break;


        case -2:

                if (lsb >= msb)
                {
                        while (msb <= lsb)
                        {
                        arout[lsb--] = UNDEF;
                        }
                }
                else
                {
                        while (lsb <= msb)
                        {
                        arout[lsb++] = UNDEF;
                        }
                }
                break;


        default:
		if (lsb >= msb)
                {
                        while (msb <= lsb)
                        {
                        arout[lsb--] = number & 0x1;
                        number = number >>1;
                        }
                }
                else
                {
                        while (lsb <= msb)
                        {
                        arout[lsb++] = number & 0x1;
                        number = number >>1;
                        }
                }
                break;
        }       /* switch */

}
