static const char file_id[] = "../../../../src/domains/thor/stars/ThorCLOCK.chdl";

////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice, 
// limitation of liability, and disclaimer of warranty provisions. 
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/26, 12:42:01 by pepp version 2.6.
//  Input is coming from file "../../../../src/domains/thor/stars/ThorCLOCK.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;

/*  CLOCK()
 *	Clock drvr fcn. - uses 3 paramters [Tstart,Ttransition,Tperiod]
 */

const char *star_nm_ThorCLOCK = "ThorCLOCK";

class ThorCLOCK : public ThorStar
{
private:

//	    Outport list: (between lines 8 and 10)
    OutThorPort		clk;

//	    State list: (between lines 12 and 16)
    int			Tstart;
    ThorState		_Tstart_;
    int			Ttrans;
    ThorState		_Ttrans_;
    int			TT;
    ThorState		_TT_;

public:
    int			isItGenerator() { return TRUE; }
    ThorCLOCK();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorCLOCK; }

};

ThorCLOCK :: ThorCLOCK ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is generated by pepp, version 2.6, from a chdl model. **\n""\n"

"/*  CLOCK()\n"
" *	Clock drvr fcn. - uses 3 paramters [Tstart,Ttransition,Tperiod]\n"
" */\n");

//	Ports:

    addPort(clk.setPort("clk",this));

//	States:

    addState(_Tstart_.setThorState("Tstart",this,"0",&Tstart));
    addState(_Ttrans_.setThorState("Ttrans",this,"0",&Ttrans));
    addState(_TT_.setThorState("TT",this,"0",&TT));
}

void ThorCLOCK :: setup()
{
}

static ThorCLOCK proto;
static KnownBlock entry(proto,"CLOCK");

void ThorCLOCK :: go()
{
#define index  strchr
#define new   _new_

    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
    StatErrHandler = &errHandler;

// line 5 "../../../../src/domains/thor/stars/ThorCLOCK.chdl"

#define RCSID "$Header: CLOCK.c,v 1.5 87/03/30 11:01:32 rla Exp $"

// line 11 "../../../../src/domains/thor/stars/ThorCLOCK.chdl"

// line 17 "../../../../src/domains/thor/stars/ThorCLOCK.chdl"

	if ( OUT_COUNT != 1 )
	{	fprintf(stderr,
"ERROR:  CLOCK() can only drive one output not %d \n", OUT_COUNT);
		EXITMOD(-2);
	}
	if ( ST_COUNT != 3)
	{	fprintf(stderr,
"ERROR:  CLOCK() requires 3 parameters not %d\n", ST_COUNT);
		EXITMOD(-3);
	}

	if (Ttrans <= 0 || TT <= Ttrans)
	{
		fprintf(stderr,
"ERROR: CLOCK() transition, period must be nonzero\n");
		EXITMOD(-3);
	}

	if (current_time == 0)
	{
		clk = ZERO;
		if (Tstart <= 0) { /* schedule for Tstart */
			Tstart = TT - (-Tstart % TT);
			if ((Tstart - TT + Ttrans) > 0) {
				self_sched(Tstart-TT+Ttrans, SELF0);
				clk = ONE;
			}
		}
		self_sched(Tstart, SELF0);
	}
	else
	{
		/* we must be either at the end of a clock cycle or
		 * at the duty cycle transition.  Schedule both
		 * evaluations at clock cycle end
		*/

		if((current_time-Tstart) % TT == 0) /* at end of clock cycle,
						 * or at Tstart. */
		{
			/* sched for duty cycle transition */
			self_sched(Ttrans, SELF0);
			/* sched for period */
			self_sched(TT, SELF0);
		}
		clk = (((current_time-Tstart)+TT) % TT) < Ttrans ? ONE : ZERO;
	}

	EXITMOD(0);
}

