static const char file_id[] = "../../../../src/domains/thor/stars/ThorAND.chdl";

////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
// All rights reserved.
// See the file ~ptolemy/copyright for copyright notice, 
// limitation of liability, and disclaimer of warranty provisions. 
//
////////////////////////////////////////////////////////////////////////

////

//  Conversion done 1992/11/26, 12:42:13 by pepp version 2.6.
//  Input is coming from file "../../../../src/domains/thor/stars/ThorAND.chdl".

#include "ThorStar.h"
#include "ThorState.h"
#include "libarp.h"
#include "KnownBlock.h"
#include "ThorPrintOverl.h"
#include "ThorErrHandler.h"

static ThorErrHandler* StatErrHandler = 0;

#ifdef EXITMOD
#undef EXITMOD
#endif
#define EXITMOD(x) StatErrHandler->status = x; return;
#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;

/*	AND()
 *		Generic mult-input AND gate
 */

const char *star_nm_ThorAND = "ThorAND";

class ThorAND : public ThorStar
{
private:

//	    Inport list: (between lines 9 and 11)
    MultiInThorPort	indat;

//	    Outport list: (between lines 13 and 15)
    OutThorPort		fun;

public:
    int			isItModel() { return TRUE; }
    ThorAND();		// Constructor
    void		go();
    void		setup();
    Block*		makeNew() const { LOG_NEW; return new ThorAND; }

};

ThorAND :: ThorAND ()	// Constructor
{
    setDescriptor("\n"
"** This star's code is generated by pepp, version 2.6, from a chdl model. **\n""\n"

"/*	AND()\n"
" *		Generic mult-input AND gate\n"
" */\n");

//	Ports:

    addPort(indat.setPort("indat",this));

    addPort(fun.setPort("fun",this));
}

void ThorAND :: setup()
{
}

static ThorAND proto;
static KnownBlock entry(proto,"AND");

void ThorAND :: go()
{
#define index  strchr
#define new   _new_

    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);
    StatErrHandler = &errHandler;

// line 6 "../../../../src/domains/thor/stars/ThorAND.chdl"

#define	RCSID "$Header: AND.c,v 1.2 86/12/30 23:49:00 div Exp $"

// line 12 "../../../../src/domains/thor/stars/ThorAND.chdl"

// line 16 "../../../../src/domains/thor/stars/ThorAND.chdl"

	register int i;

	if ( OUT_COUNT != 1)
	{
		fprintf(stderr,"ERROR: AND(): wrong # of outputs\n");
		EXITMOD(-2);
	}
	fun = ONE;
						/* for all inputs	*/
	for ( i = IN_COUNT-1; i>=0; i--)
	{
		switch(indat[i]) {
		case ZERO:
			fun = ZERO;
			EXITMOD(0);		/* break out of for() */
		case ONE:
			break;
		default:
			fun = UNDEF;
			break;
		}
	}
	EXITMOD(0);
}

