/**************************************************************************
 * Version identification:
 * @(#)utils.c	1.5	10/9/91
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 11/02/90
 *  Modifications:
 *	04/29/91:  A Wass: declared the char* ClassName.
 *	06/10/91:  A Wass: added function fillbuf.
 *  Description:
 *	Defines some common functions and variables.
 **************************************************************************/

static char identification[] = "@(#)utils.c	1.5\t10/9/91  (c) UC Berkeley";

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "comdefs.h"

char *ModelName = NULL, *ClassName = NULL;
ICL *iclptr = NULL;

static char *_null_ = "";

#define freeString(s) (s != _null_ ? free(s) : NULL)

char *savestr(str)		/* This function allocates memory for the   */
    char *str;			/* contents in string str and places a copy */
{				/* of str in this space. If str is NULL or  */
    char *s;			/* empty, a pointer to a empty string is    */
    if (!str) return _null_;	/* returned.				    */
    if (!*str) return _null_;
    s = (char *) malloc(strlen(str)+1);
    if (!s) {
	errmsg("o","(savestr:) Can't allocate more memory.\n");
	exit(1);
    }
    return strcpy(s,str);
}

int fillbuf(buf,len,fp)
    char *buf;
    int len;
    FILE *fp;
{
    int blank;
    register char *bufptr, *blankptr;
    
    buf[0] = '\0';
    bufptr = fgets(buf, len, fp);
    for (blankptr=NULL, bufptr=buf; *bufptr; bufptr++) {
	if (!blankptr && (isspace(*bufptr) || *bufptr == '\n'))
	    blankptr=bufptr;
	else if (!isspace(*bufptr) && *bufptr != '\n')
	    blankptr = NULL;
    }
    if (feof(fp) && *(bufptr-1) != '\n' && (bufptr-buf <= len-2)) {
	*bufptr++ = '\n';	/* add newline if eof and newline is missing */
	*bufptr = NULL;		/* and we still have room for it ... */
    }
    blank = (blankptr == buf);
    if (blankptr && *(bufptr - 1) == '\n') { /* remove trailing spaces ... */
	*blankptr++ = '\n';
	*blankptr = NULL;
    }
    return blank;
}

SIGSTRUCT *newsig(name,token,size,endian,line) /* This function allocates  */
    char *name, *size;		/* memory to an element of structure       */
    int token, endian, line;	/* SIGSTRUCT, initialize this structure    */
{				/* according to parameters and then return */
				/* a pointer.				   */
    SIGSTRUCT *sp = (SIGSTRUCT *) malloc(sizeof(SIGSTRUCT));
    if (!sp) {
	errmsg("o","(newsig:) Can't allocate more memory.\n");
	exit(1);
    }
    sp->name = savestr(name);
    sp->token = token;
    sp->lineno = line;
    sp->size = savestr(size);
    sp->endian = endian;
    sp->next = NULL;
    return sp;
}

SIGSTRUCT *freeSigList(ptr)	/* This function recursively free allocated   */
    SIGSTRUCT *ptr;		/* memory of structure SIGSTRUCT from element */
{				/* `ptr' to the last element in the list. The */
    if (!ptr) return NULL;	/* pointer value NULL is returned.	      */
    if (ptr->next) ptr->next = freeSigList(ptr->next);
    if (ptr->name) {
	freeString(ptr->name);
	ptr->name = NULL;
    }
    if (ptr->size) {
	freeString(ptr->size);
	ptr->size = NULL;
    }
    ptr->token = ptr->endian = ptr->lineno = 0;
    free(ptr);
    return NULL;
}

void printSigList(list)
    SIGSTRUCT *list;
{
    while (list) {
	errmsg("s","    {name = \"%s\", size = \"%s\", token = %d, endian = %d, line = %d},\n",
	       list->name, list->size, list->token, list->endian, list->lineno);
	list = list->next;
    }
}

GENSTRUCT *append_struct(elem,list) /* Append elem to list. */
    GENSTRUCT *elem, *list;	      /* Always return list.  */
{
    GENSTRUCT *ptr;
    if (!elem)
	return list;
    else if (!list)
	return elem;
    for (ptr = list; ptr->next; ptr = ptr->next);
    ptr->next = elem;
    return list;
}

VARSTRUCT *newvar(type,action,line) /* This function allocates memory to  */
    char *type, *action;	/* an element of structure VARSTRUCT,     */
    int line;			/* initialize this structure according to */
{				/* parameters and then returns a pointer. */

    VARSTRUCT *vp = (VARSTRUCT *) malloc(sizeof(VARSTRUCT));
    if (!vp) {
	errmsg("o","(newvar:) Can't allocate more memory.\n");
	exit(1);
    }
    vp->type = savestr(type);
    vp->action = action;
    vp->lineno = line;
    vp->next = NULL;
    return vp;
}

VARSTRUCT *freeVarList(ptr)	/* This function recursively free allocated   */
    VARSTRUCT *ptr;		/* memory of structure VARSTRUCT from element */
{				/* `ptr' to the last element in the list. The */
    if (!ptr) return NULL;	/* pointer value NULL is returned.	      */
    if (ptr->next) ptr->next = freeVarList(ptr->next);
    if (ptr->type) {
	freeString(ptr->type);
	ptr->type = NULL;
    }
    if (ptr->action) {
	freeString(ptr->action);
	ptr->action = NULL;
    }
    ptr->lineno = 0;
    free(ptr);
    return NULL;
}

DECSTRUCT *newdeclist(list,token,strtline,endline) /* Allocates memory    */
    SIGSTRUCT *list;		/* for an element of structure DECSTRUCT. */
    int token, strtline,	/* Initializes it with the parameter's	  */
	endline;		/* values and return its address.	  */
{
    DECSTRUCT *sp = (DECSTRUCT *) malloc(sizeof(DECSTRUCT));
    if (!sp) {
	errmsg("o","(newdeclist:) Can't allocate more memory.\n");
	exit(1);
    }
    sp->token = token;
    sp->strtline = strtline;
    sp->endline = endline;
    sp->list = list;
    sp->next = NULL;
    return sp;
}

DECSTRUCT *freeDecList(ptr)	/* Free every allocated memory space */
    DECSTRUCT *ptr;		/* beginning at `ptr' recursively. */
{
    if (!ptr) return NULL;
    if (ptr->next) ptr->next = freeDecList(ptr->next);
    if (ptr->list) ptr->list = freeSigList(ptr->list);
    ptr->token = ptr->strtline = ptr->endline = 0;
    free(ptr);
    return NULL;
}

void printDecList(list)
    DECSTRUCT *list;
{
    if (list)
	while (list) {
	    errmsg("s","  {token = %d, lines %d - %d,\n", list->token,
		   list->strtline, list->endline);
	    printSigList(list->list);
	    list = list->next;
	    errmsg("s","  }\n\n");
	}
}

NAMETABLE *insertname(name,size,type,table,line) /* allocates space   */
    char *name, *size;		/* for an element holding information */
    int type, line;		/* about size and type of vectors     */
    NAMETABLE *table;		/* declared in a thor model.          */
{				/* The element is initialized with    */
    NAMETABLE *head = table;	/* the parameter's values.	      */
    NAMETABLE *tbl = (NAMETABLE *) malloc(sizeof(NAMETABLE));
    if (!tbl) {
	errmsg("f","Out of memory. Can't continue. (sorry!)\n");
	exit(1);
    }
    tbl->name = savestr(name);
    tbl->size = savestr(size);
    tbl->type = type;
    tbl->lineno = line;
    tbl->next = NULL;
    if (!table) return tbl;
    for (; table->next; table = table->next);
    table->next = tbl;
    return head;
}

NAMETABLE *getvecinfo(name, table) /* returns the pointer to an */
    char *name;			/* element of type NAMETABLE if */
    NAMETABLE *table;		/* it exists. Otherwise NULL.   */
{
    if (!table) return 0;
    for (;table; table = table->next)
	if (!strcmp(table->name,name))
	    return table;
    return NULL;
}

NAMETABLE *freenametbl(table)	/* frees all allocated memory */
    NAMETABLE *table;		/* from `table' recursively.  */
{				/* Returns NULL. */
    if (!table) return NULL;
    if (table->next)
	table->next = freenametbl(table->next);
    freeString(table->name);
    freeString(table->size);
    table->name = table->size = NULL;
    table->type = table->lineno = 0;
    free(table);
    return NULL;
}

void printNameTbl(tbl)
    NAMETABLE *tbl;
{
    while(tbl) {
	errmsg("s","  {name = \"%s\", size = \"%s\", type = %d, line = %d}\n",
	       tbl->name, tbl->size, tbl->type, tbl->lineno);
	tbl = tbl->next;
    }
}

void printVarStruct(ptr)
    VARSTRUCT *ptr;
{
    for (;ptr; ptr = ptr->next)
	errmsg("s","    %s\t%s; // line %3d\n",
	       ptr->type, ptr->action, ptr->lineno);
}

void printVarList(list)
    VARLISTSTRUCT *list;
{
    if (list->private) {
	errmsg("s","private:\n");
	printVarStruct(list->private);
    }
    if (list->private) {
	errmsg("s","protected:\n");
	printVarStruct(list->protected);
    }
    if (list->private) {
	errmsg("s","public:\n");
	printVarStruct(list->public);
    }
}
