/**************************************************************************
 * Version identification:
 * @(#)dbgmsg.c	1.2	5/20/91
 * @(#)dbgmsg.c    1.1     10/30/90
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 10/30/90
 *  Description:
 *	This file contains the debug message function. It takes the file and
 *	line number before the format string and its arguments (if any).
 *	Message is printed to stderr and logfile.
 *	The output will look like:
 *	`DBG<pepp>: "dbgmsg.c", line  16: ...' where ... is determined by
 *	the format string and its arguments.
 **************************************************************************/

static char identification[] = "@(#)dbgmsg.c	1.2\t5/20/91  (c) UC Berkeley";

#include <stdio.h>
#include <varargs.h>

extern char *pgm_name;
extern void errmsg();
static char sbuff_[BUFSIZ];

void dbgmsg(va_alist)
    /* dbgmsg(char* file, int line, char* format, arglist ...); */
    va_dcl
{
    va_list aptr;
    char *file, *format;
    int line;
    va_start (aptr);
    file = va_arg(aptr, char *);
    line = va_arg(aptr, int);
    format = va_arg(aptr, char *);
    sbuff_[0] = NULL;
    vsprintf(sbuff_,format,aptr);
    va_end(aptr);
    errmsg("s","DBG<%s>: \"%s\", line %3d: %s", pgm_name, file, line, sbuff_);
}
