/**************************************************************************
 * Version identification:
 * @(#)cc-strings.c	1.13	11/26/92
 *
 *  Copyright (c) 1990,1991 The Regents of the University of California.
 *                        All Rights Reserved.
 *
 *  Programmer:  Anders Wass
 *  Date of creation: 11/02/90
 *
 *
 *  Description:
 *
 * This file contains C++ symbols used used in pThor star files and that are
 * independent of the source code of the translation program pepp. When some
 * kind of symbol name that are defined here changes in pThor, this should
 * be the only file to edit to get pepp to generate correct code again.
 *
 *	-- Anders Wass  1990/11/02
 *	-- Modified by Seungjun Lee  3/6/1991
 *	-- Modified by Anders Wass 5/15/1991,
 *				added string vector GlobCpps,
 *				added new include: ThorPrintOverl.h
 *	-- Modified by Anders Wass 6/7/1991,
 *				added string vector ErrHdlrDecl,
 *				added string StatErrHdlr,
 *				changed the contents in GlobCpps and
 *				added ThorErrHandler.h to includes.
 */


static char identification[] = "@(#)cc-strings.c	1.13\t11/26/92  (c) UC Berkeley";

#define NULL 0

/*-------------------------------------------------------------------------------*/

/* This vector contains the first lines written to the new cc-file. A
   linefeed is appended to each string when they are written. This vector
   must be terminated with a NULL pointer. */

char *FirstLines[] = {
    "\n",
    "////////////////////////////////////////////////////////////////////////\n",
    "//\n",
    "// Copyright (c) 1990, 1991, 1992 The Regents of the University of California.\n",
    "// All rights reserved.\n",
    "// See the file ~ptolemy/copyright for copyright notice, \n",
    "// limitation of liability, and disclaimer of warranty provisions. \n",
    "//\n",
    "////////////////////////////////////////////////////////////////////////\n",
    "\n////\n",
    NULL
    };

/*-------------------------------------------------------------------------------*/

/* This vector contains all the file names that shall be included in the
   cc-model file. It must be NULL terminated. */

char *Includes[] = {
    "\"ThorStar.h\"",
    "\"ThorState.h\"",
    "\"libarp.h\"",
    "\"KnownBlock.h\"",
    "\"ThorPrintOverl.h\"",
    "\"ThorErrHandler.h\"",
    NULL
    };

/*-------------------------------------------------------------------------------*/

/* This string vector contains the (re)definitions of EXITMOD and exit
   within a Thor model. They should go after the included files. Line
   control must be included in the strings as well the macro directives.
   The definitions depends on the ThorErrHandler class and must be edited
   accordingly to changes in that class. It also depends on the name of the
   static errHandler pointer (see below). */

char *GlobCpps[] = {
    "#ifdef EXITMOD\n#undef EXITMOD\n#endif\n",
    "#define EXITMOD(x) StatErrHandler->status = x; return;\n",
    "#define exit(x) StatErrHandler->status = x; StatErrHandler->flush(); return;\n",
    NULL
    };

/*-------------------------------------------------------------------------------*/

/* This string defines the static errHandler. */

char *StatErrHdlr = "static ThorErrHandler* StatErrHandler = 0;\n";

/*-------------------------------------------------------------------------------*/

/* This string vector contains the declaration of error handler that is used
   in the start, and go method (eventually also in wrapup method if such
   method is to be defined). It depends on the definition of ThorErrHandler
   class, ThorPrint class, and the static variable declaration of the
   ThorErrHandler pointer variable. Must be modified accordingly to the
   changes in these classes. */

char *ErrHdlrDecl[] = {
    "    ThorErrHandler errHandler(this,ThorPrint::getErrMsgBuf(),&StatErrHandler);\n",
    "    StatErrHandler = &errHandler;\n\n",
    NULL
    };

/*-------------------------------------------------------------------------------*/

/* This vector contains all the definitions that shall be included in the
   go() method of cc-model file. It must be NULL terminated.
   Added by S.Lee,  2/6/1991 */

char *Defines[] = {
    "index  strchr",
    "new   _new_",
    NULL
    };

/*-------------------------------------------------------------------------------*/

/* This vector contains the names of the functions that tells the type of
   thor model/star we have. The order is significant. The first string is
   void, the second is for models with only outputs, the third is for models
   with only inputs, and the last is for models with both inputs and outputs
   and/or biputs */

char *ThorStarType[] = { "isItModel", "isItGenerator", "isItMonitor", "isItModel" };

/*-------------------------------------------------------------------------------*/

/* This string is a format string which takes the class name as an
   parameter. */

char *Class = "\nclass %s : public ThorStar\n{\n";

/*-------------------------------------------------------------------------------*/

/* These are the type names for the current ThorPorts ... */

char *SingleIn  = "InThorPort";
char *SingleOut = "OutThorPort";
char *SingleBi  = "BiThorPort";
char *SingleSt  = "ThorState";

char *MultiIn  = "MultiInThorPort";
char *MultiOut = "MultiOutThorPort";
char *MultiBi  = "MultiBiThorPort";
char *MultiSt  = "MultiThorState";

/*-------------------------------------------------------------------------------*/

/* These are the function names and their types that initialize and runs the
   model. */

char *Go = "go";
char *GoType = "void";
char *Start = "setup";
char *StartType = "void";

/*-------------------------------------------------------------------------------*/

/* This is the cloning declaration in the class. It is a format string and
   takes one string argument, the class name. */

char *Clone = "    Block*\t\tmakeNew() const { LOG_NEW; return new %s; }\n";

/*-------------------------------------------------------------------------------*/

/* This is the descriptor strings. They are format strings and takes zero to
   two string argument, the program name and the version or the model name
   or the descriptor line from the chdl file. */

char *Descriptor[] = {
    "    setDescriptor(\"\\n\"",
    "\n\"** This star's code is generated by %s, %s, from a chdl model. **\\n\"",
    "\n\"%s\\n\"",
    "\n\"   No information was available at compilation time for star `%s'.\\n\"",
    ");\n",
    NULL
    };

/*-------------------------------------------------------------------------------*/

/* These two strings are format strings for the temporary TSIG, TGRP
   declarations. The first one takes one parameter, the name. The second one
   takes two parameters, the name and the size. All parameters are of type
   char*. */

char *TSigDecl = "    int\t\t\t%s;\n";
char *TGrpDecl = "    int\t\t\t%s[%s];\n";

/*-------------------------------------------------------------------------------*/

/* These are the strings used to format the declaration of ports (single and
   multi) and states (single and hidden single). NOTE: for single state, the
   state variable has a hidden name that must match the name convention in
   addSState. */

char *SPortDecl  = "    %s\t\t%s;\n";		/* type, name */
char *MPortDecl  = "    %s\t%s;\n";		/* type, name */
char *SStateDecl = "    int\t\t\t%s;\n";	/*       name */
char *HidSStateD = "    %s\t\t_%s_;\n";		/* type, name */

/*-------------------------------------------------------------------------------*/

/* These two strings are format strings and should handle two, three,
   or four arguments, the port/state name and optional the state size state
   variable name. */

char *AddPort   = "    addPort(%s.setPort(\"%s\",this));\n";
char *AddSState = "    addState(_%s_.setThorState(\"%s\",this,%s,&%s));\n";
char *AddMState = "    addState(%s.setThorState(\"%s\",this,%s));\n";

/*-------------------------------------------------------------------------------*/

/* These are the default initialization strings for ThorState and
   MutliThorState. They are only used when no value can be extracted from
   the model description. */

char *DefSSSize = "\"0\"";
char *DefMSSize = "0";

/*-------------------------------------------------------------------------------*/

/* These are the names of the functions that sets the vaiables that holds
   the number of in/out/bi-ports in the ThorStar class. */

char *SetIn = "setInCount";
char *SetOut = "setOutCount";
char *SetBi = "setBiCount";
char *SetSt = "setStCount";

/*-------------------------------------------------------------------------------*/

/* These two strings are the the proto and entry declarations. They are
   both format strings and take one string argument, the model name. */

char *Proto = "static %s proto;\n";
char *Entry = "static KnownBlock entry(proto,\"%s\");\n\n";

/*-------------------------------------------------------------------------------*/

/* This string is used by the pass1Syn.y. It is the command that tells the
   size of a vector. It is a format string and takes one argument, the port name.*/

char *VGrpSize = "%s.numberPorts()";

/*-------------------------------------------------------------------------------*/

/* This string is the cpp preprocessor command. It is used in main.c. */

char *Cppcmd = "/usr/gnu/lib/gcc-cpp -CP";

/*-------------------------------------------------------------------------------*/

/* define string used to pull in the file from a library */
/* the format string takes two arguments, each equal to the class name */
char *PullIn = "const char *star_nm_%s = \"%s\";\n\n";

/* <EOF> */
