/**************************************************************************
Version identification:
@(#)libarp.h	1.5	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Seungjun Lee
 Date of creation: 2/11/91
 Description: C++ version of thor library routines

**************************************************************************/
#ifndef _libarp_h
#define _libarp_h 1


///////////////////////////////////////////////////////////////////////////
//
// Version identification:
// @(#)libarp.h	1.5 11/25/92
//	
// Programmer: Seungjun Lee
// Created:    8/31/90
//
// Thor library function declarations : overloaded for Ptolemy interface
//
///////////////////////////////////////////////////////////////////////////

#include "ThorPortHole.h"
#include "Thor.h"

#ifdef __GNUG__
#ifndef switch
#define switch(x) switch(int(x))
#endif
#endif

int fadd(int*, int, int, int*, int, int, int*, int, int, int);
int fadd(MultiThorPort&, int, int, int*, int, int, int*, int, int, int);

int faddc(int*, int, int, int*, int, int, int, int);
int faddc(MultiThorPort&, int, int, int*, int, int, int, int);

int fand(int*, int, int, int*, int, int, int*, int, int);
int fand(MultiThorPort&, int, int, int*, int, int, int*, int, int);

int fandc(int*, int, int, int*, int, int, int);
int fandc(MultiThorPort&, int, int, int*, int, int, int);

int fandsig(int*);

int fcat(int*, int, int, int*, int, int, int*, int, int);
int fcat(MultiThorPort&, int, int, int*, int, int, 
         int*, int, int);

int fcatac(int*, int, int, int*, int, int, int);
int fcatac(MultiThorPort&, int, int, int*, int, int, int);

int fcatca(int*, int, int, int, int*, int, int);
int fcatca(MultiThorPort&, int, int, int, int*, int, int);

int fckanybin(int*, int, int);
int fckanybin(MultiThorPort&, int, int);

int fckbin(int*, int, int);

int fckmsize(int, int);

int fckpty(int*, int, int);

int fckrange(int, int, int, int);

int fckrange3(int, int, int, int, int, int);

int fckvalue(int*, int, int);

int fcopy(int*, int, int, int*, int, int);
int fcopy(MultiThorPort&, int, int, int*, int, int);

int fcopyinv(int*, int, int, int*, int, int);
int fcopyinv(MultiThorPort&, int, int, int*, int, int);

int fdecr(int*, int, int);
int fdecr(MultiThorPort&, int, int);

int ferr(int, const char*);

int fgetval(int*, int, int);
int fgetval(MultiThorPort&, int, int);

int fincr(int*, int, int);
int fincr(MultiThorPort&, int, int);

int finitmem(char*, int*, int, int);

int finv(int*, int, int, int*, int, int);
int finv(MultiThorPort&, int, int, int*, int, int);

int fior(int*, int, int, int*, int, int, int*, int, int);
int fior(MultiThorPort&, int, int, int*, int, int, int*, int, int);

int fiorc(int*, int, int, int*, int, int, int);
int fiorc(MultiThorPort&, int, int, int*, int, int, int);

int forsig(int*);

int fpack(int*, int, int);

int fprval(int*, int, int);

int fprvec(int*, int, int, char*);

int frorl(int*, int, int, int);
int frorl(MultiThorPort&, int, int, int);

int frorr(int*, int, int, int);
int frorr(MultiThorPort&, int, int, int);

int fsckbin(int);

int fsetword(int*, int, int, int);
int fsetword(MultiThorPort&, int, int, int);

int fshftl(int*, int, int, int, int);
int fshftl(MultiThorPort&, int, int, int, int);

int fshftr(int*, int, int, int, int);
int fshftr(MultiThorPort&, int, int, int, int);

int fshftr0(int*, int, int, int*, int, int, int);
int fshftr0(MultiThorPort&, int, int, int*, int, int, int);

int fsub(int*, int, int, int*, int, int, int*, int, int, int);
int fsub(MultiThorPort&, int, int, int*, int, int, int*, int, int, int);

int fsubc(int*, int, int, int*, int, int, int, int);
int fsubc(MultiThorPort&, int, int, int*, int, int, int, int);

int fswap(int*, int, int, int*, int, int);
int fswap(MultiThorPort&, int, int, int*, int, int);

int funpack(int*, int, int, int);
int funpack(MultiThorPort&, int, int, int);

int funpacks(int*, int, int, int);
int funpacks(MultiThorPort&, int, int, int);

int fxnor(int*, int, int, int*, int, int, int*, int, int);
int fxnor(MultiThorPort&, int, int, int*, int, int, int*, int, int);

int fxnorc(int*, int, int, int*, int, int, int);
int fxnorc(MultiThorPort&, int, int, int*, int, int, int);

int fxor(int*, int, int, int*, int, int, int*, int, int);
int fxor(MultiThorPort&, int, int, int*, int, int, int*, int, int);

int fxorc(int*, int, int, int*, int, int, int);
int fxorc(MultiThorPort&, int, int, int*, int, int, int);

#endif
